/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.lock.LockAnalysis;
import org.checkerframework.checker.lock.LockAnnotatedTypeFactory;
import org.checkerframework.checker.lock.LockChecker;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.javacutil.AnnotationUtils;

public class LockStore
extends CFAbstractStore<CFValue, LockStore> {
    protected boolean inConstructorOrInitializer = false;
    private LockAnnotatedTypeFactory atypeFactory;

    public LockStore(LockAnalysis analysis, boolean sequentialSemantics) {
        super(analysis, sequentialSemantics);
        this.atypeFactory = (LockAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    public LockStore(LockAnalysis analysis, CFAbstractStore<CFValue, LockStore> other) {
        super(other);
        this.inConstructorOrInitializer = ((LockStore)other).inConstructorOrInitializer;
        this.atypeFactory = ((LockStore)other).atypeFactory;
    }

    @Override
    public LockStore leastUpperBound(LockStore other) {
        LockStore newStore = super.leastUpperBound(other);
        newStore.inConstructorOrInitializer = this.inConstructorOrInitializer && other.inConstructorOrInitializer;
        newStore.atypeFactory = this.atypeFactory;
        return newStore;
    }

    public void insertLockPossiblyHeld(FlowExpressions.Receiver r) {
        CFValue value = (CFValue)this.analysis.createSingleAnnotationValue(this.atypeFactory.LOCKPOSSIBLYHELD, r.getType());
        assert (value != null);
        if (r.containsUnknown()) {
            return;
        }
        if (r instanceof FlowExpressions.LocalVariable) {
            FlowExpressions.LocalVariable localVar = (FlowExpressions.LocalVariable)r;
            this.localVariableValues.put(localVar, value);
        } else if (r instanceof FlowExpressions.FieldAccess) {
            FlowExpressions.FieldAccess fieldAcc = (FlowExpressions.FieldAccess)r;
            this.fieldValues.put(fieldAcc, value);
        } else if (r instanceof FlowExpressions.MethodCall) {
            FlowExpressions.MethodCall method = (FlowExpressions.MethodCall)r;
            this.methodValues.put(method, value);
        } else if (r instanceof FlowExpressions.ArrayAccess) {
            FlowExpressions.ArrayAccess arrayAccess = (FlowExpressions.ArrayAccess)r;
            this.arrayValues.put(arrayAccess, value);
        } else if (r instanceof FlowExpressions.ThisReference) {
            this.thisValue = value;
        } else if (r instanceof FlowExpressions.ClassName) {
            FlowExpressions.ClassName className = (FlowExpressions.ClassName)r;
            this.classValues.put(className, value);
        }
    }

    public void setInConstructorOrInitializer() {
        this.inConstructorOrInitializer = true;
    }

    @Override
    public @Nullable CFValue getValue(FlowExpressions.Receiver expr) {
        if (this.inConstructorOrInitializer) {
            FlowExpressions.FieldAccess fieldAcc;
            if (expr instanceof FlowExpressions.ThisReference) {
                this.initializeThisValue(this.atypeFactory.LOCKHELD, expr.getType());
            } else if (expr instanceof FlowExpressions.FieldAccess && !(fieldAcc = (FlowExpressions.FieldAccess)expr).isStatic() && fieldAcc.getReceiver() instanceof FlowExpressions.ThisReference) {
                this.insertValue(fieldAcc.getReceiver(), this.atypeFactory.LOCKHELD);
            }
        }
        return (CFValue)super.getValue(expr);
    }

    @Override
    protected void internalVisualize(CFGVisualizer<CFValue, LockStore, ?> viz) {
        viz.visualizeStoreKeyVal("inConstructorOrInitializer", this.inConstructorOrInitializer);
        super.internalVisualize(viz);
    }

    @Override
    protected boolean isSideEffectFree(AnnotatedTypeFactory atypeFactory, ExecutableElement method) {
        LockAnnotatedTypeFactory lockAnnotatedTypeFactory = (LockAnnotatedTypeFactory)atypeFactory;
        return ((LockChecker)lockAnnotatedTypeFactory.getContext()).hasOption("assumeSideEffectFree") || lockAnnotatedTypeFactory.methodSideEffectAnnotation(method, false) == LockAnnotatedTypeFactory.SideEffectAnnotation.RELEASESNOLOCKS || super.isSideEffectFree(atypeFactory, method);
    }

    @Override
    public void updateForMethodCall(MethodInvocationNode n, AnnotatedTypeFactory atypeFactory, CFValue val) {
        super.updateForMethodCall(n, atypeFactory, val);
        ExecutableElement method = n.getTarget().getMethod();
        if (!this.isSideEffectFree(atypeFactory, method)) {
            this.fieldValues.clear();
            this.localVariableValues.clear();
        }
    }

    boolean hasLockHeld(CFValue value) {
        return AnnotationUtils.containsSame(value.getAnnotations(), this.atypeFactory.LOCKHELD);
    }

    boolean hasLockPossiblyHeld(CFValue value) {
        return AnnotationUtils.containsSame(value.getAnnotations(), this.atypeFactory.LOCKPOSSIBLYHELD);
    }

    @Override
    public void insertValue(FlowExpressions.Receiver r, @Nullable CFValue value) {
        if (value == null) {
            return;
        }
        if (this.hasLockHeld(value)) {
            FlowExpressions.MethodCall method;
            CFValue oldValue;
            CFValue newValue;
            if (r instanceof FlowExpressions.FieldAccess) {
                FlowExpressions.FieldAccess fieldAcc = (FlowExpressions.FieldAccess)r;
                CFValue oldValue2 = (CFValue)this.fieldValues.get(fieldAcc);
                CFValue newValue2 = value.mostSpecific(oldValue2, null);
                if (newValue2 != null) {
                    this.fieldValues.put(fieldAcc, newValue2);
                }
            } else if (r instanceof FlowExpressions.MethodCall && (newValue = (CFValue)value.mostSpecific(oldValue = (CFValue)this.methodValues.get(method = (FlowExpressions.MethodCall)r), null)) != null) {
                this.methodValues.put(method, newValue);
            }
        }
        super.insertValue(r, value);
    }
}

