/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.aliasing;

import com.sun.source.tree.Tree;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.checkerframework.common.aliasing.qual.LeakedToResult;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.aliasing.qual.Unique;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class AliasingTransfer
extends CFTransfer {
    private AnnotatedTypeFactory factory;

    public AliasingTransfer(CFAbstractAnalysis<CFValue, CFStore, CFTransfer> analysis) {
        super(analysis);
        this.factory = analysis.getTypeFactory();
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode n, TransferInput<CFValue, CFStore> in) {
        Node rhs = n.getExpression();
        Tree treeRhs = rhs.getTree();
        AnnotatedTypeMirror rhsType = this.factory.getAnnotatedType(treeRhs);
        if (rhsType.hasAnnotation(Unique.class) && (rhs instanceof MethodInvocationNode || rhs instanceof ObjectCreationNode)) {
            return super.visitAssignment(n, in);
        }
        FlowExpressions.Receiver r = FlowExpressions.internalReprOf(this.factory, rhs);
        in.getRegularStore().clearValue(r);
        return new RegularTransferResult<Object, CFStore>(null, in.getRegularStore());
    }

    @Override
    protected void processPostconditions(MethodInvocationNode n, CFStore store, ExecutableElement methodElement, Tree tree) {
        super.processPostconditions(n, store, methodElement, tree);
        if (TreeUtils.isEnumSuper(n.getTree())) {
            return;
        }
        List<Node> args = n.getArguments();
        List<? extends VariableElement> params = methodElement.getParameters();
        assert (args.size() == params.size()) : "Number of arguments in the method call " + n.toString() + " is different from the number of parameters for the method declaration: " + methodElement.getSimpleName().toString();
        AnnotatedTypeMirror.AnnotatedExecutableType annotatedType = this.factory.getAnnotatedType(methodElement);
        List<AnnotatedTypeMirror> paramTypes = annotatedType.getParameterTypes();
        for (int i = 0; i < args.size(); ++i) {
            Node arg = args.get(i);
            AnnotatedTypeMirror paramType = paramTypes.get(i);
            if (paramType.hasAnnotation(NonLeaked.class) || paramType.hasAnnotation(LeakedToResult.class)) continue;
            store.clearValue(FlowExpressions.internalReprOf(this.factory, arg));
        }
        Node receiver = n.getTarget().getReceiver();
        AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = annotatedType.getReceiverType();
        if (receiverType != null && !receiverType.hasAnnotation(LeakedToResult.class) && !receiverType.hasAnnotation(NonLeaked.class)) {
            store.clearValue(FlowExpressions.internalReprOf(this.factory, receiver));
        }
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> in) {
        boolean parentIsStatement;
        Tree parent = n.getTreePath().getParentPath().getLeaf();
        boolean bl = parentIsStatement = parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        if (!parentIsStatement) {
            ExecutableElement methodElement = TreeUtils.elementFromUse(n.getTree());
            List<Node> args = n.getArguments();
            List<? extends VariableElement> params = methodElement.getParameters();
            assert (args.size() == params.size()) : "Number of arguments in the method call " + n.toString() + " is different from the number of parameters for the method declaration: " + methodElement.getSimpleName().toString();
            CFStore store = in.getRegularStore();
            for (int i = 0; i < args.size(); ++i) {
                Node arg = args.get(i);
                VariableElement param = params.get(i);
                if (!this.factory.getAnnotatedType(param).hasAnnotation(LeakedToResult.class)) continue;
                store.clearValue(FlowExpressions.internalReprOf(this.factory, arg));
            }
            Node receiver = n.getTarget().getReceiver();
            AnnotatedTypeMirror.AnnotatedExecutableType annotatedType = this.factory.getAnnotatedType(methodElement);
            AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = annotatedType.getReceiverType();
            if (receiverType != null && receiverType.hasAnnotation(LeakedToResult.class)) {
                store.clearValue(FlowExpressions.internalReprOf(this.factory, receiver));
            }
        }
        return super.visitMethodInvocation(n, in);
    }
}

