/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.framework.test.TestUtilities;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class PerDirectorySuite
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();
    private static final String requiredFormsMessage = "Parameter method must the following form:\n@Parameters String [] getTestDirs()";

    protected List<Runner> getChildren() {
        return this.runners;
    }

    public PerDirectorySuite(Class<?> klass) throws Throwable {
        super(klass, Collections.emptyList());
        TestClass testClass = this.getTestClass();
        Class javaTestClass = testClass.getJavaClass();
        List<List<File>> parametersList = this.getParametersList(testClass);
        for (List<File> parameters : parametersList) {
            this.runners.add((Runner)new PerParameterSetTestRunner(javaTestClass, parameters));
        }
    }

    private List<List<File>> getParametersList(TestClass klass) throws Throwable {
        FrameworkMethod method = this.getParametersMethod(klass);
        if (!method.getReturnType().isArray()) {
            return new ArrayList<List<File>>();
        }
        String[] dirs = (String[])method.invokeExplosively(null, new Object[0]);
        return TestUtilities.findJavaFilesPerDirectory(new File("tests"), dirs);
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) {
        String methodName;
        List parameterMethods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        if (parameterMethods.size() != 1) {
            StringBuilder methods = new StringBuilder();
            if (parameterMethods.isEmpty()) {
                methods.append("[No methods specified]");
            } else {
                boolean first = true;
                for (FrameworkMethod method : parameterMethods) {
                    if (!first) {
                        methods.append(", ");
                    } else {
                        first = false;
                    }
                    methods.append(method.getName());
                }
            }
            throw new RuntimeException("Exactly one of the following methods should be declared:\nParameter method must the following form:\n@Parameters String [] getTestDirs()\ntestClass=" + testClass.getName() + "\nparameterMethods=" + methods.toString());
        }
        FrameworkMethod method = (FrameworkMethod)parameterMethods.get(0);
        Class returnType = method.getReturnType();
        switch (methodName = method.getName()) {
            case "getTestDirs": {
                if (!returnType.isArray() || returnType.getComponentType().equals(String.class)) break;
                throw new RuntimeException("Component type of getTestDirs must be java.lang.String, found " + returnType.getComponentType().getCanonicalName());
            }
            default: {
                throw new RuntimeException("Parameter method must the following form:\n@Parameters String [] getTestDirs()\ntestClass=" + testClass.getName() + "\nparameterMethods=" + method.toString());
            }
        }
        int modifiers = method.getMethod().getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Parameter method (" + method.getName() + ") must be public and static");
        }
        return method;
    }

    private class PerParameterSetTestRunner
    extends BlockJUnit4ClassRunner {
        private final List<File> javaFiles;

        PerParameterSetTestRunner(Class<?> type, List<File> javaFiles) throws InitializationError {
            super(type);
            this.javaFiles = javaFiles;
        }

        public Object createTest() throws Exception {
            Object[] arguments = Collections.singleton(this.javaFiles).toArray();
            return this.getTestClass().getOnlyConstructor().newInstance(arguments);
        }

        String testCaseName() {
            File file = this.javaFiles.get(0).getParentFile();
            return file.getPath().replace("tests" + System.getProperty("file.separator"), "");
        }

        protected String getName() {
            return String.format("[%s]", this.testCaseName());
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s[%s]", method.getName(), this.testCaseName());
        }

        protected void validateZeroArgConstructor(List<Throwable> errors) {
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Name {
    }
}

