/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultRawnessComparer;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.type.visitor.VisitHistory;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.AtmCombo;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TypesUtils;

public class StructuralEqualityComparer
extends AbstractAtmComboVisitor<Boolean, VisitHistory> {
    private final DefaultRawnessComparer fallback;
    private AnnotationMirror currentTop = null;

    public StructuralEqualityComparer() {
        this(null);
    }

    public StructuralEqualityComparer(DefaultRawnessComparer fallback) {
        this.fallback = fallback;
    }

    @Override
    protected Boolean defaultAction(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, VisitHistory visitHistory) {
        if (this.fallback != null) {
            return this.fallback.isValidInHierarchy(type1, type2, this.currentTop, visitHistory);
        }
        return (Boolean)super.defaultAction(type1, type2, visitHistory);
    }

    public boolean areEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        return AtmCombo.accept(type1, type2, new VisitHistory(), this);
    }

    public boolean areEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, VisitHistory visited) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        return AtmCombo.accept(type1, type2, visited, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areEqualInHierarchy(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, AnnotationMirror top) {
        boolean areEqual;
        AnnotationMirror prevTop = this.currentTop;
        this.currentTop = top;
        try {
            areEqual = this.areEqual(type1, type2);
        }
        finally {
            this.currentTop = prevTop;
        }
        return areEqual;
    }

    protected boolean arePrimeAnnosEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2) {
        if (this.currentTop != null) {
            return AnnotationUtils.areSame(type1.getAnnotationInHierarchy(this.currentTop), type2.getAnnotationInHierarchy(this.currentTop));
        }
        return AnnotationUtils.areSame(type1.getAnnotations(), type2.getAnnotations());
    }

    protected boolean areAllEqual(Collection<? extends AnnotatedTypeMirror> types1, Collection<? extends AnnotatedTypeMirror> types2, VisitHistory visited) {
        if (types1.size() != types2.size()) {
            ErrorReporter.errorAbort("Mismatching collection sizes:\n" + PluginUtil.join(",", types1) + "\n" + PluginUtil.join(",", types2));
        }
        Iterator<? extends AnnotatedTypeMirror> types1Iter = types1.iterator();
        Iterator<? extends AnnotatedTypeMirror> types2Iter = types2.iterator();
        while (types1Iter.hasNext()) {
            AnnotatedTypeMirror type2;
            AnnotatedTypeMirror type1 = types1Iter.next();
            if (this.checkOrAreEqual(type1, type2 = types2Iter.next(), visited)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkOrAreEqual(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, VisitHistory visited) {
        if (visited.contains(type1, type2)) {
            return true;
        }
        Boolean result = this.areEqual(type1, type2, visited);
        visited.add(type1, type2);
        return result;
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, VisitHistory visited) {
        return "AnnotatedTypeMirror classes aren't equal.\ntype1 = " + type1.getClass().getSimpleName() + "( " + type1 + " )\ntype2 = " + type2.getClass().getSimpleName() + "( " + type2 + " )\nvisitHistory = " + visited;
    }

    @Override
    public Boolean visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType type1, AnnotatedTypeMirror.AnnotatedArrayType type2, VisitHistory visited) {
        if (!this.arePrimeAnnosEqual(type1, type2)) {
            return false;
        }
        return this.areEqual(type1.getComponentType(), type2.getComponentType(), visited);
    }

    @Override
    public Boolean visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, VisitHistory visited) {
        if (visited.contains(type1, type2)) {
            return true;
        }
        if (!this.arePrimeAnnosEqual(type1, type2)) {
            return false;
        }
        visited.add(type1, type2);
        return this.visitTypeArgs(type1, type2, visited);
    }

    protected Boolean visitTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, VisitHistory visited) {
        List<AnnotatedTypeMirror> type1Args = type1.getTypeArguments();
        List<AnnotatedTypeMirror> type2Args = type2.getTypeArguments();
        if (type1Args.isEmpty() || type2Args.isEmpty()) {
            return true;
        }
        if (type1Args.size() > 0 && !this.areAllEqual(type1Args, type2Args, visited)) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType type1, AnnotatedTypeMirror.AnnotatedIntersectionType type2, VisitHistory visited) {
        if (!this.arePrimeAnnosEqual(type1, type2)) {
            return false;
        }
        visited.add(type1, type2);
        return this.areAllEqual(type1.directSuperTypes(), type2.directSuperTypes(), visited);
    }

    @Override
    public Boolean visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType type1, AnnotatedTypeMirror.AnnotatedNullType type2, VisitHistory visited) {
        return this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    public Boolean visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type1, AnnotatedTypeMirror.AnnotatedPrimitiveType type2, VisitHistory visited) {
        return this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    public Boolean visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2, VisitHistory visited) {
        if (visited.contains(type1, type2)) {
            return true;
        }
        visited.add(type1, type2);
        if ((InternalUtils.isCaptured(type1.getUnderlyingType()) || InternalUtils.isCaptured(type2.getUnderlyingType())) && !this.boundsMatch(type1, type2)) {
            return this.subtypeAndCompare(type1.getUpperBound(), type2.getUpperBound(), visited) && this.subtypeAndCompare(type1.getLowerBound(), type2.getLowerBound(), visited);
        }
        visited.add(type1, type2);
        return this.areEqual(type1.getUpperBound(), type2.getUpperBound(), visited) && this.areEqual(type1.getLowerBound(), type2.getLowerBound(), visited);
    }

    boolean subtypeAndCompare(AnnotatedTypeMirror type1, AnnotatedTypeMirror type2, VisitHistory visited) {
        AnnotatedTypeMirror t2;
        AnnotatedTypeMirror t1;
        Types types = type1.atypeFactory.types;
        if (type1.getKind() == TypeKind.NULL && type2.getKind() == TypeKind.NULL) {
            return this.areEqual(type1, type2);
        }
        if (type1.getKind() == TypeKind.NULL || type2.getKind() == TypeKind.NULL) {
            t1 = type1;
            t2 = type2;
        } else if (types.isSubtype(type2.getUnderlyingType(), type1.getUnderlyingType())) {
            t1 = type1;
            t2 = AnnotatedTypes.asSuper(type1.atypeFactory, type2, type1);
        } else if (types.isSubtype(type1.getUnderlyingType(), type2.getUnderlyingType())) {
            t1 = AnnotatedTypes.asSuper(type1.atypeFactory, type1, type2);
            t2 = type2;
        } else {
            t1 = null;
            t2 = null;
        }
        if (t1 == null || t2 == null) {
            QualifierHierarchy qualifierHierarchy = type1.atypeFactory.getQualifierHierarchy();
            if (this.currentTop == null) {
                return AnnotationUtils.areSame(AnnotatedTypes.findEffectiveAnnotations(qualifierHierarchy, type1), AnnotatedTypes.findEffectiveAnnotations(qualifierHierarchy, type2));
            }
            return AnnotationUtils.areSame(AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, type1, this.currentTop), AnnotatedTypes.findEffectiveAnnotationInHierarchy(qualifierHierarchy, type2, this.currentTop));
        }
        return this.areEqual(t1, t2, visited);
    }

    public boolean boundsMatch(AnnotatedTypeMirror.AnnotatedTypeVariable type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2) {
        return type1.getUpperBound().getUnderlyingType().equals(type2.getUpperBound().getUnderlyingType()) && type1.getLowerBound().getUnderlyingType().equals(type2.getLowerBound().getUnderlyingType());
    }

    @Override
    public Boolean visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedWildcardType type2, VisitHistory visited) {
        if (visited.contains(type1, type2)) {
            return true;
        }
        visited.add(type1, type2);
        return this.areEqual(type1.getExtendsBound(), type2.getExtendsBound(), visited) && this.areEqual(type1.getSuperBound(), type2.getSuperBound(), visited);
    }

    @Override
    public Boolean visitDeclared_Primitive(AnnotatedTypeMirror.AnnotatedDeclaredType type1, AnnotatedTypeMirror.AnnotatedPrimitiveType type2, VisitHistory visitHistory) {
        if (!TypesUtils.isBoxOf(type1.getUnderlyingType(), type2.getUnderlyingType())) {
            this.defaultErrorMessage((AnnotatedTypeMirror)type1, (AnnotatedTypeMirror)type2, visitHistory);
        }
        return this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    public Boolean visitPrimitive_Declared(AnnotatedTypeMirror.AnnotatedPrimitiveType type1, AnnotatedTypeMirror.AnnotatedDeclaredType type2, VisitHistory visitHistory) {
        if (!TypesUtils.isBoxOf(type2.getUnderlyingType(), type1.getUnderlyingType())) {
            this.defaultErrorMessage((AnnotatedTypeMirror)type1, (AnnotatedTypeMirror)type2, visitHistory);
        }
        return this.arePrimeAnnosEqual(type1, type2);
    }

    @Override
    public Boolean visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType type1, AnnotatedTypeMirror.AnnotatedTypeVariable type2, VisitHistory visited) {
        if (visited.contains(type1, type2)) {
            return true;
        }
        visited.add(type1, type2);
        return this.areEqual(type1.getExtendsBound(), type2.getUpperBound(), visited) && this.areEqual(type1.getSuperBound(), type2.getLowerBound(), visited);
    }
}

