/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCConflictDescription17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbConflicts
extends SvnWcDbShared {
    private static final String CONFLICT_OP_UPDATE = "update";
    private static final String CONFLICT_OP_SWITCH = "switch";
    private static final String CONFLICT_OP_MERGE = "merge";

    public static SVNSkel convertToConflictSkel(String conflictOld, String conflictWorking, String conflictNew, String propReject, byte[] treeConflictData) throws SVNException {
        SVNSkel conflictData = null;
        if (conflictOld != null || conflictNew != null || conflictWorking != null) {
            conflictData = SvnWcDbConflicts.createConflictSkel();
            SvnWcDbConflicts.addTextConflict(conflictData, conflictWorking, conflictOld, conflictNew);
        }
        if (propReject != null) {
            if (conflictData == null) {
                conflictData = SvnWcDbConflicts.createConflictSkel();
            }
            SvnWcDbConflicts.addPropConflict(conflictData, propReject);
        }
        if (treeConflictData != null) {
            if (conflictData == null) {
                conflictData = SvnWcDbConflicts.createConflictSkel();
            }
            SVNSkel tcSkel = SVNSkel.parse(treeConflictData);
            File fakePath = SVNFileUtil.createFilePath("");
            SVNTreeConflictDescription tcDesc = SVNTreeConflictUtil.readSingleTreeConflict(tcSkel, fakePath);
            SvnWcDbConflicts.addTreeConflict(conflictData, tcDesc.getConflictReason(), tcDesc.getConflictAction());
            if (tcDesc.getOperation() != null && tcDesc.getOperation() != SVNOperation.NONE) {
                SvnWcDbConflicts.setConflictOperation(conflictData, tcDesc.getOperation(), tcDesc.getSourceLeftVersion(), tcDesc.getSourceRightVersion());
            }
        } else if (conflictData != null) {
            SvnWcDbConflicts.setConflictOperation(conflictData, SVNOperation.UPDATE, null, null);
        }
        return conflictData;
    }

    public static SVNSkel convertToConflictSkel(File wcRootAbsPath, SVNWCDb db, String localRelpath, String conflictOld, String conflictWorking, String conflictNew, String propReject, byte[] treeConflictData) throws SVNException {
        SVNSkel conflictData = null;
        if (conflictOld != null || conflictNew != null || conflictWorking != null) {
            conflictData = SvnWcDbConflicts.createConflictSkel();
            File oldAbsPath = null;
            File newAbsPath = null;
            File wrkAbsPath = null;
            if (conflictOld != null) {
                oldAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, conflictOld);
            }
            if (conflictNew != null) {
                newAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, conflictNew);
            }
            if (conflictWorking != null) {
                wrkAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, conflictWorking);
            }
            SvnWcDbConflicts.addTextConflict(conflictData, db, wcRootAbsPath, wrkAbsPath, oldAbsPath, newAbsPath);
        }
        if (propReject != null) {
            if (conflictData == null) {
                conflictData = SvnWcDbConflicts.createConflictSkel();
            }
            File prejAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, propReject);
            SvnWcDbConflicts.addPropConflict(conflictData, db, wcRootAbsPath, prejAbsPath, null, null, null, Collections.<String>emptySet());
        }
        if (treeConflictData != null) {
            if (conflictData == null) {
                conflictData = SvnWcDbConflicts.createConflictSkel();
            }
            SVNSkel tcSkel = SVNSkel.parse(treeConflictData);
            File localAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, localRelpath);
            SVNTreeConflictDescription tcDesc = SVNTreeConflictUtil.readSingleTreeConflict(tcSkel, localAbsPath);
            SvnWcDbConflicts.addTreeConflict(conflictData, db, wcRootAbsPath, tcDesc.getConflictReason(), tcDesc.getConflictAction(), null);
            if (tcDesc.getOperation() != null && tcDesc.getOperation() != SVNOperation.NONE) {
                SvnWcDbConflicts.setConflictOperation(conflictData, tcDesc.getOperation(), tcDesc.getSourceLeftVersion(), tcDesc.getSourceRightVersion());
            }
        } else if (conflictData != null) {
            SvnWcDbConflicts.setConflictOperation(conflictData, SVNOperation.UPDATE, null, null);
        }
        return conflictData;
    }

    public static List<SVNWCConflictDescription17> convertFromSkel(SVNWCDb db, File localAbsPath, boolean createTempFiles, SVNSkel conflictSkel) throws SVNException {
        ArrayList<SVNWCConflictDescription17> conflicts = new ArrayList<SVNWCConflictDescription17>();
        if (conflictSkel == null) {
            return conflicts;
        }
        Structure<ConflictInfo> conflictInfo = SvnWcDbConflicts.readConflictInfo(conflictSkel);
        List locations = (List)conflictInfo.get(ConflictInfo.locations);
        SVNConflictVersion leftVersion = null;
        SVNConflictVersion rightVersion = null;
        if (locations != null && locations.size() > 0) {
            leftVersion = (SVNConflictVersion)locations.get(0);
        }
        if (locations != null && locations.size() > 1) {
            rightVersion = (SVNConflictVersion)locations.get(1);
        }
        if (conflictInfo.is(ConflictInfo.propConflicted)) {
            SvnWcDbConflicts.readPropertyConflicts(conflicts, db, localAbsPath, conflictSkel, createTempFiles, (SVNOperation)conflictInfo.get(ConflictInfo.conflictOperation), leftVersion, rightVersion);
        }
        if (conflictInfo.is(ConflictInfo.textConflicted)) {
            Structure<TextConflictInfo> textConflictInfo = SvnWcDbConflicts.readTextConflict(db, localAbsPath, conflictSkel);
            SVNWCConflictDescription17 description = SVNWCConflictDescription17.createText(localAbsPath);
            description.setOperation((SVNOperation)conflictInfo.get(ConflictInfo.conflictOperation));
            description.setSrcLeftVersion(leftVersion);
            description.setSrcRightVersion(rightVersion);
            description.setTheirFile((File)textConflictInfo.get(TextConflictInfo.theirAbsPath));
            description.setBaseFile((File)textConflictInfo.get(TextConflictInfo.theirOldAbsPath));
            description.setMyFile((File)textConflictInfo.get(TextConflictInfo.mineAbsPath));
            description.setMergedFile(localAbsPath);
            conflicts.add(description);
        }
        if (conflictInfo.is(ConflictInfo.treeConflicted)) {
            Structure<TreeConflictInfo> treeConflictInfo = SvnWcDbConflicts.readTreeConflict(db, localAbsPath, conflictSkel);
            SVNNodeKind tcKind = leftVersion != null ? leftVersion.getKind() : (rightVersion != null ? rightVersion.getKind() : SVNNodeKind.FILE);
            SVNWCConflictDescription17 description = SVNWCConflictDescription17.createTree(localAbsPath, tcKind, (SVNOperation)conflictInfo.get(ConflictInfo.conflictOperation), leftVersion, rightVersion);
            description.setReason((SVNConflictReason)treeConflictInfo.get(TreeConflictInfo.localChange));
            description.setAction((SVNConflictAction)treeConflictInfo.get(TreeConflictInfo.incomingChange));
            conflicts.add(description);
        }
        return conflicts;
    }

    public static SVNSkel createConflictSkel() throws SVNException {
        SVNSkel skel = SVNSkel.createEmptyList();
        skel.prepend(SVNSkel.createEmptyList());
        skel.prepend(SVNSkel.createEmptyList());
        return skel;
    }

    public static boolean isConflictSkelComplete(SVNSkel skel) throws SVNException {
        if (skel == null || skel.getListSize() < 2) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Not a conflict skel");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (skel.first().getListSize() < 2) {
            return false;
        }
        return skel.first().next().getListSize() != 0;
    }

    public static void prependLocation(SVNSkel skel, SVNConflictVersion location) throws SVNException {
        SVNSkel loc = SVNSkel.createEmptyList();
        if (location == null) {
            skel.prepend(loc);
            return;
        }
        loc.prepend(SVNSkel.createAtom(location.getKind().toString()));
        loc.prepend(SVNSkel.createAtom(Long.toString(location.getPegRevision())));
        loc.prepend(SVNSkel.createAtom(location.getPath()));
        loc.prepend(SVNSkel.createEmptyList());
        loc.prepend(SVNSkel.createAtom(location.getRepositoryRoot().toString()));
        loc.prepend(SVNSkel.createAtom("subversion"));
        skel.prepend(loc);
    }

    public static void setConflictOperation(SVNSkel skel, SVNOperation operation, SVNConflictVersion original, SVNConflictVersion target) throws SVNException {
        SVNSkel why = skel.first();
        SVNSkel origins = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(origins, target);
        SvnWcDbConflicts.prependLocation(origins, original);
        why.prepend(origins);
        why.prepend(SVNSkel.createAtom(operation.getName()));
    }

    public static void addTextConflict(SVNSkel skel, ISVNWCDb db, File wriAbsPath, File mineAbsPath, File theirOldAbsPath, File theirAbsPath) throws SVNException {
        SVNSkel textConflict = SVNSkel.createEmptyList();
        SVNSkel markers = SVNSkel.createEmptyList();
        if (theirAbsPath != null) {
            File theirRelPath = db.toRelPath(theirAbsPath);
            markers.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(theirRelPath)));
        } else {
            markers.prepend(SVNSkel.createEmptyList());
        }
        if (mineAbsPath != null) {
            File mineRelPath = db.toRelPath(mineAbsPath);
            markers.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(mineRelPath)));
        } else {
            markers.prepend(SVNSkel.createEmptyList());
        }
        if (theirOldAbsPath != null) {
            File theirOldRelPath = db.toRelPath(theirOldAbsPath);
            markers.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(theirOldRelPath)));
        } else {
            markers.prepend(SVNSkel.createEmptyList());
        }
        textConflict.prepend(markers);
        textConflict.prepend(SVNSkel.createAtom(ConflictKind.text.toString()));
        skel.first().next().prepend(textConflict);
    }

    public static void addPropConflict(SVNSkel skel, ISVNWCDb db, File wriAbsPath, File markerAbsPath, SVNProperties mineProps, SVNProperties theirOldProps, SVNProperties theirProps, Collection<String> conflictedPropNames) throws SVNException {
        SVNSkel propConflict = SVNSkel.createEmptyList();
        if (theirProps != null) {
            propConflict.prepend(SVNSkel.createPropList(theirProps.asMap()));
        } else {
            propConflict.prepend(SVNSkel.createAtom(""));
        }
        if (mineProps != null) {
            propConflict.prepend(SVNSkel.createPropList(mineProps.asMap()));
        } else {
            propConflict.prepend(SVNSkel.createAtom(""));
        }
        if (theirOldProps != null) {
            propConflict.prepend(SVNSkel.createPropList(theirOldProps.asMap()));
        } else {
            propConflict.prepend(SVNSkel.createAtom(""));
        }
        SVNSkel conflictNames = SVNSkel.createEmptyList();
        for (String propertyName : conflictedPropNames) {
            conflictNames.prepend(SVNSkel.createAtom(propertyName));
        }
        propConflict.prepend(conflictNames);
        SVNSkel markers = SVNSkel.createEmptyList();
        if (markerAbsPath != null) {
            File markerRelPath = db.toRelPath(markerAbsPath);
            markers.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(markerRelPath)));
        }
        propConflict.prepend(markers);
        propConflict.prepend(SVNSkel.createAtom(ConflictKind.prop.toString()));
        skel.first().next().prepend(propConflict);
    }

    public static void addTreeConflict(SVNSkel skel, ISVNWCDb db, File wriAbsPath, SVNConflictReason localChange, SVNConflictAction incomingChange, File moveSrcOpRootAbsPath) throws SVNException {
        SVNSkel treeConflict = SVNSkel.createEmptyList();
        if (localChange == SVNConflictReason.MOVED_AWAY && moveSrcOpRootAbsPath != null) {
            File moveSrcOpRootRelPath = db.toRelPath(moveSrcOpRootAbsPath);
            treeConflict.prepend(SVNSkel.createAtom(SVNFileUtil.getFilePath(moveSrcOpRootRelPath)));
        }
        treeConflict.prepend(SVNSkel.createAtom(incomingChange.getName()));
        treeConflict.prepend(SVNSkel.createAtom(localChange.getName()));
        SVNSkel markers = SVNSkel.createEmptyList();
        treeConflict.prepend(markers);
        treeConflict.prepend(SVNSkel.createAtom(ConflictKind.tree.toString()));
        skel.first().next().prepend(treeConflict);
    }

    public static SVNSkel readConflict(SVNWCDb db, File localAbspath) throws SVNException {
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        File localRelPath = dirInfo.localRelPath;
        return SvnWcDbConflicts.readConflictInternal(dirInfo.wcDbDir.getWCRoot(), localRelPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNSkel readConflictInternal(SVNWCDbRoot wcRoot, File localRelPath) throws SVNException {
        long wcId = wcRoot.getWcId();
        SVNSqlJetDb sdb = wcRoot.getSDb();
        String localRelPathStr = localRelPath.getPath().replace(File.separatorChar, '/');
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
        try {
            byte[] conflictData;
            stmt.bindf("is", wcId, localRelPathStr);
            if (!stmt.next()) {
                SVNSqlJetStatement stmtNode = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
                try {
                    stmtNode.bindf("is", wcId, localRelPathStr);
                    if (stmtNode.next()) {
                        SVNSkel sVNSkel = null;
                        return sVNSkel;
                    }
                }
                finally {
                    SvnWcDbStatementUtil.reset(stmtNode);
                }
                File localAbspath = SVNFileUtil.createFilePath(wcRoot.getAbsPath(), localRelPath);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if ((conflictData = stmt.getColumnBlob(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data)) != null) {
                SVNSkel sVNSkel = SVNSkel.parse(conflictData);
                return sVNSkel;
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        return null;
    }

    public static Structure<ConflictInfo> readConflictInfo(SVNSkel conflictSkel) throws SVNException {
        Object result = Structure.obtain(ConflictInfo.class);
        SVNSkel operation = SvnWcDbConflicts.readConflictOperation(conflictSkel);
        if (operation == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Not a completed conflict skel");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNSkel c = operation.first();
        ((Structure)result).set((ConflictInfo)ConflictInfo.conflictOperation, SVNOperation.fromString(c.getValue()));
        c = c.next();
        ArrayList<SVNConflictVersion> locations = new ArrayList<SVNConflictVersion>();
        ((Structure)result).set((ConflictInfo)ConflictInfo.locations, locations);
        for (int i = 0; i < c.getListSize(); ++i) {
            SVNConflictVersion location = SvnWcDbConflicts.readConflictLocation(c.getChild(i));
            locations.add(location);
        }
        ((Structure)result).set((ConflictInfo)ConflictInfo.textConflicted, SvnWcDbConflicts.hasConflictKind(conflictSkel, ConflictKind.text));
        ((Structure)result).set((ConflictInfo)ConflictInfo.propConflicted, SvnWcDbConflicts.hasConflictKind(conflictSkel, ConflictKind.prop));
        ((Structure)result).set((ConflictInfo)ConflictInfo.treeConflicted, SvnWcDbConflicts.hasConflictKind(conflictSkel, ConflictKind.tree));
        return result;
    }

    public static void readPropertyConflicts(List<SVNWCConflictDescription17> target, SVNWCDb db, File localAbsPath, SVNSkel conflictSkel, boolean createTempFiles, SVNOperation operation, SVNConflictVersion leftVersion, SVNConflictVersion rightVersion) throws SVNException {
        Structure<PropertyConflictInfo> propertyConflictInfo = SvnWcDbConflicts.readPropertyConflict(db, localAbsPath, conflictSkel);
        Set conflictedProps = (Set)propertyConflictInfo.get(PropertyConflictInfo.conflictedPropNames);
        if (!createTempFiles || conflictedProps.isEmpty()) {
            SVNWCConflictDescription17 description = SVNWCConflictDescription17.createProp(localAbsPath, SVNNodeKind.UNKNOWN, "");
            description.setTheirFile((File)propertyConflictInfo.get(PropertyConflictInfo.markerAbspath));
            description.setOperation(operation);
            description.setSrcLeftVersion(leftVersion);
            description.setSrcRightVersion(rightVersion);
            target.add(description);
            return;
        }
        File tmpFileRoot = db.getWCRootTempDir(localAbsPath);
        for (String propertyName : conflictedProps) {
            File tempFile;
            SVNWCConflictDescription17 description = SVNWCConflictDescription17.createProp(localAbsPath, SVNNodeKind.UNKNOWN, propertyName);
            description.setOperation(operation);
            description.setSrcLeftVersion(leftVersion);
            description.setSrcRightVersion(rightVersion);
            description.setPropertyName(propertyName);
            Map mineProps = (Map)propertyConflictInfo.get(PropertyConflictInfo.mineProps);
            Map theirProps = (Map)propertyConflictInfo.get(PropertyConflictInfo.theirProps);
            Map oldProps = (Map)propertyConflictInfo.get(PropertyConflictInfo.theirOldProps);
            byte[] mineValue = (byte[])mineProps.get(propertyName);
            byte[] theirValue = (byte[])theirProps.get(propertyName);
            byte[] oldValue = (byte[])oldProps.get(propertyName);
            if (theirValue == null) {
                description.setAction(SVNConflictAction.DELETE);
            } else if (mineValue == null) {
                description.setAction(SVNConflictAction.ADD);
            } else {
                description.setAction(SVNConflictAction.EDIT);
            }
            if (mineValue == null) {
                description.setReason(SVNConflictReason.DELETED);
            } else if (theirValue == null) {
                description.setReason(SVNConflictReason.ADDED);
            } else {
                description.setReason(SVNConflictReason.EDITED);
            }
            description.setTheirFile((File)propertyConflictInfo.get(PropertyConflictInfo.markerAbspath));
            if (mineValue != null) {
                tempFile = SVNFileUtil.createUniqueFile(tmpFileRoot, "svn.", ".prop.tmp", false);
                description.setMyFile(tempFile);
                SVNFileUtil.writeToFile(tempFile, mineValue);
            }
            if (theirValue != null) {
                tempFile = SVNFileUtil.createUniqueFile(tmpFileRoot, "svn.", ".prop.tmp", false);
                description.setMergedFile(tempFile);
                SVNFileUtil.writeToFile(tempFile, theirValue);
            }
            if (oldValue != null) {
                tempFile = SVNFileUtil.createUniqueFile(tmpFileRoot, "svn.", ".prop.tmp", false);
                description.setBaseFile(tempFile);
                SVNFileUtil.writeToFile(tempFile, oldValue);
            }
            target.add(description);
        }
    }

    public static Structure<PropertyConflictInfo> readPropertyConflict(ISVNWCDb db, File wriAbsPath, SVNSkel conflictSkel) throws SVNException {
        SVNSkel propConflict = SvnWcDbConflicts.getConflict(conflictSkel, ConflictKind.prop);
        if (propConflict == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Conflict not set");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        Object result = Structure.obtain(PropertyConflictInfo.class);
        SVNSkel c = propConflict.first().next();
        if (c.first() != null && c.first().isAtom()) {
            File markerRelpath = SVNFileUtil.createFilePath(c.first().getValue());
            ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.markerAbspath, db.fromRelPath(wriAbsPath, markerRelpath));
        }
        c = c.next();
        HashSet<String> conflictedPropertyNames = new HashSet<String>();
        for (int i = 0; i < c.getListSize(); ++i) {
            conflictedPropertyNames.add(c.getChild(i).getValue());
        }
        ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.conflictedPropNames, conflictedPropertyNames);
        c = c.next();
        if (c.isValidPropList()) {
            ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.theirOldProps, c.parsePropList());
        } else {
            ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.theirOldProps, new HashMap());
        }
        c = c.next();
        if (c.isValidPropList()) {
            ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.mineProps, c.parsePropList());
        } else {
            ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.mineProps, new HashMap());
        }
        c = c.next();
        if (c.isValidPropList()) {
            ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.theirProps, c.parsePropList());
        } else {
            ((Structure)result).set((PropertyConflictInfo)PropertyConflictInfo.theirProps, new HashMap());
        }
        return result;
    }

    public static Structure<TextConflictInfo> readTextConflict(ISVNWCDb db, File wriAbsPath, SVNSkel conflictSkel) throws SVNException {
        File path;
        SVNSkel textConflict = SvnWcDbConflicts.getConflict(conflictSkel, ConflictKind.text);
        if (textConflict == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Conflict not set");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        Object result = Structure.obtain(TextConflictInfo.class);
        SVNSkel m3 = textConflict.first().next().first();
        if (m3.isAtom()) {
            path = db.fromRelPath(db.getWCRoot(wriAbsPath), new File(m3.getValue()));
            ((Structure)result).set((TextConflictInfo)TextConflictInfo.theirOldAbsPath, path);
        }
        if ((m3 = m3.next()).isAtom()) {
            path = db.fromRelPath(db.getWCRoot(wriAbsPath), new File(m3.getValue()));
            ((Structure)result).set((TextConflictInfo)TextConflictInfo.mineAbsPath, path);
        }
        if ((m3 = m3.next()).isAtom()) {
            path = db.fromRelPath(db.getWCRoot(wriAbsPath), new File(m3.getValue()));
            ((Structure)result).set((TextConflictInfo)TextConflictInfo.theirAbsPath, path);
        }
        return result;
    }

    public static Structure<TreeConflictInfo> readTreeConflict(ISVNWCDb db, File wriAbsPath, SVNSkel conflictSkel) throws SVNException {
        SVNSkel treeConflict = SvnWcDbConflicts.getConflict(conflictSkel, ConflictKind.tree);
        if (treeConflict == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Conflict not set");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        Object result = Structure.obtain(TreeConflictInfo.class);
        SVNSkel c = treeConflict.first().next().next();
        SVNConflictReason reason = SVNConflictReason.fromString(c.getValue());
        if (reason == null) {
            reason = SVNConflictReason.EDITED;
        }
        boolean movedAway = reason == SVNConflictReason.MOVED_AWAY;
        ((Structure)result).set((TreeConflictInfo)TreeConflictInfo.localChange, reason);
        c = c.next();
        SVNConflictAction incoming = SVNConflictAction.fromString(c.getValue());
        if (incoming == null) {
            incoming = SVNConflictAction.EDIT;
        }
        ((Structure)result).set((TreeConflictInfo)TreeConflictInfo.incomingChange, incoming);
        c = c.next();
        if (c != null && movedAway) {
            ((Structure)result).set((TreeConflictInfo)TreeConflictInfo.moveSrcOpRootAbsPath, db.fromRelPath(db.getWCRoot(wriAbsPath), new File(c.getValue())));
        }
        return result;
    }

    public static Structure<ConflictStatus> getConflictStatusForUpdate(SVNWCDb db, File localAbsPath, boolean treeConflictOnly) throws SVNException {
        Structure<ConflictStatus> result = SvnWcDbConflicts.getConflictStatus(db, localAbsPath);
        if (treeConflictOnly) {
            result.set(ConflictStatus.conflicted, result.is(ConflictStatus.treeConflicted));
        } else {
            result.set(ConflictStatus.conflicted, result.is(ConflictStatus.treeConflicted) || result.is(ConflictStatus.textConflicted) || result.is(ConflictStatus.propConflicted));
        }
        return result;
    }

    private static Structure<ConflictStatus> getConflictStatus(SVNWCDb db, File localAbsPath) throws SVNException {
        Structure<Enum> pc;
        Object result = Structure.obtain(ConflictStatus.class);
        SVNSkel conflicts = SvnWcDbConflicts.readConflict(db, localAbsPath);
        if (conflicts == null) {
            return result;
        }
        boolean resolvedText = false;
        boolean resolvedProps = false;
        Structure<ConflictInfo> conflictsInfo = SvnWcDbConflicts.readConflictInfo(conflicts);
        if (conflictsInfo.is(ConflictInfo.textConflicted)) {
            Structure<TextConflictInfo> tc = SvnWcDbConflicts.readTextConflict(db, localAbsPath, conflicts);
            File mineAbsPath = (File)tc.get(TextConflictInfo.mineAbsPath);
            File theirAbsPath = (File)tc.get(TextConflictInfo.theirAbsPath);
            File theirOldAbsPath = (File)tc.get(TextConflictInfo.theirOldAbsPath);
            boolean done = false;
            if (mineAbsPath != null) {
                ((Structure)result).set((ConflictStatus)ConflictStatus.textConflicted, SVNFileType.getType(mineAbsPath) == SVNFileType.FILE);
                done = ((Structure)result).is((ConflictStatus)ConflictStatus.textConflicted);
            }
            if (!done && theirAbsPath != null) {
                ((Structure)result).set((ConflictStatus)ConflictStatus.textConflicted, SVNFileType.getType(theirAbsPath) == SVNFileType.FILE);
                done = ((Structure)result).is((ConflictStatus)ConflictStatus.textConflicted);
            }
            if (!done && theirOldAbsPath != null) {
                ((Structure)result).set((ConflictStatus)ConflictStatus.textConflicted, SVNFileType.getType(theirOldAbsPath) == SVNFileType.FILE);
                done = ((Structure)result).is((ConflictStatus)ConflictStatus.textConflicted);
            }
            if (!(done || mineAbsPath == null && theirAbsPath == null && theirOldAbsPath == null)) {
                resolvedText = false;
            }
        }
        if (conflictsInfo.is(ConflictInfo.propConflicted)) {
            pc = SvnWcDbConflicts.readPropertyConflict(db, localAbsPath, conflicts);
            File propRejectPath = (File)pc.get(PropertyConflictInfo.markerAbspath);
            if (propRejectPath != null) {
                ((Structure)result).set((ConflictStatus)ConflictStatus.propConflicted, SVNFileType.getType(propRejectPath) == SVNFileType.FILE);
            }
            if (!((Structure)result).is((ConflictStatus)ConflictStatus.propConflicted)) {
                resolvedProps = true;
            }
        }
        if (conflictsInfo.is(ConflictInfo.treeConflicted)) {
            pc = SvnWcDbConflicts.readTreeConflict(db, localAbsPath, conflicts);
            SVNConflictReason reason = (SVNConflictReason)pc.get((PropertyConflictInfo)((Object)TreeConflictInfo.incomingChange));
            SVNConflictAction action = (SVNConflictAction)pc.get(TreeConflictInfo.localChange);
            if (reason == SVNConflictReason.MOVED_AWAY && action == SVNConflictAction.EDIT) {
                ((Structure)result).set((ConflictStatus)ConflictStatus.treeConflicted, false);
                ((Structure)result).set((ConflictStatus)ConflictStatus.conflictIgnored, true);
            }
        }
        if ((resolvedProps || resolvedText) && db.isWCLockOwns(localAbsPath, false)) {
            db.opMarkResolved(localAbsPath, resolvedText, resolvedProps, false, null);
        }
        return result;
    }

    private static SVNSkel readConflictOperation(SVNSkel conflictSkel) {
        return conflictSkel.first();
    }

    private static boolean hasConflictKind(SVNSkel conflictSkel, ConflictKind kind) {
        return SvnWcDbConflicts.getConflict(conflictSkel, kind) != null;
    }

    public static SVNSkel getConflict(SVNSkel conflictSkel, ConflictKind kind) {
        for (SVNSkel c = conflictSkel.first().next().first(); c != null; c = c.next()) {
            if (!kind.name().equalsIgnoreCase(c.first().getValue())) continue;
            return c;
        }
        return null;
    }

    private static SVNConflictVersion readConflictLocation(SVNSkel locationSkel) throws SVNException {
        SVNSkel c = locationSkel.first();
        if (c == null || !c.contentEquals("subversion")) {
            return null;
        }
        c = c.next();
        SVNURL repositoryRootURL = SVNURL.parseURIEncoded(c.getValue());
        c = c.next();
        c = c.next();
        String reposRelPath = c.getValue();
        c = c.next();
        long revision = Long.parseLong(c.getValue());
        c = c.next();
        SVNNodeKind nodeKind = SVNNodeKind.parseKind(c.getValue());
        return new SVNConflictVersion(repositoryRootURL, reposRelPath, revision, nodeKind);
    }

    public static void conflictSkelOpUpdate(SVNSkel conflictSkel, SVNConflictVersion original, SVNConflictVersion target) throws SVNException {
        assert (conflictSkel != null && conflictSkel.first() != null && conflictSkel.first().next() != null && !conflictSkel.first().next().isAtom());
        SVNSkel why = SvnWcDbConflicts.getOperation(conflictSkel);
        assert (why == null);
        why = conflictSkel.getChild(0);
        SVNSkel origins = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(origins, target);
        SvnWcDbConflicts.prependLocation(origins, original);
        why.prepend(origins);
        why.prependString(CONFLICT_OP_UPDATE);
    }

    public static void conflictSkelOpSwitch(SVNSkel conflictSkel, SVNConflictVersion original, SVNConflictVersion target) throws SVNException {
        assert (conflictSkel != null && conflictSkel.first() != null && conflictSkel.first().next() != null && !conflictSkel.first().next().isAtom());
        SVNSkel why = SvnWcDbConflicts.getOperation(conflictSkel);
        assert (why == null);
        why = conflictSkel.getChild(0);
        SVNSkel origins = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(origins, target);
        SvnWcDbConflicts.prependLocation(origins, original);
        why.prepend(origins);
        why.prependString(CONFLICT_OP_SWITCH);
    }

    public static void conflictSkelOpMerge(SVNSkel conflictSkel, SVNConflictVersion original, SVNConflictVersion target) throws SVNException {
        assert (conflictSkel != null && conflictSkel.first() != null && conflictSkel.first().next() != null && !conflictSkel.first().next().isAtom());
        SVNSkel why = SvnWcDbConflicts.getOperation(conflictSkel);
        assert (why == null);
        why = conflictSkel.getChild(0);
        SVNSkel origins = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependLocation(origins, target);
        SvnWcDbConflicts.prependLocation(origins, original);
        why.prepend(origins);
        why.prependString(CONFLICT_OP_MERGE);
    }

    public static SVNSkel createConflictMarkers(ISVNWCDb db, File localAbsPath, SVNSkel conflictSkel) throws SVNException {
        Structure<ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflictSkel);
        SVNOperation conflictOperation = (SVNOperation)conflictInfoStructure.get(ConflictInfo.conflictOperation);
        boolean propConflicted = conflictInfoStructure.is(ConflictInfo.propConflicted);
        if (propConflicted) {
            String markerName;
            File markerDir;
            SVNFileType type = SVNFileType.getType(localAbsPath);
            if (type == SVNFileType.DIRECTORY) {
                markerDir = localAbsPath;
                markerName = "dir_conflicts";
            } else {
                markerDir = SVNFileUtil.getParentFile(localAbsPath);
                markerName = SVNFileUtil.getFileName(localAbsPath);
            }
            File markerAbsPath = SVNFileUtil.createUniqueFile(markerDir, markerName, ".prej", false);
            File markerRelPath = db.toRelPath(markerAbsPath);
            SVNSkel propConflict = SvnWcDbConflicts.getConflict(conflictSkel, ConflictKind.prop);
            propConflict.first().next().prependPath(markerRelPath);
            Structure<PropertyConflictInfo> propertyConflictInfoStructure = SvnWcDbConflicts.readPropertyConflict(db, localAbsPath, conflictSkel);
            SVNProperties mineProps = SVNProperties.wrap((Map)propertyConflictInfoStructure.get(PropertyConflictInfo.mineProps));
            SVNProperties theirOriginalProps = SVNProperties.wrap((Map)propertyConflictInfoStructure.get(PropertyConflictInfo.theirOldProps));
            SVNProperties theirProps = SVNProperties.wrap((Map)propertyConflictInfoStructure.get(PropertyConflictInfo.theirProps));
            Collection conflictedPropNames = (Collection)propertyConflictInfoStructure.get(PropertyConflictInfo.conflictedPropNames);
            SVNProperties oldProps = conflictOperation == SVNOperation.MERGE ? db.readPristineProperties(localAbsPath) : theirOriginalProps;
            SVNSkel propData = SVNSkel.createEmptyList();
            propData.prepend(SVNSkel.createEmptyList());
            for (String propName : conflictedPropNames) {
                SvnWcDbConflicts.addPropConflict(propData, propName, oldProps != null ? oldProps.getSVNPropertyValue(propName) : null, mineProps != null ? mineProps.getSVNPropertyValue(propName) : null, theirProps != null ? theirProps.getSVNPropertyValue(propName) : null, theirOriginalProps != null ? theirOriginalProps.getSVNPropertyValue(propName) : null);
            }
            return SVNWCContext.wqBuildPrejInstall(db, localAbsPath, propData);
        }
        return null;
    }

    private static SVNSkel getOperation(SVNSkel conflictSkel) throws SVNException {
        assert (conflictSkel != null && conflictSkel.first() != null && conflictSkel.first().next() != null && !conflictSkel.first().next().isAtom());
        SVNSkel why = conflictSkel.first();
        if (why.first() == null) {
            why = null;
        }
        return why;
    }

    public static void addPropConflict(SVNSkel skel, String propName, SVNPropertyValue originalVal, SVNPropertyValue mineVal, SVNPropertyValue incomingVal, SVNPropertyValue incomingBaseVal) throws SVNException {
        SVNSkel propSkel = SVNSkel.createEmptyList();
        SvnWcDbConflicts.prependPropValue(incomingBaseVal, propSkel);
        SvnWcDbConflicts.prependPropValue(incomingVal, propSkel);
        SvnWcDbConflicts.prependPropValue(mineVal, propSkel);
        SvnWcDbConflicts.prependPropValue(originalVal, propSkel);
        propSkel.prependString(propName);
        propSkel.prependString(ConflictKind.prop.toString());
        skel.appendChild(propSkel);
    }

    public static void prependPropValue(SVNPropertyValue fromVal, SVNSkel skel) throws SVNException {
        SVNSkel valueSkel = SVNSkel.createEmptyList();
        if (fromVal != null && (fromVal.getBytes() != null || fromVal.getString() != null)) {
            valueSkel.prependPropertyValue(fromVal);
        }
        skel.prepend(valueSkel);
    }

    public static SVNSkel treeConflictDescriptionToSkel(ISVNWCDb db, File wriAbsPath, SVNTreeConflictDescription conflictDescription) throws SVNException {
        SVNSkel skel = SvnWcDbConflicts.createConflictSkel();
        SvnWcDbConflicts.addTreeConflict(skel, db, wriAbsPath, conflictDescription.getConflictReason(), conflictDescription.getConflictAction(), null);
        if (conflictDescription.getOperation() != null) {
            if (conflictDescription.getOperation() == SVNOperation.UPDATE) {
                SvnWcDbConflicts.conflictSkelOpUpdate(skel, conflictDescription.getSourceLeftVersion(), conflictDescription.getSourceRightVersion());
            } else if (conflictDescription.getOperation() == SVNOperation.SWITCH) {
                SvnWcDbConflicts.conflictSkelOpSwitch(skel, conflictDescription.getSourceLeftVersion(), conflictDescription.getSourceRightVersion());
            } else if (conflictDescription.getOperation() == SVNOperation.MERGE) {
                SvnWcDbConflicts.conflictSkelOpMerge(skel, conflictDescription.getSourceLeftVersion(), conflictDescription.getSourceRightVersion());
            }
        }
        return skel;
    }

    public static boolean conflictSkelResolve(SVNSkel conflictSkel, ISVNWCDb db, File wriAbsPAth, boolean resolveText, String resolveProp, boolean resolveTree) throws SVNException {
        SVNSkel operation = SvnWcDbConflicts.getOperation(conflictSkel);
        if (operation == null) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Not a completed conflict skel");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        SVNSkel conflicts = conflictSkel.first().next();
        HashSet<SVNSkel> conflictsToRemove = new HashSet<SVNSkel>();
        SVNSkel pconflict = conflicts.first();
        while (pconflict != null) {
            SVNSkel c = pconflict.first();
            if (resolveText && c.contentEquals(ConflictKind.text.name())) {
                conflictsToRemove.add(pconflict);
                pconflict = pconflict.next();
                continue;
            }
            if (resolveProp != null && c.contentEquals(ConflictKind.prop.name())) {
                SVNSkel propnames;
                SVNSkel props = c.next().next();
                if (resolveProp.length() == 0) {
                    props.removeAllChildren();
                    propnames = null;
                } else {
                    HashSet<SVNSkel> propsToRemove = new HashSet<SVNSkel>();
                    for (propnames = props.first(); propnames != null; propnames = propnames.next()) {
                        if (!propnames.contentEquals(resolveProp)) continue;
                        propsToRemove.add(propnames);
                        propnames = propnames.next();
                        break;
                    }
                    props.removeChildren(propsToRemove);
                }
                if (c.next().next().first() == null) {
                    conflictsToRemove.add(pconflict);
                    pconflict = pconflict.next();
                    continue;
                }
            } else if (resolveTree && c.contentEquals(ConflictKind.tree.name())) {
                conflictsToRemove.add(pconflict);
                pconflict = pconflict.next();
                continue;
            }
            pconflict = pconflict.next();
        }
        conflicts.removeChildren(conflictsToRemove);
        return !SvnWcDbConflicts.isConflictSkelComplete(conflictSkel);
    }

    public static List<File> readConflictMarkers(SVNWCDb db, File wriAbsPath, SVNSkel conflictSkel) throws SVNException {
        assert (conflictSkel != null);
        ArrayList<File> list = null;
        for (SVNSkel conflict = conflictSkel.first().next().first(); conflict != null; conflict = conflict.next()) {
            for (SVNSkel marker = conflict.first().next().first(); marker != null; marker = marker.next()) {
                if (!marker.isAtom()) continue;
                if (list == null) {
                    list = new ArrayList<File>(4);
                }
                File path = db.fromRelPath(wriAbsPath, SVNFileUtil.createFilePath(marker.getValue()));
                list.add(path);
            }
        }
        return list;
    }

    public static SVNSkel upgradeConflictSkelFromRaw(ISVNWCDb db, File wriAbsPath, File localRelPath, String conflictOld, String conflictWork, String conflictNew, File prejFile, SVNSkel oldTreeConflictData) throws SVNException {
        File wcRootAbsPath = db.getWCRoot(wriAbsPath);
        SVNSkel conflictData = null;
        if (conflictOld != null || conflictNew != null || conflictWork != null) {
            conflictData = SvnWcDbConflicts.createConflictSkel();
            File oldAbsPath = null;
            if (conflictOld != null) {
                oldAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, conflictOld);
            }
            File newAbsPath = null;
            if (conflictNew != null) {
                newAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, conflictNew);
            }
            File workAbsPath = null;
            if (conflictWork != null) {
                workAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, conflictWork);
            }
            SvnWcDbConflicts.addTextConflict(conflictData, db, wriAbsPath, workAbsPath, oldAbsPath, newAbsPath);
        }
        if (prejFile != null) {
            if (conflictData == null) {
                conflictData = SvnWcDbConflicts.createConflictSkel();
            }
            SvnWcDbConflicts.addPropConflict(conflictData, db, wriAbsPath, prejFile, null, null, null, new HashSet<String>());
        }
        if (oldTreeConflictData != null) {
            if (conflictData == null) {
                conflictData = SvnWcDbConflicts.createConflictSkel();
            }
            File localAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, localRelPath);
            SVNTreeConflictDescription treeConflictDescription = SVNTreeConflictUtil.readSingleTreeConflict(oldTreeConflictData, SVNFileUtil.getFileDir(localAbsPath));
            SvnWcDbConflicts.addTreeConflict(conflictData, db, wriAbsPath, treeConflictDescription.getConflictReason(), treeConflictDescription.getConflictAction(), null);
            SVNOperation operation = treeConflictDescription.getOperation();
            if (operation == SVNOperation.UPDATE) {
                SvnWcDbConflicts.conflictSkelOpUpdate(conflictData, treeConflictDescription.getSourceLeftVersion(), treeConflictDescription.getSourceRightVersion());
            } else if (operation == SVNOperation.SWITCH) {
                SvnWcDbConflicts.conflictSkelOpSwitch(conflictData, treeConflictDescription.getSourceLeftVersion(), treeConflictDescription.getSourceRightVersion());
            } else if (operation == SVNOperation.MERGE) {
                SvnWcDbConflicts.conflictSkelOpMerge(conflictData, treeConflictDescription.getSourceLeftVersion(), treeConflictDescription.getSourceRightVersion());
            } else {
                SvnWcDbConflicts.conflictSkelOpUpdate(conflictData, treeConflictDescription.getSourceLeftVersion(), treeConflictDescription.getSourceRightVersion());
            }
        } else if (conflictData != null) {
            SvnWcDbConflicts.conflictSkelOpUpdate(conflictData, null, null);
        }
        return conflictData;
    }

    private static void addTextConflict(SVNSkel skel, String mineRelPath, String theirOldRelPath, String theirRelPath) throws SVNException {
        SVNSkel textConflict = SVNSkel.createEmptyList();
        SVNSkel markers = SVNSkel.createEmptyList();
        if (theirRelPath != null) {
            markers.prepend(SVNSkel.createAtom(theirRelPath));
        } else {
            markers.prepend(SVNSkel.createEmptyList());
        }
        if (mineRelPath != null) {
            markers.prepend(SVNSkel.createAtom(mineRelPath));
        } else {
            markers.prepend(SVNSkel.createEmptyList());
        }
        if (theirOldRelPath != null) {
            markers.prepend(SVNSkel.createAtom(theirOldRelPath));
        } else {
            markers.prepend(SVNSkel.createEmptyList());
        }
        textConflict.prepend(markers);
        textConflict.prepend(SVNSkel.createAtom(ConflictKind.text.toString()));
        skel.first().next().prepend(textConflict);
    }

    private static void addPropConflict(SVNSkel skel, String propReject) throws SVNException {
        SVNSkel propConflict = SVNSkel.createEmptyList();
        SVNSkel conflictNames = SVNSkel.createEmptyList();
        propConflict.prepend(conflictNames);
        SVNSkel markers = SVNSkel.createEmptyList();
        if (propReject != null) {
            markers.prepend(SVNSkel.createAtom(propReject));
        }
        propConflict.prepend(markers);
        propConflict.prepend(SVNSkel.createAtom(ConflictKind.prop.toString()));
        skel.first().next().prepend(propConflict);
    }

    private static void addTreeConflict(SVNSkel skel, SVNConflictReason localChange, SVNConflictAction incomingChange) throws SVNException {
        SVNSkel treeConflict = SVNSkel.createEmptyList();
        treeConflict.prepend(SVNSkel.createAtom(incomingChange.getName()));
        treeConflict.prepend(SVNSkel.createAtom(localChange.getName()));
        SVNSkel markers = SVNSkel.createEmptyList();
        treeConflict.prepend(markers);
        treeConflict.prepend(SVNSkel.createAtom(ConflictKind.tree.toString()));
        skel.first().next().prepend(treeConflict);
    }

    public static enum ConflictStatus {
        conflicted,
        conflictIgnored,
        textConflicted,
        propConflicted,
        treeConflicted;

    }

    public static enum TreeConflictInfo {
        localChange,
        incomingChange,
        moveSrcOpRootAbsPath;

    }

    public static enum TextConflictInfo {
        mineAbsPath,
        theirOldAbsPath,
        theirAbsPath;

    }

    public static enum PropertyConflictInfo {
        markerAbspath,
        mineProps,
        theirOldProps,
        theirProps,
        conflictedPropNames;

    }

    public static enum ConflictKind {
        text,
        prop,
        tree,
        reject,
        obstructed;

    }

    public static enum ConflictInfo {
        conflictOperation,
        locations,
        textConflicted,
        propConflicted,
        treeConflicted;

    }
}

