/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import com.sun.source.tree.Tree;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.Element;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.RegularBlock;
import org.checkerframework.dataflow.cfg.node.Node;

public class AnalysisResult<A extends AbstractValue<A>, S extends Store<S>> {
    protected final IdentityHashMap<Node, A> nodeValues;
    protected final IdentityHashMap<Tree, Node> treeLookup;
    protected final HashMap<Element, A> finalLocalValues;
    protected final IdentityHashMap<Block, TransferInput<A, S>> stores;

    public AnalysisResult(Map<Node, A> nodeValues, IdentityHashMap<Block, TransferInput<A, S>> stores, IdentityHashMap<Tree, Node> treeLookup, HashMap<Element, A> finalLocalValues) {
        this.nodeValues = new IdentityHashMap<Node, A>(nodeValues);
        this.treeLookup = new IdentityHashMap<Tree, Node>(treeLookup);
        this.stores = stores;
        this.finalLocalValues = finalLocalValues;
    }

    public AnalysisResult() {
        this.nodeValues = new IdentityHashMap();
        this.treeLookup = new IdentityHashMap();
        this.stores = new IdentityHashMap();
        this.finalLocalValues = new HashMap();
    }

    public void combine(AnalysisResult<A, S> other) {
        for (Map.Entry<Node, A> entry : other.nodeValues.entrySet()) {
            this.nodeValues.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : other.treeLookup.entrySet()) {
            this.treeLookup.put((Tree)entry.getKey(), (Node)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : other.stores.entrySet()) {
            this.stores.put((Block)entry.getKey(), (TransferInput<A, S>)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : other.finalLocalValues.entrySet()) {
            this.finalLocalValues.put((Element)entry.getKey(), entry.getValue());
        }
    }

    public HashMap<Element, A> getFinalLocalValues() {
        return this.finalLocalValues;
    }

    public @Nullable A getValue(Node n) {
        return (A)((AbstractValue)this.nodeValues.get(n));
    }

    public @Nullable A getValue(Tree t) {
        A val = this.getValue(this.treeLookup.get(t));
        return val;
    }

    public @Nullable Node getNodeForTree(Tree tree) {
        return this.treeLookup.get(tree);
    }

    public S getStoreBefore(Tree tree) {
        Node node = this.getNodeForTree(tree);
        if (node == null) {
            return null;
        }
        return this.getStoreBefore(node);
    }

    public S getStoreBefore(Node node) {
        return this.runAnalysisFor(node, true);
    }

    public S getStoreAfter(Tree tree) {
        Node node = this.getNodeForTree(tree);
        if (node == null) {
            return null;
        }
        return this.runAnalysisFor(node, false);
    }

    protected S runAnalysisFor(Node node, boolean before) {
        Block block = node.getBlock();
        TransferInput<A, S> transferInput = this.stores.get(block);
        if (transferInput == null) {
            return null;
        }
        return AnalysisResult.runAnalysisFor(node, before, transferInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends AbstractValue<A>, S extends Store<S>> S runAnalysisFor(Node node, boolean before, TransferInput<A, S> transferInput) {
        assert (node != null);
        Block block = node.getBlock();
        assert (transferInput != null);
        Analysis<A, S, ?> analysis = transferInput.analysis;
        Node oldCurrentNode = analysis.currentNode;
        if (analysis.isRunning) {
            return analysis.currentInput.getRegularStore();
        }
        analysis.isRunning = true;
        try {
            switch (block.getType()) {
                case REGULAR_BLOCK: {
                    RegularBlock rb = (RegularBlock)block;
                    TransferInput<A, Object> store = transferInput;
                    TransferResult transferResult = null;
                    Iterator<Node> iterator = rb.getContents().iterator();
                    while (iterator.hasNext()) {
                        Node n;
                        analysis.currentNode = n = iterator.next();
                        if (n == node && before) {
                            S s2 = store.getRegularStore();
                            return s2;
                        }
                        transferResult = analysis.callTransferFunction(n, store);
                        if (n == node) {
                            Object s3 = transferResult.getRegularStore();
                            return s3;
                        }
                        store = new TransferInput(n, analysis, transferResult);
                    }
                    assert (false);
                    iterator = null;
                    return (S)iterator;
                }
                case EXCEPTION_BLOCK: {
                    ExceptionBlock eb = (ExceptionBlock)block;
                    assert (eb.getNode() == node);
                    if (before) {
                        S store = transferInput.getRegularStore();
                        return store;
                    }
                    analysis.currentNode = node;
                    TransferResult transferResult = analysis.callTransferFunction(node, transferInput);
                    Object s4 = transferResult.getRegularStore();
                    return s4;
                }
            }
            assert (false);
            S s5 = null;
            return s5;
        }
        finally {
            analysis.currentNode = oldCurrentNode;
            analysis.isRunning = false;
        }
    }
}

