/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TypesUtils;

public abstract class CFAbstractValue<V extends CFAbstractValue<V>>
implements AbstractValue<V> {
    protected final CFAbstractAnalysis<V, ?, ?> analysis;
    protected final TypeMirror underlyingType;
    protected final Set<AnnotationMirror> annotations;

    public CFAbstractValue(CFAbstractAnalysis<V, ?, ?> analysis, Set<AnnotationMirror> annotations, TypeMirror underlyingType) {
        this.analysis = analysis;
        this.annotations = annotations;
        this.underlyingType = underlyingType;
        assert (CFAbstractValue.validateSet(this.getAnnotations(), this.getUnderlyingType(), analysis.getTypeFactory().getQualifierHierarchy())) : "Encountered invalid type: " + underlyingType + " annotations: " + PluginUtil.join(", ", annotations);
    }

    public static boolean validateSet(Set<AnnotationMirror> annos, TypeMirror typeMirror, QualifierHierarchy hierarchy) {
        if (CFAbstractValue.canBeMissingAnnotations(typeMirror)) {
            return true;
        }
        Set<AnnotationMirror> missingHierarchy = null;
        for (AnnotationMirror annotationMirror : hierarchy.getTopAnnotations()) {
            AnnotationMirror anno = hierarchy.findAnnotationInHierarchy(annos, annotationMirror);
            if (anno != null) continue;
            if (missingHierarchy == null) {
                missingHierarchy = AnnotationUtils.createAnnotationSet();
            }
            missingHierarchy.add(annotationMirror);
        }
        return missingHierarchy == null;
    }

    public boolean canBeMissingAnnotations() {
        return CFAbstractValue.canBeMissingAnnotations(this.underlyingType);
    }

    private static boolean canBeMissingAnnotations(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return false;
        }
        if (typeMirror.getKind() == TypeKind.VOID || typeMirror.getKind() == TypeKind.NONE || typeMirror.getKind() == TypeKind.PACKAGE) {
            return true;
        }
        if (typeMirror.getKind() == TypeKind.WILDCARD) {
            return CFAbstractValue.canBeMissingAnnotations(((WildcardType)typeMirror).getExtendsBound());
        }
        return typeMirror.getKind() == TypeKind.TYPEVAR;
    }

    @Pure
    public Set<AnnotationMirror> getAnnotations() {
        return this.annotations;
    }

    @Pure
    public TypeMirror getUnderlyingType() {
        return this.underlyingType;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CFAbstractValue)) {
            return false;
        }
        CFAbstractValue other = (CFAbstractValue)obj;
        if (!this.analysis.getTypes().isSameType(this.getUnderlyingType(), other.getUnderlyingType())) {
            return false;
        }
        return AnnotationUtils.areSame(this.getAnnotations(), other.getAnnotations());
    }

    @Pure
    public int hashCode() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.addAll(this.getAnnotations());
        objects.add(this.underlyingType);
        return HashCodeUtils.hash(objects);
    }

    @SideEffectFree
    public String toString() {
        return "CFAbstractValue{annotations=" + this.annotations + ", underlyingType=" + this.underlyingType + '}';
    }

    public V mostSpecific(@Nullable V other, @Nullable V backup) {
        if (other == null) {
            CFAbstractValue v = this;
            return (V)v;
        }
        Types types = this.analysis.getTypes();
        TypeMirror mostSpecifTypeMirror = types.isAssignable(this.getUnderlyingType(), ((CFAbstractValue)other).getUnderlyingType()) ? this.getUnderlyingType() : (types.isAssignable(((CFAbstractValue)other).getUnderlyingType(), this.getUnderlyingType()) ? ((CFAbstractValue)other).getUnderlyingType() : (TypesUtils.isErasedSubtype(types, this.getUnderlyingType(), ((CFAbstractValue)other).getUnderlyingType()) ? this.getUnderlyingType() : (TypesUtils.isErasedSubtype(types, ((CFAbstractValue)other).getUnderlyingType(), this.getUnderlyingType()) ? ((CFAbstractValue)other).getUnderlyingType() : this.getUnderlyingType())));
        Set<AnnotationMirror> mostSpecific = AnnotationUtils.createAnnotationSet();
        MostSpecificVisitor ms = new MostSpecificVisitor(this, mostSpecifTypeMirror, this.getUnderlyingType(), ((CFAbstractValue)other).getUnderlyingType(), this.getAnnotations(), ((CFAbstractValue)other).getAnnotations(), backup, mostSpecific);
        ms.visit();
        if (ms.error) {
            return backup;
        }
        return this.analysis.createAbstractValue(mostSpecific, mostSpecifTypeMirror);
    }

    @Override
    public V leastUpperBound(@Nullable V other) {
        if (other == null) {
            CFAbstractValue v = this;
            return (V)v;
        }
        ProcessingEnvironment processingEnv = this.analysis.getTypeFactory().getProcessingEnv();
        Set<AnnotationMirror> lub = AnnotationUtils.createAnnotationSet();
        TypeMirror lubTypeMirror = InternalUtils.leastUpperBound(processingEnv, this.getUnderlyingType(), ((CFAbstractValue)other).getUnderlyingType());
        LubVisitor lubVisitor = new LubVisitor(lubTypeMirror, this.getUnderlyingType(), ((CFAbstractValue)other).getUnderlyingType(), this.getAnnotations(), ((CFAbstractValue)other).getAnnotations(), lub);
        lubVisitor.visit();
        return this.analysis.createAbstractValue(lub, lubTypeMirror);
    }

    private AnnotatedTypeMirror.AnnotatedTypeVariable getEffectTypeVar(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return null;
        }
        if (typeMirror.getKind() == TypeKind.WILDCARD) {
            return this.getEffectTypeVar(((WildcardType)typeMirror).getExtendsBound());
        }
        if (typeMirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typevar = (TypeVariable)typeMirror;
            AnnotatedTypeMirror atm = this.analysis.getTypeFactory().getAnnotatedType(typevar.asElement());
            return (AnnotatedTypeMirror.AnnotatedTypeVariable)atm;
        }
        return null;
    }

    protected abstract class AnnotationSetAndTypeMirrorVisitor {
        TypeMirror result;
        private AnnotatedTypeMirror.AnnotatedTypeVariable aAtv;
        private AnnotatedTypeMirror.AnnotatedTypeVariable bAtv;
        private Set<AnnotationMirror> aSet;
        private Set<AnnotationMirror> bSet;

        public AnnotationSetAndTypeMirrorVisitor(TypeMirror result, TypeMirror aTypeMirror, TypeMirror bTypeMirror, Set<AnnotationMirror> aSet, Set<AnnotationMirror> bSet) {
            this.result = result;
            this.aSet = aSet;
            this.bSet = bSet;
            this.aAtv = CFAbstractValue.this.getEffectTypeVar(aTypeMirror);
            this.bAtv = CFAbstractValue.this.getEffectTypeVar(bTypeMirror);
        }

        void visit() {
            QualifierHierarchy hierarchy = CFAbstractValue.this.analysis.getTypeFactory().getQualifierHierarchy();
            Set<? extends AnnotationMirror> tops = hierarchy.getTopAnnotations();
            for (AnnotationMirror annotationMirror : tops) {
                AnnotationMirror a = hierarchy.findAnnotationInHierarchy(this.aSet, annotationMirror);
                AnnotationMirror b = hierarchy.findAnnotationInHierarchy(this.bSet, annotationMirror);
                if (a != null && b != null) {
                    this.visitAnnotationExistInBothSets(a, b, annotationMirror);
                    continue;
                }
                if (a != null) {
                    this.visitAnnotationExistInOneSet(a, this.bAtv, annotationMirror);
                    continue;
                }
                if (b != null) {
                    this.visitAnnotationExistInOneSet(b, this.aAtv, annotationMirror);
                    continue;
                }
                this.visitNeitherAnnotationExistsInBothSets(this.aAtv, this.bAtv, annotationMirror);
            }
        }

        protected abstract void visitAnnotationExistInBothSets(AnnotationMirror var1, AnnotationMirror var2, AnnotationMirror var3);

        protected abstract void visitNeitherAnnotationExistsInBothSets(AnnotatedTypeMirror.AnnotatedTypeVariable var1, AnnotatedTypeMirror.AnnotatedTypeVariable var2, AnnotationMirror var3);

        protected abstract void visitAnnotationExistInOneSet(AnnotationMirror var1, AnnotatedTypeMirror.AnnotatedTypeVariable var2, AnnotationMirror var3);
    }

    class LubVisitor
    extends AnnotationSetAndTypeMirrorVisitor {
        Set<AnnotationMirror> lubSet;

        public LubVisitor(TypeMirror result, TypeMirror aTypeMirror, TypeMirror bTypeMirror, Set<AnnotationMirror> aSet, Set<AnnotationMirror> bSet, Set<AnnotationMirror> lubSet) {
            super(result, aTypeMirror, bTypeMirror, aSet, bSet);
            this.lubSet = lubSet;
        }

        @Override
        protected void visitAnnotationExistInBothSets(AnnotationMirror a, AnnotationMirror b, AnnotationMirror top) {
            QualifierHierarchy hierarchy = CFAbstractValue.this.analysis.getTypeFactory().getQualifierHierarchy();
            this.lubSet.add(hierarchy.leastUpperBound(a, b));
        }

        @Override
        protected void visitNeitherAnnotationExistsInBothSets(AnnotatedTypeMirror.AnnotatedTypeVariable aAtv, AnnotatedTypeMirror.AnnotatedTypeVariable bAtv, AnnotationMirror top) {
            QualifierHierarchy hierarchy = CFAbstractValue.this.analysis.getTypeFactory().getQualifierHierarchy();
            if (!CFAbstractValue.canBeMissingAnnotations(this.result)) {
                AnnotationMirror aUB = aAtv.getUpperBound().getEffectiveAnnotationInHierarchy(top);
                AnnotationMirror bUB = bAtv.getUpperBound().getEffectiveAnnotationInHierarchy(top);
                this.lubSet.add(hierarchy.leastUpperBound(aUB, bUB));
            }
        }

        @Override
        protected void visitAnnotationExistInOneSet(AnnotationMirror anno, AnnotatedTypeMirror.AnnotatedTypeVariable atv, AnnotationMirror top) {
            QualifierHierarchy hierarchy = CFAbstractValue.this.analysis.getTypeFactory().getQualifierHierarchy();
            AnnotationMirror upperBound = atv.getUpperBound().getEffectiveAnnotationInHierarchy(top);
            if (!CFAbstractValue.canBeMissingAnnotations(this.result)) {
                this.lubSet.add(hierarchy.leastUpperBound(anno, upperBound));
            } else {
                Set<AnnotationMirror> lBSet = AnnotatedTypes.findEffectiveLowerBoundAnnotations(hierarchy, atv);
                AnnotationMirror lowerBound = hierarchy.findAnnotationInHierarchy(lBSet, top);
                if (!hierarchy.isSubtype(anno, lowerBound)) {
                    this.lubSet.add(hierarchy.leastUpperBound(anno, upperBound));
                }
            }
        }
    }

    private static class MostSpecificVisitor
    extends AnnotationSetAndTypeMirrorVisitor {
        boolean error;
        TypeMirror backupTypeMirror;
        Set<AnnotationMirror> backupSet;
        AnnotatedTypeMirror.AnnotatedTypeVariable backupAtv;
        Set<AnnotationMirror> mostSpecific;
        final /* synthetic */ CFAbstractValue this$0;

        public MostSpecificVisitor(TypeMirror result, TypeMirror aTypeMirror, TypeMirror bTypeMirror, Set<AnnotationMirror> aSet, Set<AnnotationMirror> bSet, V backup, Set<AnnotationMirror> mostSpecific) {
            this.this$0 = var1_1;
            super(result, aTypeMirror, bTypeMirror, aSet, bSet);
            this.error = false;
            this.mostSpecific = mostSpecific;
            if (backup != null) {
                this.backupSet = ((CFAbstractValue)backup).getAnnotations();
                this.backupTypeMirror = ((CFAbstractValue)backup).getUnderlyingType();
                this.backupAtv = ((CFAbstractValue)var1_1).getEffectTypeVar(this.backupTypeMirror);
            } else {
                this.backupAtv = null;
                this.backupTypeMirror = null;
                this.backupSet = null;
            }
        }

        private AnnotationMirror getBackUpAnnoIn(AnnotationMirror top) {
            if (this.backupSet == null) {
                this.error = true;
                return null;
            }
            QualifierHierarchy hierarchy = this.this$0.analysis.getTypeFactory().getQualifierHierarchy();
            return hierarchy.findAnnotationInHierarchy(this.backupSet, top);
        }

        @Override
        protected void visitAnnotationExistInBothSets(AnnotationMirror a, AnnotationMirror b, AnnotationMirror top) {
            QualifierHierarchy hierarchy = this.this$0.analysis.getTypeFactory().getQualifierHierarchy();
            if (hierarchy.isSubtype(a, b)) {
                this.mostSpecific.add(a);
            } else if (hierarchy.isSubtype(b, a)) {
                this.mostSpecific.add(b);
            } else {
                AnnotationMirror backup = this.getBackUpAnnoIn(top);
                if (backup != null) {
                    this.mostSpecific.add(backup);
                }
            }
        }

        @Override
        protected void visitNeitherAnnotationExistsInBothSets(AnnotatedTypeMirror.AnnotatedTypeVariable aAtv, AnnotatedTypeMirror.AnnotatedTypeVariable bAtv, AnnotationMirror top) {
            if (!CFAbstractValue.canBeMissingAnnotations(this.result)) {
                AnnotationMirror aUB = aAtv.getUpperBound().getEffectiveAnnotationInHierarchy(top);
                AnnotationMirror bUB = bAtv.getUpperBound().getEffectiveAnnotationInHierarchy(top);
                this.visitAnnotationExistInBothSets(aUB, bUB, top);
            }
        }

        @Override
        protected void visitAnnotationExistInOneSet(AnnotationMirror anno, AnnotatedTypeMirror.AnnotatedTypeVariable atv, AnnotationMirror top) {
            QualifierHierarchy hierarchy = this.this$0.analysis.getTypeFactory().getQualifierHierarchy();
            AnnotationMirror upperBound = atv.getEffectiveAnnotationInHierarchy(top);
            if (!CFAbstractValue.canBeMissingAnnotations(this.result)) {
                this.visitAnnotationExistInBothSets(anno, upperBound, top);
                return;
            }
            Set<AnnotationMirror> lBSet = AnnotatedTypes.findEffectiveLowerBoundAnnotations(hierarchy, atv);
            AnnotationMirror lowerBound = hierarchy.findAnnotationInHierarchy(lBSet, top);
            if (!hierarchy.isSubtype(upperBound, anno)) {
                if (hierarchy.isSubtype(anno, lowerBound)) {
                    this.mostSpecific.add(anno);
                } else {
                    AnnotationMirror backup = this.getBackUpAnnoIn(top);
                    if (backup != null) {
                        this.mostSpecific.add(backup);
                    }
                }
            }
        }
    }
}

