/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.core.SVNException;

public class SVNAdminHelpCommand
extends SVNAdminCommand {
    private static final String GENERIC_HELP_HEADER = "general usage: {0} SUBCOMMAND REPOS_PATH  [ARGS & OPTIONS ...]\nType ''{0} help <subcommand>'' for help on a specific subcommand.\nType ''{0} --version'' to see the program version and FS modules.\n\nAvailable subcommands:";
    private static final String VERSION_HELP_FOOTER = "\nThe following repository back-end (FS) modules are available:\n\n* fs_fs : Module for working with a plain file (FSFS) repository.";

    public SVNAdminHelpCommand() {
        super("help", new String[]{"?", "h"});
    }

    @Override
    protected Collection createSupportedOptions() {
        return new LinkedList();
    }

    @Override
    public void run() throws SVNException {
        if (!this.getEnvironment().getArguments().isEmpty()) {
            for (String commandName : this.getEnvironment().getArguments()) {
                AbstractSVNCommand command = AbstractSVNCommand.getCommand(commandName);
                if (command == null) {
                    this.getEnvironment().getErr().println("\"" + commandName + "\": unknown command.\n");
                    continue;
                }
                this.getEnvironment().getProgramName();
                String help = SVNCommandUtil.getCommandHelp(command, this.getEnvironment().getProgramName(), true);
                this.getEnvironment().getOut().println(help);
            }
        } else if (this.getSVNAdminEnvironment().isVersion()) {
            String version2 = SVNCommandUtil.getVersion(this.getEnvironment(), this.getSVNAdminEnvironment().isQuiet());
            this.getEnvironment().getOut().println(version2);
            if (!this.getSVNAdminEnvironment().isQuiet()) {
                this.getEnvironment().getOut().println(VERSION_HELP_FOOTER);
            }
        } else if (this.getEnvironment().getArguments().isEmpty()) {
            String help = SVNCommandUtil.getGenericHelp(this.getEnvironment().getProgramName(), GENERIC_HELP_HEADER, null, null);
            this.getEnvironment().getOut().print(help);
        } else {
            String message = MessageFormat.format("Type ''{0} help'' for usage.", this.getEnvironment().getProgramName());
            this.getEnvironment().getOut().println(message);
        }
    }
}

