/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.text.ParseException;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPHeader;

public class HTTPStatus {
    private String myStatusLine;
    private String myVersion;
    private int myCode;
    private String myReason;
    private HTTPHeader myHeader;
    private SVNErrorMessage myError;

    public static boolean isHTTPStatusLine(String statusLine) {
        try {
            HTTPStatus status = HTTPStatus.createHTTPStatus(statusLine);
            return status != null;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static HTTPStatus createHTTPStatus(String statusLine) throws ParseException {
        int length = statusLine.length();
        int at = 0;
        int start = 0;
        String reason = null;
        String version2 = null;
        int code = -1;
        try {
            int to;
            while (Character.isWhitespace(statusLine.charAt(at))) {
                ++at;
                ++start;
            }
            if (!"HTTP".equals(statusLine.substring(at, at += 4))) {
                throw new ParseException("Status-Line '" + statusLine + "' does not start with HTTP", 0);
            }
            while (!Character.isWhitespace(statusLine.charAt(at)) && at < statusLine.length()) {
                ++at;
            }
            if (at == statusLine.length()) {
                throw new ParseException("Unable to parse HTTP-Version from the status line: '" + statusLine + "'", 0);
            }
            version2 = statusLine.substring(start, at).toUpperCase();
            while (Character.isWhitespace(statusLine.charAt(at)) && at < statusLine.length()) {
                ++at;
            }
            if (at == statusLine.length()) {
                throw new ParseException("Status-Line '" + statusLine + "' is not valid", 0);
            }
            for (to = at; !Character.isWhitespace(statusLine.charAt(to)) && to < statusLine.length(); ++to) {
            }
            try {
                code = Integer.parseInt(statusLine.substring(at, to));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Unable to parse status code from status line: '" + statusLine + "'", 0);
            }
            at = to + 1;
            reason = at < length ? statusLine.substring(at).trim() : "";
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException("Status-Line '" + statusLine + "' is not valid", 0);
        }
        return new HTTPStatus(version2, reason, code, statusLine);
    }

    private HTTPStatus(String version2, String reason, int code, String statusLine) {
        this.myVersion = version2;
        this.myStatusLine = statusLine;
        this.myReason = reason;
        this.myCode = code;
    }

    public String getReason() {
        return this.myReason;
    }

    public int getCode() {
        return this.myCode;
    }

    public int getCodeClass() {
        return this.myCode / 100;
    }

    public String getStatusLine() {
        return this.myStatusLine;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public boolean isHTTP11() {
        return "HTTP/1.1".equals(this.myVersion);
    }

    public void setHeader(HTTPHeader header) {
        this.myHeader = header;
    }

    public HTTPHeader getHeader() {
        return this.myHeader;
    }

    public void setError(SVNErrorMessage error) {
        this.myError = error;
    }

    public SVNErrorMessage getError() {
        return this.myError;
    }
}

