/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetDecoder;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDumpStreamParser {
    private ISVNCanceller myCanceller;

    public SVNDumpStreamParser(ISVNCanceller canceller) {
        this.myCanceller = canceller;
    }

    public void parseDumpStream(InputStream dumpStream, ISVNLoadHandler handler, CharsetDecoder decoder) throws SVNException {
        String line = null;
        int version2 = -1;
        StringBuffer buffer = new StringBuffer();
        try {
            SVNErrorMessage err;
            line = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
            if (line == null) {
                SVNAdminHelper.generateIncompleteDataError();
            }
            if (!line.startsWith("SVN-fs-dump-format-version:")) {
                err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            try {
                line = line.substring("SVN-fs-dump-format-version".length() + 1);
                line = line.trim();
                version2 = Integer.parseInt(line);
                if (version2 > 3) {
                    err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Unsupported dumpfile version: {0}", (Object)new Integer(version2));
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                SVNErrorManager.error(err2, nfe, SVNLogType.FSFS);
            }
            while (true) {
                SVNErrorMessage err3;
                SVNErrorMessage err4;
                long length;
                boolean isDelta;
                String delta;
                this.myCanceller.checkCancelled();
                boolean foundNode = false;
                buffer.setLength(0);
                line = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
                if (line == null) {
                    if (buffer.length() <= 0) break;
                    SVNAdminHelper.generateIncompleteDataError();
                }
                if (line.length() == 0 || Character.isWhitespace(line.charAt(0))) continue;
                Map headers = this.readHeaderBlock(dumpStream, line, decoder);
                if (headers.containsKey("Revision-number")) {
                    handler.closeRevision();
                    handler.openRevision(headers);
                } else if (headers.containsKey("Node-path")) {
                    handler.openNode(headers);
                    foundNode = true;
                } else if (headers.containsKey("UUID")) {
                    String uuid = (String)headers.get("UUID");
                    handler.parseUUID(uuid);
                } else if (headers.containsKey("SVN-fs-dump-format-version")) {
                    try {
                        version2 = Integer.parseInt((String)headers.get("SVN-fs-dump-format-version"));
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header");
                        SVNErrorManager.error(err5, nfe, SVNLogType.FSFS);
                    }
                } else {
                    SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Unrecognized record type in stream");
                    SVNErrorManager.error(err6, SVNLogType.FSFS);
                }
                String contentLength = (String)headers.get("Content-length");
                String propContentLength = (String)headers.get("Prop-content-length");
                String textContentLength = (String)headers.get("Text-content-length");
                boolean isOldVersion = version2 == 1 && contentLength != null && propContentLength == null && textContentLength == null;
                long actualPropLength = 0L;
                if (propContentLength != null || isOldVersion) {
                    delta = (String)headers.get("Prop-delta");
                    boolean bl = isDelta = delta != null && "true".equals(delta);
                    if (foundNode && !isDelta) {
                        handler.removeNodeProperties();
                    }
                    length = 0L;
                    try {
                        length = Long.parseLong(propContentLength != null ? propContentLength : contentLength);
                    }
                    catch (NumberFormatException nfe) {
                        err4 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse property block length header");
                        SVNErrorManager.error(err4, nfe, SVNLogType.FSFS);
                    }
                    actualPropLength += this.parsePropertyBlock(dumpStream, handler, decoder, length, foundNode);
                }
                if (textContentLength != null) {
                    delta = (String)headers.get("Text-delta");
                    isDelta = delta != null && "true".equals(delta);
                    length = 0L;
                    try {
                        length = Long.parseLong(textContentLength);
                    }
                    catch (NumberFormatException nfe) {
                        err4 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse text block length header");
                        SVNErrorManager.error(err4, nfe, SVNLogType.FSFS);
                    }
                    handler.parseTextBlock(dumpStream, length, isDelta);
                } else if (isOldVersion) {
                    long length2 = 0L;
                    try {
                        length2 = Long.parseLong(contentLength);
                    }
                    catch (NumberFormatException nfe) {
                        err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse content length header");
                        SVNErrorManager.error(err3, nfe, SVNLogType.FSFS);
                    }
                    if ((length2 -= actualPropLength) > 0L || SVNNodeKind.parseKind((String)headers.get("Node-kind")) == SVNNodeKind.FILE) {
                        handler.parseTextBlock(dumpStream, length2, false);
                    }
                }
                if (contentLength != null && !isOldVersion) {
                    int readSize;
                    int r;
                    long remaining = 0L;
                    try {
                        remaining = Long.parseLong(contentLength);
                    }
                    catch (NumberFormatException nfe) {
                        err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse content length header");
                        SVNErrorManager.error(err3, nfe, SVNLogType.FSFS);
                    }
                    long propertyContentLength = 0L;
                    if (propContentLength != null) {
                        try {
                            propertyContentLength = Long.parseLong(propContentLength);
                        }
                        catch (NumberFormatException nfe) {
                            err4 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse property block length header");
                            SVNErrorManager.error(err4, nfe, SVNLogType.FSFS);
                        }
                    }
                    remaining -= propertyContentLength;
                    long txtContentLength = 0L;
                    if (textContentLength != null) {
                        try {
                            txtContentLength = Long.parseLong(textContentLength);
                        }
                        catch (NumberFormatException nfe) {
                            SVNErrorMessage err7 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse text block length header");
                            SVNErrorManager.error(err7, nfe, SVNLogType.FSFS);
                        }
                    }
                    if ((remaining -= txtContentLength) < 0L) {
                        SVNErrorMessage err8 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Sum of subblock sizes larger than total block content length");
                        SVNErrorManager.error(err8, SVNLogType.FSFS);
                    }
                    byte[] buf = new byte[16384];
                    long numRead = 0L;
                    long numToRead = remaining;
                    while (remaining > 0L && (r = dumpStream.read(buf, 0, readSize = remaining >= 16384L ? 16384 : (int)remaining)) >= 0) {
                        numRead += (long)r;
                        remaining -= (long)r;
                    }
                    if (numRead != numToRead) {
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                }
                if (!foundNode) continue;
                handler.closeNode();
                foundNode = false;
            }
            handler.closeRevision();
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
    }

    private long parsePropertyBlock(InputStream dumpStream, ISVNLoadHandler handler, CharsetDecoder decoder, long contentLength, boolean isNode) throws SVNException {
        long actualLength = 0L;
        StringBuffer buffer = new StringBuffer();
        String line = null;
        try {
            while (contentLength != actualLength) {
                String propName;
                byte[] buff;
                SVNErrorMessage err;
                buffer.setLength(0);
                line = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
                if (line == null) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Incomplete or unterminated property block");
                    SVNErrorManager.error(err2, SVNLogType.FSFS);
                }
                actualLength += (long)(line.length() + 1);
                if ("PROPS-END".equals(line)) break;
                if (line.charAt(0) == 'K' && line.charAt(1) == ' ') {
                    int len = 0;
                    try {
                        len = Integer.parseInt(line.substring(2));
                    }
                    catch (NumberFormatException nfe) {
                        err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property key length");
                        SVNErrorManager.error(err, nfe, SVNLogType.FSFS);
                    }
                    buff = new byte[len + 1];
                    actualLength += (long)SVNAdminHelper.readKeyOrValue(dumpStream, buff, len + 1);
                    propName = new String(buff, 0, len, "UTF-8");
                    buffer.setLength(0);
                    line = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
                    if (line == null) {
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                    actualLength += (long)(line.length() + 1);
                    if (line.charAt(0) == 'V' && line.charAt(1) == ' ') {
                        try {
                            len = Integer.parseInt(line.substring(2));
                        }
                        catch (NumberFormatException nfe) {
                            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property value length");
                            SVNErrorManager.error(err3, nfe, SVNLogType.FSFS);
                        }
                        buff = new byte[len + 1];
                        actualLength += (long)SVNAdminHelper.readKeyOrValue(dumpStream, buff, len + 1);
                        SVNPropertyValue propValue = SVNPropertyValue.create(propName, buff, 0, len);
                        if (isNode) {
                            handler.setNodeProperty(propName, propValue);
                            continue;
                        }
                        handler.setRevisionProperty(propName, propValue);
                        continue;
                    }
                    SVNAdminHelper.generateStreamMalformedError();
                    continue;
                }
                if (line.charAt(0) == 'D' && line.charAt(1) == ' ') {
                    int len = 0;
                    try {
                        len = Integer.parseInt(line.substring(2));
                    }
                    catch (NumberFormatException nfe) {
                        err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpfile header: can't parse node property key length");
                        SVNErrorManager.error(err, nfe, SVNLogType.FSFS);
                    }
                    buff = new byte[len + 1];
                    actualLength += (long)SVNAdminHelper.readKeyOrValue(dumpStream, buff, len + 1);
                    if (!isNode) {
                        SVNAdminHelper.generateStreamMalformedError();
                    }
                    propName = new String(buff, 0, len, "UTF-8");
                    handler.deleteNodeProperty(propName);
                    continue;
                }
                SVNAdminHelper.generateStreamMalformedError();
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        return actualLength;
    }

    private Map readHeaderBlock(InputStream dumpStream, String firstHeader, CharsetDecoder decoder) throws SVNException, IOException {
        SVNHashMap headers = new SVNHashMap();
        StringBuffer buffer = new StringBuffer();
        while (true) {
            String header = null;
            buffer.setLength(0);
            if (firstHeader != null) {
                header = firstHeader;
                firstHeader = null;
            } else {
                header = SVNFileUtil.readLineFromStream(dumpStream, buffer, decoder);
                if (header == null && buffer.length() > 0) {
                    SVNAdminHelper.generateIncompleteDataError();
                } else if (buffer.length() == 0) break;
            }
            int colonInd = header.indexOf(58);
            if (colonInd == -1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Dump stream contains a malformed header (with no '':'') at ''{0}''", (Object)(header.length() > 20 ? header.substring(0, 19) : header));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            String name = header.substring(0, colonInd);
            if (colonInd + 2 > header.length()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Dump stream contains a malformed header (with no value) at ''{0}''", (Object)(header.length() > 20 ? header.substring(0, 19) : header));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            String value = header.substring(colonInd + 2);
            headers.put(name, value);
        }
        return headers;
    }
}

