/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.framework.qual.FromByteCode;
import org.checkerframework.qualframework.base.TypeMirrorConverter;
import plume.TimeLimitProcess;
import plume.UtilMDE;

public final class FileCompiler {
    public static @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown Runtime runtime = Runtime.getRuntime();
    static @Regex(value=1) @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=27, desc="Regex(1)") @TypeMirrorConverter.Key(index=27, desc="Regex(1)") @TypeMirrorConverter.Key(index=27, desc="Regex(1)") @TypeMirrorConverter.Key(index=27, desc="Regex(1)") @TypeMirrorConverter.Key(index=27, desc="Regex(1)") @TypeMirrorConverter.Key(index=27, desc="Regex(1)") @UnknownFormat @SignatureUnknown Pattern java_filename_pattern;
    private @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String compiler;
    private @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long timeLimit;

    @FromByteCode
    public FileCompiler() {
        this("javac", 6000L);
    }

    @FromByteCode
    public FileCompiler(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String compiler2, @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown long timeLimit) {
        this.compiler = compiler2;
        this.timeLimit = timeLimit;
    }

    @FromByteCode
    public @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String compileFiles(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown List<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String> fileNames) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown IOException {
        TimeLimitProcess p = this.compile_source(fileNames);
        String compile_errors = "";
        String compile_output = "";
        try {
            int n = p.waitFor();
        }
        catch (Throwable e) {
            compile_errors = UtilMDE.streamString(p.getErrorStream());
            compile_output = UtilMDE.streamString(p.getInputStream());
            System.out.println("Unexpected exception while compiling " + e);
            if (p.timed_out()) {
                System.out.println("Compile timed out after " + p.timeout_msecs() + " msecs");
            }
            e.printStackTrace();
            runtime.exit(1);
        }
        compile_errors = UtilMDE.streamString(p.getErrorStream());
        compile_output = UtilMDE.streamString(p.getInputStream());
        if (this.compiler.indexOf("javac") != -1) {
            this.recompile_without_errors(fileNames, compile_errors);
        }
        return compile_errors;
    }

    @FromByteCode
    private @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown TimeLimitProcess compile_source(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown List<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String> filenames) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown IOException {
        int num_files = filenames.size();
        if (num_files == 0) {
            throw new Error("no files to compile were provided");
        }
        String[] command = new String[num_files + 1];
        command[0] = this.compiler;
        for (int i = 0; i < num_files; ++i) {
            command[i + 1] = filenames.get(i);
        }
        return new TimeLimitProcess(runtime.exec(command), this.timeLimit, true);
    }

    @FromByteCode
    private void recompile_without_errors(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown List<@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String> fileNames, @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String errorString) throws @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown IOException {
        if (errorString != null) {
            HashSet<String> errorClasses = new HashSet<String>();
            Matcher m3 = java_filename_pattern.matcher(errorString);
            while (m3.find()) {
                @NonNull String sansExtension = m3.group(1);
                errorClasses.add(sansExtension);
            }
            ArrayList<String> retry = new ArrayList<String>();
            String filenames = "";
            for (String sourceFileName : fileNames) {
                String classFilePath = FileCompiler.getClassFilePath(sourceFileName = sourceFileName.trim());
                if (FileCompiler.fileExists(classFilePath) || errorClasses.contains(sourceFileName)) continue;
                retry.add(sourceFileName);
                filenames = filenames + " " + sourceFileName;
            }
            if (retry.size() > 0) {
                TimeLimitProcess tp = this.compile_source(retry);
                try {
                    tp.waitFor();
                }
                catch (InterruptedException e) {
                    System.out.println("Compile of " + filenames + " interrupted: " + e);
                }
            }
        }
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String getClassFilePath(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String sourceFilePath) {
        int index = sourceFilePath.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("sourceFilePath: " + sourceFilePath + " must end with an extention.");
        }
        return sourceFilePath.substring(0, index) + ".class";
    }

    @FromByteCode
    private static @UnknownKeyFor @NonRaw @NonNull @Initialized @Interned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown boolean fileExists(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String pathName) {
        return new File(pathName).exists();
    }

    static {
        try {
            String java_filename_re = "(?m)^([^ ]+?\\.java)";
            java_filename_pattern = Pattern.compile(java_filename_re);
        }
        catch (PatternSyntaxException me) {
            me.printStackTrace();
            throw new Error("Error in regexp", me);
        }
    }
}

