/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import com.sun.tools.doclint.Entity;
import com.sun.tools.doclint.Env;
import com.sun.tools.doclint.HtmlTag;
import com.sun.tools.doclint.Messages;
import com.sun.tools.javac.tree.DocPretty;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Checker
extends DocTreePathScanner<Void, Void> {
    final Env env;
    Set<Element> foundParams = new HashSet<Element>();
    Set<TypeMirror> foundThrows = new HashSet<TypeMirror>();
    Map<Element, Set<String>> foundAnchors = new HashMap<Element, Set<String>>();
    boolean foundInheritDoc = false;
    boolean foundReturn = false;
    private Deque<TagStackItem> tagStack;
    private HtmlTag currHeaderTag;
    private final int implicitHeaderLevel;
    private static final Pattern validName = Pattern.compile("[A-Za-z][A-Za-z0-9-_:.]*");
    private static final Pattern validNumber = Pattern.compile("-?[0-9]+");
    private static final Pattern docRoot = Pattern.compile("(?i)(\\{@docRoot *\\}/?)?(.*)");

    Checker(Env env) {
        env.getClass();
        this.env = env;
        this.tagStack = new LinkedList<TagStackItem>();
        this.implicitHeaderLevel = env.implicitHeaderLevel;
    }

    public Void scan(DocCommentTree tree, TreePath p) {
        boolean isOverridingMethod;
        this.env.setCurrent(p, tree);
        boolean bl = isOverridingMethod = !this.env.currOverriddenMethods.isEmpty();
        if (p.getLeaf() == p.getCompilationUnit()) {
            JavaFileObject fo = p.getCompilationUnit().getSourceFile();
            boolean isPkgInfo = fo.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
            if (tree == null) {
                if (isPkgInfo) {
                    this.reportMissing("dc.missing.comment", new Object[0]);
                }
                return null;
            }
            if (!isPkgInfo) {
                this.reportReference("dc.unexpected.comment", new Object[0]);
            }
        } else if (tree == null) {
            if (!this.isSynthetic() && !isOverridingMethod) {
                this.reportMissing("dc.missing.comment", new Object[0]);
            }
            return null;
        }
        this.tagStack.clear();
        this.currHeaderTag = null;
        this.foundParams.clear();
        this.foundThrows.clear();
        this.foundInheritDoc = false;
        this.foundReturn = false;
        this.scan(new DocTreePath(p, tree), null);
        if (!isOverridingMethod) {
            switch (this.env.currElement.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: {
                    ExecutableElement ee = (ExecutableElement)this.env.currElement;
                    this.checkParamsDocumented(ee.getTypeParameters());
                    this.checkParamsDocumented(ee.getParameters());
                    switch (ee.getReturnType().getKind()) {
                        case VOID: 
                        case NONE: {
                            break;
                        }
                        default: {
                            if (this.foundReturn || this.foundInheritDoc || this.env.types.isSameType(ee.getReturnType(), this.env.java_lang_Void)) break;
                            this.reportMissing("dc.missing.return", new Object[0]);
                        }
                    }
                    this.checkThrowsDocumented(ee.getThrownTypes());
                }
            }
        }
        return null;
    }

    private void reportMissing(String code, Object ... args) {
        this.env.messages.report(Messages.Group.MISSING, Diagnostic.Kind.WARNING, this.env.currPath.getLeaf(), code, args);
    }

    private void reportReference(String code, Object ... args) {
        this.env.messages.report(Messages.Group.REFERENCE, Diagnostic.Kind.WARNING, this.env.currPath.getLeaf(), code, args);
    }

    @Override
    public Void visitDocComment(DocCommentTree tree, Void ignore) {
        super.visitDocComment(tree, ignore);
        for (TagStackItem tsi : this.tagStack) {
            this.warnIfEmpty(tsi, null);
            if (tsi.tree.getKind() != DocTree.Kind.START_ELEMENT || tsi.tag.endKind != HtmlTag.EndKind.REQUIRED) continue;
            StartElementTree t = (StartElementTree)tsi.tree;
            this.env.messages.error(Messages.Group.HTML, t, "dc.tag.not.closed", t.getName());
        }
        return null;
    }

    @Override
    public Void visitText(TextTree tree, Void ignore) {
        if (this.hasNonWhitespace(tree)) {
            this.checkAllowsText(tree);
            this.markEnclosingTag(Flag.HAS_TEXT);
        }
        return null;
    }

    @Override
    public Void visitEntity(EntityTree tree, Void ignore) {
        this.checkAllowsText(tree);
        this.markEnclosingTag(Flag.HAS_TEXT);
        String name = tree.getName().toString();
        if (name.startsWith("#")) {
            int v;
            int n = v = StringUtils.toLowerCase(name).startsWith("#x") ? Integer.parseInt(name.substring(2), 16) : Integer.parseInt(name.substring(1), 10);
            if (!Entity.isValid(v)) {
                this.env.messages.error(Messages.Group.HTML, tree, "dc.entity.invalid", name);
            }
        } else if (!Entity.isValid(name)) {
            this.env.messages.error(Messages.Group.HTML, tree, "dc.entity.invalid", name);
        }
        return null;
    }

    void checkAllowsText(DocTree tree) {
        TagStackItem top = this.tagStack.peek();
        if (top != null && top.tree.getKind() == DocTree.Kind.START_ELEMENT && !top.tag.acceptsText() && top.flags.add(Flag.REPORTED_BAD_INLINE)) {
            this.env.messages.error(Messages.Group.HTML, tree, "dc.text.not.allowed", ((StartElementTree)top.tree).getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitStartElement(StartElementTree tree, Void ignore) {
        Name treeName = tree.getName();
        HtmlTag t = HtmlTag.get(treeName);
        if (t == null) {
            this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.unknown", treeName);
        } else {
            boolean done = false;
            for (TagStackItem tsi : this.tagStack) {
                if (tsi.tag.accepts(t)) {
                    while (this.tagStack.peek() != tsi) {
                        this.warnIfEmpty(this.tagStack.peek(), null);
                        this.tagStack.pop();
                    }
                    done = true;
                    break;
                }
                if (tsi.tag.endKind == HtmlTag.EndKind.OPTIONAL) continue;
                done = true;
                break;
            }
            if (!done && HtmlTag.BODY.accepts(t)) {
                while (!this.tagStack.isEmpty()) {
                    this.warnIfEmpty(this.tagStack.peek(), null);
                    this.tagStack.pop();
                }
            }
            this.markEnclosingTag(Flag.HAS_ELEMENT);
            this.checkStructure(tree, t);
            switch (t) {
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: {
                    this.checkHeader(tree, t);
                }
            }
            if (t.flags.contains((Object)HtmlTag.Flag.NO_NEST)) {
                for (TagStackItem i : this.tagStack) {
                    if (t != i.tag) continue;
                    this.env.messages.warning(Messages.Group.HTML, tree, "dc.tag.nested.not.allowed", treeName);
                    break;
                }
            }
        }
        if (tree.isSelfClosing()) {
            this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.self.closing", treeName);
        }
        try {
            TagStackItem parent = this.tagStack.peek();
            TagStackItem top = new TagStackItem(tree, t);
            this.tagStack.push(top);
            super.visitStartElement(tree, ignore);
            if (t != null) {
                switch (t) {
                    case CAPTION: {
                        if (parent == null || parent.tag != HtmlTag.TABLE) break;
                        parent.flags.add(Flag.TABLE_HAS_CAPTION);
                        break;
                    }
                    case IMG: {
                        if (top.attrs.contains((Object)HtmlTag.Attr.ALT)) break;
                        this.env.messages.error(Messages.Group.ACCESSIBILITY, tree, "dc.no.alt.attr.for.image", new Object[0]);
                    }
                }
            }
            Void void_ = null;
            return void_;
        }
        finally {
            if (t == null || t.endKind == HtmlTag.EndKind.NONE) {
                this.tagStack.pop();
            }
        }
    }

    private void checkStructure(StartElementTree tree, HtmlTag t) {
        Name treeName = tree.getName();
        TagStackItem top = this.tagStack.peek();
        switch (t.blockType) {
            case BLOCK: {
                if (top == null || top.tag.accepts(t)) {
                    return;
                }
                switch (top.tree.getKind()) {
                    case START_ELEMENT: {
                        if (top.tag.blockType != HtmlTag.BlockType.INLINE) break;
                        Name name = ((StartElementTree)top.tree).getName();
                        this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.not.allowed.inline.element", treeName, name);
                        return;
                    }
                    case LINK: 
                    case LINK_PLAIN: {
                        String name = top.tree.getKind().tagName;
                        this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.not.allowed.inline.tag", treeName, name);
                        return;
                    }
                }
                break;
            }
            case INLINE: {
                if (top != null && !top.tag.accepts(t)) break;
                return;
            }
            case LIST_ITEM: 
            case TABLE_ITEM: {
                if (top == null) break;
                top.flags.remove((Object)Flag.REPORTED_BAD_INLINE);
                if (!top.tag.accepts(t)) break;
                return;
            }
            case OTHER: {
                this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.not.allowed", treeName);
                return;
            }
        }
        this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.not.allowed.here", treeName);
    }

    private void checkHeader(StartElementTree tree, HtmlTag tag) {
        if (this.getHeaderLevel(tag) > this.getHeaderLevel(this.currHeaderTag) + 1) {
            if (this.currHeaderTag == null) {
                this.env.messages.error(Messages.Group.ACCESSIBILITY, tree, "dc.tag.header.sequence.1", new Object[]{tag});
            } else {
                this.env.messages.error(Messages.Group.ACCESSIBILITY, tree, "dc.tag.header.sequence.2", new Object[]{tag, this.currHeaderTag});
            }
        }
        this.currHeaderTag = tag;
    }

    private int getHeaderLevel(HtmlTag tag) {
        if (tag == null) {
            return this.implicitHeaderLevel;
        }
        switch (tag) {
            case H1: {
                return 1;
            }
            case H2: {
                return 2;
            }
            case H3: {
                return 3;
            }
            case H4: {
                return 4;
            }
            case H5: {
                return 5;
            }
            case H6: {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Void visitEndElement(EndElementTree tree, Void ignore) {
        Name treeName = tree.getName();
        HtmlTag t = HtmlTag.get(treeName);
        if (t == null) {
            this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.unknown", treeName);
        } else if (t.endKind == HtmlTag.EndKind.NONE) {
            this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.end.not.permitted", treeName);
        } else {
            boolean done = false;
            while (!this.tagStack.isEmpty()) {
                TagStackItem top = this.tagStack.peek();
                if (t == top.tag) {
                    switch (t) {
                        case TABLE: {
                            if (top.attrs.contains((Object)HtmlTag.Attr.SUMMARY) || top.flags.contains((Object)Flag.TABLE_HAS_CAPTION)) break;
                            this.env.messages.error(Messages.Group.ACCESSIBILITY, tree, "dc.no.summary.or.caption.for.table", new Object[0]);
                        }
                    }
                    this.warnIfEmpty(top, tree);
                    this.tagStack.pop();
                    done = true;
                    break;
                }
                if (top.tag == null || top.tag.endKind != HtmlTag.EndKind.REQUIRED) {
                    this.tagStack.pop();
                    continue;
                }
                boolean found = false;
                for (TagStackItem si : this.tagStack) {
                    if (si.tag != t) continue;
                    found = true;
                    break;
                }
                if (found && top.tree.getKind() == DocTree.Kind.START_ELEMENT) {
                    this.env.messages.error(Messages.Group.HTML, top.tree, "dc.tag.start.unmatched", ((StartElementTree)top.tree).getName());
                    this.tagStack.pop();
                    continue;
                }
                this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.end.unexpected", treeName);
                done = true;
                break;
            }
            if (!done && this.tagStack.isEmpty()) {
                this.env.messages.error(Messages.Group.HTML, tree, "dc.tag.end.unexpected", treeName);
            }
        }
        return (Void)super.visitEndElement(tree, ignore);
    }

    void warnIfEmpty(TagStackItem tsi, DocTree endTree) {
        if (tsi.tag != null && tsi.tree instanceof StartElementTree && tsi.tag.flags.contains((Object)HtmlTag.Flag.EXPECT_CONTENT) && !tsi.flags.contains((Object)Flag.HAS_TEXT) && !tsi.flags.contains((Object)Flag.HAS_ELEMENT) && !tsi.flags.contains((Object)Flag.HAS_INLINE_TAG)) {
            DocTree tree = endTree != null ? endTree : tsi.tree;
            Name treeName = ((StartElementTree)tsi.tree).getName();
            this.env.messages.warning(Messages.Group.HTML, tree, "dc.tag.empty", treeName);
        }
    }

    @Override
    public Void visitAttribute(AttributeTree tree, Void ignore) {
        HtmlTag currTag = this.tagStack.peek().tag;
        if (currTag != null) {
            boolean first;
            Name name = tree.getName();
            HtmlTag.Attr attr = currTag.getAttr(name);
            if (attr != null && !(first = this.tagStack.peek().attrs.add(attr))) {
                this.env.messages.error(Messages.Group.HTML, tree, "dc.attr.repeated", name);
            }
            HtmlTag.AttrKind k = currTag.getAttrKind(name);
            switch (k) {
                case OK: {
                    break;
                }
                case INVALID: {
                    this.env.messages.error(Messages.Group.HTML, tree, "dc.attr.unknown", name);
                    break;
                }
                case OBSOLETE: {
                    this.env.messages.warning(Messages.Group.ACCESSIBILITY, tree, "dc.attr.obsolete", name);
                    break;
                }
                case USE_CSS: {
                    this.env.messages.warning(Messages.Group.ACCESSIBILITY, tree, "dc.attr.obsolete.use.css", name);
                }
            }
            if (attr != null) {
                switch (attr) {
                    case NAME: {
                        if (currTag != HtmlTag.A) break;
                    }
                    case ID: {
                        String value = this.getAttrValue(tree);
                        if (value == null) {
                            this.env.messages.error(Messages.Group.HTML, tree, "dc.anchor.value.missing", new Object[0]);
                            break;
                        }
                        if (!validName.matcher(value).matches()) {
                            this.env.messages.error(Messages.Group.HTML, tree, "dc.invalid.anchor", value);
                        }
                        if (this.checkAnchor(value)) break;
                        this.env.messages.error(Messages.Group.HTML, tree, "dc.anchor.already.defined", value);
                        break;
                    }
                    case HREF: {
                        if (currTag != HtmlTag.A) break;
                        String v = this.getAttrValue(tree);
                        if (v == null || v.isEmpty()) {
                            this.env.messages.error(Messages.Group.HTML, tree, "dc.attr.lacks.value", new Object[0]);
                            break;
                        }
                        Matcher m3 = docRoot.matcher(v);
                        if (m3.matches()) {
                            String rest = m3.group(2);
                            if (rest.isEmpty()) break;
                            this.checkURI(tree, rest);
                            break;
                        }
                        this.checkURI(tree, v);
                        break;
                    }
                    case VALUE: {
                        if (currTag != HtmlTag.LI) break;
                        String v = this.getAttrValue(tree);
                        if (v == null || v.isEmpty()) {
                            this.env.messages.error(Messages.Group.HTML, tree, "dc.attr.lacks.value", new Object[0]);
                            break;
                        }
                        if (validNumber.matcher(v).matches()) break;
                        this.env.messages.error(Messages.Group.HTML, tree, "dc.attr.not.number", new Object[0]);
                    }
                }
            }
        }
        return (Void)super.visitAttribute(tree, ignore);
    }

    private boolean checkAnchor(String name) {
        Element e = this.getEnclosingPackageOrClass(this.env.currElement);
        if (e == null) {
            return true;
        }
        Set<String> set = this.foundAnchors.get(e);
        if (set == null) {
            set = new HashSet<String>();
            this.foundAnchors.put(e, set);
        }
        return set.add(name);
    }

    private Element getEnclosingPackageOrClass(Element e) {
        while (e != null) {
            switch (e.getKind()) {
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case PACKAGE: {
                    return e;
                }
            }
            e = e.getEnclosingElement();
        }
        return e;
    }

    private String getAttrValue(AttributeTree tree) {
        if (tree.getValue() == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            new DocPretty(sw).print(tree.getValue());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    private void checkURI(AttributeTree tree, String uri) {
        try {
            URI uRI = new URI(uri);
        }
        catch (URISyntaxException e) {
            this.env.messages.error(Messages.Group.HTML, tree, "dc.invalid.uri", uri);
        }
    }

    @Override
    public Void visitAuthor(AuthorTree tree, Void ignore) {
        this.warnIfEmpty(tree, tree.getName());
        return (Void)super.visitAuthor(tree, ignore);
    }

    @Override
    public Void visitDocRoot(DocRootTree tree, Void ignore) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        return (Void)super.visitDocRoot(tree, ignore);
    }

    @Override
    public Void visitInheritDoc(InheritDocTree tree, Void ignore) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        this.foundInheritDoc = true;
        return (Void)super.visitInheritDoc(tree, ignore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitLink(LinkTree tree, Void ignore) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        HtmlTag t = tree.getKind() == DocTree.Kind.LINK ? HtmlTag.CODE : HtmlTag.SPAN;
        this.tagStack.push(new TagStackItem(tree, t));
        try {
            Void void_ = (Void)super.visitLink(tree, ignore);
            return void_;
        }
        finally {
            this.tagStack.pop();
        }
    }

    @Override
    public Void visitLiteral(LiteralTree tree, Void ignore) {
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        if (tree.getKind() == DocTree.Kind.CODE) {
            for (TagStackItem tsi : this.tagStack) {
                if (tsi.tag != HtmlTag.CODE) continue;
                this.env.messages.warning(Messages.Group.HTML, tree, "dc.tag.code.within.code", new Object[0]);
                break;
            }
        }
        return (Void)super.visitLiteral(tree, ignore);
    }

    @Override
    public Void visitParam(ParamTree tree, Void ignore) {
        Element paramElement;
        boolean typaram = tree.isTypeParameter();
        IdentifierTree nameTree = tree.getName();
        Element element = paramElement = nameTree != null ? this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), nameTree)) : null;
        if (paramElement == null) {
            switch (this.env.currElement.getKind()) {
                case CLASS: 
                case INTERFACE: {
                    if (!typaram) {
                        this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.invalid.param", new Object[0]);
                        break;
                    }
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    this.env.messages.error(Messages.Group.REFERENCE, nameTree, "dc.param.name.not.found", new Object[0]);
                    break;
                }
                default: {
                    this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.invalid.param", new Object[0]);
                    break;
                }
            }
        } else {
            this.foundParams.add(paramElement);
        }
        this.warnIfEmpty(tree, tree.getDescription());
        return (Void)super.visitParam(tree, ignore);
    }

    private void checkParamsDocumented(List<? extends Element> list) {
        if (this.foundInheritDoc) {
            return;
        }
        for (Element element : list) {
            if (this.foundParams.contains(element)) continue;
            Name paramName = element.getKind() == ElementKind.TYPE_PARAMETER ? "<" + element.getSimpleName() + ">" : element.getSimpleName();
            this.reportMissing("dc.missing.param", paramName);
        }
    }

    @Override
    public Void visitReference(ReferenceTree tree, Void ignore) {
        Element e;
        String sig = tree.getSignature();
        if (sig.contains("<") || sig.contains(">")) {
            this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.type.arg.not.allowed", new Object[0]);
        }
        if ((e = this.env.trees.getElement(this.getCurrentPath())) == null) {
            this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.ref.not.found", new Object[0]);
        }
        return (Void)super.visitReference(tree, ignore);
    }

    @Override
    public Void visitReturn(ReturnTree tree, Void ignore) {
        Element e = this.env.trees.getElement(this.env.currPath);
        if (e.getKind() != ElementKind.METHOD || ((ExecutableElement)e).getReturnType().getKind() == TypeKind.VOID) {
            this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.invalid.return", new Object[0]);
        }
        this.foundReturn = true;
        this.warnIfEmpty(tree, tree.getDescription());
        return (Void)super.visitReturn(tree, ignore);
    }

    @Override
    public Void visitSerialData(SerialDataTree tree, Void ignore) {
        this.warnIfEmpty(tree, tree.getDescription());
        return (Void)super.visitSerialData(tree, ignore);
    }

    @Override
    public Void visitSerialField(SerialFieldTree tree, Void ignore) {
        this.warnIfEmpty(tree, tree.getDescription());
        return (Void)super.visitSerialField(tree, ignore);
    }

    @Override
    public Void visitSince(SinceTree tree, Void ignore) {
        this.warnIfEmpty(tree, tree.getBody());
        return (Void)super.visitSince(tree, ignore);
    }

    @Override
    public Void visitThrows(ThrowsTree tree, Void ignore) {
        block5: {
            block6: {
                Element ex;
                ReferenceTree exName;
                block4: {
                    exName = tree.getExceptionName();
                    ex = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), exName));
                    if (ex != null) break block4;
                    this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.ref.not.found", new Object[0]);
                    break block5;
                }
                if (!this.isThrowable(ex.asType())) break block6;
                switch (this.env.currElement.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: {
                        if (this.isCheckedException(ex.asType())) {
                            ExecutableElement ee = (ExecutableElement)this.env.currElement;
                            this.checkThrowsDeclared(exName, ex.asType(), ee.getThrownTypes());
                            break;
                        }
                        break block5;
                    }
                    default: {
                        this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.invalid.throws", new Object[0]);
                        break;
                    }
                }
                break block5;
            }
            this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.invalid.throws", new Object[0]);
        }
        this.warnIfEmpty(tree, tree.getDescription());
        return (Void)this.scan(tree.getDescription(), ignore);
    }

    private boolean isThrowable(TypeMirror tm) {
        switch (tm.getKind()) {
            case DECLARED: 
            case TYPEVAR: {
                return this.env.types.isAssignable(tm, this.env.java_lang_Throwable);
            }
        }
        return false;
    }

    private void checkThrowsDeclared(ReferenceTree tree, TypeMirror t, List<? extends TypeMirror> list) {
        boolean found = false;
        for (TypeMirror typeMirror : list) {
            if (!this.env.types.isAssignable(t, typeMirror)) continue;
            this.foundThrows.add(typeMirror);
            found = true;
        }
        if (!found) {
            this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.exception.not.thrown", t);
        }
    }

    private void checkThrowsDocumented(List<? extends TypeMirror> list) {
        if (this.foundInheritDoc) {
            return;
        }
        for (TypeMirror typeMirror : list) {
            if (!this.isCheckedException(typeMirror) || this.foundThrows.contains(typeMirror)) continue;
            this.reportMissing("dc.missing.throws", typeMirror);
        }
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree tree, Void ignore) {
        this.checkUnknownTag(tree, tree.getTagName());
        return (Void)super.visitUnknownBlockTag(tree, ignore);
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree tree, Void ignore) {
        this.checkUnknownTag(tree, tree.getTagName());
        return (Void)super.visitUnknownInlineTag(tree, ignore);
    }

    private void checkUnknownTag(DocTree tree, String tagName) {
        if (this.env.customTags != null && !this.env.customTags.contains(tagName)) {
            this.env.messages.error(Messages.Group.SYNTAX, tree, "dc.tag.unknown", tagName);
        }
    }

    @Override
    public Void visitValue(ValueTree tree, Void ignore) {
        ReferenceTree ref = tree.getReference();
        if (ref == null || ref.getSignature().isEmpty()) {
            if (!this.isConstant(this.env.currElement)) {
                this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.value.not.allowed.here", new Object[0]);
            }
        } else {
            Element e = this.env.trees.getElement(new DocTreePath(this.getCurrentPath(), ref));
            if (!this.isConstant(e)) {
                this.env.messages.error(Messages.Group.REFERENCE, tree, "dc.value.not.a.constant", new Object[0]);
            }
        }
        this.markEnclosingTag(Flag.HAS_INLINE_TAG);
        return (Void)super.visitValue(tree, ignore);
    }

    private boolean isConstant(Element e) {
        if (e == null) {
            return false;
        }
        switch (e.getKind()) {
            case FIELD: {
                Object value = ((VariableElement)e).getConstantValue();
                return value != null;
            }
        }
        return false;
    }

    @Override
    public Void visitVersion(VersionTree tree, Void ignore) {
        this.warnIfEmpty(tree, tree.getBody());
        return (Void)super.visitVersion(tree, ignore);
    }

    @Override
    public Void visitErroneous(ErroneousTree tree, Void ignore) {
        this.env.messages.error(Messages.Group.SYNTAX, tree, null, tree.getDiagnostic().getMessage(null));
        return null;
    }

    private boolean isCheckedException(TypeMirror t) {
        return !this.env.types.isAssignable(t, this.env.java_lang_Error) && !this.env.types.isAssignable(t, this.env.java_lang_RuntimeException);
    }

    private boolean isSynthetic() {
        switch (this.env.currElement.getKind()) {
            case CONSTRUCTOR: {
                TreePath p = this.env.currPath;
                return this.env.getPos(p) == this.env.getPos(p.getParentPath());
            }
        }
        return false;
    }

    void markEnclosingTag(Flag flag) {
        TagStackItem top = this.tagStack.peek();
        if (top != null) {
            top.flags.add(flag);
        }
    }

    String toString(TreePath p) {
        StringBuilder sb = new StringBuilder("TreePath[");
        this.toString(p, sb);
        sb.append("]");
        return sb.toString();
    }

    void toString(TreePath p, StringBuilder sb) {
        TreePath parent = p.getParentPath();
        if (parent != null) {
            this.toString(parent, sb);
            sb.append(",");
        }
        sb.append((Object)p.getLeaf().getKind()).append(":").append(this.env.getPos(p)).append(":S").append(this.env.getStartPos(p));
    }

    void warnIfEmpty(DocTree tree, List<? extends DocTree> list) {
        block3: for (DocTree docTree : list) {
            switch (docTree.getKind()) {
                case TEXT: {
                    if (!this.hasNonWhitespace((TextTree)docTree)) continue block3;
                    return;
                }
            }
            return;
        }
        this.env.messages.warning(Messages.Group.SYNTAX, tree, "dc.empty", tree.getKind().tagName);
    }

    boolean hasNonWhitespace(TextTree tree) {
        String s2 = tree.getBody();
        for (int i = 0; i < s2.length(); ++i) {
            if (Character.isWhitespace(s2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static class TagStackItem {
        final DocTree tree;
        final HtmlTag tag;
        final Set<HtmlTag.Attr> attrs;
        final Set<Flag> flags;

        TagStackItem(DocTree tree, HtmlTag tag) {
            this.tree = tree;
            this.tag = tag;
            this.attrs = EnumSet.noneOf(HtmlTag.Attr.class);
            this.flags = EnumSet.noneOf(Flag.class);
        }

        public String toString() {
            return String.valueOf((Object)this.tag);
        }
    }

    public static enum Flag {
        TABLE_HAS_CAPTION,
        HAS_ELEMENT,
        HAS_INLINE_TAG,
        HAS_TEXT,
        REPORTED_BAD_INLINE;

    }
}

