/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.CalendarParserFactory;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.CalendarException;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentFactory;
import net.fortuna.ical4j.model.Escapable;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterFactory;
import net.fortuna.ical4j.model.ParameterFactoryRegistry;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyFactory;
import net.fortuna.ical4j.model.PropertyFactoryRegistry;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VAvailability;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.property.DateListProperty;
import net.fortuna.ical4j.model.property.DateProperty;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.Constants;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarBuilder {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final CalendarParser parser;
    private final ContentHandler contentHandler;
    private final TimeZoneRegistry tzRegistry;
    private List datesMissingTimezones;
    protected Calendar calendar;
    protected Component component;
    protected Component subComponent;
    protected Property property;
    static /* synthetic */ Class class$0;

    public CalendarBuilder() {
        this(CalendarParserFactory.getInstance().createParser(), new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(CalendarParser parser) {
        this(parser, new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), TimeZoneRegistryFactory.getInstance().createRegistry());
    }

    public CalendarBuilder(TimeZoneRegistry tzRegistry) {
        this(CalendarParserFactory.getInstance().createParser(), new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), tzRegistry);
    }

    public CalendarBuilder(CalendarParser parser, TimeZoneRegistry tzRegistry) {
        this(parser, new PropertyFactoryRegistry(), new ParameterFactoryRegistry(), tzRegistry);
    }

    public CalendarBuilder(CalendarParser parser, PropertyFactoryRegistry propertyFactoryRegistry, ParameterFactoryRegistry parameterFactoryRegistry, TimeZoneRegistry tzRegistry) {
        this.parser = parser;
        this.tzRegistry = tzRegistry;
        this.contentHandler = new ContentHandlerImpl(ComponentFactory.getInstance(), propertyFactoryRegistry, parameterFactoryRegistry);
    }

    public Calendar build(InputStream in) throws IOException, ParserException {
        return this.build(new InputStreamReader(in, DEFAULT_CHARSET));
    }

    public Calendar build(Reader in) throws IOException, ParserException {
        return this.build(new UnfoldingReader(in));
    }

    public Calendar build(UnfoldingReader uin) throws IOException, ParserException {
        this.calendar = null;
        this.component = null;
        this.subComponent = null;
        this.property = null;
        this.datesMissingTimezones = new ArrayList();
        this.parser.parse(uin, this.contentHandler);
        if (this.datesMissingTimezones.size() > 0 && this.tzRegistry != null) {
            this.resolveTimezones();
        }
        return this.calendar;
    }

    private void assertComponent(Component component) {
        if (component == null) {
            throw new CalendarException("Expected component not initialised");
        }
    }

    private void assertProperty(Property property) {
        if (property == null) {
            throw new CalendarException("Expected property not initialised");
        }
    }

    public final TimeZoneRegistry getRegistry() {
        return this.tzRegistry;
    }

    private void updateTimeZone(Property property, TimeZone timezone) {
        block9: {
            try {
                ((DateProperty)property).setTimeZone(timezone);
            }
            catch (ClassCastException e) {
                try {
                    ((DateListProperty)property).setTimeZone(timezone);
                }
                catch (ClassCastException e2) {
                    if (CompatibilityHints.isHintEnabled("ical4j.parsing.relaxed")) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("net.fortuna.ical4j.data.CalendarBuilder");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log log = LogFactory.getLog(clazz);
                        log.warn("Error setting timezone [" + timezone.getID() + "] on property [" + property.getName() + "]", e);
                        break block9;
                    }
                    throw e2;
                }
            }
        }
    }

    private void resolveTimezones() throws IOException {
        Iterator it = this.datesMissingTimezones.iterator();
        while (it.hasNext()) {
            TimeZone timezone;
            Property property = (Property)it.next();
            Parameter tzParam = property.getParameter("TZID");
            if (tzParam == null || (timezone = this.tzRegistry.getTimeZone(tzParam.getValue())) == null) continue;
            String strDate = property.getValue();
            if (property instanceof DateProperty) {
                ((DateProperty)property).setTimeZone(timezone);
            } else if (property instanceof DateListProperty) {
                ((DateListProperty)property).setTimeZone(timezone);
            }
            try {
                property.setValue(strDate);
            }
            catch (ParseException e) {
                throw new CalendarException(e);
            }
            catch (URISyntaxException e) {
                throw new CalendarException(e);
            }
        }
    }

    private class ContentHandlerImpl
    implements ContentHandler {
        private final ComponentFactory componentFactory;
        private final PropertyFactory propertyFactory;
        private final ParameterFactory parameterFactory;

        public ContentHandlerImpl(ComponentFactory componentFactory, PropertyFactory propertyFactory, ParameterFactory parameterFactory) {
            this.componentFactory = componentFactory;
            this.propertyFactory = propertyFactory;
            this.parameterFactory = parameterFactory;
        }

        public void endCalendar() {
        }

        public void endComponent(String name) {
            CalendarBuilder.this.assertComponent(CalendarBuilder.this.component);
            if (CalendarBuilder.this.subComponent != null) {
                if (CalendarBuilder.this.component instanceof VTimeZone) {
                    ((VTimeZone)CalendarBuilder.this.component).getObservances().add(CalendarBuilder.this.subComponent);
                } else if (CalendarBuilder.this.component instanceof VEvent) {
                    ((VEvent)CalendarBuilder.this.component).getAlarms().add(CalendarBuilder.this.subComponent);
                } else if (CalendarBuilder.this.component instanceof VToDo) {
                    ((VToDo)CalendarBuilder.this.component).getAlarms().add(CalendarBuilder.this.subComponent);
                } else if (CalendarBuilder.this.component instanceof VAvailability) {
                    ((VAvailability)CalendarBuilder.this.component).getAvailable().add(CalendarBuilder.this.subComponent);
                }
                CalendarBuilder.this.subComponent = null;
            } else {
                CalendarBuilder.this.calendar.getComponents().add(CalendarBuilder.this.component);
                if (CalendarBuilder.this.component instanceof VTimeZone && CalendarBuilder.this.tzRegistry != null) {
                    CalendarBuilder.this.tzRegistry.register(new TimeZone((VTimeZone)CalendarBuilder.this.component));
                }
                CalendarBuilder.this.component = null;
            }
        }

        public void endProperty(String name) {
            CalendarBuilder.this.assertProperty(CalendarBuilder.this.property);
            CalendarBuilder.this.property = Constants.forProperty(CalendarBuilder.this.property);
            if (CalendarBuilder.this.component != null) {
                if (CalendarBuilder.this.subComponent != null) {
                    CalendarBuilder.this.subComponent.getProperties().add(CalendarBuilder.this.property);
                } else {
                    CalendarBuilder.this.component.getProperties().add(CalendarBuilder.this.property);
                }
            } else if (CalendarBuilder.this.calendar != null) {
                CalendarBuilder.this.calendar.getProperties().add(CalendarBuilder.this.property);
            }
            CalendarBuilder.this.property = null;
        }

        public void parameter(String name, String value) throws URISyntaxException {
            CalendarBuilder.this.assertProperty(CalendarBuilder.this.property);
            Parameter param = this.parameterFactory.createParameter(name.toUpperCase(), Strings.escapeNewline(value));
            CalendarBuilder.this.property.getParameters().add(param);
            if (param instanceof TzId && CalendarBuilder.this.tzRegistry != null && !(CalendarBuilder.this.property instanceof XProperty)) {
                TimeZone timezone = CalendarBuilder.this.tzRegistry.getTimeZone(param.getValue());
                if (timezone != null) {
                    CalendarBuilder.this.updateTimeZone(CalendarBuilder.this.property, timezone);
                } else {
                    CalendarBuilder.this.datesMissingTimezones.add(CalendarBuilder.this.property);
                }
            }
        }

        public void propertyValue(String value) throws URISyntaxException, ParseException, IOException {
            CalendarBuilder.this.assertProperty(CalendarBuilder.this.property);
            if (CalendarBuilder.this.property instanceof Escapable) {
                CalendarBuilder.this.property.setValue(Strings.unescape(value));
            } else {
                CalendarBuilder.this.property.setValue(value);
            }
        }

        public void startCalendar() {
            CalendarBuilder.this.calendar = new Calendar();
        }

        public void startComponent(String name) {
            if (CalendarBuilder.this.component != null) {
                CalendarBuilder.this.subComponent = this.componentFactory.createComponent(name);
            } else {
                CalendarBuilder.this.component = this.componentFactory.createComponent(name);
            }
        }

        public void startProperty(String name) {
            CalendarBuilder.this.property = this.propertyFactory.createProperty(name.toUpperCase());
        }
    }
}

