/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class ByteSequence
extends DataInputStream {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteArrayStream byteStream;

    public ByteSequence(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bytes) {
        super(new ByteArrayStream(bytes));
        this.byteStream = (ByteArrayStream)this.in;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.byteStream.getPosition();
    }

    final void unreadByte() {
        this.byteStream.unreadByte();
    }

    private static final class ByteArrayStream
    extends ByteArrayInputStream {
        ByteArrayStream(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] bytes) {
            super(bytes);
        }

        final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getPosition() {
            return this.pos;
        }

        final void unreadByte() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

