/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter;

import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.formatter.FormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.I18nFormatterAnnotatedTypeFactory;
import org.checkerframework.checker.i18nformatter.I18nFormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.checkerframework.checker.i18nformatter.qual.I18nInvalidFormat;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.util.AnnotationBuilder;

public class I18nFormatterTransfer
extends CFTransfer {
    public I18nFormatterTransfer(CFAnalysis analysis) {
        super(analysis);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<CFValue, CFStore> in) {
        I18nFormatterAnnotatedTypeFactory atypeFactory = (I18nFormatterAnnotatedTypeFactory)this.analysis.getTypeFactory();
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(node, in);
        I18nFormatterTreeUtil tu = atypeFactory.treeUtil;
        if (tu.isHasFormatCall(node, atypeFactory)) {
            CFStore thenStore = result.getRegularStore();
            CFStore elseStore = (CFStore)thenStore.copy();
            ConditionalTransferResult<CFValue, CFStore> newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), thenStore, elseStore);
            FormatterTreeUtil.Result<I18nConversionCategory[]> cats = tu.getHasFormatCallCategories(node);
            if (cats.value() == null) {
                tu.failure(cats, "i18nformat.indirect.arguments", new Object[0]);
            } else {
                FlowExpressions.Receiver firstParam = FlowExpressions.internalReprOf(atypeFactory, node.getArgument(0));
                AnnotationMirror anno = atypeFactory.treeUtil.categoriesToFormatAnnotation(cats.value());
                thenStore.insertValue(firstParam, anno);
            }
            return newResult;
        }
        if (tu.isIsFormatCall(node, atypeFactory)) {
            CFStore thenStore = result.getRegularStore();
            CFStore elseStore = (CFStore)thenStore.copy();
            ConditionalTransferResult<CFValue, CFStore> newResult = new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), thenStore, elseStore);
            FlowExpressions.Receiver firstParam = FlowExpressions.internalReprOf(atypeFactory, node.getArgument(0));
            AnnotationBuilder builder = new AnnotationBuilder(tu.processingEnv, I18nInvalidFormat.class.getCanonicalName());
            builder.setValue((CharSequence)"value", "");
            elseStore.insertValue(firstParam, builder.build());
            return newResult;
        }
        if (tu.isMakeFormatCall(node, atypeFactory)) {
            FormatterTreeUtil.Result<I18nConversionCategory[]> cats = tu.makeFormatCallCategories(node, atypeFactory);
            if (cats.value() == null) {
                tu.failure(cats, "i18nformat.key.not.found", new Object[0]);
            } else {
                AnnotationMirror anno = atypeFactory.treeUtil.categoriesToFormatAnnotation(cats.value());
                CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(anno, result.getResultValue().getUnderlyingType());
                return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
            }
        }
        return result;
    }
}

