/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.AnalysisResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.DOTCFGVisualizer;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractTransfer;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFCFGBuilder;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.DefaultFor;
import org.checkerframework.framework.qual.DefaultInUncheckedCodeFor;
import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.DefaultQualifierInHierarchyInUncheckedCode;
import org.checkerframework.framework.qual.MonotonicQualifier;
import org.checkerframework.framework.qual.RelevantJavaTypes;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.qual.Unqualified;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultInferredTypesApplier;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.type.typeannotator.ImplicitsTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.IrrelevantTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.ListTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.PropagationTypeAnnotator;
import org.checkerframework.framework.type.typeannotator.TypeAnnotator;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.QualifierPolymorphism;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public abstract class GenericAnnotatedTypeFactory<Value extends CFAbstractValue<Value>, Store extends CFAbstractStore<Value, Store>, TransferFunction extends CFAbstractTransfer<Value, Store, TransferFunction>, FlowAnalysis extends CFAbstractAnalysis<Value, Store, TransferFunction>>
extends AnnotatedTypeFactory {
    protected static boolean FLOW_BY_DEFAULT = true;
    private Set<Class<? extends Annotation>> supportedMonotonicQuals;
    protected TypeAnnotator typeAnnotator;
    private ImplicitsTypeAnnotator implicitsTypeAnnotator;
    protected TreeAnnotator treeAnnotator;
    protected QualifierPolymorphism poly;
    protected QualifierDefaults defaults;
    private boolean useFlow;
    private final boolean everUseFlow;
    private boolean shouldDefaultTypeVarLocals;
    private Store emptyStore;
    private static final Comparator<Class<? extends Annotation>> QUALIFIER_SORT_ORDERING = new Comparator<Class<? extends Annotation>>(){

        @Override
        public int compare(Class<? extends Annotation> a1, Class<? extends Annotation> a2) {
            return a1.getCanonicalName().compareTo(a2.getCanonicalName());
        }
    };
    protected final Map<ClassTree, ScanState> scannedClasses;
    protected AnalysisResult<Value, Store> flowResult;
    protected IdentityHashMap<Tree, Store> regularExitStores;
    protected IdentityHashMap<MethodTree, List<Pair<ReturnNode, TransferResult<Value, Store>>>> returnStatementStores;
    protected IdentityHashMap<MethodInvocationTree, Store> methodInvocationStores;
    protected final Deque<FlowAnalysis> analyses;
    protected Store initializationStore;
    protected Store initializationStaticStore;
    protected final CFGVisualizer<Value, Store, TransferFunction> cfgVisualizer;

    public GenericAnnotatedTypeFactory(BaseTypeChecker checker, boolean useFlow) {
        super(checker);
        this.everUseFlow = useFlow;
        this.shouldDefaultTypeVarLocals = useFlow;
        this.useFlow = useFlow;
        this.analyses = new LinkedList<FlowAnalysis>();
        this.scannedClasses = new HashMap<ClassTree, ScanState>();
        this.flowResult = null;
        this.regularExitStores = null;
        this.methodInvocationStores = null;
        this.returnStatementStores = null;
        this.initializationStore = null;
        this.initializationStaticStore = null;
        this.cfgVisualizer = this.createCFGVisualizer();
    }

    @Override
    protected void postInit() {
        super.postInit();
        this.defaults = this.createQualifierDefaults();
        this.treeAnnotator = this.createTreeAnnotator();
        this.typeAnnotator = this.createTypeAnnotator();
        this.poly = this.createQualifierPolymorphism();
        this.parseStubFiles();
    }

    @Override
    public void preProcessClassTree(ClassTree classTree) {
        if (this.everUseFlow) {
            this.checkAndPerformFlowAnalysis(classTree);
        }
    }

    public GenericAnnotatedTypeFactory(BaseTypeChecker checker) {
        this(checker, FLOW_BY_DEFAULT);
    }

    @Override
    public void setRoot(@Nullable CompilationUnitTree root) {
        super.setRoot(root);
        this.analyses.clear();
        this.scannedClasses.clear();
        this.flowResult = null;
        this.regularExitStores = null;
        this.methodInvocationStores = null;
        this.returnStatementStores = null;
        this.initializationStore = null;
        this.initializationStaticStore = null;
    }

    public final Set<Class<? extends Annotation>> getSupportedMonotonicTypeQualifiers() {
        if (this.supportedMonotonicQuals == null) {
            this.supportedMonotonicQuals = new HashSet<Class<? extends Annotation>>();
            for (Class<? extends Annotation> anno : this.getSupportedTypeQualifiers()) {
                MonotonicQualifier mono = anno.getAnnotation(MonotonicQualifier.class);
                if (mono == null) continue;
                this.supportedMonotonicQuals.add(anno);
            }
        }
        return this.supportedMonotonicQuals;
    }

    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new PropagationTreeAnnotator(this), new ImplicitsTreeAnnotator(this));
    }

    protected TypeAnnotator createTypeAnnotator() {
        ArrayList<TypeAnnotator> typeAnnotators = new ArrayList<TypeAnnotator>();
        RelevantJavaTypes relevantJavaTypes = this.checker.getClass().getAnnotation(RelevantJavaTypes.class);
        if (relevantJavaTypes != null) {
            Class<?>[] classes = relevantJavaTypes.value();
            typeAnnotators.add(new IrrelevantTypeAnnotator(this, this.getQualifierHierarchy().getTopAnnotations(), classes));
        }
        typeAnnotators.add(new PropagationTypeAnnotator(this));
        this.implicitsTypeAnnotator = new ImplicitsTypeAnnotator(this);
        typeAnnotators.add(this.implicitsTypeAnnotator);
        return new ListTypeAnnotator(typeAnnotators);
    }

    protected void addTypeNameImplicit(Class<?> clazz, AnnotationMirror implicitAnno) {
        this.implicitsTypeAnnotator.addTypeName(clazz, implicitAnno);
    }

    protected FlowAnalysis createFlowAnalysis(List<Pair<VariableElement, Value>> fieldValues) {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Analysis").replace("Subchecker", "Analysis");
            CFAbstractAnalysis result = (CFAbstractAnalysis)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{BaseTypeChecker.class, this.getClass(), List.class}, new Object[]{this.checker, this, fieldValues});
            if (result == null) continue;
            return (FlowAnalysis)result;
        }
        ArrayList<Pair<VariableElement, CFValue>> tmp = new ArrayList<Pair<VariableElement, CFValue>>();
        for (Pair<VariableElement, Value> fieldVal : fieldValues) {
            assert (fieldVal.second instanceof CFValue);
            tmp.add(Pair.of(fieldVal.first, (CFValue)fieldVal.second));
        }
        return (FlowAnalysis)new CFAnalysis(this.checker, this, (List<Pair<VariableElement, CFValue>>)tmp);
    }

    public TransferFunction createFlowTransferFunction(CFAbstractAnalysis<Value, Store, TransferFunction> analysis) {
        for (Class<?> checkerClass = this.checker.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Transfer").replace("Subchecker", "Transfer");
            CFAbstractTransfer result = (CFAbstractTransfer)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{analysis.getClass()}, new Object[]{analysis});
            if (result == null) continue;
            return (TransferFunction)result;
        }
        CFTransfer ret = new CFTransfer(analysis);
        return (TransferFunction)ret;
    }

    protected final QualifierDefaults createQualifierDefaults() {
        QualifierDefaults defs = new QualifierDefaults(this.elements, this);
        this.addCheckedCodeDefaults(defs);
        this.addCheckedStandardDefaults(defs);
        this.addUncheckedCodeDefaults(defs);
        this.addUncheckedStandardDefaults(defs);
        this.checkForDefaultQualifierInHierarchy(defs);
        return defs;
    }

    protected final String getSortedQualifierNames() {
        ArrayList<Class<? extends Annotation>> sortedSupportedQuals = new ArrayList<Class<? extends Annotation>>();
        sortedSupportedQuals.addAll(this.getSupportedTypeQualifiers());
        Collections.sort(sortedSupportedQuals, QUALIFIER_SORT_ORDERING);
        StringBuilder sb = new StringBuilder();
        sb.append(sortedSupportedQuals.size());
        sb.append(" qualifiers examined");
        if (sortedSupportedQuals.size() > 0) {
            sb.append(": ");
            for (Class clazz : sortedSupportedQuals) {
                sb.append(clazz.getCanonicalName());
                sb.append(", ");
            }
            return sb.substring(0, sb.length() - 2);
        }
        return sb.toString();
    }

    protected void addCheckedCodeDefaults(QualifierDefaults defs) {
        boolean foundOtherwise = false;
        for (Class<? extends Annotation> qual : this.getSupportedTypeQualifiers()) {
            DefaultFor defaultFor = qual.getAnnotation(DefaultFor.class);
            if (defaultFor != null) {
                TypeUseLocation[] locations = defaultFor.value();
                defs.addCheckedCodeDefaults(AnnotationUtils.fromClass(this.elements, qual), locations);
                boolean bl = foundOtherwise = foundOtherwise || Arrays.asList(locations).contains((Object)TypeUseLocation.OTHERWISE);
            }
            if (qual.getAnnotation(DefaultQualifierInHierarchy.class) == null) continue;
            defs.addCheckedCodeDefault(AnnotationUtils.fromClass(this.elements, qual), TypeUseLocation.OTHERWISE);
            foundOtherwise = true;
        }
        AnnotationMirror unqualified = AnnotationUtils.fromClass(this.elements, Unqualified.class);
        if (!foundOtherwise && this.isSupportedQualifier(unqualified)) {
            defs.addCheckedCodeDefault(unqualified, TypeUseLocation.OTHERWISE);
        }
    }

    protected void addCheckedStandardDefaults(QualifierDefaults defs) {
        if (this.everUseFlow) {
            Set<? extends AnnotationMirror> tops = this.qualHierarchy.getTopAnnotations();
            Set<? extends AnnotationMirror> bottoms = this.qualHierarchy.getBottomAnnotations();
            defs.addClimbStandardDefaults(tops, bottoms);
        }
    }

    protected void addUncheckedCodeDefaults(QualifierDefaults defs) {
        for (Class<? extends Annotation> annotation : this.getSupportedTypeQualifiers()) {
            DefaultInUncheckedCodeFor defaultInUncheckedCodeFor = annotation.getAnnotation(DefaultInUncheckedCodeFor.class);
            if (defaultInUncheckedCodeFor != null) {
                TypeUseLocation[] locations = defaultInUncheckedCodeFor.value();
                defs.addUncheckedCodeDefaults(AnnotationUtils.fromClass(this.elements, annotation), locations);
            }
            if (annotation.getAnnotation(DefaultQualifierInHierarchyInUncheckedCode.class) == null) continue;
            defs.addUncheckedCodeDefault(AnnotationUtils.fromClass(this.elements, annotation), TypeUseLocation.OTHERWISE);
        }
    }

    protected void addUncheckedStandardDefaults(QualifierDefaults defs) {
        Set<? extends AnnotationMirror> tops = this.qualHierarchy.getTopAnnotations();
        Set<? extends AnnotationMirror> bottoms = this.qualHierarchy.getBottomAnnotations();
        defs.addUncheckedStandardDefaults(tops, bottoms);
    }

    protected void checkForDefaultQualifierInHierarchy(QualifierDefaults defs) {
        if (!defs.hasDefaultsForCheckedCode()) {
            ErrorReporter.errorAbort("GenericAnnotatedTypeFactory.createQualifierDefaults: @DefaultQualifierInHierarchy or @DefaultFor(TypeUseLocation.OTHERWISE) not found. Every checker must specify a default qualifier. " + this.getSortedQualifierNames());
        }
    }

    protected QualifierPolymorphism createQualifierPolymorphism() {
        return new QualifierPolymorphism(this.processingEnv, this);
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        if (type.getKind() == TypeKind.DECLARED) {
            for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
                Element elt = ((DeclaredType)annotatedTypeMirror.getUnderlyingType()).asElement();
                this.addComputedTypeAnnotations(elt, annotatedTypeMirror);
            }
        }
    }

    public AnnotatedTypeMirror getResultingTypeOfConstructorMemberReference(MemberReferenceTree memberReferenceTree, AnnotatedTypeMirror.AnnotatedExecutableType constructorType) {
        assert (memberReferenceTree.getMode() == MemberReferenceTree.ReferenceMode.NEW);
        AnnotatedTypeMirror.AnnotatedDeclaredType constructorReturnType = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromTypeTree(memberReferenceTree.getQualifierExpression());
        AnnotatedTypes.copyOnlyExplicitConstructorAnnotations(this, constructorReturnType, constructorType);
        this.addComputedTypeAnnotations(memberReferenceTree.getQualifierExpression(), (AnnotatedTypeMirror)constructorReturnType);
        return constructorReturnType;
    }

    public @Nullable Store getRegularExitStore(Tree t) {
        return (Store)((CFAbstractStore)this.regularExitStores.get(t));
    }

    public List<Pair<ReturnNode, TransferResult<Value, Store>>> getReturnStatementStores(MethodTree methodTree) {
        assert (this.returnStatementStores.containsKey(methodTree));
        return this.returnStatementStores.get(methodTree);
    }

    public Store getStoreBefore(Tree tree) {
        if (this.analyses.isEmpty()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreBefore(tree));
        }
        CFAbstractAnalysis analysis = (CFAbstractAnalysis)this.analyses.getFirst();
        Node node = analysis.getNodeForTree(tree);
        if (node == null) {
            return null;
        }
        return this.getStoreBefore(node);
    }

    public Store getStoreBefore(Node node) {
        if (this.analyses.isEmpty()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreBefore(node));
        }
        CFAbstractAnalysis analysis = (CFAbstractAnalysis)this.analyses.getFirst();
        TransferInput prevStore = analysis.getInput(node.getBlock());
        if (prevStore == null) {
            return null;
        }
        CFAbstractStore store = (CFAbstractStore)AnalysisResult.runAnalysisFor(node, true, prevStore);
        return (Store)store;
    }

    public Store getStoreAfter(Tree tree) {
        if (this.analyses.isEmpty()) {
            return (Store)((CFAbstractStore)this.flowResult.getStoreAfter(tree));
        }
        CFAbstractAnalysis analysis = (CFAbstractAnalysis)this.analyses.getFirst();
        Node node = analysis.getNodeForTree(tree);
        CFAbstractStore store = (CFAbstractStore)AnalysisResult.runAnalysisFor(node, false, analysis.getInput(node.getBlock()));
        return (Store)store;
    }

    public Node getNodeForTree(Tree tree) {
        return this.flowResult.getNodeForTree(tree);
    }

    public HashMap<Element, Value> getFinalLocalValues() {
        return this.flowResult.getFinalLocalValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performFlowAnalysis(ClassTree classTree) {
        if (this.flowResult == null) {
            this.regularExitStores = new IdentityHashMap();
            this.returnStatementStores = new IdentityHashMap();
            this.flowResult = new AnalysisResult();
        }
        if (classTree.getKind() == Tree.Kind.ANNOTATION_TYPE) {
            this.scannedClasses.put(classTree, ScanState.FINISHED);
            return;
        }
        LinkedList<ClassTree> queue = new LinkedList<ClassTree>();
        ArrayList<Pair<VariableElement, Value>> fieldValues = new ArrayList<Pair<VariableElement, Value>>();
        queue.add(classTree);
        while (!queue.isEmpty()) {
            ClassTree ct = (ClassTree)queue.remove();
            this.scannedClasses.put(ct, ScanState.IN_PROGRESS);
            AnnotatedTypeMirror.AnnotatedDeclaredType preClassType = this.visitorState.getClassType();
            ClassTree preClassTree = this.visitorState.getClassTree();
            AnnotatedTypeMirror.AnnotatedDeclaredType preAMT = this.visitorState.getMethodReceiver();
            MethodTree preMT = this.visitorState.getMethodTree();
            this.visitorState.setClassType(this.getAnnotatedType(ct));
            this.visitorState.setClassTree(ct);
            this.visitorState.setMethodReceiver(null);
            this.visitorState.setMethodTree(null);
            this.initializationStaticStore = null;
            this.initializationStore = null;
            LinkedList<Pair<LambdaExpressionTree, Store>> lambdaQueue = new LinkedList<Pair<LambdaExpressionTree, Store>>();
            try {
                ArrayList<UnderlyingAST.CFGMethod> methods = new ArrayList<UnderlyingAST.CFGMethod>();
                block10: for (Tree tree : ct.getMembers()) {
                    switch (tree.getKind()) {
                        case METHOD: {
                            MethodTree mt = (MethodTree)tree;
                            ModifiersTree modifiers = mt.getModifiers();
                            if (modifiers != null) {
                                Set<Modifier> flags = modifiers.getFlags();
                                if (flags.contains((Object)Modifier.ABSTRACT)) continue block10;
                                if (flags.contains((Object)Modifier.NATIVE)) break;
                            }
                            if (mt.getBody() == null) break;
                            UnderlyingAST.CFGMethod met = new UnderlyingAST.CFGMethod(mt, ct);
                            methods.add(met);
                            break;
                        }
                        case VARIABLE: {
                            VariableTree vt = (VariableTree)tree;
                            ExpressionTree initializer = vt.getInitializer();
                            if (initializer == null) continue block10;
                            boolean isStatic = vt.getModifiers().getFlags().contains((Object)Modifier.STATIC);
                            this.analyze(queue, lambdaQueue, new UnderlyingAST.CFGStatement(vt, ct), fieldValues, classTree, true, true, isStatic);
                            CFAbstractValue value = (CFAbstractValue)this.flowResult.getValue(initializer);
                            if (value == null) continue block10;
                            VariableElement element = TreeUtils.elementFromDeclaration(vt);
                            fieldValues.add(Pair.of(element, value));
                            break;
                        }
                        case CLASS: 
                        case ANNOTATION_TYPE: 
                        case INTERFACE: 
                        case ENUM: {
                            queue.add((ClassTree)tree);
                            break;
                        }
                        case BLOCK: {
                            BlockTree b = (BlockTree)tree;
                            this.analyze(queue, lambdaQueue, new UnderlyingAST.CFGStatement(b, ct), fieldValues, ct, true, true, b.isStatic());
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected member: " + (Object)((Object)tree.getKind());
                            continue block10;
                        }
                    }
                }
                for (UnderlyingAST.CFGMethod cFGMethod : methods) {
                    this.analyze(queue, lambdaQueue, cFGMethod, fieldValues, classTree, TreeUtils.isConstructor(cFGMethod.getMethod()), false, false);
                }
                while (lambdaQueue.size() > 0) {
                    Pair lambdaPair = (Pair)lambdaQueue.poll();
                    this.analyze(queue, lambdaQueue, new UnderlyingAST.CFGLambda((LambdaExpressionTree)lambdaPair.first), fieldValues, classTree, false, false, false, (CFAbstractStore)lambdaPair.second);
                }
                if (this.initializationStaticStore == null) {
                    this.regularExitStores.put(ct, this.emptyStore);
                } else {
                    this.regularExitStores.put(ct, this.initializationStaticStore);
                }
            }
            finally {
                this.visitorState.setClassType(preClassType);
                this.visitorState.setClassTree(preClassTree);
                this.visitorState.setMethodReceiver(preAMT);
                this.visitorState.setMethodTree(preMT);
            }
            this.scannedClasses.put(ct, ScanState.FINISHED);
        }
    }

    protected void analyze(Queue<ClassTree> queue, Queue<Pair<LambdaExpressionTree, Store>> lambdaQueue, UnderlyingAST ast, List<Pair<VariableElement, Value>> fieldValues, ClassTree currentClass, boolean isInitializationCode, boolean updateInitializationStore, boolean isStatic) {
        this.analyze(queue, lambdaQueue, ast, fieldValues, currentClass, isInitializationCode, updateInitializationStore, isStatic, null);
    }

    protected void analyze(Queue<ClassTree> queue, Queue<Pair<LambdaExpressionTree, Store>> lambdaQueue, UnderlyingAST ast, List<Pair<VariableElement, Value>> fieldValues, ClassTree currentClass, boolean isInitializationCode, boolean updateInitializationStore, boolean isStatic, Store lambdaStore) {
        CFAbstractStore regularExitStore;
        UnderlyingAST block;
        CFCFGBuilder builder = new CFCFGBuilder(this.checker, this);
        ControlFlowGraph cfg = ((CFGBuilder)builder).run(this.root, this.processingEnv, ast);
        FlowAnalysis newAnalysis = this.createFlowAnalysis(fieldValues);
        CFAbstractTransfer transfer = (CFAbstractTransfer)((Analysis)newAnalysis).getTransferFunction();
        if (this.emptyStore == null) {
            this.emptyStore = ((CFAbstractAnalysis)newAnalysis).createEmptyStore(transfer.usesSequentialSemantics());
        }
        this.analyses.addFirst(newAnalysis);
        if (lambdaStore != null) {
            transfer.setFixedInitialStore(lambdaStore);
        } else {
            Store initStore;
            Store Store2 = initStore = !isStatic ? this.initializationStore : this.initializationStaticStore;
            if (isInitializationCode && initStore != null) {
                transfer.setFixedInitialStore(initStore);
            }
        }
        ((CFAbstractAnalysis)this.analyses.getFirst()).performAnalysis(cfg);
        AnalysisResult result = ((CFAbstractAnalysis)this.analyses.getFirst()).getResult();
        this.flowResult.combine(result);
        if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod mast = (UnderlyingAST.CFGMethod)ast;
            MethodTree method = mast.getMethod();
            CFAbstractStore regularExitStore2 = (CFAbstractStore)((CFAbstractAnalysis)this.analyses.getFirst()).getRegularExitStore();
            if (regularExitStore2 != null) {
                this.regularExitStores.put(method, regularExitStore2);
            }
            this.returnStatementStores.put(method, ((CFAbstractAnalysis)this.analyses.getFirst()).getReturnStatementStores());
        } else if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            block = (UnderlyingAST.CFGStatement)ast;
            regularExitStore = (CFAbstractStore)((CFAbstractAnalysis)this.analyses.getFirst()).getRegularExitStore();
            if (regularExitStore != null) {
                this.regularExitStores.put(((UnderlyingAST.CFGStatement)block).getCode(), regularExitStore);
            }
        } else if (ast.getKind() == UnderlyingAST.Kind.LAMBDA) {
            block = (UnderlyingAST.CFGLambda)ast;
            regularExitStore = (CFAbstractStore)((CFAbstractAnalysis)this.analyses.getFirst()).getRegularExitStore();
            if (regularExitStore != null) {
                this.regularExitStores.put(((UnderlyingAST.CFGLambda)block).getCode(), regularExitStore);
            }
        }
        if (isInitializationCode && updateInitializationStore) {
            CFAbstractStore newInitStore = (CFAbstractStore)((CFAbstractAnalysis)this.analyses.getFirst()).getRegularExitStore();
            if (!isStatic) {
                this.initializationStore = newInitStore;
            } else {
                this.initializationStaticStore = newInitStore;
            }
        }
        if (this.checker.hasOption("flowdotdir") || this.checker.hasOption("cfgviz")) {
            this.handleCFGViz();
        }
        this.analyses.removeFirst();
        queue.addAll(builder.getDeclaredClasses());
        for (LambdaExpressionTree lambda : builder.getDeclaredLambdas()) {
            lambdaQueue.add(Pair.of(lambda, this.getStoreBefore(lambda)));
        }
    }

    protected void handleCFGViz() {
        ((CFAbstractAnalysis)this.analyses.getFirst()).visualizeCFG();
    }

    public AnnotatedTypeMirror getAnnotatedTypeLhsNoTypeVarDefault(Tree lhsTree) {
        boolean old = this.shouldDefaultTypeVarLocals;
        this.shouldDefaultTypeVarLocals = false;
        AnnotatedTypeMirror type = this.getAnnotatedTypeLhs(lhsTree);
        this.shouldDefaultTypeVarLocals = old;
        return type;
    }

    public AnnotatedTypeMirror getAnnotatedTypeLhs(Tree lhsTree) {
        AnnotatedTypeMirror res = null;
        boolean oldUseFlow = this.useFlow;
        boolean oldShouldCache = this.shouldCache;
        this.useFlow = false;
        this.shouldCache = false;
        switch (lhsTree.getKind()) {
            case VARIABLE: 
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case ARRAY_ACCESS: {
                res = this.getAnnotatedType(lhsTree);
                break;
            }
            default: {
                if (TreeUtils.isTypeTree(lhsTree)) {
                    res = this.getAnnotatedType(lhsTree);
                    break;
                }
                ErrorReporter.errorAbort("GenericAnnotatedTypeFactory: Unexpected tree passed to getAnnotatedTypeLhs. lhsTree: " + lhsTree + " Tree.Kind: " + (Object)((Object)lhsTree.getKind()));
            }
        }
        this.useFlow = oldUseFlow;
        this.shouldCache = oldShouldCache;
        return res;
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> constructorFromUse(NewClassTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.constructorFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        this.poly.annotate(tree, method);
        return mfuPair;
    }

    @Override
    protected final void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type) {
        this.addComputedTypeAnnotations(tree, type, this.useFlow);
    }

    protected void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        Value as;
        assert (this.root != null) : "GenericAnnotatedTypeFactory.addComputedTypeAnnotations:  root needs to be set when used on trees; factory: " + this.getClass();
        this.treeAnnotator.visit(tree, type);
        this.typeAnnotator.visit(type, null);
        this.defaults.annotate(tree, type);
        if (iUseFlow && (as = tree.getKind() == Tree.Kind.POSTFIX_DECREMENT || tree.getKind() == Tree.Kind.POSTFIX_INCREMENT ? this.getInferredValueFor(((UnaryTree)tree).getExpression()) : this.getInferredValueFor(tree)) != null) {
            this.applyInferredAnnotations(type, as);
        }
    }

    protected void checkAndPerformFlowAnalysis(Tree tree) {
        ClassTree classTree;
        if (tree instanceof ClassTree && !this.scannedClasses.containsKey(classTree = (ClassTree)tree)) {
            this.performFlowAnalysis(classTree);
        }
    }

    public Value getInferredValueFor(Tree tree) {
        if (tree == null) {
            ErrorReporter.errorAbort("GenericAnnotatedTypeFactory.getInferredValueFor called with null tree. Don't!");
            return null;
        }
        CFAbstractValue as = null;
        if (!this.analyses.isEmpty()) {
            as = (CFAbstractValue)((CFAbstractAnalysis)this.analyses.getFirst()).getValue(tree);
        }
        if (as == null && this.flowResult != null) {
            as = (CFAbstractValue)this.flowResult.getValue(tree);
        }
        return (Value)as;
    }

    protected void applyInferredAnnotations(AnnotatedTypeMirror type, Value as) {
        DefaultInferredTypesApplier applier = new DefaultInferredTypesApplier(this.getQualifierHierarchy(), this);
        applier.applyInferredType(type, ((CFAbstractValue)as).getAnnotations(), ((CFAbstractValue)as).getUnderlyingType());
    }

    @Override
    public void addComputedTypeAnnotations(Element elt, AnnotatedTypeMirror type) {
        this.typeAnnotator.visit(type, null);
        this.defaults.annotate(elt, type);
    }

    @Override
    public Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> methodFromUse(MethodInvocationTree tree) {
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = super.methodFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        this.poly.annotate(tree, method);
        return mfuPair;
    }

    public Store getEmptyStore() {
        return this.emptyStore;
    }

    public <T extends GenericAnnotatedTypeFactory<?, ?, ?, ?>, U extends BaseTypeChecker> T getTypeFactoryOfSubchecker(Class<U> checkerClass) {
        return this.checker.getTypeFactoryOfSubchecker(checkerClass);
    }

    public boolean getShouldDefaultTypeVarLocals() {
        return this.shouldDefaultTypeVarLocals;
    }

    protected CFGVisualizer<Value, Store, TransferFunction> createCFGVisualizer() {
        if (this.checker.hasOption("flowdotdir")) {
            String flowdotdir = this.checker.getOption("flowdotdir");
            boolean verbose = this.checker.hasOption("verbosecfg");
            HashMap<String, Object> args = new HashMap<String, Object>(2);
            args.put("outdir", flowdotdir);
            args.put("verbose", verbose);
            args.put("checkerName", this.getCheckerName());
            DOTCFGVisualizer res = new DOTCFGVisualizer();
            res.init(args);
            return res;
        }
        if (this.checker.hasOption("cfgviz")) {
            String[] opts;
            Map<String, Object> args;
            String cfgviz = this.checker.getOption("cfgviz");
            if (cfgviz == null) {
                ErrorReporter.errorAbort("-Acfgviz specified without arguments, should be -Acfgviz=VizClassName[,opts,...]");
            }
            if (!(args = this.processCFGVisualizerOption(opts = cfgviz.split(","))).containsKey("verbose")) {
                boolean verbose = this.checker.hasOption("verbosecfg");
                args.put("verbose", verbose);
            }
            args.put("checkerName", this.getCheckerName());
            CFGVisualizer res = (CFGVisualizer)BaseTypeChecker.invokeConstructorFor(opts[0], null, null);
            res.init(args);
            return res;
        }
        return null;
    }

    private String getCheckerName() {
        String checkerName = this.checker.getClass().getSimpleName();
        if (checkerName.endsWith("Checker") || checkerName.endsWith("checker")) {
            checkerName = checkerName.substring(0, checkerName.length() - "checker".length());
        }
        return checkerName;
    }

    private Map<String, Object> processCFGVisualizerOption(String[] opts) {
        HashMap<String, Object> res = new HashMap<String, Object>(opts.length - 1);
        block4: for (int i = 1; i < opts.length; ++i) {
            String opt = opts[i];
            String[] split = opt.split("=");
            switch (split.length) {
                case 1: {
                    res.put(split[0], true);
                    continue block4;
                }
                case 2: {
                    res.put(split[0], split[1]);
                    continue block4;
                }
                default: {
                    ErrorReporter.errorAbort("Too many `=` in cfgviz option: " + opt);
                }
            }
        }
        return res;
    }

    public CFGVisualizer<Value, Store, TransferFunction> getCFGVisualizer() {
        return this.cfgVisualizer;
    }

    protected static enum ScanState {
        IN_PROGRESS,
        FINISHED;

    }
}

