/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.WildcardTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.TypeFromTreeVisitor;
import org.checkerframework.framework.type.visitor.AnnotatedTypeMerger;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

class TypeFromExpressionVisitor
extends TypeFromTreeVisitor {
    TypeFromExpressionVisitor() {
    }

    @Override
    public AnnotatedTypeMirror visitAnnotatedType(AnnotatedTypeTree node, AnnotatedTypeFactory f) {
        return f.fromTypeTree(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotatedTypeMirror visitArrayAccess(ArrayAccessTree node, AnnotatedTypeFactory f) {
        Pair<Tree, AnnotatedTypeMirror> preAssCtxt = f.visitorState.getAssignmentContext();
        try {
            f.visitorState.setAssignmentContext(null);
            AnnotatedTypeMirror type = f.getAnnotatedType(node.getExpression());
            assert (type instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            AnnotatedTypeMirror annotatedTypeMirror = ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType();
            return annotatedTypeMirror;
        }
        finally {
            f.visitorState.setAssignmentContext(preAssCtxt);
        }
    }

    @Override
    public AnnotatedTypeMirror visitAssignment(AssignmentTree node, AnnotatedTypeFactory f) {
        return (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
    }

    @Override
    public AnnotatedTypeMirror visitBinary(BinaryTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror res = f.type(node);
        res.clearAnnotations();
        return res;
    }

    @Override
    public AnnotatedTypeMirror visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror res = (AnnotatedTypeMirror)this.visit(node.getVariable(), f);
        res.clearAnnotations();
        return res;
    }

    @Override
    public AnnotatedTypeMirror visitConditionalExpression(ConditionalExpressionTree node, AnnotatedTypeFactory f) {
        TypeMirror alub = InternalUtils.typeOf(node);
        AnnotatedTypeMirror trueType = f.getAnnotatedType(node.getTrueExpression());
        AnnotatedTypeMirror falseType = f.getAnnotatedType(node.getFalseExpression());
        return AnnotatedTypes.leastUpperBound(f, trueType, falseType, alub);
    }

    @Override
    public AnnotatedTypeMirror visitIdentifier(IdentifierTree node, AnnotatedTypeFactory f) {
        if (node.getName().contentEquals("this") || node.getName().contentEquals("super")) {
            AnnotatedTypeMirror.AnnotatedDeclaredType res = f.getSelfType(node);
            return res;
        }
        Element elt = TreeUtils.elementFromUse(node);
        AnnotatedTypeMirror.AnnotatedDeclaredType selfType = f.getImplicitReceiverType(node);
        if (selfType != null) {
            return AnnotatedTypes.asMemberOf(f.types, f, (AnnotatedTypeMirror)selfType, elt).asUse();
        }
        return f.getAnnotatedType(elt);
    }

    @Override
    public AnnotatedTypeMirror visitInstanceOf(InstanceOfTree node, AnnotatedTypeFactory f) {
        return f.type(node);
    }

    @Override
    public AnnotatedTypeMirror visitLiteral(LiteralTree node, AnnotatedTypeFactory f) {
        return f.type(node);
    }

    @Override
    public AnnotatedTypeMirror visitMemberSelect(MemberSelectTree node, AnnotatedTypeFactory f) {
        Element elt = TreeUtils.elementFromUse(node);
        if (TreeUtils.isClassLiteral(node)) {
            return f.getAnnotatedType(elt);
        }
        switch (elt.getKind()) {
            case METHOD: 
            case PACKAGE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return f.fromElement(elt);
            }
        }
        if (node.getIdentifier().contentEquals("this")) {
            return f.getEnclosingType((TypeElement)InternalUtils.symbol(node.getExpression()), node);
        }
        AnnotatedTypeMirror t = f.getAnnotatedType(node.getExpression());
        if (t instanceof AnnotatedTypeMirror.AnnotatedDeclaredType || t instanceof AnnotatedTypeMirror.AnnotatedArrayType || t instanceof AnnotatedTypeMirror.AnnotatedTypeVariable) {
            return AnnotatedTypes.asMemberOf(f.types, f, t, elt).asUse();
        }
        ErrorReporter.errorAbort("TypeFromExpressionVisitor.visitMemberSelect unexpected element or type: " + node.toString());
        return null;
    }

    @Override
    public AnnotatedTypeMirror visitMethodInvocation(MethodInvocationTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror.AnnotatedExecutableType ex = (AnnotatedTypeMirror.AnnotatedExecutableType)f.methodFromUse((MethodInvocationTree)node).first;
        return ex.getReturnType().asUse();
    }

    @Override
    public AnnotatedTypeMirror visitNewArray(NewArrayTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror.AnnotatedArrayType result = (AnnotatedTypeMirror.AnnotatedArrayType)f.type(node);
        if (node.getType() == null) {
            return result;
        }
        this.annotateArrayAsArray(result, node, f);
        return result;
    }

    private AnnotatedTypeMirror descendBy(AnnotatedTypeMirror type, int depth) {
        AnnotatedTypeMirror result = type;
        while (depth > 0) {
            result = ((AnnotatedTypeMirror.AnnotatedArrayType)result).getComponentType();
            --depth;
        }
        return result;
    }

    private void annotateArrayAsArray(AnnotatedTypeMirror.AnnotatedArrayType result, NewArrayTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror treeElem = f.fromTypeTree(node.getType());
        boolean hasInit = node.getInitializers() != null;
        AnnotatedTypeMirror typeElem = this.descendBy(result, hasInit ? 1 : node.getDimensions().size());
        while (true) {
            typeElem.addAnnotations(treeElem.getAnnotations());
            if (!(treeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType)) break;
            assert (typeElem instanceof AnnotatedTypeMirror.AnnotatedArrayType);
            treeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)treeElem).getComponentType();
            typeElem = ((AnnotatedTypeMirror.AnnotatedArrayType)typeElem).getComponentType();
        }
        int idx = 0;
        AnnotatedTypeMirror level = result;
        while (level.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType array = level;
            List<? extends AnnotationMirror> annos = InternalUtils.annotationsFromArrayCreation(node, idx++);
            array.addAnnotations(annos);
            level = array.getComponentType();
        }
        result.addAnnotations(InternalUtils.annotationsFromArrayCreation(node, -1));
    }

    @Override
    public AnnotatedTypeMirror visitNewClass(NewClassTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = f.fromNewClass(node);
        if (this.isNewEnum(type)) {
            return type;
        }
        AnnotatedTypeMirror.AnnotatedExecutableType ex = (AnnotatedTypeMirror.AnnotatedExecutableType)f.constructorFromUse((NewClassTree)node).first;
        AnnotatedTypes.copyOnlyExplicitConstructorAnnotations(f, type, ex);
        return type;
    }

    @Override
    public AnnotatedTypeMirror visitMemberReference(MemberReferenceTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = (AnnotatedTypeMirror.AnnotatedDeclaredType)f.toAnnotatedType(InternalUtils.typeOf(node), false);
        return type;
    }

    @Override
    public AnnotatedTypeMirror visitLambdaExpression(LambdaExpressionTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = (AnnotatedTypeMirror.AnnotatedDeclaredType)f.toAnnotatedType(InternalUtils.typeOf(node), false);
        return type;
    }

    private boolean isNewEnum(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        return type.getUnderlyingType().asElement().getKind() == ElementKind.ENUM;
    }

    @Override
    public AnnotatedTypeMirror visitParenthesized(ParenthesizedTree node, AnnotatedTypeFactory f) {
        return (AnnotatedTypeMirror)this.visit(node.getExpression(), f);
    }

    @Override
    public AnnotatedTypeMirror visitTypeCast(TypeCastTree node, AnnotatedTypeFactory f) {
        return f.fromTypeTree(node.getType());
    }

    @Override
    public AnnotatedTypeMirror visitUnary(UnaryTree node, AnnotatedTypeFactory f) {
        return f.type(node);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard(WildcardTree node, AnnotatedTypeFactory f) {
        AnnotatedTypeMirror bound = (AnnotatedTypeMirror)this.visit(node.getBound(), f);
        AnnotatedTypeMirror result = f.type(node);
        assert (result instanceof AnnotatedTypeMirror.AnnotatedWildcardType);
        if (node.getKind() == Tree.Kind.SUPER_WILDCARD) {
            AnnotatedTypeMerger.merge(bound, ((AnnotatedTypeMirror.AnnotatedWildcardType)result).getSuperBound());
        } else if (node.getKind() == Tree.Kind.EXTENDS_WILDCARD) {
            AnnotatedTypeMerger.merge(bound, ((AnnotatedTypeMirror.AnnotatedWildcardType)result).getExtendsBound());
        }
        return result;
    }

    @Override
    public AnnotatedTypeMirror visitPrimitiveType(PrimitiveTypeTree node, AnnotatedTypeFactory f) {
        return f.fromTypeTree(node);
    }

    @Override
    public AnnotatedTypeMirror visitArrayType(ArrayTypeTree node, AnnotatedTypeFactory f) {
        return f.fromTypeTree(node);
    }

    @Override
    public AnnotatedTypeMirror visitParameterizedType(ParameterizedTypeTree node, AnnotatedTypeFactory f) {
        return f.fromTypeTree(node);
    }

    @Override
    public AnnotatedTypeMirror visitIntersectionType(IntersectionTypeTree node, AnnotatedTypeFactory f) {
        return f.fromTypeTree(node);
    }
}

