/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.typeinference.constraint;

import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.DefaultTypeHierarchy;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.util.PluginUtil;
import org.checkerframework.framework.util.typeinference.constraint.AFConstraint;
import org.checkerframework.framework.util.typeinference.constraint.AFReducer;
import org.checkerframework.framework.util.typeinference.constraint.FIsA;

public class FIsAReducer
implements AFReducer {
    protected final FIsAReducingVisitor visitor;
    private final AnnotatedTypeFactory typeFactory;

    public FIsAReducer(AnnotatedTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.visitor = new FIsAReducingVisitor();
    }

    @Override
    public boolean reduce(AFConstraint constraint, Set<AFConstraint> newConstraints) {
        if (constraint instanceof FIsA) {
            FIsA fIsA = (FIsA)constraint;
            this.visitor.visit(fIsA.formalParameter, fIsA.argument, newConstraints);
            return true;
        }
        return false;
    }

    private class FIsAReducingVisitor
    extends AbstractAtmComboVisitor<Void, Set<AFConstraint>> {
        private FIsAReducingVisitor() {
        }

        @Override
        protected String defaultErrorMessage(AnnotatedTypeMirror argument, AnnotatedTypeMirror parameter, Set<AFConstraint> afConstraints) {
            return "Unexpected FIsA Combination:\nargument=" + argument + "\nparameter=" + parameter + "\nconstraints=[\n" + PluginUtil.join(", ", afConstraints) + "\n]";
        }

        @Override
        public Void visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType parameter, AnnotatedTypeMirror.AnnotatedArrayType argument, Set<AFConstraint> constraints) {
            constraints.add(new FIsA(parameter.getComponentType(), argument.getComponentType()));
            return null;
        }

        @Override
        public Void visitArray_Declared(AnnotatedTypeMirror.AnnotatedArrayType parameter, AnnotatedTypeMirror.AnnotatedDeclaredType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitArray_Null(AnnotatedTypeMirror.AnnotatedArrayType parameter, AnnotatedTypeMirror.AnnotatedNullType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitArray_Wildcard(AnnotatedTypeMirror.AnnotatedArrayType parameter, AnnotatedTypeMirror.AnnotatedWildcardType argument, Set<AFConstraint> constraints) {
            constraints.add(new FIsA(parameter, argument.getExtendsBound()));
            return null;
        }

        @Override
        public Void visitDeclared_Array(AnnotatedTypeMirror.AnnotatedDeclaredType parameter, AnnotatedTypeMirror.AnnotatedArrayType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType parameter, AnnotatedTypeMirror.AnnotatedDeclaredType argument, Set<AFConstraint> constraints) {
            if (argument.wasRaw() || parameter.wasRaw()) {
                return null;
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType argumentAsParam = DefaultTypeHierarchy.castedAsSuper(argument, parameter);
            if (argumentAsParam == null) {
                return null;
            }
            List<AnnotatedTypeMirror> argTypeArgs = argumentAsParam.getTypeArguments();
            List<AnnotatedTypeMirror> paramTypeArgs = parameter.getTypeArguments();
            for (int i = 0; i < argTypeArgs.size(); ++i) {
                AnnotatedTypeMirror argTypeArg = argTypeArgs.get(i);
                AnnotatedTypeMirror paramTypeArg = paramTypeArgs.get(i);
                if (paramTypeArg.getKind() == TypeKind.WILDCARD) {
                    AnnotatedTypeMirror.AnnotatedWildcardType paramWc = (AnnotatedTypeMirror.AnnotatedWildcardType)paramTypeArg;
                    if (argTypeArg.getKind() != TypeKind.WILDCARD) continue;
                    AnnotatedTypeMirror.AnnotatedWildcardType argWc = (AnnotatedTypeMirror.AnnotatedWildcardType)argTypeArg;
                    constraints.add(new FIsA(paramWc.getExtendsBound(), argWc.getExtendsBound()));
                    constraints.add(new FIsA(paramWc.getSuperBound(), argWc.getSuperBound()));
                    continue;
                }
                constraints.add(new FIsA(paramTypeArgs.get(i), argTypeArgs.get(i)));
            }
            return null;
        }

        @Override
        public Void visitDeclared_Null(AnnotatedTypeMirror.AnnotatedDeclaredType parameter, AnnotatedTypeMirror.AnnotatedNullType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitDeclared_Primitive(AnnotatedTypeMirror.AnnotatedDeclaredType parameter, AnnotatedTypeMirror.AnnotatedPrimitiveType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitDeclared_Union(AnnotatedTypeMirror.AnnotatedDeclaredType parameter, AnnotatedTypeMirror.AnnotatedUnionType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType parameter, AnnotatedTypeMirror.AnnotatedIntersectionType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitIntersection_Null(AnnotatedTypeMirror.AnnotatedIntersectionType parameter, AnnotatedTypeMirror.AnnotatedNullType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitNull_Null(AnnotatedTypeMirror.AnnotatedNullType parameter, AnnotatedTypeMirror.AnnotatedNullType argument, Set<AFConstraint> afConstraints) {
            return null;
        }

        @Override
        public Void visitPrimitive_Declared(AnnotatedTypeMirror.AnnotatedPrimitiveType parameter, AnnotatedTypeMirror.AnnotatedDeclaredType argument, Set<AFConstraint> constraints) {
            constraints.add(new FIsA(FIsAReducer.this.typeFactory.getBoxedType(parameter), argument));
            return null;
        }

        @Override
        public Void visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType parameter, AnnotatedTypeMirror.AnnotatedPrimitiveType argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable parameter, AnnotatedTypeMirror.AnnotatedTypeVariable argument, Set<AFConstraint> constraints) {
            return null;
        }

        @Override
        public Void visitTypevar_Null(AnnotatedTypeMirror.AnnotatedTypeVariable argument, AnnotatedTypeMirror.AnnotatedNullType parameter, Set<AFConstraint> constraints) {
            return null;
        }
    }
}

