/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.core.SVNException;

public class SVNHelpCommand
extends SVNCommand {
    private static final String GENERIC_HELP_HEADER = "usage: {0} <subcommand> [options] [args]\nSubversion command-line client, version {1}.\nType ''{0} help <subcommand>'' for help on a specific subcommand.\nType ''{0} --version'' to see the program version and RA modules\n  or ''{0} --version --quiet'' to see just the version number.\n\nMost subcommands take file and/or directory arguments, recursing\non the directories.  If no arguments are supplied to such a\ncommand, it recurses on the current directory (inclusive) by default.\n\nAvailable subcommands:";
    private static final String GENERIC_HELP_FOOTER = "SVNKit is a pure Java (TM) version of Subversion - a tool for version control.\nFor additional information, see http://svnkit.com/\n";
    private static final String VERSION_HELP_FOOTER = "\nThe following repository access (RA) modules are available:\n\n* org.tmatesoft.svn.core.internal.io.dav : Module for accessing a repository via WebDAV protocol.\n  - handles 'http' scheme\n  - handles 'https' scheme\n* org.tmatesoft.svn.core.internal.io.svn: Module for accessing a repository using the svn network protocol.\n  - handles 'svn' scheme\n* org.tmatesoft.svn.core.internal.io.fs: Module for accessing a repository on local disk.\n  - handles 'file' scheme (only FSFS repositories are supported)\n";

    public SVNHelpCommand() {
        super("help", new String[]{"?", "h"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList options = new LinkedList();
        return options;
    }

    public static void printBasicUsage(String programName) {
        System.err.println(MessageFormat.format("Type ''{0} help'' for usage.", programName));
    }

    @Override
    public void run() throws SVNException {
        if (!this.getSVNEnvironment().getArguments().isEmpty()) {
            for (String commandName : this.getSVNEnvironment().getArguments()) {
                AbstractSVNCommand command = AbstractSVNCommand.getCommand(commandName);
                if (command == null) {
                    this.getSVNEnvironment().getErr().println("\"" + commandName + "\": unknown command.\n");
                    continue;
                }
                String help = SVNCommandUtil.getCommandHelp(command, this.getEnvironment().getProgramName(), true);
                this.getSVNEnvironment().getOut().println(help);
                this.getSVNEnvironment().getOut().println();
            }
        } else if (this.getSVNEnvironment().isVersion()) {
            String version2 = SVNCommandUtil.getVersion(this.getEnvironment(), this.getSVNEnvironment().isQuiet());
            this.getEnvironment().getOut().println(version2);
            if (!this.getSVNEnvironment().isQuiet()) {
                this.getEnvironment().getOut().println(VERSION_HELP_FOOTER);
            }
        } else if (this.getSVNEnvironment().getArguments().isEmpty()) {
            String help = SVNCommandUtil.getGenericHelp(this.getEnvironment().getProgramName(), GENERIC_HELP_HEADER, GENERIC_HELP_FOOTER, null);
            this.getSVNEnvironment().getOut().print(help);
        } else {
            String message = MessageFormat.format("Type ''{0} help'' for usage.", this.getSVNEnvironment().getProgramName());
            this.getSVNEnvironment().getOut().println(message);
        }
    }
}

