/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.framework.qual.FromByteCode;
import org.checkerframework.qualframework.base.TypeMirrorConverter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class HtmlPrettyPrint {
    @FromByteCode
    private HtmlPrettyPrint() {
        throw new Error("do not instantiate");
    }

    @FromByteCode
    public static void main(@UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown String @UnknownKeyFor @NonRaw @NonNull @Initialized @UnknownInterned @LockPossiblyHeld @GuardedBy @TypeMirrorConverter.Key(index=3, desc="RegexTop") @TypeMirrorConverter.Key(index=3, desc="RegexTop") @UnknownFormat @SignatureUnknown [] args) {
        for (String arg : args) {
            File f = new File(arg);
            String url = "file://" + f.getAbsolutePath();
            try {
                XMLReader tagsoup = XMLReaderFactory.createXMLReader("org.ccil.cowan.tagsoup.Parser");
                Builder parser = new Builder(tagsoup);
                Document document = parser.build(url);
                Serializer serializer = new Serializer(System.out);
                serializer.setIndent(2);
                serializer.setMaxLength(80);
                try {
                    serializer.write(document);
                }
                catch (IOException ex) {
                    System.err.println(ex);
                }
            }
            catch (ParsingException ex) {
                System.out.println(url + " is not well-formed.");
                throw new Error(ex);
            }
            catch (SAXException ex) {
                System.out.println("Could not load Xerces.");
                System.out.println(ex.getMessage());
            }
            catch (IOException ex) {
                System.out.println("IOException:  parser could not read " + url);
            }
        }
    }
}

