/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import org.apache.commons.bcel6.generic.ClassGenException;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.ConstantPushInstruction;
import org.apache.commons.bcel6.generic.Instruction;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.generic.Visitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class FCONST
extends Instruction
implements ConstantPushInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float value;

    FCONST() {
    }

    public FCONST(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float f) {
        super((short)11, (short)1);
        if ((double)f == 0.0) {
            super.setOpcode((short)11);
        } else if ((double)f == 1.0) {
            super.setOpcode((short)12);
        } else if ((double)f == 2.0) {
            super.setOpcode((short)13);
        } else {
            throw new ClassGenException("FCONST can be used only for 0.0, 1.0 and 2.0: " + f);
        }
        this.value = f;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Number getValue() {
        return new Float(this.value);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        return Type.FLOAT;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitFCONST(this);
    }
}

