/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.bcel6.classfile.ClassParser;
import org.apache.commons.bcel6.classfile.JavaClass;
import org.apache.commons.bcel6.util.ClassPath;
import org.apache.commons.bcel6.util.Repository;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureBottom;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class SyntheticRepository
implements Repository {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SyntheticRepository> _instances = new HashMap<ClassPath, SyntheticRepository>();
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath _path = null;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SoftReference<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass>> _loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    private SyntheticRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath path) {
        this._path = path;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SyntheticRepository getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath classPath) {
        SyntheticRepository rep = _instances.get(classPath);
        if (rep == null) {
            rep = new SyntheticRepository(classPath);
            _instances.put(classPath, rep);
        }
        return rep;
    }

    @Override
    public void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) {
        SoftReference<JavaClass> ref = this._loadedClasses.get(className);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SignatureUnknown @SignatureBottom ?> clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        InputStream clsStream = null;
        try {
            String className = clazz.getName();
            JavaClass repositoryClass = this.findClass(className);
            if (repositoryClass != null) {
                JavaClass javaClass = repositoryClass;
                return javaClass;
            }
            String name = className;
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(i + 1);
            }
            clsStream = clazz.getResourceAsStream(name + ".class");
            JavaClass javaClass = this.loadClass(clsStream, className);
            return javaClass;
        }
        finally {
            try {
                if (clsStream != null) {
                    clsStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InputStream is, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassNotFoundException {
        try {
            if (is != null) {
                ClassParser parser = new ClassParser(is, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                JavaClass javaClass = clazz;
                return javaClass;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath getClassPath() {
        return this._path;
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

