/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.lock;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.lock.LockAnnotatedTypeFactory;
import org.checkerframework.checker.lock.qual.EnsuresLockHeld;
import org.checkerframework.checker.lock.qual.EnsuresLockHeldIf;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.Holding;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.ImplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.ContractsUtils;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class LockVisitor
extends BaseTypeVisitor<LockAnnotatedTypeFactory> {
    private final Class<? extends Annotation> checkerGuardedByClass = GuardedBy.class;
    private final Class<? extends Annotation> checkerGuardSatisfiedClass = GuardSatisfied.class;
    private static final Pattern selfReceiverPattern = Pattern.compile("^<self>(\\.(.*))?$");

    public LockVisitor(BaseTypeChecker checker) {
        super(checker);
        this.checkForAnnotatedJdk();
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        AnnotatedTypeMirror atm;
        TypeMirror tm = InternalUtils.typeOf(node);
        if ((TypesUtils.isBoxedPrimitive(tm) || TypesUtils.isPrimitive(tm) || TypesUtils.isString(tm)) && ((atm = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node)).hasExplicitAnnotationRelaxed(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDSATISFIED) || atm.hasExplicitAnnotationRelaxed(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY) || atm.hasExplicitAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN) || atm.hasExplicitAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYBOTTOM))) {
            this.checker.report(Result.failure("immutable.type.guardedby", new Object[0]), node);
        }
        this.issueErrorIfMoreThanOneGuardedByAnnotationPresent(node);
        return super.visitVariable(node, p);
    }

    private void issueErrorIfMoreThanOneGuardedByAnnotationPresent(VariableTree variableTree) {
        int guardedByAnnotationCount = 0;
        List<AnnotationMirror> annos = InternalUtils.annotationsFromTypeAnnotationTrees(variableTree.getModifiers().getAnnotations());
        for (AnnotationMirror anno : annos) {
            if (!AnnotationUtils.areSameByClass(anno, GuardedBy.class) && !AnnotationUtils.areSameByClass(anno, net.jcip.annotations.GuardedBy.class) && !AnnotationUtils.areSameByClass(anno, javax.annotation.concurrent.GuardedBy.class) || ++guardedByAnnotationCount <= 1) continue;
            this.checker.report(Result.failure("multiple.guardedby.annotations", new Object[0]), variableTree);
            return;
        }
    }

    @Override
    public LockAnnotatedTypeFactory createTypeFactory() {
        return new LockAnnotatedTypeFactory(this.checker);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        int returnGuardSatisfiedIndex;
        AnnotatedTypeMirror returnTypeATM;
        ExecutableElement methodElement = TreeUtils.elementFromDeclaration(node);
        this.issueErrorIfMoreThanOneLockPreconditionMethodAnnotationPresent(methodElement, node);
        LockAnnotatedTypeFactory.SideEffectAnnotation sea = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(methodElement, true);
        if (sea == LockAnnotatedTypeFactory.SideEffectAnnotation.MAYRELEASELOCKS) {
            boolean issueGSwithMRLWarning = false;
            VariableTree receiver = node.getReceiverParameter();
            if (receiver != null && ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(receiver).hasAnnotation(this.checkerGuardSatisfiedClass)) {
                issueGSwithMRLWarning = true;
            }
            if (!issueGSwithMRLWarning) {
                for (VariableTree variableTree : node.getParameters()) {
                    if (!((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(variableTree).hasAnnotation(this.checkerGuardSatisfiedClass)) continue;
                    issueGSwithMRLWarning = true;
                    break;
                }
            }
            if (issueGSwithMRLWarning) {
                this.checker.report(Result.failure("guardsatisfied.with.mayreleaselocks", new Object[0]), node);
            }
        }
        if (methodElement != null && methodElement.getKind() != ElementKind.CONSTRUCTOR && (returnTypeATM = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(node).getReturnType()) != null && returnTypeATM.hasAnnotation(GuardSatisfied.class) && (returnGuardSatisfiedIndex = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(returnTypeATM)) == -1) {
            this.checker.report(Result.failure("guardsatisfied.return.must.have.index", new Object[0]), node);
        }
        if (!sea.isWeakerThan(LockAnnotatedTypeFactory.SideEffectAnnotation.LOCKINGFREE) && methodElement.getModifiers().contains((Object)Modifier.SYNCHRONIZED)) {
            this.checker.report(Result.failure("lockingfree.synchronized.method", new Object[]{sea}), node);
        }
        return super.visitMethod(node, p);
    }

    private void issueErrorIfMoreThanOneLockPreconditionMethodAnnotationPresent(ExecutableElement methodElement, MethodTree treeForErrorReporting) {
        int lockPreconditionAnnotationCount = 0;
        if (((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, Holding.class) != null) {
            ++lockPreconditionAnnotationCount;
        }
        if (((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, net.jcip.annotations.GuardedBy.class) != null) {
            ++lockPreconditionAnnotationCount;
        }
        if (lockPreconditionAnnotationCount < 2 && ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, javax.annotation.concurrent.GuardedBy.class) != null) {
            ++lockPreconditionAnnotationCount;
        }
        if (lockPreconditionAnnotationCount > 1) {
            this.checker.report(Result.failure("multiple.lock.precondition.annotations", new Object[0]), treeForErrorReporting);
        }
    }

    @Override
    protected boolean skipReceiverSubtypeCheck(MethodInvocationTree node, AnnotatedTypeMirror methodDefinitionReceiver, AnnotatedTypeMirror methodCallReceiver) {
        AnnotationMirror primaryGbOnMethodDefinition;
        AnnotationMirror primaryGb = methodCallReceiver.getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
        AnnotationMirror effectiveGb = methodCallReceiver.getEffectiveAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
        if (primaryGb != null && AnnotationUtils.areSameByClass(primaryGb, this.checkerGuardSatisfiedClass) && (primaryGbOnMethodDefinition = methodDefinitionReceiver.getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN)) != null && AnnotationUtils.areSameByClass(primaryGbOnMethodDefinition, this.checkerGuardSatisfiedClass)) {
            return true;
        }
        if (AnnotationUtils.areSameByClass(effectiveGb, this.checkerGuardedByClass)) {
            Set<AnnotationMirror> annos = methodDefinitionReceiver.getAnnotations();
            for (AnnotationMirror anno : annos) {
                if (!AnnotationUtils.areSameByClass(anno, this.checkerGuardSatisfiedClass)) continue;
                MethodInvocationNode methodInvocationNode = (MethodInvocationNode)((LockAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(node);
                Node receiverNode = methodInvocationNode.getTarget().getReceiver();
                this.checkPreconditions(node, receiverNode, this.generatePreconditionsBasedOnGuards(methodCallReceiver));
                return true;
            }
        }
        return false;
    }

    @Override
    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        Set<? extends AnnotationMirror> tops = ((LockAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().getTopAnnotations();
        Set<AnnotationMirror> annotationSet = AnnotationUtils.createAnnotationSet();
        for (AnnotationMirror annotationMirror : tops) {
            if (AnnotationUtils.areSame(annotationMirror, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN)) {
                annotationSet.add(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
                continue;
            }
            annotationSet.add(annotationMirror);
        }
        return annotationSet;
    }

    private Set<ContractsUtils.Precondition> generatePreconditionsBasedOnGuards(AnnotatedTypeMirror atm) {
        Set<AnnotationMirror> amList = atm.getAnnotations();
        LinkedHashSet<ContractsUtils.Precondition> preconditions = new LinkedHashSet<ContractsUtils.Precondition>();
        if (amList != null) {
            for (AnnotationMirror annotationMirror : amList) {
                if (!AnnotationUtils.areSameByClass(annotationMirror, this.checkerGuardedByClass) || !AnnotationUtils.hasElementValue(annotationMirror, "value")) continue;
                List<String> guardedByValue = AnnotationUtils.getElementValueArray(annotationMirror, "value", String.class, false);
                for (String lockExpression : guardedByValue) {
                    preconditions.add(new ContractsUtils.Precondition(lockExpression, ((LockAnnotatedTypeFactory)this.atypeFactory).LOCKHELD));
                }
            }
        }
        return preconditions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        Tree.Kind valueTreeKind = valueTree.getKind();
        switch (valueTreeKind) {
            case NEW_CLASS: 
            case NEW_ARRAY: {
                if (varType.hasAnnotation(GuardedByBottom.class)) break;
                return;
            }
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case FLOAT_LITERAL: 
            case DOUBLE_LITERAL: 
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: {
                if (varType.hasAnnotation(GuardedByBottom.class)) break;
                return;
            }
        }
        if (varType.hasAnnotation(GuardSatisfied.class)) {
            if (valueType.hasAnnotation(GuardedBy.class)) {
                this.checkPreconditions((ExpressionTree)valueTree, this.generatePreconditionsBasedOnGuards(valueType));
                return;
            }
            if (valueType.hasAnnotation(GuardSatisfied.class)) {
                if (errorKey.equals("argument.type.incompatible")) return;
                int varTypeGuardSatisfiedIndex = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(varType);
                int valueTypeGuardSatisfiedIndex = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(valueType);
                if (varTypeGuardSatisfiedIndex == -1 && valueTypeGuardSatisfiedIndex == -1) {
                    this.checker.report(Result.failure("guardsatisfied.assignment.disallowed", varType, valueType), valueTree);
                }
            } else if (!((LockAnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(valueType, varType)) {
                AnnotatedTypeMirror varType2 = varType.deepCopy();
                varType2.replaceAnnotation(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY);
                if (((LockAnnotatedTypeFactory)this.atypeFactory).getTypeHierarchy().isSubtype(valueType, varType2)) {
                    return;
                }
            }
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree tree, Void p) {
        if (((LockAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(tree) instanceof FieldAccessNode) {
            ExpressionTree treeOfExpression = tree.getExpression();
            Node nodeOfExpression = ((LockAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(treeOfExpression);
            this.checkFieldOrArrayAccess(tree, treeOfExpression, nodeOfExpression);
        }
        return (Void)super.visitMemberSelect(tree, p);
    }

    private void reportFailure(@CompilerMessageKey String messageKey, MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, List<String> overriderLocks, List<String> overriddenLocks) {
        AnnotatedTypeMirror.AnnotatedExecutableType overrider = ((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(overriderTree);
        if (overrider.getTypeVariables().isEmpty() && !overridden.getTypeVariables().isEmpty()) {
            overridden = overridden.getErased();
        }
        String overriderMeth = overrider.toString();
        String overriderTyp = enclosingType.getUnderlyingType().asElement().toString();
        String overriddenMeth = overridden.toString();
        String overriddenTyp = overriddenType.getUnderlyingType().asElement().toString();
        if (overriderLocks == null || overriddenLocks == null) {
            this.checker.report(Result.failure(messageKey, overriderMeth, overriderTyp, overriddenMeth, overriddenTyp), overriderTree);
        } else {
            this.checker.report(Result.failure(messageKey, overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, overriderLocks, overriddenLocks), overriderTree);
        }
    }

    @Override
    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, Void p) {
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfOverridenMethod;
        boolean isValid = true;
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfOverriderMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(TreeUtils.elementFromDeclaration(overriderTree), false);
        if (seaOfOverriderMethod.isWeakerThan(seaOfOverridenMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(overridden.getElement(), false))) {
            isValid = false;
            this.reportFailure("override.sideeffect.invalid", overriderTree, enclosingType, overridden, overriddenType, null, null);
        }
        return super.checkOverride(overriderTree, enclosingType, overridden, overriddenType, p) && isValid;
    }

    private void checkFieldOrArrayAccess(ExpressionTree accessTree, Tree treeToReportErrorAt, Node expressionNode) {
        AnnotatedTypeMirror atmOfReceiver = ((LockAnnotatedTypeFactory)this.atypeFactory).getReceiverType(accessTree);
        if (treeToReportErrorAt != null && atmOfReceiver != null) {
            AnnotationMirror gb = atmOfReceiver.getEffectiveAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN);
            if (gb == null) {
                ErrorReporter.errorAbort("LockVisitor.checkFieldOrArrayAccess: gb cannot be null");
            }
            if (AnnotationUtils.areSameByClass(gb, this.checkerGuardedByClass)) {
                Set<ContractsUtils.Precondition> preconditions = this.generatePreconditionsBasedOnGuards(atmOfReceiver);
                this.checkPreconditions(treeToReportErrorAt, expressionNode, preconditions);
            } else if (!AnnotationUtils.areSameByClass(gb, this.checkerGuardSatisfiedClass)) {
                this.checker.report(Result.failure("cannot.dereference", accessTree.toString(), AnnotationUtils.annotationSimpleName(gb)), accessTree);
            }
        }
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Void p) {
        ExpressionTree treeOfExpression = tree.getExpression();
        Node nodeOfExpression = ((LockAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(treeOfExpression);
        this.checkFieldOrArrayAccess(tree, treeOfExpression, nodeOfExpression);
        return super.visitArrayAccess(tree, p);
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfContainingMethod;
        ExecutableElement methodElement = TreeUtils.elementFromUse(node);
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfInvokedMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(methodElement, false);
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(((LockAnnotatedTypeFactory)this.atypeFactory).getPath(node));
        ExecutableElement enclosingMethodElement = null;
        if (enclosingMethod != null) {
            enclosingMethodElement = TreeUtils.elementFromDeclaration(enclosingMethod);
        }
        if (enclosingMethodElement != null && seaOfInvokedMethod.isWeakerThan(seaOfContainingMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(enclosingMethodElement, false))) {
            this.checker.report(Result.failure("method.guarantee.violated", seaOfContainingMethod.getNameOfSideEffectAnnotation(), enclosingMethodElement.toString(), methodElement.toString(), seaOfInvokedMethod.getNameOfSideEffectAnnotation()), node);
        }
        if (methodElement != null) {
            AnnotationMirror ensuresLockHeldIfAnno;
            ExpressionTree recvTree = TreeUtils.getReceiverTree(node);
            this.ensureReceiverOfExplicitUnlockCallIsEffectivelyFinal(node, methodElement, recvTree);
            AnnotationMirror ensuresLockHeldAnno = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, EnsuresLockHeld.class);
            ArrayList<String> expressions = new ArrayList<String>();
            if (ensuresLockHeldAnno != null) {
                expressions.addAll(AnnotationUtils.getElementValueArray(ensuresLockHeldAnno, "value", String.class, false));
            }
            if ((ensuresLockHeldIfAnno = ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElement, EnsuresLockHeldIf.class)) != null) {
                expressions.addAll(AnnotationUtils.getElementValueArray(ensuresLockHeldIfAnno, "expression", String.class, false));
            }
            for (String expr : expressions) {
                ExpressionTree firstParameter;
                if (expr.equals("this")) {
                    if (recvTree == null) continue;
                    this.ensureExpressionIsEffectivelyFinal(recvTree);
                    continue;
                }
                if (!expr.equals("#1") || (firstParameter = node.getArguments().get(0)) == null) continue;
                this.ensureExpressionIsEffectivelyFinal(firstParameter);
            }
        }
        Pair<AnnotatedTypeMirror.AnnotatedExecutableType, List<AnnotatedTypeMirror>> mfuPair = ((LockAnnotatedTypeFactory)this.atypeFactory).methodFromUse(node);
        AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = (AnnotatedTypeMirror.AnnotatedExecutableType)mfuPair.first;
        List<AnnotatedTypeMirror> requiredArgs = AnnotatedTypes.expandVarArgs(this.atypeFactory, invokedMethod, node.getArguments());
        int[] guardSatisfiedIndex = new int[requiredArgs.size() + 1];
        guardSatisfiedIndex[0] = -1;
        AnnotatedTypeMirror.AnnotatedDeclaredType methodDefinitionReceiver = null;
        AnnotatedTypeMirror methodCallReceiver = null;
        ExecutableElement invokedMethodElement = invokedMethod.getElement();
        if (!ElementUtils.isStatic(invokedMethodElement) && invokedMethod.getElement().getKind() != ElementKind.CONSTRUCTOR && (methodDefinitionReceiver = invokedMethod.getReceiverType()) != null && methodDefinitionReceiver.hasAnnotation(this.checkerGuardSatisfiedClass)) {
            guardSatisfiedIndex[0] = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(methodDefinitionReceiver);
            methodCallReceiver = ((LockAnnotatedTypeFactory)this.atypeFactory).getReceiverType(node);
        }
        for (int i = 0; i < requiredArgs.size(); ++i) {
            guardSatisfiedIndex[i + 1] = -1;
            AnnotatedTypeMirror arg = requiredArgs.get(i);
            if (!arg.hasAnnotation(this.checkerGuardSatisfiedClass)) continue;
            guardSatisfiedIndex[i + 1] = ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(arg);
        }
        ArrayList<AnnotationMirror> passedArgAnnotations = new ArrayList<AnnotationMirror>(guardSatisfiedIndex.length);
        passedArgAnnotations.add(methodCallReceiver == null ? null : methodCallReceiver.getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN));
        for (ExpressionTree expressionTree : node.getArguments()) {
            passedArgAnnotations.add(((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expressionTree).getAnnotationInHierarchy(((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN));
        }
        for (int i = 0; i < guardSatisfiedIndex.length; ++i) {
            void var16_20;
            if (guardSatisfiedIndex[i] == -1) continue;
            int n = i + 1;
            while (var16_20 < guardSatisfiedIndex.length) {
                if (guardSatisfiedIndex[i] == guardSatisfiedIndex[var16_20]) {
                    AnnotationMirror arg1Anno = (AnnotationMirror)passedArgAnnotations.get(i);
                    AnnotationMirror arg2Anno = (AnnotationMirror)passedArgAnnotations.get((int)var16_20);
                    if (arg1Anno != null && arg2Anno != null) {
                        boolean bothAreGSwithNoIndex = false;
                        if (AnnotationUtils.areSameByClass(arg1Anno, this.checkerGuardSatisfiedClass) && AnnotationUtils.areSameByClass(arg2Anno, this.checkerGuardSatisfiedClass) && ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(arg1Anno) == -1 && ((LockAnnotatedTypeFactory)this.atypeFactory).getGuardSatisfiedIndex(arg2Anno) == -1) {
                            bothAreGSwithNoIndex = true;
                        }
                        if (bothAreGSwithNoIndex || !((LockAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(arg1Anno, arg2Anno) && !((LockAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(arg2Anno, arg1Anno)) {
                            String formalParam1 = null;
                            formalParam1 = i == 0 ? "The receiver type" : "Parameter #" + i;
                            String formalParam2 = "parameter #" + (int)var16_20;
                            this.checker.report(Result.failure("guardsatisfied.parameters.must.match", formalParam1, formalParam2, invokedMethod.toString(), guardSatisfiedIndex[i], arg1Anno, arg2Anno), node);
                        }
                    }
                }
                ++var16_20;
            }
        }
        return super.visitMethodInvocation(node, p);
    }

    private void ensureReceiverOfExplicitUnlockCallIsEffectivelyFinal(MethodInvocationTree node, ExecutableElement methodElement, ExpressionTree lockExpression) {
        if (lockExpression == null) {
            return;
        }
        if (!methodElement.getSimpleName().contentEquals("unlock")) {
            return;
        }
        TypeMirror lockExpressionType = InternalUtils.typeOf(lockExpression);
        ProcessingEnvironment processingEnvironment = this.checker.getProcessingEnvironment();
        Types types = processingEnvironment.getTypeUtils();
        TypeMirror lockInterfaceTypeMirror = TypesUtils.typeFromClass(types, processingEnvironment.getElementUtils(), Lock.class);
        if (types.isSubtype(types.erasure(lockExpressionType), lockInterfaceTypeMirror)) {
            this.ensureExpressionIsEffectivelyFinal(lockExpression);
        }
    }

    @Override
    public Void visitSynchronized(SynchronizedTree node, Void p) {
        LockAnnotatedTypeFactory.SideEffectAnnotation seaOfContainingMethod;
        ProcessingEnvironment processingEnvironment = this.checker.getProcessingEnvironment();
        Types types = processingEnvironment.getTypeUtils();
        TypeMirror lockInterfaceTypeMirror = TypesUtils.typeFromClass(types, processingEnvironment.getElementUtils(), Lock.class);
        ExpressionTree synchronizedExpression = node.getExpression();
        this.ensureExpressionIsEffectivelyFinal(synchronizedExpression);
        TypeMirror expressionType = types.erasure(((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(synchronizedExpression).getUnderlyingType());
        if (types.isSubtype(expressionType, lockInterfaceTypeMirror)) {
            this.checker.report(Result.failure("explicit.lock.synchronized", new Object[0]), node);
        }
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(((LockAnnotatedTypeFactory)this.atypeFactory).getPath(node));
        ExecutableElement methodElement = null;
        if (enclosingMethod != null && !(seaOfContainingMethod = ((LockAnnotatedTypeFactory)this.atypeFactory).methodSideEffectAnnotation(methodElement = TreeUtils.elementFromDeclaration(enclosingMethod), false)).isWeakerThan(LockAnnotatedTypeFactory.SideEffectAnnotation.LOCKINGFREE)) {
            this.checker.report(Result.failure("synchronized.block.in.lockingfree.method", new Object[]{seaOfContainingMethod}), node);
        }
        return (Void)super.visitSynchronized(node, p);
    }

    private void ensureExpressionIsEffectivelyFinal(ExpressionTree lockExpressionTree) {
        ExpressionTree tree = lockExpressionTree;
        block5: while (true) {
            tree = TreeUtils.skipParens(tree);
            switch (tree.getKind()) {
                case MEMBER_SELECT: {
                    if (!this.isTreeSymbolEffectivelyFinalOrUnmodifiable(tree)) {
                        this.checker.report(Result.failure("lock.expression.not.final", lockExpressionTree), tree);
                        return;
                    }
                    tree = ((MemberSelectTree)tree).getExpression();
                    continue block5;
                }
                case IDENTIFIER: {
                    if (!this.isTreeSymbolEffectivelyFinalOrUnmodifiable(tree)) {
                        this.checker.report(Result.failure("lock.expression.not.final", lockExpressionTree), tree);
                    }
                    return;
                }
                case METHOD_INVOCATION: {
                    Element elem = TreeUtils.elementFromUse(tree);
                    if (((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotationNoAliases(elem, Deterministic.class) == null && ((LockAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotationNoAliases(elem, Pure.class) == null) {
                        this.checker.report(Result.failure("lock.expression.not.final", lockExpressionTree), tree);
                        return;
                    }
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                    for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
                        this.ensureExpressionIsEffectivelyFinal(expressionTree);
                    }
                    tree = methodInvocationTree.getMethodSelect();
                    continue block5;
                }
            }
            break;
        }
        this.checker.report(Result.failure("lock.expression.possibly.not.final", lockExpressionTree), tree);
    }

    private void ensureExpressionIsEffectivelyFinal(FlowExpressions.Receiver lockExpr, String expressionForErrorReporting, Tree treeForErrorReporting) {
        FlowExpressions.Receiver expr = lockExpr;
        while (true) {
            if (expr instanceof FlowExpressions.FieldAccess) {
                FlowExpressions.FieldAccess fieldAccess = (FlowExpressions.FieldAccess)expr;
                FlowExpressions.Receiver recv = fieldAccess.getReceiver();
                if (!(fieldAccess.isUnmodifiableByOtherCode() || fieldAccess.isFinal() && recv instanceof FlowExpressions.MethodCall)) {
                    this.checker.report(Result.failure("lock.expression.not.final", expressionForErrorReporting), treeForErrorReporting);
                    return;
                }
                expr = recv;
                continue;
            }
            if (expr instanceof FlowExpressions.LocalVariable) {
                if (!ElementUtils.isEffectivelyFinal(((FlowExpressions.LocalVariable)expr).getElement())) {
                    this.checker.report(Result.failure("lock.expression.not.final", expressionForErrorReporting), treeForErrorReporting);
                }
                return;
            }
            if (!(expr instanceof FlowExpressions.MethodCall)) break;
            FlowExpressions.MethodCall methodCall = (FlowExpressions.MethodCall)expr;
            for (FlowExpressions.Receiver param : methodCall.getParameters()) {
                this.ensureExpressionIsEffectivelyFinal(param, expressionForErrorReporting, treeForErrorReporting);
            }
            if (!PurityUtils.isDeterministic((AnnotationProvider)this.atypeFactory, methodCall.getElement())) {
                this.checker.report(Result.failure("lock.expression.not.final", expressionForErrorReporting), treeForErrorReporting);
                return;
            }
            expr = methodCall.getReceiver();
        }
        if (expr instanceof FlowExpressions.ThisReference || expr instanceof FlowExpressions.ClassName) {
            return;
        }
        this.checker.report(Result.failure("lock.expression.possibly.not.final", expressionForErrorReporting), treeForErrorReporting);
    }

    @Override
    public Void visitAnnotation(AnnotationTree tree, Void p) {
        ArrayList<AnnotationTree> annotationTreeList = new ArrayList<AnnotationTree>(1);
        annotationTreeList.add(tree);
        List<AnnotationMirror> amList = InternalUtils.annotationsFromTypeAnnotationTrees(annotationTreeList);
        if (amList != null) {
            for (AnnotationMirror annotationMirror : amList) {
                if (AnnotationUtils.areSameByClass(annotationMirror, this.checkerGuardedByClass)) {
                    this.checkLockExpressionInGuardedByAnnotation(tree, annotationMirror);
                    continue;
                }
                if (!AnnotationUtils.areSameByClass(annotationMirror, this.checkerGuardSatisfiedClass)) continue;
                this.issueErrorIfGuardSatisfiedAnnotationInUnsupportedLocation(tree);
            }
        }
        return super.visitAnnotation(tree, p);
    }

    private void checkLockExpressionInGuardedByAnnotation(AnnotationTree tree, AnnotationMirror guardedByAnnotation) {
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext;
        List<String> guardedByValue = AnnotationUtils.getElementValueArray(guardedByAnnotation, "value", String.class, true);
        if (guardedByValue.isEmpty()) {
            return;
        }
        TreePath path = this.getCurrentPath();
        MethodTree enclMethod = TreeUtils.enclosingMethod(path);
        if (enclMethod != null) {
            flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration(enclMethod, path, (BaseContext)this.checker.getContext());
        } else {
            ClassTree enclosingClass = TreeUtils.enclosingClass(path);
            flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForClassDeclaration(enclosingClass, this.checker.getContext());
        }
        if (flowExprContext == null) {
            this.checker.report(Result.failure("lock.expression.possibly.not.final", guardedByValue), tree);
            return;
        }
        TreePath pathForLocalVariableRetrieval = this.getPathForLocalVariableRetrieval(path);
        if (pathForLocalVariableRetrieval == null) {
            this.checker.report(Result.failure("lock.expression.possibly.not.final", guardedByValue), tree);
            return;
        }
        for (String lockExpression : guardedByValue) {
            try {
                this.parseExpressionString(lockExpression, flowExprContext, pathForLocalVariableRetrieval, null, tree, true);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.checker.report(e.getResult(), tree);
            }
        }
    }

    private void issueErrorIfGuardSatisfiedAnnotationInUnsupportedLocation(AnnotationTree annotationTree) {
        TreePath currentPath = this.getCurrentPath();
        TreePath path = this.getPathForLocalVariableRetrieval(currentPath);
        if (path != null) {
            AnnotatedTypeTree annotatedTypeTree;
            Tree.Kind varTypeTreeKind;
            TreePath parentPath;
            VariableTree varTree;
            Tree varTypeTree;
            Tree tree = path.getLeaf();
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.METHOD) {
                return;
            }
            if (kind == Tree.Kind.VARIABLE && (varTypeTree = (varTree = (VariableTree)tree).getType()) != null && (parentPath = path.getParentPath()) != null && parentPath.getLeaf().getKind() == Tree.Kind.METHOD && ((varTypeTreeKind = varTypeTree.getKind()) == Tree.Kind.ANNOTATED_TYPE ? (annotatedTypeTree = (AnnotatedTypeTree)varTypeTree).getUnderlyingType().getKind() != Tree.Kind.ARRAY_TYPE || annotatedTypeTree.getAnnotations().contains(annotationTree) : varTypeTreeKind != Tree.Kind.ARRAY_TYPE)) {
                return;
            }
        }
        this.checker.report(Result.failure("guardsatisfied.location.disallowed", new Object[0]), annotationTree);
    }

    private TreePath getPathForLocalVariableRetrieval(TreePath path) {
        assert (path.getLeaf() instanceof AnnotationTree);
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        if ((path = path.getParentPath()) == null) {
            return null;
        }
        Tree tree = path.getLeaf();
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case NEW_ARRAY: 
            case ARRAY_TYPE: 
            case VARIABLE: 
            case TYPE_CAST: 
            case INSTANCE_OF: 
            case METHOD: 
            case TYPE_PARAMETER: {
                return path;
            }
        }
        return null;
    }

    private boolean isTreeSymbolEffectivelyFinalOrUnmodifiable(Tree tree) {
        Element elem = InternalUtils.symbol(tree);
        ElementKind ek = elem.getKind();
        return ek == ElementKind.PACKAGE || ek == ElementKind.CLASS || ek == ElementKind.METHOD || ElementUtils.isEffectivelyFinal(elem);
    }

    @Override
    public Void visitIdentifier(IdentifierTree tree, Void p) {
        Node receiverNode;
        Node node = ((LockAnnotatedTypeFactory)this.atypeFactory).getNodeForTree(tree);
        if (node instanceof FieldAccessNode && (receiverNode = ((FieldAccessNode)node).getReceiver()) instanceof ImplicitThisLiteralNode) {
            this.checkFieldOrArrayAccess(tree, tree, receiverNode);
        }
        return super.visitIdentifier(tree, p);
    }

    @Override
    protected FlowExpressions.Receiver parseExpressionString(String expression, FlowExpressionParseUtil.FlowExpressionContext flowExprContext, TreePath path, Node node, Tree treeForErrorReporting, boolean use) throws FlowExpressionParseUtil.FlowExpressionParseException {
        FlowExpressions.Receiver expr = null;
        Matcher selfReceiverMatcher = selfReceiverPattern.matcher(expression = expression.trim());
        if (selfReceiverMatcher.matches()) {
            if (node == null) {
                return null;
            }
            String remainingExpression = selfReceiverMatcher.group(2);
            expr = remainingExpression == null || remainingExpression.isEmpty() ? FlowExpressions.internalReprOf(this.atypeFactory, node) : FlowExpressionParseUtil.parse(node.toString() + "." + remainingExpression, flowExprContext, path, true);
        } else {
            expr = super.parseExpressionString(expression, flowExprContext, path, node, treeForErrorReporting, true);
        }
        this.ensureExpressionIsEffectivelyFinal(expr, expression, treeForErrorReporting);
        return expr;
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        List<AnnotationMirror> annos = InternalUtils.annotationsFromTypeAnnotationTrees(node.getModifiers().getAnnotations());
        for (AnnotationMirror anno : annos) {
            if (AnnotationUtils.areSame(anno, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY) || !AnnotationUtils.areSameIgnoringValues(anno, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYUNKNOWN) && !AnnotationUtils.areSameIgnoringValues(anno, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBY) && !AnnotationUtils.areSameIgnoringValues(anno, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDSATISFIED) && !AnnotationUtils.areSameIgnoringValues(anno, ((LockAnnotatedTypeFactory)this.atypeFactory).GUARDEDBYBOTTOM)) continue;
            this.checker.report(Result.failure("class.declaration.guardedby.annotation.invalid", new Object[0]), node);
        }
        return super.visitClass(node, p);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (node.getKind() == Tree.Kind.PLUS) {
            ExpressionTree leftTree = node.getLeftOperand();
            ExpressionTree rightTree = node.getRightOperand();
            boolean lhsIsString = TypesUtils.isString(InternalUtils.typeOf(leftTree));
            boolean rhsIsString = TypesUtils.isString(InternalUtils.typeOf(rightTree));
            if (!lhsIsString && rhsIsString) {
                this.checkPreconditionsForImplicitToStringCall(leftTree);
            } else if (lhsIsString && !rhsIsString) {
                this.checkPreconditionsForImplicitToStringCall(rightTree);
            }
        }
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        if (node.getKind() == Tree.Kind.PLUS_ASSIGNMENT) {
            ExpressionTree rightTree = node.getExpression();
            if (TypesUtils.isString(InternalUtils.typeOf(node.getVariable())) && !TypesUtils.isString(InternalUtils.typeOf(rightTree))) {
                this.checkPreconditionsForImplicitToStringCall(rightTree);
            }
        }
        return super.visitCompoundAssignment(node, p);
    }

    private void checkPreconditionsForImplicitToStringCall(Tree tree) {
        this.checkPreconditions(tree, this.generatePreconditionsBasedOnGuards(((LockAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree)));
    }
}

