/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.flow;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.CaseNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.EqualToNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NotEqualNode;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.VariableDeclarationNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.ContractsUtils;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;

public abstract class CFAbstractTransfer<V extends CFAbstractValue<V>, S extends CFAbstractStore<V, S>, T extends CFAbstractTransfer<V, S, T>>
extends AbstractNodeVisitor<TransferResult<V, S>, TransferInput<V, S>>
implements TransferFunction<V, S> {
    protected CFAbstractAnalysis<V, S, T> analysis;
    protected final boolean sequentialSemantics;
    private final boolean infer;
    private S fixedInitialStore = null;

    public CFAbstractTransfer(CFAbstractAnalysis<V, S, T> analysis) {
        this.analysis = analysis;
        this.sequentialSemantics = !analysis.checker.hasOption("concurrentSemantics");
        this.infer = analysis.checker.hasOption("infer");
    }

    public CFAbstractTransfer(CFAbstractAnalysis<V, S, T> analysis, boolean forceConcurrentSemantics) {
        this.analysis = analysis;
        this.sequentialSemantics = !forceConcurrentSemantics && !analysis.checker.hasOption("concurrentSemantics");
        this.infer = analysis.checker.hasOption("infer");
    }

    public boolean usesSequentialSemantics() {
        return this.sequentialSemantics;
    }

    protected V finishValue(V value, S store) {
        return value;
    }

    protected V finishValue(V value, S thenStore, S elseStore) {
        return value;
    }

    protected V getValueFromFactory(Tree tree, Node node) {
        GenericAnnotatedTypeFactory factory = this.analysis.atypeFactory;
        Tree preTree = this.analysis.getCurrentTree();
        Pair<Tree, AnnotatedTypeMirror> preCtxt = factory.getVisitorState().getAssignmentContext();
        this.analysis.setCurrentTree(tree);
        if (node != null && node.getAssignmentContext() != null) {
            Tree contextTree = node.getAssignmentContext().getContextTree();
            AnnotatedTypeMirror assCtxt = null;
            if (contextTree != null) {
                assCtxt = factory.getAnnotatedTypeLhs(contextTree);
            } else {
                Element assCtxtElement = node.getAssignmentContext().getElementForType();
                if (assCtxtElement != null) {
                    assCtxt = factory.getAnnotatedType(assCtxtElement);
                }
            }
            if (assCtxt != null) {
                if (assCtxt instanceof AnnotatedTypeMirror.AnnotatedExecutableType) {
                    assCtxt = ((AnnotatedTypeMirror.AnnotatedExecutableType)assCtxt).getReturnType();
                }
                factory.getVisitorState().setAssignmentContext(Pair.of(node.getAssignmentContext().getContextTree(), assCtxt));
            }
        }
        AnnotatedTypeMirror at = factory.getAnnotatedType(tree);
        this.analysis.setCurrentTree(preTree);
        factory.getVisitorState().setAssignmentContext(preCtxt);
        return this.analysis.createAbstractValue(at);
    }

    protected V getValueWithSameAnnotations(TypeMirror type, V annotatedValue) {
        if (annotatedValue == null) {
            return null;
        }
        return this.analysis.createAbstractValue(((CFAbstractValue)annotatedValue).getAnnotations(), type);
    }

    public void setFixedInitialStore(S s2) {
        this.fixedInitialStore = s2;
    }

    @Override
    public S initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        if (this.fixedInitialStore != null && underlyingAST.getKind() != UnderlyingAST.Kind.LAMBDA && underlyingAST.getKind() != UnderlyingAST.Kind.METHOD) {
            return this.fixedInitialStore;
        }
        S info = this.analysis.createEmptyStore(this.sequentialSemantics);
        if (underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            if (this.fixedInitialStore != null) {
                info = this.analysis.createCopiedStore(this.fixedInitialStore);
            }
            GenericAnnotatedTypeFactory<V, S, T, CFAbstractAnalysis<V, S, T>> factory = this.analysis.getTypeFactory();
            for (LocalVariableNode p : parameters) {
                AnnotatedTypeMirror anno = factory.getAnnotatedType(p.getElement());
                ((CFAbstractStore)info).initializeMethodParameter(p, this.analysis.createAbstractValue(anno));
            }
            UnderlyingAST.CFGMethod method = (UnderlyingAST.CFGMethod)underlyingAST;
            MethodTree methodTree = method.getMethod();
            ExecutableElement methodElem = TreeUtils.elementFromDeclaration(methodTree);
            this.addInformationFromPreconditions(info, factory, method, methodTree, methodElem);
            ClassTree classTree = method.getClassTree();
            this.addFieldValues(info, factory, classTree, methodTree);
            this.addFinalLocalValues(info, methodElem);
            if (this.shouldPerformWholeProgramInference((Tree)methodTree, methodElem)) {
                Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods = AnnotatedTypes.overriddenMethods(this.analysis.atypeFactory.getElementUtils(), this.analysis.atypeFactory, methodElem);
                for (Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair : overriddenMethods.entrySet()) {
                    AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod = AnnotatedTypes.asMemberOf(this.analysis.atypeFactory.getProcessingEnv().getTypeUtils(), this.analysis.atypeFactory, (AnnotatedTypeMirror)pair.getKey(), pair.getValue());
                    this.analysis.atypeFactory.getWholeProgramInference().updateInferredMethodParameterTypes(methodTree, methodElem, overriddenMethod, this.analysis.getTypeFactory());
                    this.analysis.atypeFactory.getWholeProgramInference().updateInferredMethodReceiverType(methodTree, methodElem, overriddenMethod, this.analysis.getTypeFactory());
                }
            }
            return info;
        }
        if (underlyingAST.getKind() == UnderlyingAST.Kind.LAMBDA) {
            info = this.analysis.createCopiedStore(this.fixedInitialStore);
            ((CFAbstractStore)info).localVariableValues.clear();
            ((CFAbstractStore)info).classValues.clear();
            ((CFAbstractStore)info).arrayValues.clear();
            ((CFAbstractStore)info).methodValues.clear();
            GenericAnnotatedTypeFactory<V, S, T, CFAbstractAnalysis<V, S, T>> factory = this.analysis.getTypeFactory();
            for (LocalVariableNode p : parameters) {
                AnnotatedTypeMirror anno = factory.getAnnotatedType(p.getElement());
                ((CFAbstractStore)info).initializeMethodParameter(p, this.analysis.createAbstractValue(anno));
            }
            UnderlyingAST.CFGLambda lambda = (UnderlyingAST.CFGLambda)underlyingAST;
            Tree enclosingTree = TreeUtils.enclosingOfKind(factory.getPath(lambda.getLambdaTree()), new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.ENUM)));
            Element enclosingElement = null;
            if (enclosingTree.getKind() == Tree.Kind.METHOD) {
                enclosingElement = InternalUtils.symbol(enclosingTree);
            } else if (TreeUtils.isClassTree(enclosingTree)) {
                TreePath loopTree = factory.getPath(lambda.getLambdaTree()).getParentPath();
                Element anEnclosingElement = null;
                while (loopTree.getLeaf() != enclosingTree) {
                    Element sym = InternalUtils.symbol(loopTree.getLeaf());
                    if (sym != null) {
                        anEnclosingElement = sym;
                        break;
                    }
                    loopTree = loopTree.getParentPath();
                }
                while (anEnclosingElement != null && !anEnclosingElement.equals(InternalUtils.symbol(enclosingTree))) {
                    if (anEnclosingElement.getKind() == ElementKind.INSTANCE_INIT || anEnclosingElement.getKind() == ElementKind.STATIC_INIT) {
                        enclosingElement = anEnclosingElement;
                        break;
                    }
                    anEnclosingElement = anEnclosingElement.getEnclosingElement();
                }
            }
            if (enclosingElement != null) {
                this.addFinalLocalValues(info, enclosingElement);
            }
            HashMap fieldValuesClone = new HashMap(((CFAbstractStore)info).fieldValues);
            for (Map.Entry fieldValue : fieldValuesClone.entrySet()) {
                AnnotatedTypeMirror declaredType = factory.getAnnotatedType(((FlowExpressions.FieldAccess)fieldValue.getKey()).getField());
                CFAbstractValue lubbedValue = this.analysis.createAbstractValue(declaredType).leastUpperBound((CFAbstractValue)((CFAbstractValue)fieldValue.getValue()));
                ((CFAbstractStore)info).fieldValues.put((FlowExpressions.FieldAccess)fieldValue.getKey(), lubbedValue);
            }
        }
        return info;
    }

    private void addFieldValues(S info, AnnotatedTypeFactory factory, ClassTree classTree, MethodTree methodTree) {
        TypeMirror classType = InternalUtils.typeOf(classTree);
        List<Pair<VariableElement, V>> fieldValues = this.analysis.getFieldValues();
        for (Pair<VariableElement, V> p : fieldValues) {
            VariableElement variableElement = (VariableElement)p.first;
            CFAbstractValue value = (CFAbstractValue)p.second;
            if (!ElementUtils.isFinal(variableElement) && !TreeUtils.isConstructor(methodTree)) continue;
            FlowExpressions.Receiver receiver = ElementUtils.isStatic(variableElement) ? new FlowExpressions.ClassName(classType) : new FlowExpressions.ThisReference(classType);
            TypeMirror fieldType = ElementUtils.getType(variableElement);
            FlowExpressions.FieldAccess field = new FlowExpressions.FieldAccess(receiver, fieldType, variableElement);
            ((CFAbstractStore)info).insertValue((FlowExpressions.Receiver)field, (CFAbstractValue)value);
        }
        boolean isNotFullyInitializedReceiver = this.isNotFullyInitializedReceiver(methodTree);
        if (isNotFullyInitializedReceiver && !TreeUtils.isConstructor(methodTree)) {
            return;
        }
        for (Tree tree : classTree.getMembers()) {
            if (!(tree instanceof VariableTree)) continue;
            VariableTree vt = (VariableTree)tree;
            VariableElement element = TreeUtils.elementFromDeclaration(vt);
            AnnotatedTypeMirror type = factory.getAnnotatedType(element);
            TypeMirror fieldType = ElementUtils.getType(element);
            FlowExpressions.Receiver receiver = ElementUtils.isStatic(element) ? new FlowExpressions.ClassName(classType) : new FlowExpressions.ThisReference(classType);
            CFAbstractValue value = this.analysis.createAbstractValue(type);
            if (value == null) continue;
            if (TreeUtils.isConstructor(methodTree)) {
                boolean found = false;
                for (Pair<VariableElement, V> fieldValue : fieldValues) {
                    if (!((VariableElement)fieldValue.first).equals(element)) continue;
                    value = value.leastUpperBound((CFAbstractValue)((CFAbstractValue)fieldValue.second));
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            FlowExpressions.FieldAccess field = new FlowExpressions.FieldAccess(receiver, fieldType, element);
            ((CFAbstractStore)info).insertValue((FlowExpressions.Receiver)field, value);
        }
    }

    private void addFinalLocalValues(S info, Element enclosingElement) {
        block0: for (Map.Entry e : this.analysis.atypeFactory.getFinalLocalValues().entrySet()) {
            Element elem = e.getKey();
            Element enclosingMethodOfVariableDeclaration = elem.getEnclosingElement();
            if (enclosingMethodOfVariableDeclaration == null) continue;
            for (Element enclosingMethodOfCurrentMethod = enclosingElement; enclosingMethodOfCurrentMethod != null; enclosingMethodOfCurrentMethod = enclosingMethodOfCurrentMethod.getEnclosingElement()) {
                if (!enclosingMethodOfVariableDeclaration.equals(enclosingMethodOfCurrentMethod)) continue;
                FlowExpressions.LocalVariable l = new FlowExpressions.LocalVariable(elem);
                ((CFAbstractStore)info).insertValue((FlowExpressions.Receiver)l, (CFAbstractValue)((CFAbstractValue)e.getValue()));
                continue block0;
            }
        }
    }

    protected boolean isNotFullyInitializedReceiver(MethodTree methodTree) {
        return TreeUtils.isConstructor(methodTree);
    }

    protected void addInformationFromPreconditions(S info, AnnotatedTypeFactory factory, UnderlyingAST.CFGMethod method, MethodTree methodTree, ExecutableElement methodElement) {
        ContractsUtils contracts = ContractsUtils.getInstance(this.analysis.atypeFactory);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        Set<ContractsUtils.Precondition> preconditions = contracts.getPreconditions(methodElement);
        for (ContractsUtils.Precondition p : preconditions) {
            String expression = p.expression;
            AnnotationMirror annotation = p.annotation;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration(methodTree, method.getClassTree(), (BaseContext)this.analysis.checker.getContext());
            }
            try {
                FlowExpressions.Receiver expr = FlowExpressionParseUtil.parse(expression, flowExprContext, this.analysis.atypeFactory.getPath(methodTree), false);
                ((CFAbstractStore)info).insertValue(expr, annotation);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.analysis.checker.report(e.getResult(), methodTree);
            }
        }
    }

    @Override
    public TransferResult<V, S> visitNode(Node n, TransferInput<V, S> in) {
        V value = null;
        Tree tree = n.getTree();
        if (tree != null && TreeUtils.canHaveTypeAnnotation(tree)) {
            value = this.getValueFromFactory(tree, n);
        }
        if (in.containsTwoStores()) {
            CFAbstractStore thenStore = (CFAbstractStore)in.getThenStore();
            CFAbstractStore elseStore = (CFAbstractStore)in.getElseStore();
            return new ConditionalTransferResult<Object, CFAbstractStore>(this.finishValue(value, thenStore, elseStore), thenStore, elseStore);
        }
        CFAbstractStore info = (CFAbstractStore)in.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(value, info), info);
    }

    @Override
    public TransferResult<V, S> visitClassName(ClassNameNode n, TransferInput<V, S> in) {
        V value = null;
        Tree tree = n.getTree();
        if (tree != null && TreeUtils.canHaveTypeAnnotation(tree)) {
            GenericAnnotatedTypeFactory factory = this.analysis.atypeFactory;
            this.analysis.setCurrentTree(tree);
            AnnotatedTypeMirror at = factory.getAnnotatedTypeFromTypeTree(tree);
            this.analysis.setCurrentTree(null);
            value = this.analysis.createAbstractValue(at);
        }
        if (in.containsTwoStores()) {
            CFAbstractStore thenStore = (CFAbstractStore)in.getThenStore();
            CFAbstractStore elseStore = (CFAbstractStore)in.getElseStore();
            return new ConditionalTransferResult<Object, CFAbstractStore>(this.finishValue(value, thenStore, elseStore), thenStore, elseStore);
        }
        CFAbstractStore info = (CFAbstractStore)in.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(value, info), info);
    }

    @Override
    public TransferResult<V, S> visitFieldAccess(FieldAccessNode n, TransferInput<V, S> p) {
        CFAbstractStore store = (CFAbstractStore)p.getRegularStore();
        Object storeValue = store.getValue(n);
        V factoryValue = this.getValueFromFactory(n.getTree(), n);
        V value = this.moreSpecificValue(factoryValue, storeValue);
        return new RegularTransferResult<V, CFAbstractStore>(this.finishValue(value, store), store);
    }

    @Override
    public TransferResult<V, S> visitArrayAccess(ArrayAccessNode n, TransferInput<V, S> p) {
        CFAbstractStore store = (CFAbstractStore)p.getRegularStore();
        Object storeValue = store.getValue(n);
        V factoryValue = this.getValueFromFactory(n.getTree(), n);
        V value = this.moreSpecificValue(factoryValue, storeValue);
        return new RegularTransferResult<V, CFAbstractStore>(this.finishValue(value, store), store);
    }

    @Override
    public TransferResult<V, S> visitLocalVariable(LocalVariableNode n, TransferInput<V, S> in) {
        CFAbstractStore store = (CFAbstractStore)in.getRegularStore();
        Object valueFromStore = store.getValue(n);
        V valueFromFactory = this.getValueFromFactory(n.getTree(), n);
        V value = this.moreSpecificValue(valueFromFactory, valueFromStore);
        return new RegularTransferResult<V, CFAbstractStore>(this.finishValue(value, store), store);
    }

    @Override
    public TransferResult<V, S> visitThisLiteral(ThisLiteralNode n, TransferInput<V, S> in) {
        CFAbstractStore store = (CFAbstractStore)in.getRegularStore();
        Object valueFromStore = store.getValue(n);
        V valueFromFactory = null;
        Object value = null;
        Tree tree = n.getTree();
        if (tree != null && TreeUtils.canHaveTypeAnnotation(tree)) {
            valueFromFactory = this.getValueFromFactory(tree, n);
        }
        value = valueFromFactory == null ? (Object)valueFromStore : this.moreSpecificValue(valueFromFactory, valueFromStore);
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(value, store), store);
    }

    @Override
    public TransferResult<V, S> visitTernaryExpression(TernaryExpressionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitTernaryExpression(n, p);
        CFAbstractStore store = (CFAbstractStore)result.getRegularStore();
        CFAbstractValue thenValue = (CFAbstractValue)p.getValueOfSubNode(n.getThenOperand());
        CFAbstractValue elseValue = (CFAbstractValue)p.getValueOfSubNode(n.getElseOperand());
        CFAbstractValue resultValue = null;
        if (thenValue != null && elseValue != null) {
            resultValue = thenValue.leastUpperBound(elseValue);
        }
        return new RegularTransferResult<CFAbstractValue, CFAbstractStore>(this.finishValue(resultValue, store), store);
    }

    @Override
    public TransferResult<V, S> visitConditionalNot(ConditionalNotNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitConditionalNot(n, p);
        CFAbstractStore thenStore = (CFAbstractStore)result.getThenStore();
        CFAbstractStore elseStore = (CFAbstractStore)result.getElseStore();
        return new ConditionalTransferResult(result.getResultValue(), elseStore, thenStore);
    }

    @Override
    public TransferResult<V, S> visitEqualTo(EqualToNode n, TransferInput<V, S> p) {
        TransferResult<CFAbstractValue, S> res = (TransferResult<CFAbstractValue, S>)super.visitEqualTo(n, p);
        Node leftN = n.getLeftOperand();
        Node rightN = n.getRightOperand();
        CFAbstractValue leftV = (CFAbstractValue)p.getValueOfSubNode(leftN);
        CFAbstractValue rightV = (CFAbstractValue)p.getValueOfSubNode(rightN);
        res = this.strengthenAnnotationOfEqualTo(res, leftN, rightN, leftV, rightV, false);
        res = this.strengthenAnnotationOfEqualTo(res, rightN, leftN, rightV, leftV, false);
        return res;
    }

    @Override
    public TransferResult<V, S> visitNotEqual(NotEqualNode n, TransferInput<V, S> p) {
        TransferResult<CFAbstractValue, S> res = (TransferResult<CFAbstractValue, S>)super.visitNotEqual(n, p);
        Node leftN = n.getLeftOperand();
        Node rightN = n.getRightOperand();
        CFAbstractValue leftV = (CFAbstractValue)p.getValueOfSubNode(leftN);
        CFAbstractValue rightV = (CFAbstractValue)p.getValueOfSubNode(rightN);
        res = this.strengthenAnnotationOfEqualTo(res, leftN, rightN, leftV, rightV, true);
        res = this.strengthenAnnotationOfEqualTo(res, rightN, leftN, rightV, leftV, true);
        return res;
    }

    protected TransferResult<V, S> strengthenAnnotationOfEqualTo(TransferResult<V, S> res, Node firstNode, Node secondNode, V firstValue, V secondValue, boolean notEqualTo) {
        if (firstValue != null && !((CFAbstractValue)firstValue).equals(secondValue)) {
            List<Node> secondParts = this.splitAssignments(secondNode);
            for (Node secondPart : secondParts) {
                FlowExpressions.Receiver secondInternal = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), secondPart);
                if (!CFAbstractStore.canInsertReceiver(secondInternal)) continue;
                CFAbstractStore thenStore = (CFAbstractStore)res.getThenStore();
                CFAbstractStore elseStore = (CFAbstractStore)res.getElseStore();
                if (notEqualTo) {
                    elseStore.insertValue(secondInternal, firstValue);
                } else {
                    thenStore.insertValue(secondInternal, firstValue);
                }
                return new ConditionalTransferResult<V, CFAbstractStore>(res.getResultValue(), thenStore, elseStore);
            }
        }
        return res;
    }

    protected List<Node> splitAssignments(Node node) {
        if (node instanceof AssignmentNode) {
            ArrayList<Node> result = new ArrayList<Node>();
            AssignmentNode a = (AssignmentNode)node;
            result.add(a.getTarget());
            result.addAll(this.splitAssignments(a.getExpression()));
            return result;
        }
        return Collections.singletonList(node);
    }

    @Override
    public TransferResult<V, S> visitAssignment(AssignmentNode n, TransferInput<V, S> in) {
        Node lhs = n.getTarget();
        Node rhs = n.getExpression();
        CFAbstractStore info = (CFAbstractStore)in.getRegularStore();
        CFAbstractValue rhsValue = (CFAbstractValue)in.getValueOfSubNode(rhs);
        if (this.shouldPerformWholeProgramInference(n.getTree(), lhs.getTree())) {
            if (lhs instanceof FieldAccessNode) {
                this.analysis.atypeFactory.getWholeProgramInference().updateInferredFieldType((FieldAccessNode)lhs, rhs, this.analysis.getContainingClass(n.getTree()), this.analysis.getTypeFactory());
            } else if (lhs instanceof LocalVariableNode && ((LocalVariableNode)lhs).getElement().getKind() == ElementKind.PARAMETER) {
                this.analysis.atypeFactory.getWholeProgramInference().updateInferredParameterType((LocalVariableNode)lhs, rhs, this.analysis.getContainingClass(n.getTree()), this.analysis.getContainingMethod(n.getTree()), this.analysis.getTypeFactory());
            }
        }
        this.processCommonAssignment(in, lhs, rhs, info, rhsValue);
        return new RegularTransferResult<CFAbstractValue, CFAbstractStore>(this.finishValue(rhsValue, info), info);
    }

    @Override
    public TransferResult<V, S> visitReturn(ReturnNode n, TransferInput<V, S> p) {
        if (this.shouldPerformWholeProgramInference(n.getTree())) {
            ClassTree classTree = this.analysis.getContainingClass(n.getTree());
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)InternalUtils.symbol(classTree);
            this.analysis.atypeFactory.getWholeProgramInference().updateInferredMethodReturnType(n, classSymbol, this.analysis.getContainingMethod(n.getTree()), this.analysis.getTypeFactory());
        }
        return (TransferResult)super.visitReturn(n, p);
    }

    @Override
    public TransferResult<V, S> visitStringConcatenateAssignment(StringConcatenateAssignmentNode n, TransferInput<V, S> in) {
        TransferResult result = (TransferResult)super.visitStringConcatenateAssignment(n, in);
        Node lhs = n.getLeftOperand();
        Node rhs = n.getRightOperand();
        CFAbstractStore info = (CFAbstractStore)result.getRegularStore();
        CFAbstractValue resultValue = (CFAbstractValue)result.getResultValue();
        if (lhs instanceof FieldAccessNode && this.shouldPerformWholeProgramInference(n.getTree(), lhs.getTree())) {
            this.analysis.atypeFactory.getWholeProgramInference().updateInferredFieldType((FieldAccessNode)lhs, rhs, this.analysis.getContainingClass(n.getTree()), this.analysis.getTypeFactory());
        }
        this.processCommonAssignment(in, lhs, rhs, info, resultValue);
        return new RegularTransferResult<CFAbstractValue, CFAbstractStore>(this.finishValue(resultValue, info), info);
    }

    protected void processCommonAssignment(TransferInput<V, S> in, Node lhs, Node rhs, S info, V rhsValue) {
        ((CFAbstractStore)info).updateForAssignment(lhs, rhsValue);
    }

    @Override
    public TransferResult<V, S> visitObjectCreation(ObjectCreationNode n, TransferInput<V, S> p) {
        if (this.shouldPerformWholeProgramInference(n.getTree())) {
            ExecutableElement constructorElt = ((AnnotatedTypeMirror.AnnotatedExecutableType)this.analysis.getTypeFactory().constructorFromUse((NewClassTree)n.getTree()).first).getElement();
            this.analysis.atypeFactory.getWholeProgramInference().updateInferredConstructorParameterTypes(n, constructorElt, this.analysis.getTypeFactory());
        }
        return (TransferResult)super.visitObjectCreation(n, p);
    }

    @Override
    public TransferResult<V, S> visitMethodInvocation(MethodInvocationNode n, TransferInput<V, S> in) {
        CFAbstractStore store = (CFAbstractStore)in.getRegularStore();
        ExecutableElement method = n.getTarget().getMethod();
        V factoryValue = null;
        MethodInvocationTree tree = n.getTree();
        if (tree != null) {
            factoryValue = this.getValueFromFactory(tree, n);
        }
        Object storeValue = store.getValue(n);
        V resValue = this.moreSpecificValue(factoryValue, storeValue);
        store.updateForMethodCall(n, this.analysis.atypeFactory, resValue);
        this.processPostconditions(n, store, method, tree);
        CFAbstractStore thenStore = store;
        Store elseStore = thenStore.copy();
        this.processConditionalPostconditions(n, method, tree, thenStore, elseStore);
        if (this.shouldPerformWholeProgramInference((Tree)n.getTree(), method)) {
            Tree receiverTree = n.getTarget().getReceiver().getTree();
            if (receiverTree == null) {
                receiverTree = this.analysis.getContainingClass(n.getTree());
            }
            this.analysis.atypeFactory.getWholeProgramInference().updateInferredMethodParameterTypes(n, receiverTree, method, this.analysis.getTypeFactory());
        }
        return new ConditionalTransferResult<Object, Store>(this.finishValue(resValue, thenStore, elseStore), thenStore, elseStore);
    }

    private boolean shouldPerformWholeProgramInference(Tree tree) {
        return this.infer && (tree == null || !this.analysis.checker.shouldSuppressWarnings(tree, null));
    }

    private boolean shouldPerformWholeProgramInference(Tree expressionTree, Tree lhsTree) {
        if (!this.shouldPerformWholeProgramInference(expressionTree)) {
            return false;
        }
        Element elt = InternalUtils.symbol(lhsTree);
        return !this.analysis.checker.shouldSuppressWarnings(elt, null);
    }

    private boolean shouldPerformWholeProgramInference(Tree tree, Element elt) {
        return this.shouldPerformWholeProgramInference(tree) && !this.analysis.checker.shouldSuppressWarnings(elt, null);
    }

    protected void processPostconditions(MethodInvocationNode n, S store, ExecutableElement methodElement, Tree tree) {
        ContractsUtils contracts = ContractsUtils.getInstance(this.analysis.atypeFactory);
        Set<ContractsUtils.Postcondition> postconditions = contracts.getPostconditions(methodElement);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (ContractsUtils.Postcondition p : postconditions) {
            String expression = p.expression.trim();
            AnnotationMirror anno = p.annotation;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodUse(n, this.analysis.checker.getContext());
            }
            try {
                FlowExpressions.Receiver r = FlowExpressionParseUtil.parse(expression, flowExprContext, this.analysis.atypeFactory.getPath(tree), false);
                ((CFAbstractStore)store).insertValue(r, anno);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.analysis.checker.report(e.getResult(), tree);
            }
        }
    }

    protected void processConditionalPostconditions(MethodInvocationNode n, ExecutableElement methodElement, Tree tree, S thenStore, S elseStore) {
        ContractsUtils contracts = ContractsUtils.getInstance(this.analysis.atypeFactory);
        Set<ContractsUtils.ConditionalPostcondition> conditionalPostconditions = contracts.getConditionalPostconditions(methodElement);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (ContractsUtils.ConditionalPostcondition p : conditionalPostconditions) {
            String expression = p.expression;
            AnnotationMirror anno = p.annotation;
            boolean result = p.annoResult;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodUse(n, this.analysis.checker.getContext());
            }
            try {
                FlowExpressions.Receiver r = null;
                r = FlowExpressionParseUtil.parse(expression, flowExprContext, this.analysis.atypeFactory.getPath(tree), false);
                if (result) {
                    ((CFAbstractStore)thenStore).insertValue(r, anno);
                    continue;
                }
                ((CFAbstractStore)elseStore).insertValue(r, anno);
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                this.analysis.checker.report(e.getResult(), tree);
            }
        }
    }

    @Override
    public TransferResult<V, S> visitCase(CaseNode n, TransferInput<V, S> in) {
        CFAbstractStore store = (CFAbstractStore)in.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(null, store), store);
    }

    public V moreSpecificValue(V value1, V value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return ((CFAbstractValue)value1).mostSpecific(value2, value1);
    }

    @Override
    public TransferResult<V, S> visitVariableDeclaration(VariableDeclarationNode n, TransferInput<V, S> p) {
        CFAbstractStore store = (CFAbstractStore)p.getRegularStore();
        return new RegularTransferResult<Object, CFAbstractStore>(this.finishValue(null, store), store);
    }

    @Override
    public TransferResult<V, S> visitNarrowingConversion(NarrowingConversionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitNarrowingConversion(n, p);
        CFAbstractValue operandValue = (CFAbstractValue)p.getValueOfSubNode(n.getOperand());
        CFAbstractValue narrowedValue = this.getValueWithSameAnnotations(n.getType(), operandValue);
        result.setResultValue(narrowedValue);
        return result;
    }

    @Override
    public TransferResult<V, S> visitWideningConversion(WideningConversionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitWideningConversion(n, p);
        CFAbstractValue operandValue = (CFAbstractValue)p.getValueOfSubNode(n.getOperand());
        CFAbstractValue widenedValue = this.getValueWithSameAnnotations(n.getType(), operandValue);
        result.setResultValue(widenedValue);
        return result;
    }

    @Override
    public TransferResult<V, S> visitStringConversion(StringConversionNode n, TransferInput<V, S> p) {
        TransferResult result = (TransferResult)super.visitStringConversion(n, p);
        result.setResultValue(p.getValueOfSubNode(n.getOperand()));
        return result;
    }

    public <W extends GenericAnnotatedTypeFactory<?, ?, ?, ?>, U extends BaseTypeChecker> W getTypeFactoryOfSubchecker(Class<U> checkerClass) {
        return this.analysis.getTypeFactoryOfSubchecker(checkerClass);
    }
}

