/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.element;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeParameterElement;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.util.element.ElementAnnotationUtil;
import org.checkerframework.javacutil.ErrorReporter;

public class TypeVarUseApplier {
    private static ElementKind[] acceptedKinds = new ElementKind[]{ElementKind.PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.METHOD};
    private final AnnotatedTypeMirror.AnnotatedArrayType arrayType;
    private final AnnotatedTypeMirror.AnnotatedTypeVariable typeVariable;
    private final TypeParameterElement declarationElem;
    private final Element useElem;
    private AnnotatedTypeFactory typeFactory;

    public static void apply(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        new TypeVarUseApplier(type, element, typeFactory).extractAndApply();
    }

    public static boolean accepts(AnnotatedTypeMirror type, Element element) {
        return (type instanceof AnnotatedTypeMirror.AnnotatedTypeVariable || TypeVarUseApplier.isGenericArrayType(type)) && ElementAnnotationUtil.contains((Object)element.getKind(), (Object[])acceptedKinds);
    }

    private static boolean isGenericArrayType(AnnotatedTypeMirror type) {
        return type instanceof AnnotatedTypeMirror.AnnotatedArrayType && TypeVarUseApplier.getNestedComponentType(type) instanceof AnnotatedTypeMirror.AnnotatedTypeVariable;
    }

    private static AnnotatedTypeMirror getNestedComponentType(AnnotatedTypeMirror type) {
        AnnotatedTypeMirror componentType = type;
        while (componentType instanceof AnnotatedTypeMirror.AnnotatedArrayType) {
            componentType = ((AnnotatedTypeMirror.AnnotatedArrayType)componentType).getComponentType();
        }
        return componentType;
    }

    TypeVarUseApplier(AnnotatedTypeMirror type, Element element, AnnotatedTypeFactory typeFactory) {
        if (!TypeVarUseApplier.accepts(type, element)) {
            ErrorReporter.errorAbort("TypeParamUseApplier does not accept type/element combination ( type ( " + type + " ) element ( " + element + " ) ");
        }
        if (TypeVarUseApplier.isGenericArrayType(type)) {
            this.arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)type;
            this.typeVariable = (AnnotatedTypeMirror.AnnotatedTypeVariable)TypeVarUseApplier.getNestedComponentType(type);
            this.declarationElem = (TypeParameterElement)this.typeVariable.getUnderlyingType().asElement();
            this.useElem = element;
            this.typeFactory = typeFactory;
        } else {
            this.arrayType = null;
            this.typeVariable = (AnnotatedTypeMirror.AnnotatedTypeVariable)type;
            this.declarationElem = (TypeParameterElement)this.typeVariable.getUnderlyingType().asElement();
            this.useElem = element;
            this.typeFactory = typeFactory;
        }
    }

    public void extractAndApply() {
        java.util.List<Attribute.TypeCompound> typeVarAnnotations;
        ElementAnnotationUtil.addAnnotationsFromElement(this.typeVariable, this.useElem.getAnnotationMirrors());
        ElementAnnotationApplier.apply(this.typeVariable, this.declarationElem, this.typeFactory);
        java.util.List<Attribute.TypeCompound> annotations = TypeVarUseApplier.getAnnotations(this.useElem, this.declarationElem);
        if (this.arrayType != null) {
            typeVarAnnotations = this.removeComponentAnnotations(this.arrayType, annotations);
            ElementAnnotationUtil.annotateViaTypeAnnoPosition(this.arrayType, annotations);
        } else {
            typeVarAnnotations = annotations;
        }
        for (Attribute.TypeCompound annotation : typeVarAnnotations) {
            this.typeVariable.removeAnnotationInHierarchy(annotation);
            this.typeVariable.addAnnotation(annotation);
            java.util.List<? extends AnnotatedTypeMirror> upperBounds = this.typeVariable.getUpperBound() instanceof AnnotatedTypeMirror.AnnotatedIntersectionType ? this.typeVariable.getUpperBound().directSuperTypes() : Arrays.asList(this.typeVariable.getUpperBound());
            for (AnnotatedTypeMirror annotatedTypeMirror : upperBounds) {
                annotatedTypeMirror.removeAnnotationInHierarchy(annotation);
                annotatedTypeMirror.addAnnotation(annotation);
            }
        }
    }

    private java.util.List<Attribute.TypeCompound> removeComponentAnnotations(AnnotatedTypeMirror.AnnotatedArrayType arrayType, java.util.List<Attribute.TypeCompound> annotations) {
        ArrayList<Attribute.TypeCompound> componentAnnotations = new ArrayList<Attribute.TypeCompound>();
        if (arrayType != null) {
            int i = 0;
            while (i < annotations.size()) {
                Attribute.TypeCompound anno = annotations.get(i);
                if (this.isBaseComponent(arrayType, anno)) {
                    componentAnnotations.add(anno);
                    annotations.remove(anno);
                    continue;
                }
                ++i;
            }
        }
        return componentAnnotations;
    }

    private boolean isBaseComponent(AnnotatedTypeMirror.AnnotatedArrayType arrayType, Attribute.TypeCompound anno) {
        return ElementAnnotationUtil.getTypeAtLocation(arrayType, anno.getPosition().location).getClass().equals(AnnotatedTypeMirror.AnnotatedTypeVariable.class);
    }

    private static java.util.List<Attribute.TypeCompound> getAnnotations(Element useElem, Element declarationElem) {
        java.util.List<Attribute.TypeCompound> annotations;
        switch (useElem.getKind()) {
            case METHOD: {
                annotations = TypeVarUseApplier.getReturnAnnos(useElem);
                break;
            }
            case PARAMETER: {
                annotations = TypeVarUseApplier.getParameterAnnos(useElem);
                break;
            }
            case FIELD: 
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                annotations = TypeVarUseApplier.getVariableAnnos(useElem);
                break;
            }
            default: {
                ErrorReporter.errorAbort("TypeVarUseApplier::extractAndApply : Unhandled element kind " + (Object)((Object)useElem.getKind()) + "useElem ( " + useElem + " ) declarationElem ( " + declarationElem + " ) ");
                annotations = null;
            }
        }
        return annotations;
    }

    private static java.util.List<Attribute.TypeCompound> getVariableAnnos(Element variableElem) {
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)variableElem;
        ArrayList<Attribute.TypeCompound> annotations = new ArrayList<Attribute.TypeCompound>();
        for (Attribute.TypeCompound anno : varSymbol.getRawTypeAttributes()) {
            TypeAnnotationPosition pos = anno.position;
            switch (pos.type) {
                case FIELD: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case EXCEPTION_PARAMETER: {
                    annotations.add(anno);
                    break;
                }
            }
        }
        return annotations;
    }

    private static java.util.List<Attribute.TypeCompound> getParameterAnnos(Element paramElem) {
        Element enclosingElement = paramElem.getEnclosingElement();
        if (!(enclosingElement instanceof ExecutableElement)) {
            ErrorReporter.errorAbort("Bad element passed to TypeFromElement.getTypeParameterAnnotationAttributes: element: " + paramElem + " not found in enclosing executable: " + enclosingElement);
        }
        Symbol.MethodSymbol enclosingMethod = (Symbol.MethodSymbol)paramElem.getEnclosingElement();
        List<Attribute.TypeCompound> annotations = enclosingMethod.getRawTypeAttributes();
        int paramIndex = ((List)enclosingMethod.getParameters()).indexOf(paramElem);
        ArrayList<Attribute.TypeCompound> result = new ArrayList<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeAnno : annotations) {
            if (typeAnno.position.type != TargetType.METHOD_FORMAL_PARAMETER || typeAnno.position.parameter_index != paramIndex) continue;
            result.add(typeAnno);
        }
        return result;
    }

    private static java.util.List<Attribute.TypeCompound> getReturnAnnos(Element methodElem) {
        if (!(methodElem instanceof ExecutableElement)) {
            ErrorReporter.errorAbort("Bad element passed to TypeVarUseApplier.getReturnAnnos:" + methodElem);
        }
        Symbol.MethodSymbol enclosingMethod = (Symbol.MethodSymbol)methodElem;
        List<Attribute.TypeCompound> annotations = enclosingMethod.getRawTypeAttributes();
        ArrayList<Attribute.TypeCompound> result = new ArrayList<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeAnno : annotations) {
            if (typeAnno.position.type != TargetType.METHOD_RETURN) continue;
            result.add(typeAnno);
        }
        return result;
    }
}

