/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.bcel6.classfile.AccessFlags;
import org.apache.commons.bcel6.classfile.AnnotationEntry;
import org.apache.commons.bcel6.classfile.Annotations;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.Field;
import org.apache.commons.bcel6.classfile.JavaClass;
import org.apache.commons.bcel6.classfile.Method;
import org.apache.commons.bcel6.classfile.RuntimeInvisibleAnnotations;
import org.apache.commons.bcel6.classfile.RuntimeVisibleAnnotations;
import org.apache.commons.bcel6.classfile.SourceFile;
import org.apache.commons.bcel6.generic.AnnotationEntryGen;
import org.apache.commons.bcel6.generic.ClassGenException;
import org.apache.commons.bcel6.generic.ClassObserver;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.INVOKESPECIAL;
import org.apache.commons.bcel6.generic.InstructionConst;
import org.apache.commons.bcel6.generic.InstructionList;
import org.apache.commons.bcel6.generic.MethodGen;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.util.BCELComparator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.checker.signature.qual.BinaryNameForNonArray;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String super_class_name;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String file_name;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int class_name_index = -1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclass_name_index = -1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major = 45;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor = 3;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field> field_vec = new ArrayList<Field>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method> method_vec = new ArrayList<Method>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute> attribute_vec = new ArrayList<Attribute>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String> interface_vec = new ArrayList<String>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen> annotation_vec = new ArrayList<AnnotationEntryGen>();
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            ClassGen THIS = (ClassGen)o1;
            ClassGen THAT = (ClassGen)o2;
            return THIS.getClassName().equals(THAT.getClassName());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            ClassGen THIS = (ClassGen)o;
            return THIS.getClassName().hashCode();
        }
    };
    private @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassObserver> observers;

    public ClassGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryName String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryName String super_class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String file_name, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        super(access_flags);
        this.class_name = class_name;
        this.super_class_name = super_class_name;
        this.file_name = file_name;
        this.cp = cp;
        if (file_name != null) {
            this.addAttribute(new SourceFile(cp.addUtf8("SourceFile"), 2, cp.addUtf8(file_name), cp.getConstantPool()));
        }
        this.class_name_index = cp.addClass(class_name);
        this.superclass_name_index = cp.addClass(super_class_name);
        if (interfaces != null) {
            for (String interface1 : interfaces) {
                this.addInterface(interface1);
            }
        }
    }

    public ClassGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String super_class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String file_name, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] interfaces) {
        this(class_name, super_class_name, file_name, access_flags, interfaces, new ConstantPoolGen());
    }

    public ClassGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        super(clazz.getAccessFlags());
        this.class_name_index = clazz.getClassNameIndex();
        this.superclass_name_index = clazz.getSuperclassNameIndex();
        this.class_name = clazz.getClassName();
        this.super_class_name = clazz.getSuperclassName();
        this.file_name = clazz.getSourceFileName();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
        this.major = clazz.getMajor();
        this.minor = clazz.getMinor();
        Attribute[] attributes = clazz.getAttributes();
        AnnotationEntryGen[] annotations = this.unpackAnnotations(attributes);
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        String[] interfaces = clazz.getInterfaceNames();
        for (String interface1 : interfaces) {
            this.addInterface(interface1);
        }
        for (Attribute attribute : attributes) {
            if (attribute instanceof Annotations) continue;
            this.addAttribute(attribute);
        }
        for (AnnotationEntryGen annotation : annotations) {
            this.addAnnotationEntry(annotation);
        }
        for (Method method : methods) {
            this.addMethod(method);
        }
        for (Field field : fields) {
            this.addField(field);
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] unpackAnnotations(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] attrs) {
        ArrayList<AnnotationEntryGen> annotationGenObjs = new ArrayList<AnnotationEntryGen>();
        for (Attribute attr : attrs) {
            AnnotationEntry[] annos;
            if (attr instanceof RuntimeVisibleAnnotations) {
                RuntimeVisibleAnnotations rva = (RuntimeVisibleAnnotations)attr;
                for (AnnotationEntry a : annos = rva.getAnnotationEntries()) {
                    annotationGenObjs.add(new AnnotationEntryGen(a, this.getConstantPool(), false));
                }
                continue;
            }
            if (!(attr instanceof RuntimeInvisibleAnnotations)) continue;
            RuntimeInvisibleAnnotations ria = (RuntimeInvisibleAnnotations)attr;
            for (AnnotationEntry a : annos = ria.getAnnotationEntries()) {
                annotationGenObjs.add(new AnnotationEntryGen(a, this.getConstantPool(), false));
            }
        }
        return annotationGenObjs.toArray(new AnnotationEntryGen[annotationGenObjs.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass getJavaClass() {
        int[] interfaces = this.getInterfaces();
        Field[] fields = this.getFields();
        Method[] methods = this.getMethods();
        Attribute[] attributes = null;
        if (this.annotation_vec.isEmpty()) {
            attributes = this.getAttributes();
        } else {
            Attribute[] annAttributes = AnnotationEntryGen.getAnnotationAttributes(this.cp, this.getAnnotationEntries());
            attributes = new Attribute[this.attribute_vec.size() + annAttributes.length];
            this.attribute_vec.toArray(attributes);
            System.arraycopy(annAttributes, 0, attributes, this.attribute_vec.size(), annAttributes.length);
        }
        ConstantPool _cp = this.cp.getFinalConstantPool();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, super.getAccessFlags(), _cp, interfaces, fields, methods, attributes);
    }

    public void addInterface(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        this.interface_vec.add(name);
    }

    public void removeInterface(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        this.interface_vec.remove(name);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMajor() {
        return this.major;
    }

    public void setMajor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int major) {
        this.major = major;
    }

    public void setMinor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int minor) {
        this.minor = minor;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMinor() {
        return this.minor;
    }

    public void addAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.attribute_vec.add(a);
    }

    public void addAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen a) {
        this.annotation_vec.add(a);
    }

    public void addMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method m3) {
        this.method_vec.add(m3);
    }

    public void addEmptyConstructor(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags) {
        InstructionList il = new InstructionList();
        il.append(InstructionConst.THIS);
        il.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        il.append(InstructionConst.RETURN);
        MethodGen mg = new MethodGen(access_flags, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, il, this.cp);
        mg.setMaxStack(1);
        this.addMethod(mg.getMethod());
    }

    public void addField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field f) {
        this.field_vec.add(f);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean containsField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field f) {
        return this.field_vec.contains(f);
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Field containsField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name) {
        for (Field f : this.field_vec) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Method containsMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String signature) {
        for (Method m3 : this.method_vec) {
            if (!m3.getName().equals(name) || !m3.getSignature().equals(signature)) continue;
            return m3;
        }
        return null;
    }

    public void removeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute a) {
        this.attribute_vec.remove(a);
    }

    public void removeMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method m3) {
        this.method_vec.remove(m3);
    }

    public void replaceMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method old, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.method_vec.indexOf(old);
        if (i < 0) {
            this.method_vec.add(new_);
        } else {
            this.method_vec.set(i, new_);
        }
    }

    public void replaceField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field old, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i = this.field_vec.indexOf(old);
        if (i < 0) {
            this.field_vec.add(new_);
        } else {
            this.field_vec.set(i, new_);
        }
    }

    public void removeField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field f) {
        this.field_vec.remove(f);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String getClassName() {
        return this.class_name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String getSuperclassName() {
        return this.super_class_name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getFileName() {
        return this.file_name;
    }

    public void setClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String name) {
        this.class_name = name.replace('/', '.');
        this.class_name_index = this.cp.addClass(name);
    }

    public void setSuperclassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String name) {
        this.super_class_name = name.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(name);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getMethods() {
        return this.method_vec.toArray(new Method[this.method_vec.size()]);
    }

    public void setMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] methods) {
        this.method_vec.clear();
        for (Method method : methods) {
            this.addMethod(method);
        }
    }

    public void setMethodAt(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method method, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pos) {
        this.method_vec.set(pos, method);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Method getMethodAt(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int pos) {
        return this.method_vec.get(pos);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaceNames() {
        int size = this.interface_vec.size();
        String[] interfaces = new String[size];
        this.interface_vec.toArray(interfaces);
        return interfaces;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getInterfaces() {
        int size = this.interface_vec.size();
        int[] interfaces = new int[size];
        for (int i = 0; i < size; ++i) {
            interfaces[i] = this.cp.addClass(this.interface_vec.get(i));
        }
        return interfaces;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getFields() {
        return this.field_vec.toArray(new Field[this.field_vec.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAttributes() {
        return this.attribute_vec.toArray(new Attribute[this.attribute_vec.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntryGen @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAnnotationEntries() {
        return this.annotation_vec.toArray(new AnnotationEntryGen[this.annotation_vec.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen constant_pool) {
        this.cp = constant_pool;
    }

    public void setClassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int class_name_index) {
        this.class_name_index = class_name_index;
        this.class_name = this.cp.getConstantPool().getConstantString(class_name_index, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
        this.super_class_name = this.cp.getConstantPool().getConstantString(superclass_name_index, (byte)7).replace('/', '.');
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getClassNameIndex() {
        return this.class_name_index;
    }

    public void addObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<ClassObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (ClassObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown Object obj) {
        return _cmp.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return _cmp.hashCode(this);
    }
}

