/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import org.apache.commons.bcel6.classfile.ConstantCP;
import org.apache.commons.bcel6.classfile.ConstantNameAndType;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.ConstantUtf8;
import org.apache.commons.bcel6.generic.ArrayType;
import org.apache.commons.bcel6.generic.CPInstruction;
import org.apache.commons.bcel6.generic.ClassGenException;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.LoadClass;
import org.apache.commons.bcel6.generic.ObjectType;
import org.apache.commons.bcel6.generic.ReferenceType;
import org.apache.commons.bcel6.generic.Type;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.BinaryNameForNonArray;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class FieldOrMethod
extends CPInstruction
implements LoadClass {
    FieldOrMethod() {
    }

    protected FieldOrMethod(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        super(opcode, index);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getNameIndex())).getBytes();
    }

    @Deprecated
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String getClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return "java.lang.Object";
        }
        return className.replace('/', '.');
    }

    @Deprecated
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getClassType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        return ObjectType.getInstance(this.getClassName(cpg));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReferenceType getReferenceType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return (ArrayType)Type.getType(className);
        }
        className = className.replace('/', '.');
        return ObjectType.getInstance(className);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType getLoadClassType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ReferenceType rt = this.getReferenceType(cpg);
        if (rt instanceof ObjectType) {
            return (ObjectType)rt;
        }
        throw new ClassGenException(rt.getSignature() + " does not represent an ObjectType");
    }
}

