/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.lowerbound;

import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexRefinementInfo;
import org.checkerframework.checker.index.lowerbound.LowerBoundAnnotatedTypeFactory;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class LowerBoundTransfer
extends IndexAbstractTransfer {
    public final AnnotationMirror GTEN1;
    public final AnnotationMirror NN;
    public final AnnotationMirror POS;
    public final AnnotationMirror UNKNOWN;
    private LowerBoundAnnotatedTypeFactory aTypeFactory;

    public LowerBoundTransfer(CFAnalysis analysis) {
        super(analysis);
        this.aTypeFactory = (LowerBoundAnnotatedTypeFactory)analysis.getTypeFactory();
        this.GTEN1 = this.aTypeFactory.GTEN1;
        this.NN = this.aTypeFactory.NN;
        this.POS = this.aTypeFactory.POS;
        this.UNKNOWN = this.aTypeFactory.UNKNOWN;
    }

    private void notEqualToValue(Node mLiteral, Node otherNode, AnnotationMirror otherAnno, CFStore store) {
        Long integerLiteralOrNull = this.aTypeFactory.getExactValueOrNullFromTree(mLiteral.getTree());
        if (integerLiteralOrNull == null) {
            return;
        }
        if (integerLiteralOrNull == 0L) {
            if (AnnotationUtils.areSameByClass(otherAnno, NonNegative.class)) {
                FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, otherNode);
                store.insertValue(rec, this.POS);
            }
        } else if (integerLiteralOrNull == -1L && AnnotationUtils.areSameByClass(otherAnno, GTENegativeOne.class)) {
            FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, otherNode);
            store.insertValue(rec, this.NN);
        }
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> result, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        result = super.strengthenAnnotationOfEqualTo(result, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result, this.analysis, secondNode, firstNode);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result;
        }
        CFStore notEqualsStore = notEqualTo ? rfi.thenStore : rfi.elseStore;
        this.notEqualToValue(rfi.left, rfi.right, rfi.rightAnno, notEqualsStore);
        this.notEqualToValue(rfi.right, rfi.left, rfi.leftAnno, notEqualsStore);
        return rfi.newResult;
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        if (rightAnno == null || leftAnno == null) {
            return;
        }
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, left);
        if (AnnotationUtils.areSame(rightAnno, this.GTEN1)) {
            store.insertValue(leftRec, this.NN);
            return;
        }
        if (AnnotationUtils.areSame(rightAnno, this.NN)) {
            store.insertValue(leftRec, this.POS);
            return;
        }
        if (AnnotationUtils.areSame(rightAnno, this.POS)) {
            store.insertValue(leftRec, this.POS);
            return;
        }
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        if (rightAnno == null || leftAnno == null) {
            return;
        }
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)this.aTypeFactory, left);
        AnnotationMirror newLBType = this.aTypeFactory.getQualifierHierarchy().greatestLowerBound(rightAnno, leftAnno);
        store.insertValue(leftRec, newLBType);
    }
}

