/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.minlen;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.MinLenBottom;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.ArrayLen;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.defaults.QualifierDefaults;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class MinLenAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    final AnnotationMirror MIN_LEN_0;
    final AnnotationMirror MIN_LEN_BOTTOM;

    public MinLenAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, MinLen.class);
        builder.setValue((CharSequence)"value", 0);
        this.MIN_LEN_0 = builder.build();
        this.MIN_LEN_BOTTOM = AnnotationUtils.fromClass(this.elements, MinLenBottom.class);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(MinLen.class, MinLenBottom.class));
    }

    @Override
    protected void addCheckedCodeDefaults(QualifierDefaults defaults) {
        defaults.addCheckedCodeDefault(this.MIN_LEN_0, TypeUseLocation.OTHERWISE);
    }

    public ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    public AnnotatedTypeMirror valueTypeFromTree(Tree tree) {
        return this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
    }

    public Integer getMinLenFromValueType(AnnotatedTypeMirror valueType) {
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues == null || possibleValues.size() == 0) {
            return null;
        }
        Integer min2 = Collections.min(possibleValues).intValue();
        return min2;
    }

    private List<Long> possibleValuesFromValueType(AnnotatedTypeMirror valueType) {
        AnnotationMirror anm = valueType.getAnnotation(IntVal.class);
        if (anm == null) {
            return null;
        }
        return ValueAnnotatedTypeFactory.getIntValues(anm);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new MinLenQualifierHierarchy(factory);
    }

    private void addMinLenAnnotationFromArrayLen(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        if (valueType.hasAnnotation(ArrayLen.class)) {
            AnnotationMirror anm = valueType.getAnnotation(ArrayLen.class);
            Integer val = Collections.min(ValueAnnotatedTypeFactory.getArrayLength(anm));
            type.replaceAnnotation(this.createMinLen(val));
        }
    }

    private void addMinLenAnnotationFromStringVal(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        if (valueType.hasAnnotation(StringVal.class)) {
            AnnotationMirror anm = valueType.getAnnotation(StringVal.class);
            String[] values = AnnotationUtils.getElementValueArray(anm, "value", String.class, true).toArray(new String[0]);
            ArrayList<Integer> lengths = new ArrayList<Integer>();
            for (String value : values) {
                lengths.add(value.length());
            }
            int val = (Integer)Collections.min(lengths);
            type.replaceAnnotation(this.createMinLen(val));
        }
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(element, type);
        if (element != null) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(element);
            this.addMinLenAnnotationFromArrayLen(valueType, type);
            this.addMinLenAnnotationFromStringVal(valueType, type);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (tree != null && TreeUtils.isExpressionTree(tree)) {
            AnnotatedTypeMirror valueType = this.valueTypeFromTree(tree);
            this.addMinLenAnnotationFromArrayLen(valueType, type);
            this.addMinLenAnnotationFromStringVal(valueType, type);
        }
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new MinLenTreeAnnotator(this), new PropagationTreeAnnotator(this), new ImplicitsTreeAnnotator(this));
    }

    protected static Integer getMinLenValue(AnnotationMirror annotation) {
        if (annotation == null || AnnotationUtils.areSameByClass(annotation, MinLenBottom.class)) {
            return null;
        }
        return AnnotationUtils.getElementValue(annotation, "value", Integer.class, true);
    }

    public AnnotationMirror createMinLen(@NonNegative int val) {
        if (val == 0) {
            return this.MIN_LEN_0;
        }
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, MinLen.class);
        builder.setValue((CharSequence)"value", val);
        return builder.build();
    }

    public int getMinLenFromString(String arrayExpression, Tree tree, TreePath currentPath) {
        CFValue value;
        FlowExpressions.Receiver array;
        TypeMirror enclosingClass = InternalUtils.typeOf(TreeUtils.enclosingClass(currentPath));
        FlowExpressions.Receiver r = FlowExpressions.internalRepOfPseudoReceiver(currentPath, enclosingClass);
        FlowExpressionParseUtil.FlowExpressionContext context = new FlowExpressionParseUtil.FlowExpressionContext(r, FlowExpressions.getParametersOfEnclosingMethod(this, currentPath), this.getContext());
        try {
            array = FlowExpressionParseUtil.parse(arrayExpression, context, currentPath, true);
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException ex) {
            return 0;
        }
        AnnotationMirror minLenAnno = null;
        if (CFAbstractStore.canInsertReceiver(array) && (value = (CFValue)((CFStore)this.getStoreBefore(tree)).getValue(array)) != null) {
            minLenAnno = AnnotationUtils.getAnnotationByClass(value.getAnnotations(), MinLen.class);
        }
        if (minLenAnno == null) {
            Element ele;
            if (array instanceof FlowExpressions.LocalVariable) {
                ele = ((FlowExpressions.LocalVariable)array).getElement();
                minLenAnno = this.getAnnotatedType(ele).getAnnotationInHierarchy(this.MIN_LEN_0);
            } else if (array instanceof FlowExpressions.FieldAccess) {
                ele = ((FlowExpressions.FieldAccess)array).getField();
                minLenAnno = this.getAnnotatedType(ele).getAnnotationInHierarchy(this.MIN_LEN_0);
            }
        }
        if (minLenAnno == null) {
            return 0;
        }
        Integer minLenValue = MinLenAnnotatedTypeFactory.getMinLenValue(minLenAnno);
        return minLenValue == null ? 0 : minLenValue;
    }

    protected class MinLenTreeAnnotator
    extends TreeAnnotator {
        public MinLenTreeAnnotator(MinLenAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitNewArray(NewArrayTree node, AnnotatedTypeMirror type) {
            AnnotationMirror minLenAnno;
            ExpressionTree dimExp;
            if (node.getDimensions().size() > 0 && TreeUtils.isArrayLengthAccess(dimExp = node.getDimensions().get(0)) && (minLenAnno = MinLenAnnotatedTypeFactory.this.getAnnotationMirror(((MemberSelectTree)dimExp).getExpression(), MinLen.class)) != null) {
                type.addAnnotation(minLenAnno);
            }
            return null;
        }
    }

    private final class MinLenQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        Set<? extends AnnotationMirror> minLenTops;

        public MinLenQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
            this.minLenTops = null;
        }

        @Override
        public Set<? extends AnnotationMirror> getTopAnnotations() {
            if (this.minLenTops == null) {
                Set<AnnotationMirror> tops = AnnotationUtils.createAnnotationSet();
                tops.add(MinLenAnnotatedTypeFactory.this.MIN_LEN_0);
                this.minLenTops = Collections.unmodifiableSet(tops);
            }
            return this.minLenTops;
        }

        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return MinLenAnnotatedTypeFactory.this.MIN_LEN_0;
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSameByClass(a1, MinLenBottom.class)) {
                return a1;
            }
            if (AnnotationUtils.areSameByClass(a2, MinLenBottom.class)) {
                return a2;
            }
            Integer a1Val = AnnotationUtils.getElementValue(a1, "value", Integer.class, true);
            Integer a2Val = AnnotationUtils.getElementValue(a2, "value", Integer.class, true);
            if (a1Val >= a2Val) {
                return a1;
            }
            return a2;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSameByClass(a1, MinLenBottom.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, MinLenBottom.class)) {
                return a1;
            }
            Integer a1Val = AnnotationUtils.getElementValue(a1, "value", Integer.class, true);
            Integer a2Val = AnnotationUtils.getElementValue(a2, "value", Integer.class, true);
            if (a1Val <= a2Val) {
                return a1;
            }
            return a2;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameByClass(rhs, MinLenBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(lhs, MinLenBottom.class)) {
                return false;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, lhs)) {
                Integer rhsVal = AnnotationUtils.getElementValue(rhs, "value", Integer.class, true);
                Integer lhsVal = AnnotationUtils.getElementValue(lhs, "value", Integer.class, true);
                return rhsVal >= lhsVal;
            }
            return false;
        }
    }
}

