/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;

public class SameLenTransfer
extends CFTransfer {
    private SameLenAnnotatedTypeFactory aTypeFactory;
    private AnnotationMirror UNKNOWN;
    private CFAnalysis analysis;

    public SameLenTransfer(CFAnalysis analysis) {
        super(analysis);
        this.analysis = analysis;
        this.aTypeFactory = (SameLenAnnotatedTypeFactory)analysis.getTypeFactory();
        this.UNKNOWN = this.aTypeFactory.UNKNOWN;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode node, TransferInput<CFValue, CFStore> in) {
        ArrayCreationNode acNode;
        TransferResult<CFValue, CFStore> result = super.visitAssignment(node, in);
        if (node.getExpression() instanceof ArrayCreationNode && (acNode = (ArrayCreationNode)node.getExpression()).getDimensions().size() == 1 && this.isArrayLengthAccess(acNode.getDimension(0))) {
            FieldAccessNode arrayLengthNode = (FieldAccessNode)acNode.getDimension(0);
            Node arrayLengthNodeReceiver = arrayLengthNode.getReceiver();
            FlowExpressions.Receiver targetRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget());
            FlowExpressions.Receiver otherRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), arrayLengthNodeReceiver);
            AnnotationMirror arrayLengthAnnotation = this.aTypeFactory.getAnnotatedType(arrayLengthNodeReceiver.getTree()).getAnnotationInHierarchy(this.UNKNOWN);
            AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(otherRec.toString(), targetRec.toString(), arrayLengthAnnotation, this.UNKNOWN);
            result.getRegularStore().clearValue(targetRec);
            result.getRegularStore().insertValue(targetRec, combinedSameLen);
            result.getRegularStore().clearValue(otherRec);
            result.getRegularStore().insertValue(otherRec, combinedSameLen);
        }
        return result;
    }

    private boolean isArrayLengthAccess(Node node) {
        return node instanceof FieldAccessNode && ((FieldAccessNode)node).getFieldName().equals("length") && ((FieldAccessNode)node).getReceiver().getType().getKind() == TypeKind.ARRAY;
    }

    private void refineEq(Node left, Node right, CFStore store) {
        if (this.isArrayLengthAccess(left) && this.isArrayLengthAccess(right)) {
            Node leftReceiverNode = ((FieldAccessNode)left).getReceiver();
            Node rightReceiverNode = ((FieldAccessNode)right).getReceiver();
            FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), leftReceiverNode);
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), rightReceiverNode);
            AnnotationMirror rightReceiverAnno = this.aTypeFactory.getAnnotatedType(rightReceiverNode.getTree()).getAnnotationInHierarchy(this.UNKNOWN);
            AnnotationMirror leftReceiverAnno = this.aTypeFactory.getAnnotatedType(leftReceiverNode.getTree()).getAnnotationInHierarchy(this.UNKNOWN);
            AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(rightRec.toString(), leftRec.toString(), rightReceiverAnno, leftReceiverAnno);
            store.clearValue(leftRec);
            store.clearValue(rightRec);
            store.insertValue(leftRec, combinedSameLen);
            store.insertValue(rightRec, combinedSameLen);
        }
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> result, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        if (notEqualTo) {
            this.refineEq(firstNode, secondNode, result.getElseStore());
        } else {
            this.refineEq(firstNode, secondNode, result.getThenStore());
        }
        return result;
    }
}

