/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.minlen.MinLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.minlen.MinLenChecker;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.samelen.SameLenChecker;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.expressionannotations.ExpressionAnnotationHelper;
import org.checkerframework.framework.util.expressionannotations.ExpressionAnnotationTreeAnnotator;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class UpperBoundAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    private final IndexMethodIdentifier imf;

    public UpperBoundAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationUtils.fromClass(this.elements, UpperBoundUnknown.class);
        this.addAliasedAnnotation(IndexFor.class, this.createLTLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(IndexOrHigh.class, this.createLTEqLengthOfAnnotation(new String[0]));
        this.imf = new IndexMethodIdentifier(this.processingEnv);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(UpperBoundUnknown.class, LTEqLengthOf.class, LTLengthOf.class, LTOMLengthOf.class, UpperBoundBottom.class));
    }

    public static String[] getValue(AnnotationMirror anno) {
        if (!AnnotationUtils.hasElementValue(anno, "value")) {
            return null;
        }
        return AnnotationUtils.getElementValueArray(anno, "value", String.class, true).toArray(new String[0]);
    }

    ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    MinLenAnnotatedTypeFactory getMinLenAnnotatedTypeFactory() {
        return (MinLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(MinLenChecker.class);
    }

    private SameLenAnnotatedTypeFactory getSameLenAnnotatedTypeFactory() {
        return (SameLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SameLenChecker.class);
    }

    @Override
    protected ExpressionAnnotationHelper createExpressionAnnotationHelper() {
        ArrayList<Class<LTOMLengthOf>> annos = new ArrayList<Class<LTOMLengthOf>>();
        annos.add(LTLengthOf.class);
        annos.add(LTEqLengthOf.class);
        annos.add(IndexFor.class);
        annos.add(IndexOrHigh.class);
        annos.add(LTOMLengthOf.class);
        return new ExpressionAnnotationHelper(this, annos){

            @Override
            public TreeAnnotator createExpressionAnnotationTreeAnnotator(AnnotatedTypeFactory factory) {
                return new ExpressionAnnotationTreeAnnotator(factory, this){

                    @Override
                    public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
                        if (TreeUtils.isArrayLengthAccess(tree)) {
                            return null;
                        }
                        return super.visitMemberSelect(tree, type);
                    }
                };
            }
        };
    }

    @Override
    public AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        if (AnnotationUtils.areSameByClass(a, IndexFor.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        if (AnnotationUtils.areSameByClass(a, IndexOrHigh.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTEqLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        return super.aliasedAnnotation(a);
    }

    public int minLenFromExpressionTree(ExpressionTree tree) {
        AnnotatedTypeMirror minLenType = this.getMinLenAnnotatedTypeFactory().getAnnotatedType(tree);
        AnnotationMirror anm = minLenType.getAnnotation(MinLen.class);
        if (anm == null) {
            return -1;
        }
        int minLen = AnnotationUtils.getElementValue(anm, "value", Integer.class, true);
        return minLen;
    }

    public AnnotationMirror sameLenAnnotationFromExpressionTree(ExpressionTree tree) {
        AnnotatedTypeMirror sameLenType = this.getMinLenAnnotatedTypeFactory().getAnnotatedType(tree);
        return sameLenType.getAnnotationInHierarchy(this.UNKNOWN);
    }

    private List<Long> possibleValuesFromValueType(AnnotatedTypeMirror valueType) {
        AnnotationMirror anm = valueType.getAnnotation(IntVal.class);
        if (anm == null) {
            return null;
        }
        return ValueAnnotatedTypeFactory.getIntValues(anm);
    }

    private Integer maybeValFromValueType(AnnotatedTypeMirror valueType) {
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues != null && possibleValues.size() == 1) {
            return possibleValues.get(0).intValue();
        }
        return null;
    }

    public Integer valMaxFromExpressionTree(ExpressionTree tree) {
        AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues == null || possibleValues.size() == 0) {
            return null;
        }
        long valMax = Collections.max(possibleValues);
        return new Integer((int)valMax);
    }

    public boolean isMathMin(Tree methodTree) {
        return this.imf.isMathMin(methodTree, this.processingEnv);
    }

    protected AnnotationMirror createAnnotation(AnnotationMirror anno, String ... names) {
        if (names == null) {
            names = new String[]{};
        }
        if (AnnotationUtils.areSameByClass(anno, LTLengthOf.class)) {
            return this.createLTLengthOfAnnotation(names);
        }
        if (AnnotationUtils.areSameByClass(anno, LTEqLengthOf.class)) {
            return this.createLTEqLengthOfAnnotation(names);
        }
        if (AnnotationUtils.areSameByClass(anno, LTOMLengthOf.class)) {
            return this.createLTOMLengthOfAnnotation(names);
        }
        return this.UNKNOWN;
    }

    protected AnnotationMirror createAnnotation(Class<?> anno, String ... names) {
        if (names == null) {
            names = new String[]{};
        }
        if (LTLengthOf.class.equals(anno)) {
            return this.createLTLengthOfAnnotation(names);
        }
        if (LTEqLengthOf.class.equals(anno)) {
            return this.createLTEqLengthOfAnnotation(names);
        }
        if (LTOMLengthOf.class.equals(anno)) {
            return this.createLTOMLengthOfAnnotation(names);
        }
        return this.UNKNOWN;
    }

    AnnotationMirror createLTOMLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTOMLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    AnnotationMirror createLTLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    AnnotationMirror createLTEqLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTEqLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new UpperBoundQualifierHierarchy(factory);
    }

    private String[] getCombinedNames(AnnotationMirror a1, AnnotationMirror a2) {
        List<String> a1Names = AnnotationUtils.getElementValueArray(a1, "value", String.class, true);
        List<String> a2Names = AnnotationUtils.getElementValueArray(a2, "value", String.class, true);
        HashSet<String> newValues = new HashSet<String>(a1Names.size() + a2Names.size());
        newValues.addAll(a1Names);
        newValues.addAll(a2Names);
        String[] names = newValues.toArray(new String[0]);
        return names;
    }

    private String[] getIntersectingNames(AnnotationMirror a1, AnnotationMirror a2) {
        List<String> a1Names = AnnotationUtils.getElementValueArray(a1, "value", String.class, true);
        List<String> a2Names = AnnotationUtils.getElementValueArray(a2, "value", String.class, true);
        HashSet<String> newValues = new HashSet<String>(Math.min(a1Names.size(), a2Names.size()));
        newValues.addAll(a1Names);
        newValues.retainAll(a2Names);
        String[] names = newValues.toArray(new String[0]);
        return names;
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new UpperBoundTreeAnnotator(this), super.createTreeAnnotator());
    }

    public AnnotationMirror combineFacts(AnnotationMirror a1, AnnotationMirror a2) {
        if (this.qualHierarchy.isSubtype(a1, a2)) {
            return a1;
        }
        if (this.qualHierarchy.isSubtype(a2, a1)) {
            return a2;
        }
        if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
            String[] names = this.getCombinedNames(a1, a2);
            if (AnnotationUtils.areSameByClass(a1, LTLengthOf.class)) {
                return this.createLTLengthOfAnnotation(names);
            }
            if (AnnotationUtils.areSameByClass(a1, LTEqLengthOf.class)) {
                return this.createLTEqLengthOfAnnotation(names);
            }
            if (AnnotationUtils.areSameByClass(a1, LTOMLengthOf.class)) {
                return this.createLTOMLengthOfAnnotation(names);
            }
            return this.UNKNOWN;
        }
        String[] names = this.getCombinedNames(a1, a2);
        if (AnnotationUtils.areSameByClass(a2, LTEqLengthOf.class) || AnnotationUtils.areSameByClass(a1, LTEqLengthOf.class)) {
            return this.createLTEqLengthOfAnnotation(names);
        }
        return this.createLTLengthOfAnnotation(names);
    }

    protected class UpperBoundTreeAnnotator
    extends TreeAnnotator {
        public UpperBoundTreeAnnotator(UpperBoundAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (UpperBoundAnnotatedTypeFactory.this.isMathMin(tree)) {
                AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotatedTypeMirror rightType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(1));
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(leftType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN), rightType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN)));
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isArrayLengthAccess(tree)) {
                String arrName = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, tree.getExpression()).toString();
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTEqLengthOfAnnotation(arrName));
            }
            return (Void)super.visitMemberSelect(tree, type);
        }

        @Override
        public Void visitUnary(UnaryTree tree, AnnotatedTypeMirror typeDst) {
            AnnotatedTypeMirror typeSrc = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
            switch (tree.getKind()) {
                case PREFIX_INCREMENT: {
                    this.handleIncrement(typeSrc, typeDst);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.handleDecrement(typeSrc, typeDst);
                    break;
                }
                case POSTFIX_INCREMENT: {
                    break;
                }
                case POSTFIX_DECREMENT: {
                    break;
                }
            }
            return (Void)super.visitUnary(tree, typeDst);
        }

        private void handleIncrement(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LTOMLengthOf.class)) {
                String[] names = UpperBoundAnnotatedTypeFactory.getValue(typeSrc.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                typeDst.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(names));
            } else if (typeSrc.hasAnnotation(LTLengthOf.class)) {
                String[] names = UpperBoundAnnotatedTypeFactory.getValue(typeSrc.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                typeDst.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTEqLengthOfAnnotation(names));
            } else if (typeSrc.hasAnnotation(LTEqLengthOf.class)) {
                typeDst.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        private void handleDecrement(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LTLengthOf.class) || typeSrc.hasAnnotation(LTOMLengthOf.class)) {
                String[] names = UpperBoundAnnotatedTypeFactory.getValue(typeSrc.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                typeDst.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTOMLengthOfAnnotation(names));
            } else if (typeSrc.hasAnnotation(LTEqLengthOf.class)) {
                String[] names = UpperBoundAnnotatedTypeFactory.getValue(typeSrc.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                typeDst.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(names));
            }
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return super.visitBinary(tree, type);
            }
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            switch (tree.getKind()) {
                case PLUS: {
                    this.addAnnotationForPlus(left, right, type);
                    break;
                }
                case MINUS: {
                    this.addAnnotationForMinus(left, right, type);
                    break;
                }
                case MULTIPLY: {
                    this.addAnnotationForMultiply(left, right, type);
                    break;
                }
                case DIVIDE: {
                    this.addAnnotationForDivide(left, right, type);
                    break;
                }
            }
            return super.visitBinary(tree, type);
        }

        private void addAnnotationForDivide(ExpressionTree left, ExpressionTree right, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror valueTypeRight = UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory().getAnnotatedType(right);
            Integer maybeValRight = UpperBoundAnnotatedTypeFactory.this.maybeValFromValueType(valueTypeRight);
            if (maybeValRight != null) {
                AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(left);
                this.addAnnotationForLiteralDivide(maybeValRight, leftType, type);
            }
        }

        private void addAnnotationForLiteralDivide(int val, AnnotatedTypeMirror nonLiteralType, AnnotatedTypeMirror type) {
            if (nonLiteralType.hasAnnotation(LTLengthOf.class) || nonLiteralType.hasAnnotation(LTOMLengthOf.class)) {
                if (val >= 1) {
                    type.replaceAnnotation(nonLiteralType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                }
            } else if (nonLiteralType.hasAnnotation(LTEqLengthOf.class)) {
                if (val >= 2) {
                    String[] names = UpperBoundAnnotatedTypeFactory.getValue(nonLiteralType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                    type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(names));
                } else if (val == 1) {
                    type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                }
            }
        }

        private void addAnnotationForLiteralPlus(int val, AnnotatedTypeMirror nonLiteralType, AnnotatedTypeMirror type) {
            if (val == 0) {
                type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                return;
            }
            if (val == 1) {
                this.handleIncrement(nonLiteralType, type);
                return;
            }
            if (val == -1) {
                this.handleDecrement(nonLiteralType, type);
                return;
            }
            if (val < -1) {
                if (nonLiteralType.hasAnnotation(LTLengthOf.class) || nonLiteralType.hasAnnotation(LTOMLengthOf.class) || nonLiteralType.hasAnnotation(LTEqLengthOf.class)) {
                    String[] names = UpperBoundAnnotatedTypeFactory.getValue(nonLiteralType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN));
                    type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTOMLengthOfAnnotation(names));
                    return;
                }
                type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return;
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForPlus(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            AnnotatedTypeMirror valueTypeRight = UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory().getAnnotatedType(rightExpr);
            Integer maybeValRight = UpperBoundAnnotatedTypeFactory.this.maybeValFromValueType(valueTypeRight);
            if (maybeValRight != null) {
                this.addAnnotationForLiteralPlus(maybeValRight, leftType, type);
                return;
            }
            AnnotatedTypeMirror rightType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            AnnotatedTypeMirror valueTypeLeft = UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory().getAnnotatedType(rightExpr);
            Integer maybeValLeft = UpperBoundAnnotatedTypeFactory.this.maybeValFromValueType(valueTypeLeft);
            if (maybeValLeft != null) {
                this.addAnnotationForLiteralPlus(maybeValLeft, rightType, type);
                return;
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private boolean checkForMathRandomSpecialCase(ExpressionTree randTree, ExpressionTree arrLenTree, AnnotatedTypeMirror type) {
            if (randTree.getKind() == Tree.Kind.METHOD_INVOCATION && TreeUtils.isArrayLengthAccess(arrLenTree)) {
                MemberSelectTree mstree = (MemberSelectTree)arrLenTree;
                MethodInvocationTree mitree = (MethodInvocationTree)randTree;
                if (UpperBoundAnnotatedTypeFactory.this.imf.isMathRandom(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(mstree.getExpression().toString()));
                    return true;
                }
                if (UpperBoundAnnotatedTypeFactory.this.imf.isRandomNextDouble(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(mstree.getExpression().toString()));
                    return true;
                }
            }
            return false;
        }

        private void addAnnotationForMultiply(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            if (this.checkForMathRandomSpecialCase(rightExpr, leftExpr, type) || this.checkForMathRandomSpecialCase(leftExpr, rightExpr, type)) {
                return;
            }
        }

        private void addAnnotationForMinus(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            AnnotatedTypeMirror valueTypeRight = UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory().getAnnotatedType(rightExpr);
            Integer maybeValRight = UpperBoundAnnotatedTypeFactory.this.maybeValFromValueType(valueTypeRight);
            if (maybeValRight != null) {
                this.addAnnotationForLiteralPlus(-1 * maybeValRight, leftType, type);
                return;
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
        }
    }

    protected final class UpperBoundQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public UpperBoundQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a1;
            }
            if (this.isSubtype(a2, a1)) {
                return a2;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                String[] names = UpperBoundAnnotatedTypeFactory.this.getCombinedNames(a1, a2);
                if (AnnotationUtils.areSameByClass(a1, LTLengthOf.class)) {
                    return UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(names);
                }
                if (AnnotationUtils.areSameByClass(a1, LTEqLengthOf.class)) {
                    return UpperBoundAnnotatedTypeFactory.this.createLTEqLengthOfAnnotation(names);
                }
                if (AnnotationUtils.areSameByClass(a1, LTOMLengthOf.class)) {
                    return UpperBoundAnnotatedTypeFactory.this.createLTOMLengthOfAnnotation(names);
                }
                return UpperBoundAnnotatedTypeFactory.this.UNKNOWN;
            }
            String[] names = UpperBoundAnnotatedTypeFactory.this.getCombinedNames(a1, a2);
            if (AnnotationUtils.areSameByClass(a2, LTOMLengthOf.class) || AnnotationUtils.areSameByClass(a1, LTOMLengthOf.class)) {
                return UpperBoundAnnotatedTypeFactory.this.createLTOMLengthOfAnnotation(names);
            }
            return UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(names);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            if (AnnotationUtils.areSameIgnoringValues(a1, a2)) {
                String[] names = UpperBoundAnnotatedTypeFactory.this.getIntersectingNames(a1, a2);
                return UpperBoundAnnotatedTypeFactory.this.createAnnotation(a1, names);
            }
            if (AnnotationUtils.areSameByClass(a1, LTLengthOf.class) && AnnotationUtils.areSameByClass(a2, LTEqLengthOf.class) || AnnotationUtils.areSameByClass(a1, LTEqLengthOf.class) && AnnotationUtils.areSameByClass(a2, LTLengthOf.class)) {
                String[] names = UpperBoundAnnotatedTypeFactory.this.getIntersectingNames(a1, a2);
                return UpperBoundAnnotatedTypeFactory.this.createLTEqLengthOfAnnotation(names);
            }
            if (AnnotationUtils.areSameByClass(a1, LTOMLengthOf.class) && AnnotationUtils.areSameByClass(a2, LTEqLengthOf.class) || AnnotationUtils.areSameByClass(a1, LTEqLengthOf.class) && AnnotationUtils.areSameByClass(a2, LTOMLengthOf.class)) {
                String[] names = UpperBoundAnnotatedTypeFactory.this.getIntersectingNames(a1, a2);
                return UpperBoundAnnotatedTypeFactory.this.createLTEqLengthOfAnnotation(names);
            }
            if (AnnotationUtils.areSameByClass(a1, LTLengthOf.class) && AnnotationUtils.areSameByClass(a2, LTOMLengthOf.class) || AnnotationUtils.areSameByClass(a1, LTOMLengthOf.class) && AnnotationUtils.areSameByClass(a2, LTLengthOf.class)) {
                String[] names = UpperBoundAnnotatedTypeFactory.this.getIntersectingNames(a1, a2);
                return UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(names);
            }
            return UpperBoundAnnotatedTypeFactory.this.UNKNOWN;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameByClass(lhs, UpperBoundUnknown.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(rhs, UpperBoundUnknown.class)) {
                return false;
            }
            if (AnnotationUtils.areSameByClass(rhs, UpperBoundBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(lhs, UpperBoundBottom.class)) {
                return false;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                List<Object> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Object.class, true);
                List<Object> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Object.class, true);
                return rhsValues.containsAll(lhsValues);
            }
            if (this.isSubtypeRelaxed(rhs, lhs)) {
                List<Object> lhsValues = AnnotationUtils.getElementValueArray(lhs, "value", Object.class, true);
                List<Object> rhsValues = AnnotationUtils.getElementValueArray(rhs, "value", Object.class, true);
                return rhsValues.containsAll(lhsValues);
            }
            return false;
        }

        private boolean isSubtypeRelaxed(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(lhs, rhs)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(lhs, UpperBoundUnknown.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(rhs, UpperBoundUnknown.class)) {
                return false;
            }
            if (AnnotationUtils.areSameByClass(lhs, LTEqLengthOf.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(rhs, LTEqLengthOf.class)) {
                return false;
            }
            if (AnnotationUtils.areSameByClass(rhs, UpperBoundBottom.class)) {
                return true;
            }
            return AnnotationUtils.areSameByClass(rhs, LTOMLengthOf.class) && AnnotationUtils.areSameByClass(lhs, LTLengthOf.class);
        }
    }
}

