/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexRefinementInfo;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class UpperBoundTransfer
extends IndexAbstractTransfer {
    private UpperBoundAnnotatedTypeFactory atypeFactory;
    private QualifierHierarchy qualifierHierarchy;

    public UpperBoundTransfer(CFAnalysis analysis) {
        super(analysis);
        this.atypeFactory = (UpperBoundAnnotatedTypeFactory)analysis.getTypeFactory();
        this.qualifierHierarchy = this.atypeFactory.getQualifierHierarchy();
    }

    private void combineFacts(CFStore store, FlowExpressions.Receiver receiver, AnnotationMirror oldAM, AnnotationMirror newAM) {
        AnnotationMirror combinedAM = this.atypeFactory.combineFacts(oldAM, newAM);
        store.clearValue(receiver);
        store.insertValue(receiver, combinedAM);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode node, TransferInput<CFValue, CFStore> in) {
        AnnotationMirror UNKNOWN = this.atypeFactory.UNKNOWN;
        TransferResult<CFValue, CFStore> result = super.visitAssignment(node, in);
        if (node.getExpression() instanceof ArrayCreationNode) {
            ArrayCreationNode acNode = (ArrayCreationNode)node.getExpression();
            CFStore store = result.getRegularStore();
            List<Node> nodeList = acNode.getDimensions();
            if (nodeList.size() < 1) {
                return result;
            }
            Node dim = acNode.getDimension(0);
            FlowExpressions.Receiver dimRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), dim);
            FlowExpressions.Receiver arrayRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget());
            Set<AnnotationMirror> oldType = in.getValueOfSubNode(dim).getAnnotations();
            AnnotationMirror oldAM = this.qualifierHierarchy.findAnnotationInHierarchy(oldType, UNKNOWN);
            AnnotationMirror newAM = this.atypeFactory.createLTEqLengthOfAnnotation(arrayRec.toString());
            this.combineFacts(store, dimRec, oldAM, newAM);
        }
        return result;
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> res, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        TransferResult<CFValue, CFStore> result = super.strengthenAnnotationOfEqualTo(res, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result, this.analysis, firstNode, secondNode);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result;
        }
        CFStore equalsStore = notEqualTo ? rfi.elseStore : rfi.thenStore;
        CFStore notEqualStore = notEqualTo ? rfi.thenStore : rfi.elseStore;
        this.refineEq(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, equalsStore);
        this.refineNeq(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, notEqualStore);
        return rfi.newResult;
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        Class nextHigherClass;
        if (AnnotationUtils.areSameByClass(leftAnno, LTEqLengthOf.class)) {
            nextHigherClass = LTLengthOf.class;
        } else if (AnnotationUtils.areSameByClass(leftAnno, LTLengthOf.class)) {
            nextHigherClass = LTOMLengthOf.class;
        } else {
            return;
        }
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
        String[] names = UpperBoundAnnotatedTypeFactory.getValue(leftAnno);
        this.combineFacts(store, rightRec, rightAnno, this.atypeFactory.createAnnotation(nextHigherClass, names));
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        if (AnnotationUtils.areSameByClass(leftAnno, LTLengthOf.class) || AnnotationUtils.areSameByClass(leftAnno, LTEqLengthOf.class) || AnnotationUtils.areSameByClass(leftAnno, LTOMLengthOf.class)) {
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
            this.combineFacts(store, rightRec, rightAnno, leftAnno);
        }
    }

    private void refineEq(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        if (rightAnno == null || leftAnno == null) {
            return;
        }
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), left);
        this.combineFacts(store, rightRec, rightAnno, leftAnno);
        this.combineFacts(store, leftRec, rightAnno, leftAnno);
    }

    private void refineNeq(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        this.refineNotEqualLtlandLteql(leftAnno, left, right, store);
        this.refineNotEqualLtlandLteql(rightAnno, right, left, store);
    }

    private void refineNotEqualLtlandLteql(AnnotationMirror leftAnno, Node left, Node right, CFStore store) {
        Class nextHigherClass;
        if (AnnotationUtils.areSameByClass(leftAnno, LTEqLengthOf.class)) {
            nextHigherClass = LTLengthOf.class;
        } else if (AnnotationUtils.areSameByClass(leftAnno, LTLengthOf.class)) {
            nextHigherClass = LTOMLengthOf.class;
        } else {
            return;
        }
        if (this.isArrayLengthFieldAccess(right)) {
            FlowExpressions.FieldAccess fieldAccess = FlowExpressions.internalReprOfFieldAccess(this.atypeFactory, (FieldAccessNode)right);
            String arrayName = fieldAccess.getReceiver().toString();
            String[] names = UpperBoundAnnotatedTypeFactory.getValue(leftAnno);
            if (names.length != 1) {
                return;
            }
            if (names[0].equals(arrayName)) {
                store.insertValue(FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), left), this.atypeFactory.createAnnotation(nextHigherClass, arrayName));
            }
        }
    }
}

