/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class UpperBoundVisitor
extends BaseTypeVisitor<UpperBoundAnnotatedTypeFactory> {
    private static final String UPPER_BOUND = "array.access.unsafe.high";

    public UpperBoundVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Void type) {
        ExpressionTree indexTree = tree.getIndex();
        ExpressionTree arrTree = tree.getExpression();
        this.visitAccess(indexTree, arrTree);
        return super.visitArrayAccess(tree, type);
    }

    private void visitAccess(ExpressionTree indexTree, ExpressionTree arrTree) {
        AnnotationMirror sameLenAnno;
        AnnotatedTypeMirror indexType;
        String arrName = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, arrTree).toString();
        if (this.indexTypeContainsArray(arrName, indexType = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(indexTree), sameLenAnno = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).sameLenAnnotationFromExpressionTree(arrTree))) {
            return;
        }
        Integer valMax = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).valMaxFromExpressionTree(indexTree);
        int minLen = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).minLenFromExpressionTree(arrTree);
        if (valMax != null && minLen != -1 && valMax < minLen) {
            return;
        }
        this.checker.report(Result.failure(UPPER_BOUND, indexType.toString(), arrName, arrName), indexTree);
    }

    private boolean indexTypeContainsArray(String array, AnnotatedTypeMirror ubType, AnnotationMirror sameLenAnno) {
        String[] arrayNamesFromUBAnno;
        if (ubType.hasAnnotation(LTLengthOf.class)) {
            arrayNamesFromUBAnno = UpperBoundAnnotatedTypeFactory.getValue(ubType.getAnnotation(LTLengthOf.class));
        } else if (ubType.hasAnnotation(LTOMLengthOf.class)) {
            arrayNamesFromUBAnno = UpperBoundAnnotatedTypeFactory.getValue(ubType.getAnnotation(LTOMLengthOf.class));
        } else {
            return false;
        }
        HashSet<String> arrays = new HashSet<String>();
        arrays.add(array);
        if (sameLenAnno != null && AnnotationUtils.areSameByClass(sameLenAnno, SameLen.class) && AnnotationUtils.hasElementValue(sameLenAnno, "value")) {
            List<String> slNames = AnnotationUtils.getElementValueArray(sameLenAnno, "value", String.class, true);
            arrays.addAll(slNames);
        }
        for (String st : arrayNamesFromUBAnno) {
            if (!arrays.contains(st)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        Integer rhsValue = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).valMaxFromExpressionTree(valueExp);
        if (rhsValue == null) {
            super.commonAssignmentCheck(varType, valueExp, errorKey);
            return;
        }
        if (rhsValue == 0) {
            return;
        }
        AnnotationMirror upperBoundAnno = varType.getAnnotationInHierarchy(((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        boolean minLenMatches = true;
        String[] arrayNames = UpperBoundAnnotatedTypeFactory.getValue(upperBoundAnno);
        if (arrayNames == null) {
            super.commonAssignmentCheck(varType, valueExp, errorKey);
            return;
        }
        for (String arrayName : arrayNames) {
            int minLen = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getMinLenAnnotatedTypeFactory().getMinLenFromString(arrayName, valueExp, this.getCurrentPath());
            if (AnnotationUtils.areSameByClass(upperBoundAnno, LTLengthOf.class)) {
                if (minLen > rhsValue) continue;
                minLenMatches = false;
                continue;
            }
            if (AnnotationUtils.areSameByClass(upperBoundAnno, LTEqLengthOf.class)) {
                if (minLen >= rhsValue) continue;
                minLenMatches = false;
                continue;
            }
            if (!AnnotationUtils.areSameByClass(upperBoundAnno, LTOMLengthOf.class) || minLen - 1 > rhsValue) continue;
            minLenMatches = false;
        }
        if (!minLenMatches) {
            super.commonAssignmentCheck(varType, valueExp, errorKey);
        }
    }
}

