/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import java.util.ArrayList;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AbstractAtmComboVisitor;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TypesUtils;

public class AsSuperVisitor
extends AbstractAtmComboVisitor<AnnotatedTypeMirror, Void> {
    private final Types types;
    private final AnnotatedTypeFactory annotatedTypeFactory;
    private boolean isUninferredTypeAgrument = false;

    public AsSuperVisitor(AnnotatedTypeFactory annotatedTypeFactory) {
        this.annotatedTypeFactory = annotatedTypeFactory;
        this.types = annotatedTypeFactory.types;
    }

    public <T extends AnnotatedTypeMirror> T asSuper(AnnotatedTypeMirror type, T superType) {
        if (type == null || superType == null) {
            ErrorReporter.errorAbort("AsSuperVisitor type and supertype cannot be null.");
            return null;
        }
        if (type == superType) {
            return (T)type.deepCopy();
        }
        AnnotatedTypeMirror copyType = type.deepCopy();
        AnnotatedTypeMirror copySuperType = superType.deepCopy();
        this.reset();
        AnnotatedTypeMirror result = this.visit(copyType, copySuperType, null);
        if (result == null) {
            ErrorReporter.errorAbort("AsSuperVisitor returned null.\ntype: %s\nsuperType: %s", type, copySuperType);
        }
        return (T)result;
    }

    private void reset() {
        this.isUninferredTypeAgrument = false;
    }

    @Override
    public AnnotatedTypeMirror visit(AnnotatedTypeMirror type, AnnotatedTypeMirror superType, Void p) {
        this.ensurePrimaryIsCorrectForUnionsAndIntersections(type);
        return (AnnotatedTypeMirror)super.visit(type, superType, p);
    }

    private void ensurePrimaryIsCorrectForUnionsAndIntersections(AnnotatedTypeMirror type) {
        if (type.getKind() == TypeKind.INTERSECTION) {
            AnnotatedTypeMirror.AnnotatedIntersectionType intersectionType = (AnnotatedTypeMirror.AnnotatedIntersectionType)type;
            Set<AnnotationMirror> glbs = null;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType directST : intersectionType.directSuperTypes()) {
                if (glbs == null) {
                    glbs = directST.getAnnotations();
                    continue;
                }
                Set<AnnotationMirror> newGlbs = AnnotationUtils.createAnnotationSet();
                for (AnnotationMirror glb : glbs) {
                    AnnotationMirror anno = directST.getAnnotationInHierarchy(glb);
                    newGlbs.add(this.annotatedTypeFactory.getQualifierHierarchy().greatestLowerBound(anno, glb));
                }
                glbs = newGlbs;
            }
            type.replaceAnnotations(glbs);
        } else if (type.getKind() == TypeKind.UNION) {
            AnnotatedTypeMirror.AnnotatedUnionType annotatedUnionType = (AnnotatedTypeMirror.AnnotatedUnionType)type;
            Set<AnnotationMirror> lubs = null;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType altern : annotatedUnionType.getAlternatives()) {
                if (lubs == null) {
                    lubs = altern.getAnnotations();
                    continue;
                }
                Set<AnnotationMirror> newLubs = AnnotationUtils.createAnnotationSet();
                for (AnnotationMirror lub : lubs) {
                    AnnotationMirror anno = altern.getAnnotationInHierarchy(lub);
                    newLubs.add(this.annotatedTypeFactory.getQualifierHierarchy().leastUpperBound(anno, lub));
                }
                lubs = newLubs;
            }
            type.replaceAnnotations(lubs);
        }
    }

    @Override
    protected String defaultErrorMessage(AnnotatedTypeMirror type, AnnotatedTypeMirror superType, Void p) {
        return String.format("AsSuperVisitor: Unexpected combination: type: %s superType: %s.\ntype: %s\nsuperType: %s", new Object[]{type.getKind(), superType.getKind(), type, superType});
    }

    private AnnotatedTypeMirror errorTypeNotErasedSubtypeOfSuperType(AnnotatedTypeMirror type, AnnotatedTypeMirror superType, Void p) {
        if (TypesUtils.isString(superType.getUnderlyingType())) {
            return this.visit((AnnotatedTypeMirror)this.annotatedTypeFactory.getStringType(type), superType, p);
        }
        if (this.isUninferredTypeAgrument) {
            return this.copyPrimaryAnnos(type, superType);
        }
        ErrorReporter.errorAbort("AsSuperVisitor: type is not an erased subtype of supertype.\ntype: %s\nsuperType: %s", type, superType);
        return null;
    }

    private AnnotatedTypeMirror copyPrimaryAnnos(AnnotatedTypeMirror from, AnnotatedTypeMirror to) {
        to.replaceAnnotations(new ArrayList<AnnotationMirror>(from.getAnnotations()));
        if (to.getKind() == TypeKind.UNION) {
            AnnotatedTypeMirror.AnnotatedUnionType unionType = (AnnotatedTypeMirror.AnnotatedUnionType)to;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType altern : unionType.getAlternatives()) {
                altern.addMissingAnnotations(unionType.getAnnotations());
            }
        }
        return to;
    }

    private AnnotatedTypeMirror asSuperWildcardLowerBound(AnnotatedTypeMirror type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        AnnotatedTypeMirror lowerBound = superType.getSuperBound();
        return this.asSuperLowerBound(type, p, lowerBound);
    }

    private AnnotatedTypeMirror asSuperTypevarLowerBound(AnnotatedTypeMirror type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        AnnotatedTypeMirror lowerBound = superType.getLowerBound();
        return this.asSuperLowerBound(type, p, lowerBound);
    }

    private AnnotatedTypeMirror asSuperLowerBound(AnnotatedTypeMirror type, Void p, AnnotatedTypeMirror lowerBound) {
        if (lowerBound.getKind() == TypeKind.NULL) {
            Set<AnnotationMirror> typeLowerBound = AnnotatedTypes.findEffectiveLowerBoundAnnotations(this.annotatedTypeFactory.getQualifierHierarchy(), type);
            lowerBound.replaceAnnotations(typeLowerBound);
            return lowerBound;
        }
        lowerBound = this.visit(type, lowerBound, p);
        return lowerBound;
    }

    private boolean isErasedJavaSubtype(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedDeclaredType supertype) {
        TypeMirror javaSubtype = this.types.erasure(subtype.getUnderlyingType());
        TypeMirror javaSupertype = this.types.erasure(supertype.getUnderlyingType());
        return this.types.isSubtype(javaSubtype, javaSupertype);
    }

    private boolean isErasedJavaSubtype(AnnotatedTypeMirror.AnnotatedDeclaredType subtype, AnnotatedTypeMirror.AnnotatedUnionType supertype) {
        for (AnnotatedTypeMirror.AnnotatedDeclaredType alternSuperType : supertype.getAlternatives()) {
            if (this.isErasedJavaSubtype(subtype, alternSuperType)) continue;
            return false;
        }
        return true;
    }

    private boolean areErasedJavaTypesEquivalent(AnnotatedTypeMirror.AnnotatedDeclaredType typeA, AnnotatedTypeMirror.AnnotatedDeclaredType typeB) {
        TypeMirror underlyingTypeA = this.types.erasure(typeA.getUnderlyingType());
        TypeMirror underlyingTypeB = this.types.erasure(typeB.getUnderlyingType());
        return this.types.isSameType(underlyingTypeA, underlyingTypeB);
    }

    @Override
    public AnnotatedTypeMirror visitArray_Array(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror.AnnotatedArrayType superType, Void p) {
        AnnotatedTypeMirror asSuperCT = this.visit(type.getComponentType(), superType.getComponentType(), p);
        superType.setComponentType(asSuperCT);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitArray_Intersection(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror.AnnotatedIntersectionType superType, Void p) {
        for (AnnotatedTypeMirror annotatedTypeMirror : superType.directSuperTypes()) {
            if (!(TypesUtils.isObject(annotatedTypeMirror.getUnderlyingType()) || TypesUtils.isDeclaredOfName(annotatedTypeMirror.getUnderlyingType(), "java.lang.Cloneable") || TypesUtils.isDeclaredOfName(annotatedTypeMirror.getUnderlyingType(), "java.io.Serializable"))) {
                return this.errorTypeNotErasedSubtypeOfSuperType(type, superType, p);
            }
            this.copyPrimaryAnnos(type, annotatedTypeMirror);
        }
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitArray_Declared(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror.AnnotatedDeclaredType superType, Void p) {
        TypeElement possibleArray;
        TypeElement array = InternalUtils.getTypeElement(type.getUnderlyingType());
        boolean isArrayClass = array.equals(possibleArray = InternalUtils.getTypeElement(superType.getUnderlyingType()));
        if (isArrayClass || TypesUtils.isObject(superType.getUnderlyingType()) || TypesUtils.isDeclaredOfName(superType.getUnderlyingType(), "java.lang.Cloneable") || TypesUtils.isDeclaredOfName(superType.getUnderlyingType(), "java.io.Serializable")) {
            return this.copyPrimaryAnnos(type, superType);
        }
        return this.errorTypeNotErasedSubtypeOfSuperType(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitArray_Typevar(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit((AnnotatedTypeMirror)type, superType.getUpperBound(), p);
        superType.setUpperBound(upperBound);
        AnnotatedTypeMirror lowerBound = this.asSuperTypevarLowerBound(type, superType, p);
        superType.setLowerBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitArray_Wildcard(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit((AnnotatedTypeMirror)type, superType.getExtendsBound(), p);
        superType.setExtendsBound(upperBound);
        AnnotatedTypeMirror lowerBound = this.asSuperWildcardLowerBound(type, superType, p);
        superType.setSuperBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitDeclared_Declared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror.AnnotatedDeclaredType superType, Void p) {
        if (this.areErasedJavaTypesEquivalent(type, superType)) {
            return type;
        }
        for (AnnotatedTypeMirror.AnnotatedDeclaredType dst : type.directSuperTypes()) {
            if (!this.isErasedJavaSubtype(dst, superType)) continue;
            return this.visit((AnnotatedTypeMirror)dst, (AnnotatedTypeMirror)superType, p);
        }
        return this.errorTypeNotErasedSubtypeOfSuperType(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitDeclared_Intersection(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror.AnnotatedIntersectionType superType, Void p) {
        ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> newDirectSupertypes = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType superDirect : superType.directSuperTypes()) {
            AnnotatedTypeMirror.AnnotatedDeclaredType found = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.visit((AnnotatedTypeMirror)type, (AnnotatedTypeMirror)superDirect, p);
            newDirectSupertypes.add(found);
        }
        superType.setDirectSuperTypes(newDirectSupertypes);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitDeclared_Primitive(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror.AnnotatedPrimitiveType superType, Void p) {
        if (!TypesUtils.isBoxedPrimitive(type.getUnderlyingType())) {
            ErrorReporter.errorAbort("AsSuperVisitor Declared_Primitive: type is not a box primitive.");
        }
        AnnotatedTypeMirror.AnnotatedPrimitiveType unboxedType = this.annotatedTypeFactory.getUnboxedType(type);
        return this.copyPrimaryAnnos(unboxedType, superType);
    }

    @Override
    public AnnotatedTypeMirror visitDeclared_Typevar(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit((AnnotatedTypeMirror)type, superType.getUpperBound(), p);
        superType.setUpperBound(upperBound);
        AnnotatedTypeMirror lowerBound = this.asSuperTypevarLowerBound(type, superType, p);
        superType.setLowerBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitDeclared_Union(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror.AnnotatedUnionType superType, Void p) {
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitDeclared_Wildcard(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit((AnnotatedTypeMirror)type, superType.getExtendsBound(), p);
        superType.setExtendsBound(upperBound);
        AnnotatedTypeMirror lowerBound = this.asSuperWildcardLowerBound(type, superType, p);
        superType.setSuperBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitIntersection_Declared(AnnotatedTypeMirror.AnnotatedIntersectionType type, AnnotatedTypeMirror.AnnotatedDeclaredType superType, Void p) {
        for (AnnotatedTypeMirror.AnnotatedDeclaredType typeDirect : type.directSuperTypes()) {
            if (!this.isErasedJavaSubtype(typeDirect, superType)) continue;
            AnnotatedTypeMirror asSuper = this.visit((AnnotatedTypeMirror)typeDirect, (AnnotatedTypeMirror)superType, p);
            return this.copyPrimaryAnnos(type, asSuper);
        }
        return this.errorTypeNotErasedSubtypeOfSuperType(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitIntersection_Intersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, AnnotatedTypeMirror.AnnotatedIntersectionType superType, Void p) {
        ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType> newDirectSupertypes = new ArrayList<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        for (AnnotatedTypeMirror.AnnotatedDeclaredType superDirect : superType.directSuperTypes()) {
            AnnotatedTypeMirror.AnnotatedDeclaredType found = null;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType typeDirect : type.directSuperTypes()) {
                if (!this.isErasedJavaSubtype(typeDirect, superDirect)) continue;
                found = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.visit((AnnotatedTypeMirror)typeDirect, (AnnotatedTypeMirror)superDirect, p);
                newDirectSupertypes.add(found);
                break;
            }
            if (found != null) continue;
            ErrorReporter.errorAbort("AsSuperVisitor visitIntersection_Intersection:\ntype: %s superType: %s", type, superType);
        }
        superType.setDirectSuperTypes(newDirectSupertypes);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitIntersection_Primitive(AnnotatedTypeMirror.AnnotatedIntersectionType type, AnnotatedTypeMirror.AnnotatedPrimitiveType superType, Void p) {
        for (AnnotatedTypeMirror.AnnotatedDeclaredType typeDirect : type.directSuperTypes()) {
            if (!TypesUtils.isBoxedPrimitive(typeDirect.getUnderlyingType())) continue;
            AnnotatedTypeMirror asSuper = this.visit((AnnotatedTypeMirror)typeDirect, (AnnotatedTypeMirror)superType, p);
            return this.copyPrimaryAnnos(type, asSuper);
        }
        ErrorReporter.errorAbort("AsSuperVisitor visitIntersection_Primitive:\ntype: %s superType: %s", type, superType);
        return null;
    }

    @Override
    public AnnotatedTypeMirror visitIntersection_Typevar(AnnotatedTypeMirror.AnnotatedIntersectionType type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit((AnnotatedTypeMirror)type, superType.getUpperBound(), p);
        superType.setUpperBound(upperBound);
        AnnotatedTypeMirror lowerBound = this.asSuperTypevarLowerBound(type, superType, p);
        superType.setLowerBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitIntersection_Union(AnnotatedTypeMirror.AnnotatedIntersectionType type, AnnotatedTypeMirror.AnnotatedUnionType superType, Void p) {
        for (AnnotatedTypeMirror.AnnotatedDeclaredType typeDirect : type.directSuperTypes()) {
            if (!this.isErasedJavaSubtype(typeDirect, superType)) continue;
            AnnotatedTypeMirror asSuper = this.visit((AnnotatedTypeMirror)typeDirect, (AnnotatedTypeMirror)superType, p);
            return this.copyPrimaryAnnos(type, asSuper);
        }
        ErrorReporter.errorAbort("AsSuperVisitor visitIntersection_Union:\ntype: %s\nsuperType: %s", type, superType);
        return null;
    }

    @Override
    public AnnotatedTypeMirror visitIntersection_Wildcard(AnnotatedTypeMirror.AnnotatedIntersectionType type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit((AnnotatedTypeMirror)type, superType.getExtendsBound(), p);
        superType.setExtendsBound(upperBound);
        AnnotatedTypeMirror lowerBound = this.asSuperWildcardLowerBound(type, superType, p);
        superType.setSuperBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitPrimitive_Primitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror.AnnotatedPrimitiveType superType, Void p) {
        return this.copyPrimaryAnnos(type, superType);
    }

    private AnnotatedTypeMirror visitPrimitive_Other(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror superType, Void p) {
        return this.visit((AnnotatedTypeMirror)this.annotatedTypeFactory.getBoxedType(type), superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitPrimitive_Declared(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror.AnnotatedDeclaredType superType, Void p) {
        PrimitiveType unboxedSuper;
        if (TypesUtils.isBoxedPrimitive(superType.getUnderlyingType()) && (unboxedSuper = this.types.unboxedType(superType.getUnderlyingType())).getKind() != type.getKind() && this.canBeNarrowingPrimitiveConversion(unboxedSuper)) {
            AnnotatedTypeMirror.AnnotatedPrimitiveType narrowedType = this.annotatedTypeFactory.getNarrowedPrimitive(type, unboxedSuper);
            return this.visit((AnnotatedTypeMirror)narrowedType, (AnnotatedTypeMirror)superType, p);
        }
        return this.visitPrimitive_Other(type, superType, p);
    }

    private boolean canBeNarrowingPrimitiveConversion(TypeMirror type) {
        TypeMirror unboxedType = TypesUtils.isBoxedPrimitive(type) ? this.types.unboxedType(type) : type;
        TypeKind unboxedKind = unboxedType.getKind();
        return unboxedKind == TypeKind.BYTE || unboxedKind == TypeKind.SHORT || unboxedKind == TypeKind.CHAR;
    }

    @Override
    public AnnotatedTypeMirror visitPrimitive_Intersection(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror.AnnotatedIntersectionType superType, Void p) {
        return this.visitPrimitive_Other(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitPrimitive_Typevar(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        return this.visitPrimitive_Other(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitPrimitive_Union(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror.AnnotatedUnionType superType, Void p) {
        return this.visitPrimitive_Other(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitPrimitive_Wildcard(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        return this.visitPrimitive_Other(type, superType, p);
    }

    private AnnotatedTypeMirror visitTypevar_NotTypevarNorWildcard(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror superType, Void p) {
        AnnotatedTypeMirror asSuper = this.visit(type.getUpperBound(), superType, p);
        return this.copyPrimaryAnnos(type, asSuper);
    }

    @Override
    public AnnotatedTypeMirror visitTypevar_Declared(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedDeclaredType superType, Void p) {
        return this.visitTypevar_NotTypevarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitTypevar_Intersection(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedIntersectionType superType, Void p) {
        return this.visitTypevar_NotTypevarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitTypevar_Primitive(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedPrimitiveType superType, Void p) {
        return this.visitTypevar_NotTypevarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitTypevar_Typevar(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit(type.getUpperBound(), superType.getUpperBound(), p);
        superType.setUpperBound(upperBound);
        AnnotatedTypeMirror lowerBound = type.getLowerBound().getKind() == TypeKind.NULL && superType.getLowerBound().getKind() == TypeKind.NULL ? this.copyPrimaryAnnos(type.getLowerBound(), superType.getLowerBound()) : (type.getLowerBound().getKind() == TypeKind.NULL ? this.visit((AnnotatedTypeMirror)type, superType.getLowerBound(), p) : this.asSuperTypevarLowerBound(type.getLowerBound(), superType, p));
        superType.setLowerBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitTypevar_Union(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedUnionType superType, Void p) {
        return this.visitTypevar_NotTypevarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitTypevar_Wildcard(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        AnnotatedTypeMirror upperBound = this.visit(type.getUpperBound(), superType.getExtendsBound(), p);
        superType.setExtendsBound(upperBound);
        AnnotatedTypeMirror lowerBound = type.getLowerBound().getKind() == TypeKind.NULL && superType.getSuperBound().getKind() == TypeKind.NULL ? this.copyPrimaryAnnos(type.getLowerBound(), superType.getSuperBound()) : (type.getLowerBound().getKind() == TypeKind.NULL ? this.visit((AnnotatedTypeMirror)type, superType.getSuperBound(), p) : this.asSuperWildcardLowerBound(type.getLowerBound(), superType, p));
        superType.setSuperBound(lowerBound);
        return this.copyPrimaryAnnos(type, superType);
    }

    private AnnotatedTypeMirror visitUnion_Other(AnnotatedTypeMirror.AnnotatedUnionType type, AnnotatedTypeMirror superType, Void p) {
        AnnotatedTypeMirror asSuper = this.visit((AnnotatedTypeMirror)type.getAlternatives().get(0), superType, p);
        return this.copyPrimaryAnnos(type, asSuper);
    }

    @Override
    public AnnotatedTypeMirror visitUnion_Declared(AnnotatedTypeMirror.AnnotatedUnionType type, AnnotatedTypeMirror.AnnotatedDeclaredType superType, Void p) {
        return this.visitUnion_Other(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitUnion_Intersection(AnnotatedTypeMirror.AnnotatedUnionType type, AnnotatedTypeMirror.AnnotatedIntersectionType superType, Void p) {
        return this.visitUnion_Other(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitUnion_Typevar(AnnotatedTypeMirror.AnnotatedUnionType type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        return this.visitUnion_Other(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitUnion_Union(AnnotatedTypeMirror.AnnotatedUnionType type, AnnotatedTypeMirror.AnnotatedUnionType superType, Void p) {
        for (AnnotatedTypeMirror annotatedTypeMirror : superType.getAlternatives()) {
            this.copyPrimaryAnnos(type, annotatedTypeMirror);
        }
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitUnion_Wildcard(AnnotatedTypeMirror.AnnotatedUnionType type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        return this.visitUnion_Other(type, superType, p);
    }

    private AnnotatedTypeMirror visitWildcard_NotTypvarNorWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror superType, Void p) {
        boolean oldIsUninferredTypeArgument = this.isUninferredTypeAgrument;
        if (type.isUninferredTypeArgument()) {
            this.isUninferredTypeAgrument = true;
        }
        AnnotatedTypeMirror asSuper = this.visit(type.getExtendsBound(), superType, p);
        this.isUninferredTypeAgrument = oldIsUninferredTypeArgument;
        return this.copyPrimaryAnnos(type, asSuper);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard_Array(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedArrayType superType, Void p) {
        return this.visitWildcard_NotTypvarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard_Declared(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedDeclaredType superType, Void p) {
        return this.visitWildcard_NotTypvarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard_Intersection(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedIntersectionType superType, Void p) {
        return this.visitWildcard_NotTypvarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard_Primitive(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedPrimitiveType superType, Void p) {
        return this.visitWildcard_NotTypvarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard_Typevar(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedTypeVariable superType, Void p) {
        boolean oldIsUninferredTypeArgument = this.isUninferredTypeAgrument;
        if (type.isUninferredTypeArgument()) {
            this.isUninferredTypeAgrument = true;
        }
        AnnotatedTypeMirror upperBound = this.visit(type.getExtendsBound(), superType.getUpperBound(), p);
        superType.setUpperBound(upperBound);
        AnnotatedTypeMirror lowerBound = type.getSuperBound().getKind() == TypeKind.NULL && superType.getLowerBound().getKind() == TypeKind.NULL ? this.copyPrimaryAnnos(type.getSuperBound(), superType.getLowerBound()) : (type.getSuperBound().getKind() == TypeKind.NULL ? this.visit((AnnotatedTypeMirror)type, superType.getLowerBound(), p) : this.asSuperTypevarLowerBound(type.getSuperBound(), superType, p));
        superType.setLowerBound(lowerBound);
        this.isUninferredTypeAgrument = oldIsUninferredTypeArgument;
        return this.copyPrimaryAnnos(type, superType);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard_Union(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedUnionType superType, Void p) {
        return this.visitWildcard_NotTypvarNorWildcard(type, superType, p);
    }

    @Override
    public AnnotatedTypeMirror visitWildcard_Wildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror.AnnotatedWildcardType superType, Void p) {
        boolean oldIsUninferredTypeArgument = this.isUninferredTypeAgrument;
        if (type.isUninferredTypeArgument()) {
            this.isUninferredTypeAgrument = true;
        }
        AnnotatedTypeMirror upperBound = this.visit(type.getExtendsBound(), superType.getExtendsBound(), p);
        superType.setExtendsBound(upperBound);
        AnnotatedTypeMirror lowerBound = type.getSuperBound().getKind() == TypeKind.NULL && superType.getSuperBound().getKind() == TypeKind.NULL ? this.copyPrimaryAnnos(type.getSuperBound(), superType.getSuperBound()) : (type.getSuperBound().getKind() == TypeKind.NULL ? this.visit((AnnotatedTypeMirror)type, superType.getSuperBound(), p) : this.asSuperWildcardLowerBound(type.getSuperBound(), superType, p));
        superType.setSuperBound(lowerBound);
        this.isUninferredTypeAgrument = oldIsUninferredTypeArgument;
        return this.copyPrimaryAnnos(type, superType);
    }

    public boolean sameAnnotatedTypeFactory(AnnotatedTypeFactory annotatedTypeFactory) {
        return this.annotatedTypeFactory == annotatedTypeFactory;
    }
}

