/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.DefaultSVNCommandLineDiffGenerator;
import org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import org.tmatesoft.svn.cli.svn.SVNConflictAcceptPolicy;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequence;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnPropertiesDiffHandler;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNConflictStats;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNPropertyConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTextConflictDescription;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommandLineConflictHandler
implements ISVNConflictHandler {
    private SVNConflictAcceptPolicy myAccept;
    private SVNCommandEnvironment mySVNEnvironment;
    private boolean myIsExternalFailed;

    public SVNCommandLineConflictHandler(SVNConflictAcceptPolicy accept, SVNCommandEnvironment environment) {
        this.myAccept = accept;
        this.mySVNEnvironment = environment;
    }

    @Override
    public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
        SVNConflictResult conflictResult = this.handleConflictNoStats(conflictDescription);
        if (conflictResult != null && conflictResult.getConflictChoice() != SVNConflictChoice.POSTPONE) {
            SVNConflictStats conflictStats = this.getConflictStats();
            if (conflictDescription instanceof SVNTextConflictDescription) {
                conflictStats.incrementTextConflictsResolved(SVNFileUtil.getFilePath(conflictDescription.getPath()));
            } else if (conflictDescription instanceof SVNPropertyConflictDescription) {
                conflictStats.incrementPropConflictsResolved(SVNFileUtil.getFilePath(conflictDescription.getPath()));
            } else if (conflictDescription instanceof SVNTreeConflictDescription) {
                conflictStats.incrementTreeConflictsResolved(SVNFileUtil.getFilePath(conflictDescription.getPath()));
            } else {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.ASSERTION_FAIL, "Invalid conflict kind on ''{0}''", (Object)conflictDescription.getPath());
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
        }
        return conflictResult;
    }

    public SVNConflictResult handleConflictNoStats(SVNConflictDescription conflictDescription) throws SVNException {
        SVNConflictChoice choice;
        boolean saveMerged;
        block81: {
            if (conflictDescription.isTreeConflict()) {
                return null;
            }
            SVNMergeFileSet files = conflictDescription.getMergeFiles();
            if (this.myAccept == SVNConflictAcceptPolicy.POSTPONE) {
                return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.BASE) {
                return new SVNConflictResult(SVNConflictChoice.BASE, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.WORKING) {
                return new SVNConflictResult(SVNConflictChoice.MERGED, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.MINE_CONFLICT) {
                return new SVNConflictResult(SVNConflictChoice.MINE_CONFLICT, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.THEIRS_CONFLICT) {
                return new SVNConflictResult(SVNConflictChoice.THEIRS_CONFLICT, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.MINE_FULL) {
                return new SVNConflictResult(SVNConflictChoice.MINE_FULL, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.THEIRS_FULL) {
                return new SVNConflictResult(SVNConflictChoice.THEIRS_FULL, null);
            }
            if (this.myAccept == SVNConflictAcceptPolicy.EDIT) {
                if (files.getResultFile() != null) {
                    if (this.myIsExternalFailed) {
                        return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                    }
                    try {
                        SVNCommandUtil.editFileExternally(this.mySVNEnvironment, this.mySVNEnvironment.getEditorCommand(), files.getResultFile().getAbsolutePath());
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_EDITOR) {
                            this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No editor found, leaving all conflicts.");
                            this.myIsExternalFailed = true;
                        }
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                            String message;
                            String string = message = svne.getErrorMessage().getMessageTemplate() != null ? svne.getErrorMessage().getMessage() : "Error running editor, leaving all conflicts.";
                            if (message.startsWith("svn: ")) {
                                message = message.substring("svn: ".length());
                            }
                            this.mySVNEnvironment.getErr().println(message);
                            this.myIsExternalFailed = true;
                        }
                        throw svne;
                    }
                    return new SVNConflictResult(SVNConflictChoice.MERGED, null);
                }
            } else if (this.myAccept == SVNConflictAcceptPolicy.LAUNCH && files.getBaseFile() != null && files.getLocalFile() != null && files.getRepositoryFile() != null && files.getResultFile() != null) {
                if (this.myIsExternalFailed) {
                    return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                }
                boolean[] remainsInConflict = new boolean[]{false};
                try {
                    SVNCommandUtil.mergeFileExternally(this.mySVNEnvironment, files.getBaseFile().getAbsolutePath(), files.getRepositoryFile().getAbsolutePath(), files.getLocalFile().getAbsolutePath(), files.getResultFile().getAbsolutePath(), files.getWCPath(), remainsInConflict);
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_MERGE_TOOL) {
                        this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No merge tool found.");
                        this.myIsExternalFailed = true;
                    } else if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                        this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "Error running merge tool.");
                        this.myIsExternalFailed = true;
                    }
                    throw svne;
                }
                if (remainsInConflict[0]) {
                    return new SVNConflictResult(SVNConflictChoice.POSTPONE, null);
                }
                return new SVNConflictResult(SVNConflictChoice.MERGED, null);
            }
            saveMerged = false;
            choice = SVNConflictChoice.POSTPONE;
            if (conflictDescription.getNodeKind() == SVNNodeKind.FILE && conflictDescription.getConflictAction() == SVNConflictAction.EDIT && conflictDescription.getConflictReason() == SVNConflictReason.EDITED || conflictDescription.isPropertyConflict()) {
                String message;
                boolean performedEdit = false;
                boolean diffAllowed = false;
                boolean knowsSmth = false;
                String path = this.mySVNEnvironment.getRelativePath(files.getWCFile());
                path = SVNCommandUtil.getLocalPath(path);
                if (conflictDescription.isPropertyConflict()) {
                    message = "Conflict for property ''{0}'' discovered on ''{1}''.";
                    message = MessageFormat.format(message, conflictDescription.getPropertyName(), path);
                    this.mySVNEnvironment.getErr().println(message);
                    if (files.getLocalFile() == null && files.getRepositoryFile() != null || files.getLocalFile() != null && files.getRepositoryFile() == null) {
                        if (files.getLocalFile() != null) {
                            String myVal = SVNFileUtil.readFile(files.getLocalFile());
                            message = MessageFormat.format("They want to delete the property, you want to change the value to ''{0}''.", myVal);
                            this.mySVNEnvironment.getErr().println(message);
                        } else {
                            String reposVal = SVNFileUtil.readFile(files.getRepositoryFile());
                            message = MessageFormat.format("They want to change the property value to ''{0}'', you want to delete the property.", reposVal);
                            this.mySVNEnvironment.getErr().println(message);
                        }
                    }
                } else {
                    message = "Conflict discovered in ''{0}''.";
                    message = MessageFormat.format(message, path);
                    this.mySVNEnvironment.getErr().println(message);
                }
                if (files.getResultFile() != null && files.getBaseFile() != null || files.getBaseFile() != null && files.getLocalFile() != null && files.getRepositoryFile() != null) {
                    diffAllowed = true;
                }
                while (true) {
                    String answer;
                    message = "Select: (p) postpone";
                    if (diffAllowed) {
                        message = message + ", (df) diff-full, (e) edit";
                        if (knowsSmth) {
                            message = message + ", (r) resolved";
                        }
                        if (!files.isBinary() && !conflictDescription.isPropertyConflict()) {
                            message = message + ",\n        (mc) mine-conflict, (tc) theirs-conflict";
                        }
                    } else {
                        if (knowsSmth) {
                            message = message + ", (r) resolved";
                        }
                        message = message + ",\n        (mf) mine-full, (tf) theirs-full";
                    }
                    if ("s".equals(answer = SVNCommandUtil.prompt(message = message + ",\n        (s) show all options: ", this.mySVNEnvironment))) {
                        this.mySVNEnvironment.getErr().println();
                        this.mySVNEnvironment.getErr().println("  (e)  edit             - change merged file in an editor");
                        this.mySVNEnvironment.getErr().println("  (df) diff-full        - show all changes made to merged file");
                        this.mySVNEnvironment.getErr().println("  (r)  resolved         - accept merged version of file");
                        this.mySVNEnvironment.getErr().println();
                        this.mySVNEnvironment.getErr().println("  (dc) display-conflict - show all conflicts (ignoring merged version)");
                        this.mySVNEnvironment.getErr().println("  (mc) mine-conflict    - accept my version for all conflicts (same)");
                        this.mySVNEnvironment.getErr().println("  (tc) theirs-conflict  - accept their version for all conflicts (same)");
                        this.mySVNEnvironment.getErr().println();
                        this.mySVNEnvironment.getErr().println("  (mf) mine-full        - accept my version of entire file (even non-conflicts)");
                        this.mySVNEnvironment.getErr().println("  (tf) theirs-full      - accept their version of entire file (same)");
                        this.mySVNEnvironment.getErr().println();
                        this.mySVNEnvironment.getErr().println("  (p)  postpone         - mark the conflict to be resolved later");
                        this.mySVNEnvironment.getErr().println("  (l)  launch           - launch external tool to resolve conflict");
                        this.mySVNEnvironment.getErr().println("  (s)  show all         - show this list");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if ("p".equals(answer)) {
                        choice = SVNConflictChoice.POSTPONE;
                        break block81;
                    }
                    if ("mc".equals(answer)) {
                        if (files.isBinary()) {
                            this.mySVNEnvironment.getErr().println("Invalid option; cannot choose based on conflicts in a binary file.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        if (conflictDescription.isPropertyConflict()) {
                            this.mySVNEnvironment.getErr().println("Invalid option; cannot choose based on conflicts for properties.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        choice = SVNConflictChoice.MINE_CONFLICT;
                        if (performedEdit) {
                            saveMerged = true;
                        }
                        break block81;
                    }
                    if ("tc".equals(answer)) {
                        if (files.isBinary()) {
                            this.mySVNEnvironment.getErr().println("Invalid option; cannot choose based on conflicts in a binary file.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        if (conflictDescription.isPropertyConflict()) {
                            this.mySVNEnvironment.getErr().println("Invalid option; cannot choose based on conflicts for properties.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        choice = SVNConflictChoice.THEIRS_CONFLICT;
                        if (performedEdit) {
                            saveMerged = true;
                        }
                        break block81;
                    }
                    if ("mf".equals(answer)) {
                        choice = SVNConflictChoice.MINE_FULL;
                        if (performedEdit) {
                            saveMerged = true;
                        }
                        break block81;
                    }
                    if ("tf".equals(answer)) {
                        choice = SVNConflictChoice.THEIRS_FULL;
                        if (performedEdit) {
                            saveMerged = true;
                        }
                        break block81;
                    }
                    if ("dc".equals(answer)) {
                        if (files.isBinary()) {
                            this.mySVNEnvironment.getErr().println("Invalid option; cannot display conflicts for a binary file.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        if (conflictDescription.isPropertyConflict()) {
                            this.mySVNEnvironment.getErr().println("Invalid option; cannot display conflicts for properties.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        if (files.getLocalFile() == null || files.getBaseFile() == null || files.getRepositoryFile() == null) {
                            this.mySVNEnvironment.getErr().println("Invalid option; original files not available.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        this.showConflictedChunks(files);
                        knowsSmth = true;
                        continue;
                    }
                    if ("df".equals(answer)) {
                        if (!diffAllowed) {
                            this.mySVNEnvironment.getErr().println("Invalid option; there's no merged version to diff.");
                            this.mySVNEnvironment.getErr().println();
                            continue;
                        }
                        File path1 = null;
                        File path2 = null;
                        if (files.getResultFile() != null && files.getBaseFile() != null) {
                            path1 = files.getBaseFile();
                            path2 = files.getResultFile();
                        } else {
                            path1 = files.getRepositoryFile();
                            path2 = files.getLocalFile();
                        }
                        DefaultSVNCommandLineDiffGenerator diffGenerator = new DefaultSVNCommandLineDiffGenerator(path1, path2);
                        diffGenerator.setDiffOptions(new SVNDiffOptions(false, false, true));
                        if (diffGenerator instanceof ISvnPropertiesDiffHandler) {
                            ((ISvnPropertiesDiffHandler)((Object)diffGenerator)).handlePropertiesDiff(null, null);
                        }
                        diffGenerator.displayFileDiff("", path1, path2, null, null, null, null, System.out);
                        knowsSmth = true;
                        continue;
                    }
                    if ("e".equals(answer)) {
                        if (files.getResultFile() != null) {
                            try {
                                String resultPath = files.getResultFile().getAbsolutePath();
                                SVNCommandUtil.editFileExternally(this.mySVNEnvironment, this.mySVNEnvironment.getEditorCommand(), resultPath);
                                performedEdit = true;
                            }
                            catch (SVNException svne) {
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_EDITOR) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No editor found.");
                                }
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "Error running editor.");
                                }
                                throw svne;
                            }
                        } else {
                            this.mySVNEnvironment.getErr().println("Invalid option; there's no merged version to edit.");
                            this.mySVNEnvironment.getErr().println();
                        }
                        if (!performedEdit) continue;
                        knowsSmth = true;
                        continue;
                    }
                    if ("l".equals(answer)) {
                        if (files.getBaseFile() != null && files.getLocalFile() != null && files.getRepositoryFile() != null && files.getResultFile() != null) {
                            try {
                                SVNCommandUtil.mergeFileExternally(this.mySVNEnvironment, files.getBasePath(), files.getRepositoryPath(), files.getLocalPath(), files.getResultPath(), files.getWCPath(), null);
                                performedEdit = true;
                            }
                            catch (SVNException svne) {
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_MERGE_TOOL) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "No merge tool found.");
                                    this.myIsExternalFailed = true;
                                }
                                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.EXTERNAL_PROGRAM) {
                                    this.mySVNEnvironment.getErr().println(svne.getErrorMessage().getMessage() != null ? svne.getErrorMessage().getMessage() : "Error running merge tool.");
                                    this.myIsExternalFailed = true;
                                }
                                throw svne;
                            }
                        }
                        this.mySVNEnvironment.getErr().println("Invalid option.");
                        this.mySVNEnvironment.getErr().println();
                        continue;
                    }
                    if (!"r".equals(answer)) continue;
                    if (knowsSmth) {
                        choice = SVNConflictChoice.MERGED;
                        break block81;
                    }
                    this.mySVNEnvironment.getErr().println("Invalid option.");
                    this.mySVNEnvironment.getErr().println();
                }
            }
            if (conflictDescription.getConflictAction() == SVNConflictAction.ADD && conflictDescription.getConflictReason() == SVNConflictReason.OBSTRUCTED) {
                String answer;
                String message = "Conflict discovered when trying to add ''{0}''.";
                message = MessageFormat.format(message, files.getWCFile());
                this.mySVNEnvironment.getErr().println(message);
                this.mySVNEnvironment.getErr().println("An object of the same name already exists.");
                String prompt = "Select: (p) postpone, (mf) mine-full, (tf) theirs-full, (h) help:";
                do {
                    if ("h".equals(answer = SVNCommandUtil.prompt(prompt, this.mySVNEnvironment)) || "?".equals(answer)) {
                        this.mySVNEnvironment.getErr().println("  (p)  postpone    - resolve the conflict later");
                        this.mySVNEnvironment.getErr().println("  (mf) mine-full   - accept pre-existing item (ignore upstream addition)");
                        this.mySVNEnvironment.getErr().println("  (tf) theirs-full - accept incoming item (overwrite pre-existing item)");
                        this.mySVNEnvironment.getErr().println("  (h)  help        - show this help");
                        this.mySVNEnvironment.getErr().println();
                    }
                    if ("p".equals(answer)) {
                        choice = SVNConflictChoice.POSTPONE;
                    } else {
                        if (!"mf".equals(answer)) continue;
                        choice = SVNConflictChoice.MINE_FULL;
                    }
                    break block81;
                } while (!"tf".equals(answer));
                choice = SVNConflictChoice.THEIRS_FULL;
            } else {
                choice = SVNConflictChoice.POSTPONE;
            }
        }
        return new SVNConflictResult(choice, null, saveMerged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showConflictedChunks(SVNMergeFileSet files) throws SVNException {
        byte[] conflictStartMarker = "<<<<<<< MINE (select with 'mc')".getBytes();
        byte[] conflictSeparator = "=======".getBytes();
        byte[] conflictEndMarker = ">>>>>>> THEIRS (select with 'tc')".getBytes();
        byte[] conflictOriginalMarker = "||||||| ORIGINAL".getBytes();
        SVNDiffOptions options = new SVNDiffOptions(false, false, true);
        FSMergerBySequence merger = new FSMergerBySequence(conflictStartMarker, conflictSeparator, conflictEndMarker, conflictOriginalMarker);
        RandomAccessFile localIS = null;
        RandomAccessFile latestIS = null;
        RandomAccessFile baseIS = null;
        try {
            localIS = new RandomAccessFile(files.getWCFile(), "r");
            latestIS = new RandomAccessFile(files.getRepositoryFile(), "r");
            baseIS = new RandomAccessFile(files.getBaseFile(), "r");
            QSequenceLineRAFileData baseData = new QSequenceLineRAFileData(baseIS);
            QSequenceLineRAFileData localData = new QSequenceLineRAFileData(localIS);
            QSequenceLineRAFileData latestData = new QSequenceLineRAFileData(latestIS);
            merger.merge(baseData, localData, latestData, options, this.mySVNEnvironment.getOut(), SVNDiffConflictChoiceStyle.CHOOSE_ONLY_CONFLICTS);
        }
        catch (IOException e) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(localIS);
                SVNFileUtil.closeFile(baseIS);
                SVNFileUtil.closeFile(latestIS);
                throw throwable;
            }
            SVNFileUtil.closeFile(localIS);
            SVNFileUtil.closeFile(baseIS);
            SVNFileUtil.closeFile(latestIS);
        }
        SVNFileUtil.closeFile(localIS);
        SVNFileUtil.closeFile(baseIS);
        SVNFileUtil.closeFile(latestIS);
    }

    private SVNConflictStats getConflictStats() {
        return this.mySVNEnvironment.getConflictStats();
    }
}

