/*
 * Decompiled with CFR 0.152.
 */
package annotations.io.classfile;

import annotations.el.AScene;
import annotations.io.IndexFileParser;
import annotations.io.classfile.ClassAnnotationSceneWriter;
import annotations.io.classfile.ClassFileReader;
import com.sun.tools.javac.main.CommandLine;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.objectweb.asm.ClassReader;
import plume.Option;
import plume.Options;

public class ClassFileWriter {
    @Option(value="-h print usage information and exit")
    public static boolean help = false;
    @Option(value="print version information and exit")
    public static boolean version = false;
    private static String linesep = System.getProperty("line.separator");
    static String usage = "usage: insert-annotations [options] class1 indexfile1 class2 indexfile2 ..." + linesep + "For each class/index file pair (a.b.C a.b.C.jaif), read annotations from" + linesep + "the index file a.b.C.jaif and insert them into the class a.b.C, then" + linesep + "output the merged class file to a.b.C.class" + linesep + "Each class is either a fully-qualified name of a class on your classpath," + linesep + "or a path to a .class file, such as e.g. /.../path/to/a/b/C.class ." + linesep + "Arguments beginning with a single '@' are interpreted as argument files to" + linesep + "be read and expanded into the command line.  Options:";

    public static void main(String[] args) throws IOException {
        int i;
        String[] file_args;
        Options options = new Options(usage, ClassFileWriter.class);
        try {
            String[] cl_args = CommandLine.parse(args);
            file_args = options.parse_or_usage(cl_args);
        }
        catch (IOException ex) {
            System.err.println(ex);
            System.err.println("(For non-argfile beginning with \"@\", use \"@@\" for initial \"@\".");
            System.err.println("Alternative for filenames: indicate directory, e.g. as './@file'.");
            System.err.println("Alternative for flags: use '=', as in '-o=@Deprecated'.)");
            file_args = null;
            System.exit(1);
        }
        if (version) {
            System.out.printf("insert-annotations (%s)", "Annotation File Utilities v3.6.39");
        }
        if (help) {
            options.print_usage();
        }
        if (version || help) {
            System.exit(-1);
        }
        if (file_args.length == 0) {
            options.print_usage("No arguments given.");
            System.exit(-1);
        }
        if (file_args.length % 2 == 1) {
            options.print_usage("Must supply an even number of arguments.");
            System.exit(-1);
        }
        for (i = 0; i < file_args.length; i += 2) {
            if (ClassFileReader.checkClass(file_args[i])) continue;
            System.exit(-1);
        }
        for (i = 0; i < file_args.length; ++i) {
            String className = file_args[i];
            if (++i >= file_args.length) {
                System.out.println("Error: incorrect number of arguments");
                System.out.println("Run insert-annotations --help for usage information");
                return;
            }
            String indexFileName = file_args[i];
            AScene scene = new AScene();
            IndexFileParser.parseFile(indexFileName, scene);
            try {
                if (className.endsWith(".class")) {
                    System.out.printf("Adding annotations to class file %s%n", className);
                    ClassFileWriter.insert(scene, className, true);
                    continue;
                }
                String outputFileName = className + ".class";
                System.out.printf("Reading class file %s; writing with annotations to %s%n", className, outputFileName);
                ClassFileWriter.insert(scene, className, outputFileName, true);
                continue;
            }
            catch (IOException e) {
                System.out.printf("IOException: %s%n", e.getMessage());
                return;
            }
            catch (Exception e) {
                System.out.println("Unknown error trying to insert annotations from: " + indexFileName + " to " + className);
                e.printStackTrace();
                System.out.println("Please submit a bug report at");
                System.out.println("  https://github.com/typetools/annotation-tools/issues");
                System.out.println("Be sure to include a copy of the following output trace, instructions on how");
                System.out.println("to reproduce this error, and all input files.  Thanks!");
                return;
            }
        }
    }

    public static void insert(AScene scene, String fileName, boolean overwrite) throws IOException {
        assert (fileName.endsWith(".class"));
        FileInputStream in = new FileInputStream(fileName);
        ClassReader cr = new ClassReader(in);
        ((InputStream)in).close();
        ClassAnnotationSceneWriter cw = new ClassAnnotationSceneWriter(cr, scene, overwrite);
        cr.accept(cw, false);
        FileOutputStream fos = new FileOutputStream(fileName);
        ((OutputStream)fos).write(cw.toByteArray());
        ((OutputStream)fos).close();
    }

    public static void insert(AScene scene, InputStream in, OutputStream out, boolean overwrite) throws IOException {
        ClassReader cr = new ClassReader(in);
        ClassAnnotationSceneWriter cw = new ClassAnnotationSceneWriter(cr, scene, overwrite);
        cr.accept(cw, false);
        out.write(cw.toByteArray());
    }

    public static void insert(AScene scene, String className, String outputFileName, boolean overwrite) throws IOException {
        ClassReader cr = new ClassReader(className);
        ClassAnnotationSceneWriter cw = new ClassAnnotationSceneWriter(cr, scene, overwrite);
        cr.accept(cw, false);
        FileOutputStream fos = new FileOutputStream(outputFileName);
        ((OutputStream)fos).write(cw.toByteArray());
        ((OutputStream)fos).close();
    }
}

