/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.bcel6.Const;
import org.apache.commons.bcel6.classfile.Constant;
import org.apache.commons.bcel6.classfile.ConstantClass;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.generic.ClassGenException;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.IndexedInstruction;
import org.apache.commons.bcel6.generic.Instruction;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.generic.TypedInstruction;
import org.apache.commons.bcel6.util.ByteSequence;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index;

    CPInstruction() {
    }

    protected CPInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        super(opcode, (short)3);
        this.setIndex(index);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        out.writeByte(super.getOpcode());
        out.writeShort(this.index);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        String str = cp.constantToString(c);
        if (c instanceof ConstantClass) {
            str = str.replace('.', '/');
        }
        return Const.getOpcodeName(super.getOpcode()) + " " + str;
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.setIndex(bytes.readUnsignedShort());
        super.setLength(3);
    }

    @Override
    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        if (index < 0) {
            throw new ClassGenException("Negative index value: " + index);
        }
        this.index = index;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        String name = cp.getConstantString(this.index, (byte)7);
        if (!name.startsWith("[")) {
            name = "L" + name + ";";
        }
        return Type.getType(name);
    }
}

