/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.bcel6.classfile.AnnotationEntry;
import org.apache.commons.bcel6.classfile.Annotations;
import org.apache.commons.bcel6.classfile.Attribute;
import org.apache.commons.bcel6.classfile.Constant;
import org.apache.commons.bcel6.classfile.ConstantObject;
import org.apache.commons.bcel6.classfile.ConstantPool;
import org.apache.commons.bcel6.classfile.ConstantValue;
import org.apache.commons.bcel6.classfile.Field;
import org.apache.commons.bcel6.classfile.Utility;
import org.apache.commons.bcel6.generic.AnnotationEntryGen;
import org.apache.commons.bcel6.generic.ClassGenException;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.FieldGenOrMethodGen;
import org.apache.commons.bcel6.generic.FieldObserver;
import org.apache.commons.bcel6.generic.ObjectType;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.util.BCELComparator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class FieldGen
extends FieldGenOrMethodGen {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object value = null;
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o2) {
            FieldGen THIS = (FieldGen)o1;
            FieldGen THAT = (FieldGen)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object o) {
            FieldGen THIS = (FieldGen)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldObserver> observers;

    public FieldGen(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        super(access_flags);
        this.setType(type);
        this.setName(name);
        this.setConstantPool(cp);
    }

    public FieldGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field field, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        this(field.getAccessFlags(), Type.getType(field.getSignature()), field.getName(), cp);
        Attribute[] attrs;
        for (Attribute attr : attrs = field.getAttributes()) {
            if (attr instanceof ConstantValue) {
                this.setValue(((ConstantValue)attr).getConstantValueIndex());
                continue;
            }
            if (attr instanceof Annotations) {
                AnnotationEntry[] annotationEntries;
                Annotations runtimeAnnotations = (Annotations)attr;
                for (AnnotationEntry element : annotationEntries = runtimeAnnotations.getAnnotationEntries()) {
                    this.addAnnotationEntry(new AnnotationEntryGen(element, cp, false));
                }
                continue;
            }
            this.addAttribute(attr);
        }
    }

    private void setValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        ConstantPool cp = super.getConstantPool().getConstantPool();
        Constant c = cp.getConstant(index);
        this.value = ((ConstantObject)((Object)c)).getConstantValue(cp);
    }

    public void setInitValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String str) {
        this.checkType(ObjectType.getInstance("java.lang.String"));
        if (str != null) {
            this.value = str;
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown long l) {
        this.checkType(Type.LONG);
        if (l != 0L) {
            this.value = l;
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int i) {
        this.checkType(Type.INT);
        if (i != 0) {
            this.value = i;
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short s2) {
        this.checkType(Type.SHORT);
        if (s2 != 0) {
            this.value = (int)s2;
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char c) {
        this.checkType(Type.CHAR);
        if (c != '\u0000') {
            this.value = (int)c;
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte b) {
        this.checkType(Type.BYTE);
        if (b != 0) {
            this.value = (int)b;
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean b) {
        this.checkType(Type.BOOLEAN);
        if (b) {
            this.value = 1;
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown float f) {
        this.checkType(Type.FLOAT);
        if ((double)f != 0.0) {
            this.value = new Float(f);
        }
    }

    public void setInitValue(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown double d) {
        this.checkType(Type.DOUBLE);
        if (d != 0.0) {
            this.value = new Double(d);
        }
    }

    public void cancelInitValue() {
        this.value = null;
    }

    private void checkType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type atype) {
        Type superType = super.getType();
        if (superType == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!superType.equals(atype)) {
            throw new ClassGenException("Types are not compatible: " + superType + " vs. " + atype);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Field getField() {
        String signature = this.getSignature();
        int name_index = super.getConstantPool().addUtf8(super.getName());
        int signature_index = super.getConstantPool().addUtf8(signature);
        if (this.value != null) {
            this.checkType(super.getType());
            int index = this.addConstant();
            this.addAttribute(new ConstantValue(super.getConstantPool().addUtf8("ConstantValue"), 2, index, super.getConstantPool().getConstantPool()));
        }
        this.addAnnotationsAsAttribute(super.getConstantPool());
        return new Field(super.getAccessFlags(), name_index, signature_index, this.getAttributes(), super.getConstantPool().getConstantPool());
    }

    private void addAnnotationsAsAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        Attribute[] attrs;
        for (Attribute attr : attrs = AnnotationEntryGen.getAnnotationAttributes(cp, super.getAnnotationEntries())) {
            this.addAttribute(attr);
        }
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int addConstant() {
        switch (super.getType().getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return super.getConstantPool().addInteger((Integer)this.value);
            }
            case 6: {
                return super.getConstantPool().addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return super.getConstantPool().addDouble((Double)this.value);
            }
            case 11: {
                return super.getConstantPool().addLong((Long)this.value);
            }
            case 14: {
                return super.getConstantPool().addString((String)this.value);
            }
        }
        throw new RuntimeException("Oops: Unhandled : " + super.getType().getType());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature() {
        return super.getType().getSignature();
    }

    public void addObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<FieldObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (FieldObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getInitValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        access = access.equals("") ? "" : access + " ";
        String signature = super.getType().toString();
        String name = this.getName();
        StringBuilder buf = new StringBuilder(32);
        buf.append(access).append(signature).append(" ").append(name);
        String value = this.getInitValue();
        if (value != null) {
            buf.append(" = ").append(value);
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldGen copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        FieldGen fg = (FieldGen)this.clone();
        fg.setConstantPool(cp);
        return fg;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object obj) {
        return _cmp.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int hashCode() {
        return _cmp.hashCode(this);
    }
}

