/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.bcel6.generic.ClassGenException;
import org.apache.commons.bcel6.generic.ConstantPoolGen;
import org.apache.commons.bcel6.generic.LocalVariableInstruction;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.generic.Visitor;
import org.apache.commons.bcel6.util.ByteSequence;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class IINC
extends LocalVariableInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int c;

    IINC() {
    }

    public IINC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int c) {
        super.setOpcode((short)132);
        super.setLength(3);
        this.setIndex(n);
        this.setIncrement(c);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(super.getOpcode());
        if (this.wide) {
            out.writeShort(super.getIndex());
            out.writeShort(this.c);
        } else {
            out.writeByte(super.getIndex());
            out.writeByte(this.c);
        }
    }

    private void setWide() {
        boolean bl = this.wide = super.getIndex() > 255 || Math.abs(this.c) > 127;
        if (this.wide) {
            super.setLength(6);
        } else {
            super.setLength(3);
        }
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.wide = wide;
        if (wide) {
            super.setLength(6);
            super.setIndexOnly(bytes.readUnsignedShort());
            this.c = bytes.readShort();
        } else {
            super.setLength(3);
            super.setIndexOnly(bytes.readUnsignedByte());
            this.c = bytes.readByte();
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        return super.toString(verbose) + " " + this.c;
    }

    @Override
    public final void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        super.setIndexOnly(n);
        this.setWide();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getIncrement() {
        return this.c;
    }

    public final void setIncrement(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int c) {
        this.c = c;
        this.setWide();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        return Type.INT;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitLocalVariableInstruction(this);
        v.visitIINC(this);
    }
}

