/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.generic;

import org.apache.commons.bcel6.generic.BranchInstruction;
import org.apache.commons.bcel6.generic.ConstantPushInstruction;
import org.apache.commons.bcel6.generic.IndexedInstruction;
import org.apache.commons.bcel6.generic.Instruction;
import org.apache.commons.bcel6.generic.NEWARRAY;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public interface InstructionComparator {
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionComparator DEFAULT = new InstructionComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction i2) {
            if (i1.getOpcode() == i2.getOpcode()) {
                if (i1 instanceof BranchInstruction) {
                    return false;
                }
                if (i1 instanceof ConstantPushInstruction) {
                    return ((ConstantPushInstruction)((Object)i1)).getValue().equals(((ConstantPushInstruction)((Object)i2)).getValue());
                }
                if (i1 instanceof IndexedInstruction) {
                    return ((IndexedInstruction)((Object)i1)).getIndex() == ((IndexedInstruction)((Object)i2)).getIndex();
                }
                if (i1 instanceof NEWARRAY) {
                    return ((NEWARRAY)i1).getTypecode() == ((NEWARRAY)i2).getTypecode();
                }
                return true;
            }
            return false;
        }
    };

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction var1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction var2);
}

