/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.bcel6.verifier;

import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.UIManager;
import org.apache.commons.bcel6.generic.Type;
import org.apache.commons.bcel6.verifier.VerifierAppFrame;
import org.apache.commons.bcel6.verifier.VerifierFactory;
import org.apache.commons.bcel6.verifier.VerifierFactoryListModel;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class GraphicalVerifier {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean packFrame = false;

    public GraphicalVerifier() {
        VerifierAppFrame frame = new VerifierAppFrame();
        frame.validate();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        frame.getClassNamesJList().setModel(new VerifierFactoryListModel());
        VerifierFactory.getVerifier(Type.OBJECT.getClassName());
        frame.getClassNamesJList().setSelectedIndex(0);
    }

    public static void main(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new GraphicalVerifier();
    }
}

