/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.i18nformatter.I18nFormatUtil;
import org.checkerframework.checker.i18nformatter.I18nFormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.checkerframework.checker.i18nformatter.qual.I18nFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nFormatBottom;
import org.checkerframework.checker.i18nformatter.qual.I18nFormatFor;
import org.checkerframework.checker.i18nformatter.qual.I18nInvalidFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nUnknownFormat;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.GraphQualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class I18nFormatterAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror I18NUNKNOWNFORMAT;
    protected final AnnotationMirror I18NFORMAT;
    protected final AnnotationMirror I18NINVALIDFORMAT;
    protected final AnnotationMirror I18NFORMATBOTTOM;
    protected final AnnotationMirror I18NFORMATFOR;
    public final Map<String, String> translations;
    protected final I18nFormatterTreeUtil treeUtil;

    public I18nFormatterAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.I18NUNKNOWNFORMAT = AnnotationUtils.fromClass(this.elements, I18nUnknownFormat.class);
        this.I18NFORMAT = AnnotationUtils.fromClass(this.elements, I18nFormat.class);
        this.I18NINVALIDFORMAT = AnnotationUtils.fromClass(this.elements, I18nInvalidFormat.class);
        this.I18NFORMATBOTTOM = AnnotationUtils.fromClass(this.elements, I18nFormatBottom.class);
        this.I18NFORMATFOR = AnnotationUtils.fromClass(this.elements, I18nFormatFor.class);
        this.translations = Collections.unmodifiableMap(this.buildLookup());
        this.treeUtil = new I18nFormatterTreeUtil(checker);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return this.getBundledTypeQualifiersWithoutPolyAll(I18nUnknownFormat.class, I18nFormatBottom.class);
    }

    private Map<String, String> buildLookup() {
        String[] namesArr;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.checker.hasOption("propfiles")) {
            String names = this.checker.getOption("propfiles");
            namesArr = names.split(":");
            if (namesArr == null) {
                System.err.println("Couldn't parse the properties files: <" + names + ">");
            } else {
                for (String name : namesArr) {
                    try {
                        Properties prop = new Properties();
                        InputStream in = null;
                        ClassLoader cl = this.getClass().getClassLoader();
                        if (cl == null) {
                            cl = ClassLoader.getSystemClassLoader();
                        }
                        if ((in = cl.getResourceAsStream(name)) == null) {
                            try {
                                in = new FileInputStream(name);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                // empty catch block
                            }
                        }
                        if (in == null) {
                            System.err.println("Couldn't find the properties file: " + name);
                            continue;
                        }
                        prop.load(in);
                        for (String key : prop.stringPropertyNames()) {
                            result.put(key, prop.getProperty(key));
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Exception in PropertyKeyChecker.keysOfPropertyFile: " + e);
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.checker.hasOption("bundlenames")) {
            String bundleNames = this.checker.getOption("bundlenames");
            namesArr = bundleNames.split(":");
            if (namesArr == null) {
                System.err.println("Couldn't parse the resource bundles: <" + bundleNames + ">");
            } else {
                for (String bundleName : namesArr) {
                    ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
                    if (bundle == null) {
                        System.err.println("Couldn't find the resource bundle: <" + bundleName + "> for locale <" + Locale.getDefault() + ">");
                        continue;
                    }
                    for (String key : bundle.keySet()) {
                        result.put(key, bundle.getString(key));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new I18nFormatterQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new I18nFormatterTreeAnnotator(this));
    }

    class I18nFormatterQualifierHierarchy
    extends GraphQualifierHierarchy {
        public I18nFormatterQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory f) {
            super(f, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATBOTTOM);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT) && AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                I18nConversionCategory[] lhsArgTypes;
                I18nConversionCategory[] rhsArgTypes = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(rhs);
                if (rhsArgTypes.length > (lhsArgTypes = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(lhs)).length) {
                    return false;
                }
                for (int i = 0; i < rhsArgTypes.length; ++i) {
                    if (I18nConversionCategory.isSubsetOf(lhsArgTypes[i], rhsArgTypes[i])) continue;
                    return false;
                }
                return true;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT) && AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                return AnnotationUtils.getElementValue(rhs, "value", String.class, true).equals(AnnotationUtils.getElementValue(lhs, "value", String.class, true));
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                lhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                rhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                lhs = I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                rhs = I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT;
            }
            if (AnnotationUtils.areSameIgnoringValues(lhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR)) {
                lhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR;
            }
            if (AnnotationUtils.areSameIgnoringValues(rhs, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR)) {
                rhs = I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR;
            }
            return super.isSubtype(rhs, lhs);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror anno1, AnnotationMirror anno2) {
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATBOTTOM)) {
                return anno2;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno2, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATBOTTOM)) {
                return anno1;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT) && AnnotationUtils.areSameIgnoringValues(anno2, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                int i;
                I18nConversionCategory[] longerArgTypesList;
                I18nConversionCategory[] shorterArgTypesList = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(anno1);
                if (shorterArgTypesList.length > (longerArgTypesList = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(anno2)).length) {
                    I18nConversionCategory[] temp = longerArgTypesList;
                    longerArgTypesList = shorterArgTypesList;
                    shorterArgTypesList = temp;
                }
                I18nConversionCategory[] resultArgTypes = new I18nConversionCategory[longerArgTypesList.length];
                for (i = 0; i < shorterArgTypesList.length; ++i) {
                    resultArgTypes[i] = I18nConversionCategory.intersect(shorterArgTypesList[i], longerArgTypesList[i]);
                }
                for (i = shorterArgTypesList.length; i < longerArgTypesList.length; ++i) {
                    resultArgTypes[i] = longerArgTypesList[i];
                }
                return I18nFormatterAnnotatedTypeFactory.this.treeUtil.categoriesToFormatAnnotation(resultArgTypes);
            }
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT) && AnnotationUtils.areSameIgnoringValues(anno2, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                assert (!anno1.getElementValues().isEmpty());
                assert (!anno2.getElementValues().isEmpty());
                if (AnnotationUtils.areSame(anno1, anno2)) {
                    return anno1;
                }
                return I18nFormatterAnnotatedTypeFactory.this.treeUtil.stringToInvalidFormatAnnotation("(" + I18nFormatterAnnotatedTypeFactory.this.treeUtil.invalidFormatAnnotationToErrorMessage(anno1) + " or " + I18nFormatterAnnotatedTypeFactory.this.treeUtil.invalidFormatAnnotationToErrorMessage(anno2) + ")");
            }
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR) && AnnotationUtils.areSame(anno1, anno2)) {
                return anno1;
            }
            return I18nFormatterAnnotatedTypeFactory.this.I18NUNKNOWNFORMAT;
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror anno1, AnnotationMirror anno2) {
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NUNKNOWNFORMAT)) {
                return anno2;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno2, I18nFormatterAnnotatedTypeFactory.this.I18NUNKNOWNFORMAT)) {
                return anno1;
            }
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT) && AnnotationUtils.areSameIgnoringValues(anno2, I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                int length;
                I18nConversionCategory[] anno1ArgTypes = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(anno1);
                I18nConversionCategory[] anno2ArgTypes = I18nFormatterAnnotatedTypeFactory.this.treeUtil.formatAnnotationToCategories(anno2);
                if (anno2ArgTypes.length < (length = anno1ArgTypes.length)) {
                    length = anno2ArgTypes.length;
                }
                I18nConversionCategory[] anno3ArgTypes = new I18nConversionCategory[length];
                for (int i = 0; i < length; ++i) {
                    anno3ArgTypes[i] = I18nConversionCategory.union(anno1ArgTypes[i], anno2ArgTypes[i]);
                }
                return I18nFormatterAnnotatedTypeFactory.this.treeUtil.categoriesToFormatAnnotation(anno3ArgTypes);
            }
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT) && AnnotationUtils.areSameIgnoringValues(anno2, I18nFormatterAnnotatedTypeFactory.this.I18NINVALIDFORMAT)) {
                assert (!anno1.getElementValues().isEmpty());
                assert (!anno2.getElementValues().isEmpty());
                if (AnnotationUtils.areSame(anno1, anno2)) {
                    return anno1;
                }
                return I18nFormatterAnnotatedTypeFactory.this.treeUtil.stringToInvalidFormatAnnotation("(" + I18nFormatterAnnotatedTypeFactory.this.treeUtil.invalidFormatAnnotationToErrorMessage(anno1) + " and " + I18nFormatterAnnotatedTypeFactory.this.treeUtil.invalidFormatAnnotationToErrorMessage(anno2) + ")");
            }
            if (AnnotationUtils.areSameIgnoringValues(anno1, I18nFormatterAnnotatedTypeFactory.this.I18NFORMATFOR) && AnnotationUtils.areSame(anno1, anno2)) {
                return anno1;
            }
            return I18nFormatterAnnotatedTypeFactory.this.I18NFORMATBOTTOM;
        }
    }

    private class I18nFormatterTreeAnnotator
    extends TreeAnnotator {
        public I18nFormatterTreeAnnotator(AnnotatedTypeFactory atypeFactory) {
            super(atypeFactory);
        }

        @Override
        public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
            if (!type.isAnnotatedInHierarchy(I18nFormatterAnnotatedTypeFactory.this.I18NFORMAT)) {
                String format = null;
                if (tree.getKind() == Tree.Kind.STRING_LITERAL) {
                    format = (String)tree.getValue();
                } else if (tree.getKind() == Tree.Kind.CHAR_LITERAL) {
                    format = Character.toString(((Character)tree.getValue()).charValue());
                }
                if (format != null) {
                    AnnotationMirror anno;
                    try {
                        I18nConversionCategory[] cs = I18nFormatUtil.formatParameterCategories(format);
                        anno = I18nFormatterAnnotatedTypeFactory.this.treeUtil.categoriesToFormatAnnotation(cs);
                    }
                    catch (IllegalArgumentException e) {
                        anno = I18nFormatterAnnotatedTypeFactory.this.treeUtil.exceptionToInvalidFormatAnnotation(e);
                    }
                    type.addAnnotation(anno);
                }
            }
            return (Void)super.visitLiteral(tree, type);
        }
    }
}

