/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.lowerbound;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.minlen.MinLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.minlen.MinLenChecker;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ImplicitsTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.PropagationTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class LowerBoundAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror GTEN1;
    public final AnnotationMirror NN;
    public final AnnotationMirror POS;
    public final AnnotationMirror UNKNOWN;
    private final IndexMethodIdentifier imf;

    public LowerBoundAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.GTEN1 = AnnotationUtils.fromClass(this.elements, GTENegativeOne.class);
        this.NN = AnnotationUtils.fromClass(this.elements, NonNegative.class);
        this.POS = AnnotationUtils.fromClass(this.elements, Positive.class);
        this.UNKNOWN = AnnotationUtils.fromClass(this.elements, LowerBoundUnknown.class);
        this.addAliasedAnnotation(IndexFor.class, this.NN);
        this.addAliasedAnnotation(IndexOrLow.class, this.GTEN1);
        this.addAliasedAnnotation(IndexOrHigh.class, this.NN);
        this.imf = new IndexMethodIdentifier(this.processingEnv);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(Positive.class, NonNegative.class, GTENegativeOne.class, LowerBoundUnknown.class));
    }

    private void addLowerBoundTypeFromValueType(AnnotatedTypeMirror valueType, AnnotatedTypeMirror type) {
        AnnotationMirror anm = this.getLowerBoundAnnotationFromValueType(valueType);
        if (!type.isAnnotatedInHierarchy(this.UNKNOWN)) {
            if (!AnnotationUtils.areSameByClass(anm, LowerBoundUnknown.class)) {
                type.addAnnotation(anm);
            }
            return;
        }
        if (this.qualHierarchy.isSubtype(anm, type.getAnnotationInHierarchy(this.UNKNOWN))) {
            type.replaceAnnotation(anm);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Element element, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(element, type);
        if (element != null) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(element);
            this.addLowerBoundTypeFromValueType(valueType, type);
        }
    }

    @Override
    public void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (iUseFlow && tree != null && TreeUtils.isExpressionTree(tree)) {
            AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
            this.addLowerBoundTypeFromValueType(valueType, type);
        }
    }

    public ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    public MinLenAnnotatedTypeFactory getMinLenAnnotatedTypeFactory() {
        return (MinLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(MinLenChecker.class);
    }

    public Long getExactValueOrNullFromTree(Tree tree) {
        AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues != null && possibleValues.size() == 1) {
            return possibleValues.get(0);
        }
        return null;
    }

    private AnnotationMirror getLowerBoundAnnotationFromValueType(AnnotatedTypeMirror valueType) {
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues == null || possibleValues.size() == 0) {
            return this.UNKNOWN;
        }
        long lvalMin = Collections.min(possibleValues);
        int valMin = (int)Math.max(Math.min(Integer.MAX_VALUE, lvalMin), Integer.MIN_VALUE);
        return this.anmFromVal(valMin);
    }

    private AnnotationMirror anmFromVal(int val) {
        if (val >= 1) {
            return this.POS;
        }
        if (val >= 0) {
            return this.NN;
        }
        if (val >= -1) {
            return this.GTEN1;
        }
        return this.UNKNOWN;
    }

    private List<Long> possibleValuesFromValueType(AnnotatedTypeMirror valueType) {
        AnnotationMirror anm = valueType.getAnnotation(IntVal.class);
        if (anm == null) {
            return null;
        }
        return ValueAnnotatedTypeFactory.getIntValues(anm);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new LowerBoundTreeAnnotator(this), new PropagationTreeAnnotator(this), new ImplicitsTreeAnnotator(this));
    }

    private void addAnnotationForRightShift(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror rightType = this.getAnnotatedType(rightExpr);
        AnnotatedTypeMirror leftType = this.getAnnotatedType(leftExpr);
        if ((leftType.hasAnnotation(this.NN) || leftType.hasAnnotation(this.POS)) && (rightType.hasAnnotation(this.NN) || rightType.hasAnnotation(this.POS))) {
            type.addAnnotation(this.NN);
            return;
        }
        type.addAnnotation(this.UNKNOWN);
    }

    private void addAnnotationForAnd(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror rightType = this.getAnnotatedType(rightExpr);
        if (rightType.hasAnnotation(this.NN) || rightType.hasAnnotation(this.POS)) {
            type.addAnnotation(this.NN);
            return;
        }
        type.addAnnotation(this.UNKNOWN);
    }

    private class LowerBoundTreeAnnotator
    extends TreeAnnotator {
        public LowerBoundTreeAnnotator(AnnotatedTypeFactory annotatedTypeFactory) {
            super(annotatedTypeFactory);
        }

        private void promoteType(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        private void demoteType(AnnotatedTypeMirror typeSrc, AnnotatedTypeMirror typeDst) {
            if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else if (typeSrc.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
            } else {
                typeDst.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
            }
        }

        @Override
        public Void visitUnary(UnaryTree tree, AnnotatedTypeMirror typeDst) {
            AnnotatedTypeMirror typeSrc = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getExpression());
            switch (tree.getKind()) {
                case PREFIX_INCREMENT: {
                    this.promoteType(typeSrc, typeDst);
                    break;
                }
                case PREFIX_DECREMENT: {
                    this.demoteType(typeSrc, typeDst);
                    break;
                }
                case POSTFIX_INCREMENT: 
                case POSTFIX_DECREMENT: {
                    break;
                }
            }
            return (Void)super.visitUnary(tree, typeDst);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            ExpressionTree right;
            ExpressionTree left;
            if (LowerBoundAnnotatedTypeFactory.this.imf.isMathMin(tree, LowerBoundAnnotatedTypeFactory.this.processingEnv)) {
                left = tree.getArguments().get(0);
                right = tree.getArguments().get(1);
                type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.qualHierarchy.leastUpperBound(LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(left).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS), LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(right).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS)));
            }
            if (LowerBoundAnnotatedTypeFactory.this.imf.isMathMax(tree, LowerBoundAnnotatedTypeFactory.this.processingEnv)) {
                left = tree.getArguments().get(0);
                right = tree.getArguments().get(1);
                type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(left).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS), LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(right).getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS)));
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        private Integer getMinLenFromMemberSelectTree(MemberSelectTree tree) {
            if (TreeUtils.isArrayLengthAccess(tree)) {
                AnnotatedTypeMirror minLenType = LowerBoundAnnotatedTypeFactory.this.getMinLenAnnotatedTypeFactory().getAnnotatedType(tree.getExpression());
                AnnotationMirror anm = minLenType.getAnnotation(MinLen.class);
                if (anm == null) {
                    return null;
                }
                return AnnotationUtils.getElementValue(anm, "value", Integer.class, true);
            }
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
            Integer minLen = this.getMinLenFromMemberSelectTree(tree);
            if (minLen != null) {
                type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.anmFromVal(minLen));
            }
            return (Void)super.visitMemberSelect(tree, type);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
                return super.visitBinary(tree, type);
            }
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            switch (tree.getKind()) {
                case PLUS: {
                    this.addAnnotationForPlus(left, right, type);
                    break;
                }
                case MINUS: {
                    this.addAnnotationForMinus(left, right, type);
                    break;
                }
                case MULTIPLY: {
                    this.addAnnotationForMultiply(left, right, type);
                    break;
                }
                case DIVIDE: {
                    this.addAnnotationForDivide(left, right, type);
                    break;
                }
                case REMAINDER: {
                    this.addAnnotationForRemainder(left, right, type);
                    break;
                }
                case AND: {
                    LowerBoundAnnotatedTypeFactory.this.addAnnotationForAnd(left, right, type);
                    break;
                }
                case RIGHT_SHIFT: {
                    LowerBoundAnnotatedTypeFactory.this.addAnnotationForRightShift(left, right, type);
                    break;
                }
            }
            return super.visitBinary(tree, type);
        }

        private void addAnnotationForLiteralPlus(int val, AnnotatedTypeMirror nonLiteralType, AnnotatedTypeMirror type) {
            if (val == -2) {
                if (nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
                    return;
                }
            } else {
                if (val == -1) {
                    this.demoteType(nonLiteralType, type);
                    return;
                }
                if (val == 0) {
                    type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                    return;
                }
                if (val == 1) {
                    this.promoteType(nonLiteralType, type);
                    return;
                }
                if (val >= 2 && !nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
                    return;
                }
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForPlus(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            Long valRightOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(rightExpr);
            if (valRightOrNull != null) {
                this.addAnnotationForLiteralPlus(valRightOrNull.intValue(), leftType, type);
                return;
            }
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valLeftOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(leftExpr);
            if (valLeftOrNull != null) {
                this.addAnnotationForLiteralPlus(valLeftOrNull.intValue(), rightType, type);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(rightType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            if (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(leftType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1) || leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForMinus(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            Long valRightOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(rightExpr);
            if (valRightOrNull != null) {
                MemberSelectTree mstree;
                Integer minLen;
                AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
                this.addAnnotationForLiteralPlus(-1 * valRightOrNull.intValue(), leftType, type);
                if (leftExpr.getKind() == Tree.Kind.MEMBER_SELECT && (minLen = this.getMinLenFromMemberSelectTree(mstree = (MemberSelectTree)leftExpr)) != null) {
                    type.replaceAnnotation(LowerBoundAnnotatedTypeFactory.this.anmFromVal(minLen - valRightOrNull.intValue()));
                }
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForLiteralMultiply(int val, AnnotatedTypeMirror nonLiteralType, AnnotatedTypeMirror type) {
            if (val == 0) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (val == 1) {
                type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            if (val > 1 && (nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || nonLiteralType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN))) {
                type.addAnnotation(nonLiteralType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private boolean checkForMathRandomSpecialCase(ExpressionTree randTree, ExpressionTree arrLenTree, AnnotatedTypeMirror type) {
            if (randTree.getKind() == Tree.Kind.METHOD_INVOCATION && TreeUtils.isArrayLengthAccess(arrLenTree)) {
                MethodInvocationTree miTree = (MethodInvocationTree)randTree;
                if (LowerBoundAnnotatedTypeFactory.this.imf.isMathRandom(miTree, LowerBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                    return true;
                }
                if (LowerBoundAnnotatedTypeFactory.this.imf.isRandomNextDouble(miTree, LowerBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                    return true;
                }
            }
            return false;
        }

        private void addAnnotationForMultiply(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            if (this.checkForMathRandomSpecialCase(rightExpr, leftExpr, type) || this.checkForMathRandomSpecialCase(leftExpr, rightExpr, type)) {
                return;
            }
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            Long valRightOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(rightExpr);
            if (valRightOrNull != null) {
                this.addAnnotationForLiteralMultiply(valRightOrNull.intValue(), leftType, type);
                return;
            }
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valLeftOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(leftExpr);
            if (valLeftOrNull != null) {
                this.addAnnotationForLiteralMultiply(valLeftOrNull.intValue(), rightType, type);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) || leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) && rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForLiteralDivideLeft(int val, AnnotatedTypeMirror rightType, AnnotatedTypeMirror type) {
            if (val == 0) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            } else if (val == 1) {
                if (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN) || rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS)) {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                } else {
                    type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
                }
            }
        }

        private void addAnnotationForLiteralDivideRight(int val, AnnotatedTypeMirror leftType, AnnotatedTypeMirror type) {
            if (val == 0) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.POS);
            } else if (val == 1) {
                type.addAnnotation(leftType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
            } else if (val >= 2 && (leftType.hasAnnotation(NonNegative.class) || leftType.hasAnnotation(Positive.class))) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            }
        }

        private void addAnnotationForDivide(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            Long valRightOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(rightExpr);
            if (valRightOrNull != null) {
                this.addAnnotationForLiteralDivideRight(valRightOrNull.intValue(), leftType, type);
                return;
            }
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valLeftOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(leftExpr);
            if (valLeftOrNull != null) {
                this.addAnnotationForLiteralDivideLeft(valLeftOrNull.intValue(), leftType, type);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) && (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN))) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || rightType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(leftType.getAnnotationInHierarchy(LowerBoundAnnotatedTypeFactory.this.POS));
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }

        private void addAnnotationForLiteralRemainder(int val, AnnotatedTypeMirror type) {
            if (val == 1 || val == -1) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
            }
        }

        public void addAnnotationForRemainder(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror leftType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(leftExpr);
            AnnotatedTypeMirror rightType = LowerBoundAnnotatedTypeFactory.this.getAnnotatedType(rightExpr);
            Long valRightOrNull = LowerBoundAnnotatedTypeFactory.this.getExactValueOrNullFromTree(rightExpr);
            if (valRightOrNull != null) {
                this.addAnnotationForLiteralRemainder(valRightOrNull.intValue(), type);
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.POS) || leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.NN)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.NN);
                return;
            }
            if (leftType.hasAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1)) {
                type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.GTEN1);
                return;
            }
            type.addAnnotation(LowerBoundAnnotatedTypeFactory.this.UNKNOWN);
        }
    }
}

