/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.samelen.SameLenUtils;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationUtils;

public class SameLenAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    private AnnotationMirror BOTTOM;

    public SameLenAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationUtils.fromClass(this.elements, SameLenUnknown.class);
        this.BOTTOM = AnnotationUtils.fromClass(this.elements, SameLenBottom.class);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(SameLen.class, SameLenBottom.class, SameLenUnknown.class));
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new SameLenQualifierHierarchy(factory);
    }

    private boolean overlap(List<String> listA, List<String> listB) {
        for (String a : listA) {
            for (String b : listB) {
                if (!a.equals(b)) continue;
                return true;
            }
        }
        return false;
    }

    public AnnotationMirror getCombinedSameLen(List<String> a1Names, List<String> a2Names) {
        HashSet<String> newValues = new HashSet<String>(a1Names.size() + a2Names.size());
        newValues.addAll(a1Names);
        newValues.addAll(a2Names);
        Object[] names = newValues.toArray(new String[newValues.size()]);
        Arrays.sort(names);
        return this.createSameLen((String[])names);
    }

    public AnnotationMirror createCombinedSameLen(FlowExpressions.Receiver aRec, FlowExpressions.Receiver bRec, AnnotationMirror sl1, AnnotationMirror sl2) {
        String a = aRec.toString();
        String b = bRec.toString();
        ArrayList<String> aValues = new ArrayList<String>();
        aValues.add(a);
        if (AnnotationUtils.areSameByClass(sl1, SameLen.class)) {
            aValues.addAll(SameLenUtils.getValue(sl1));
        }
        ArrayList<String> bValues = new ArrayList<String>();
        bValues.add(b);
        if (AnnotationUtils.areSameByClass(sl2, SameLen.class)) {
            bValues.addAll(SameLenUtils.getValue(sl2));
        }
        AnnotationMirror res = this.getCombinedSameLen(aValues, bValues);
        return res;
    }

    public AnnotationMirror createSameLen(String ... val) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, SameLen.class);
        builder.setValue((CharSequence)"value", val);
        return builder.build();
    }

    private final class SameLenQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public SameLenQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror getTopAnnotation(AnnotationMirror start) {
            return SameLenAnnotatedTypeFactory.this.UNKNOWN;
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.hasElementValue(a1, "value") && AnnotationUtils.hasElementValue(a2, "value")) {
                List<String> a2Val;
                List<String> a1Val = SameLenUtils.getValue(a1);
                if (SameLenAnnotatedTypeFactory.this.overlap(a1Val, a2Val = SameLenUtils.getValue(a2))) {
                    return SameLenAnnotatedTypeFactory.this.getCombinedSameLen(a1Val, a2Val);
                }
                return SameLenAnnotatedTypeFactory.this.BOTTOM;
            }
            if (AnnotationUtils.areSameByClass(a1, SameLenUnknown.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, SameLenUnknown.class)) {
                return a1;
            }
            return SameLenAnnotatedTypeFactory.this.BOTTOM;
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.hasElementValue(a1, "value") && AnnotationUtils.hasElementValue(a2, "value")) {
                List<String> a2Val;
                List<String> a1Val = SameLenUtils.getValue(a1);
                if (SameLenAnnotatedTypeFactory.this.overlap(a1Val, a2Val = SameLenUtils.getValue(a2))) {
                    return SameLenAnnotatedTypeFactory.this.getCombinedSameLen(a1Val, a2Val);
                }
                return SameLenAnnotatedTypeFactory.this.UNKNOWN;
            }
            if (AnnotationUtils.areSameByClass(a1, SameLenBottom.class)) {
                return a2;
            }
            if (AnnotationUtils.areSameByClass(a2, SameLenBottom.class)) {
                return a1;
            }
            return SameLenAnnotatedTypeFactory.this.UNKNOWN;
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            List<String> a2Val;
            List<String> a1Val;
            if (AnnotationUtils.areSameByClass(rhs, SameLenBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(lhs, SameLenUnknown.class)) {
                return true;
            }
            return AnnotationUtils.hasElementValue(rhs, "value") && AnnotationUtils.hasElementValue(lhs, "value") && SameLenAnnotatedTypeFactory.this.overlap(a1Val = SameLenUtils.getValue(rhs), a2Val = SameLenUtils.getValue(lhs));
        }
    }
}

