/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.samelen;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.samelen.SameLenUtils;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;

public class SameLenTransfer
extends CFTransfer {
    private SameLenAnnotatedTypeFactory aTypeFactory;
    private AnnotationMirror UNKNOWN;
    private CFAnalysis analysis;

    public SameLenTransfer(CFAnalysis analysis) {
        super(analysis);
        this.analysis = analysis;
        this.aTypeFactory = (SameLenAnnotatedTypeFactory)analysis.getTypeFactory();
        this.UNKNOWN = this.aTypeFactory.UNKNOWN;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode node, TransferInput<CFValue, CFStore> in) {
        AnnotationMirror leftAnno;
        ArrayCreationNode acNode;
        TransferResult<CFValue, CFStore> result = super.visitAssignment(node, in);
        if (node.getExpression() instanceof ArrayCreationNode && (acNode = (ArrayCreationNode)node.getExpression()).getDimensions().size() == 1 && this.isArrayLengthAccess(acNode.getDimension(0))) {
            FieldAccessNode arrayLengthNode = (FieldAccessNode)acNode.getDimension(0);
            Node arrayLengthNodeReceiver = arrayLengthNode.getReceiver();
            FlowExpressions.Receiver targetRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget());
            FlowExpressions.Receiver otherRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), arrayLengthNodeReceiver);
            AnnotationMirror arrayLengthNodeAnnotation = this.aTypeFactory.getAnnotatedType(arrayLengthNodeReceiver.getTree()).getAnnotationInHierarchy(this.UNKNOWN);
            AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(targetRec, otherRec, this.UNKNOWN, arrayLengthNodeAnnotation);
            this.propagateCombinedSameLen(combinedSameLen, node, result.getRegularStore());
        }
        if ((leftAnno = this.aTypeFactory.getAnnotatedType(node.getExpression().getTree()).getAnnotationInHierarchy(this.UNKNOWN)) != null && AnnotationUtils.areSameByClass(leftAnno, SameLen.class)) {
            AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget()), FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getExpression()), this.UNKNOWN, leftAnno);
            this.propagateCombinedSameLen(combinedSameLen, node, result.getRegularStore());
        }
        return result;
    }

    private void propagateCombinedSameLen(AnnotationMirror combinedSameLen, Node node, CFStore store) {
        for (String s2 : SameLenUtils.getValue(combinedSameLen)) {
            FlowExpressions.Receiver recS;
            try {
                recS = this.aTypeFactory.getReceiverFromJavaExpressionString(s2, this.aTypeFactory.getPath(node.getTree()));
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                recS = null;
            }
            if (recS == null) continue;
            store.clearValue(recS);
            store.insertValue(recS, combinedSameLen);
        }
    }

    private boolean isArrayLengthAccess(Node node) {
        return node instanceof FieldAccessNode && ((FieldAccessNode)node).getFieldName().equals("length") && ((FieldAccessNode)node).getReceiver().getType().getKind() == TypeKind.ARRAY;
    }

    private void refineEq(Node left, Node right, CFStore store) {
        if (this.isArrayLengthAccess(left) && this.isArrayLengthAccess(right)) {
            Node leftReceiverNode = ((FieldAccessNode)left).getReceiver();
            Node rightReceiverNode = ((FieldAccessNode)right).getReceiver();
            FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), leftReceiverNode);
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), rightReceiverNode);
            AnnotationMirror leftReceiverAnno = this.getAnno(leftReceiverNode);
            AnnotationMirror rightReceiverAnno = this.getAnno(rightReceiverNode);
            AnnotationMirror combinedSameLen = this.aTypeFactory.createCombinedSameLen(leftRec, rightRec, leftReceiverAnno, rightReceiverAnno);
            this.propagateCombinedSameLen(combinedSameLen, left, store);
        }
    }

    AnnotationMirror getAnno(Node n) {
        CFValue cfValue = (CFValue)this.analysis.getValue(n);
        if (cfValue == null) {
            return this.UNKNOWN;
        }
        if (cfValue.getAnnotations().size() == 1) {
            return cfValue.getAnnotations().iterator().next();
        }
        return this.UNKNOWN;
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> result, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        if (notEqualTo) {
            this.refineEq(firstNode, secondNode, result.getElseStore());
        } else {
            this.refineEq(firstNode, secondNode, result.getThenStore());
        }
        return new ConditionalTransferResult<CFValue, CFStore>(result.getResultValue(), result.getThenStore(), result.getElseStore());
    }
}

