/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.Pair;

public abstract class UBQualifier {
    public static UBQualifier createUBQualifier(AnnotationMirror am) {
        if (AnnotationUtils.areSameByClass(am, UpperBoundUnknown.class)) {
            return UpperBoundUnknownQualifier.UNKNOWN;
        }
        if (AnnotationUtils.areSameByClass(am, UpperBoundBottom.class)) {
            return UpperBoundBottomQualifier.BOTTOM;
        }
        if (AnnotationUtils.areSameByClass(am, LTLengthOf.class)) {
            return UBQualifier.parseLTLengthOf(am);
        }
        if (AnnotationUtils.areSameByClass(am, LTEqLengthOf.class)) {
            return UBQualifier.parseLTEqLengthOf(am);
        }
        if (AnnotationUtils.areSameByClass(am, LTOMLengthOf.class)) {
            return UBQualifier.parseLTOMLengthOf(am);
        }
        assert (false);
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    private static UBQualifier parseLTLengthOf(AnnotationMirror am) {
        List<String> arrays = AnnotationUtils.getElementValueArray(am, "value", String.class, true);
        List<String> offset = AnnotationUtils.getElementValueArray(am, "offset", String.class, true);
        if (offset.isEmpty()) {
            offset = Collections.nCopies(arrays.size(), "");
        }
        return UBQualifier.createUBQualifier(arrays, offset);
    }

    private static UBQualifier parseLTEqLengthOf(AnnotationMirror am) {
        List<String> arrays = AnnotationUtils.getElementValueArray(am, "value", String.class, true);
        List<String> offset = Collections.nCopies(arrays.size(), "-1");
        return UBQualifier.createUBQualifier(arrays, offset);
    }

    private static UBQualifier parseLTOMLengthOf(AnnotationMirror am) {
        List<String> arrays = AnnotationUtils.getElementValueArray(am, "value", String.class, true);
        List<String> offset = Collections.nCopies(arrays.size(), "1");
        return UBQualifier.createUBQualifier(arrays, offset);
    }

    public static UBQualifier createUBQualifier(String array, String offset) {
        return UBQualifier.createUBQualifier(Collections.singletonList(array), Collections.singletonList(offset));
    }

    public static UBQualifier createUBQualifier(AnnotatedTypeMirror type, AnnotationMirror top) {
        return UBQualifier.createUBQualifier(type.getAnnotationInHierarchy(top));
    }

    public static UBQualifier createUBQualifier(List<String> arrays, List<String> offsets) {
        assert (!arrays.isEmpty());
        HashMap<String, Set<OffsetEquation>> map = new HashMap<String, Set<OffsetEquation>>();
        if (offsets.isEmpty()) {
            for (String array : arrays) {
                map.put(array, Collections.singleton(OffsetEquation.ZERO));
            }
        } else {
            assert (arrays.size() == offsets.size());
            for (int i = 0; i < arrays.size(); ++i) {
                OffsetEquation eq;
                String array = arrays.get(i);
                String offset = offsets.get(i);
                HashSet<OffsetEquation> set = (HashSet<OffsetEquation>)map.get(array);
                if (set == null) {
                    set = new HashSet<OffsetEquation>();
                    map.put(array, set);
                }
                if ((eq = OffsetEquation.createOffsetFromJavaExpression(offset)).hasError()) {
                    return UpperBoundUnknownQualifier.UNKNOWN;
                }
                set.add(eq);
            }
        }
        return new LessThanLengthOf(map);
    }

    public UBQualifier plusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public UBQualifier plusOffset(int value) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public UBQualifier minusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public UBQualifier minusOffset(int value) {
        return UpperBoundUnknownQualifier.UNKNOWN;
    }

    public final boolean isUnknownOrBottom() {
        return this.isBottom() || this.isUnknown();
    }

    public abstract boolean isUnknown();

    public abstract boolean isBottom();

    public abstract boolean isSubtype(UBQualifier var1);

    public abstract UBQualifier lub(UBQualifier var1);

    public abstract UBQualifier glb(UBQualifier var1);

    public boolean isLessThanLengthOf(String array) {
        return false;
    }

    public boolean isLessThanLengthOfAny(List<String> arrays) {
        return false;
    }

    public boolean isLessThanOrEqualTo(String array) {
        return false;
    }

    private static class UpperBoundBottomQualifier
    extends UBQualifier {
        static final UBQualifier BOTTOM = new UpperBoundBottomQualifier();

        private UpperBoundBottomQualifier() {
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return true;
        }

        @Override
        public boolean isSubtype(UBQualifier superType) {
            return true;
        }

        @Override
        public UBQualifier lub(UBQualifier other) {
            return other;
        }

        @Override
        public UBQualifier glb(UBQualifier other) {
            return this;
        }

        public String toString() {
            return "BOTTOM";
        }
    }

    public static class UpperBoundUnknownQualifier
    extends UBQualifier {
        static final UBQualifier UNKNOWN = new UpperBoundUnknownQualifier();

        private UpperBoundUnknownQualifier() {
        }

        @Override
        public boolean isBottom() {
            return false;
        }

        @Override
        public boolean isSubtype(UBQualifier superType) {
            return superType.isUnknown();
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public UBQualifier lub(UBQualifier other) {
            return this;
        }

        @Override
        public UBQualifier glb(UBQualifier other) {
            return other;
        }

        public String toString() {
            return "UNKNOWN";
        }
    }

    static class LessThanLengthOf
    extends UBQualifier {
        private final Map<String, Set<OffsetEquation>> map;

        private LessThanLengthOf(Map<String, Set<OffsetEquation>> map) {
            assert (!map.isEmpty());
            this.map = map;
        }

        @Override
        public boolean isLessThanOrEqualTo(String array) {
            Set<OffsetEquation> offsets = this.map.get(array);
            if (offsets == null) {
                return false;
            }
            return offsets.contains(OffsetEquation.NEG_1);
        }

        @Override
        public boolean isLessThanLengthOfAny(List<String> arrays) {
            for (String array : arrays) {
                if (!this.isLessThanLengthOf(array)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isLessThanLengthOf(String array) {
            Set<OffsetEquation> offsets = this.map.get(array);
            if (offsets == null) {
                return false;
            }
            if (offsets.isEmpty()) {
                return true;
            }
            for (OffsetEquation offset : offsets) {
                if (!offset.isNonNegative()) continue;
                return true;
            }
            return false;
        }

        public AnnotationMirror convertToAnnotationMirror(ProcessingEnvironment env) {
            AnnotationBuilder builder;
            ArrayList<String> sortedArrays = new ArrayList<String>(this.map.keySet());
            Collections.sort(sortedArrays);
            ArrayList<String> arrays = new ArrayList<String>();
            ArrayList<String> offsets = new ArrayList<String>();
            boolean isLTEq = true;
            boolean isLTOM = true;
            for (String array : sortedArrays) {
                ArrayList<String> sortOffsets = new ArrayList<String>();
                for (OffsetEquation eq : this.map.get(array)) {
                    isLTEq = isLTEq && eq.equals(OffsetEquation.NEG_1);
                    isLTOM = isLTOM && eq.equals(OffsetEquation.ONE);
                    sortOffsets.add(eq.toString());
                }
                Collections.sort(sortOffsets);
                for (String offset : sortOffsets) {
                    arrays.add(array);
                    offsets.add(offset);
                }
            }
            if (isLTEq) {
                builder = new AnnotationBuilder(env, LTEqLengthOf.class);
                builder.setValue((CharSequence)"value", arrays);
            } else if (isLTOM) {
                builder = new AnnotationBuilder(env, LTOMLengthOf.class);
                builder.setValue((CharSequence)"value", arrays);
            } else {
                builder = new AnnotationBuilder(env, LTLengthOf.class);
                builder.setValue((CharSequence)"value", arrays);
                builder.setValue((CharSequence)"offset", offsets);
            }
            return builder.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LessThanLengthOf qualifier = (LessThanLengthOf)o;
            if (LessThanLengthOf.containsSame(this.map.keySet(), qualifier.map.keySet())) {
                for (Map.Entry<String, Set<OffsetEquation>> entry : this.map.entrySet()) {
                    Set<OffsetEquation> thisOffset;
                    Set<OffsetEquation> otherOffset = qualifier.map.get(entry.getKey());
                    if (LessThanLengthOf.containsSame(otherOffset, thisOffset = entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static <T> boolean containsSame(Set<T> set1, Set<T> set2) {
            return set1.containsAll(set2) && set2.containsAll(set1);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public boolean isUnknown() {
            return false;
        }

        @Override
        public boolean isBottom() {
            return false;
        }

        @Override
        public boolean isSubtype(UBQualifier superType) {
            if (superType.isUnknown()) {
                return true;
            }
            if (superType.isBottom()) {
                return false;
            }
            LessThanLengthOf superTypeLTL = (LessThanLengthOf)superType;
            if (!this.map.keySet().containsAll(superTypeLTL.map.keySet())) {
                return false;
            }
            for (Map.Entry<String, Set<OffsetEquation>> entry : superTypeLTL.map.entrySet()) {
                String array = entry.getKey();
                Set<OffsetEquation> superOffsets = entry.getValue();
                Set<OffsetEquation> subOffsets = this.map.get(array);
                if (this.isSubtypeOffset(subOffsets, superOffsets)) continue;
                return false;
            }
            return true;
        }

        private boolean isSubtypeOffset(Set<OffsetEquation> subOffsets, Set<OffsetEquation> superOffsets) {
            for (OffsetEquation superOffset : superOffsets) {
                boolean oneIsSubtype = false;
                for (OffsetEquation subOffset : subOffsets) {
                    if (!superOffset.lessThanOrEqual(subOffset)) continue;
                    oneIsSubtype = true;
                    break;
                }
                if (oneIsSubtype) continue;
                return false;
            }
            return true;
        }

        @Override
        public UBQualifier lub(UBQualifier other) {
            if (other.isUnknown()) {
                return other;
            }
            if (other.isBottom()) {
                return this;
            }
            LessThanLengthOf otherLtl = (LessThanLengthOf)other;
            HashSet<String> arrays = new HashSet<String>(this.map.keySet());
            arrays.retainAll(otherLtl.map.keySet());
            HashMap<String, Set<OffsetEquation>> lubMap = new HashMap<String, Set<OffsetEquation>>();
            for (String array : arrays) {
                HashSet<OffsetEquation> lub = new HashSet<OffsetEquation>();
                Set<OffsetEquation> offsets1 = this.map.get(array);
                Set<OffsetEquation> offsets2 = otherLtl.map.get(array);
                for (OffsetEquation offset1 : offsets1) {
                    for (OffsetEquation offset2 : offsets2) {
                        if (offset2.lessThanOrEqual(offset1)) {
                            lub.add(offset2);
                            continue;
                        }
                        if (!offset1.lessThanOrEqual(offset2)) continue;
                        lub.add(offset1);
                    }
                }
                if (lub.isEmpty()) continue;
                lubMap.put(array, lub);
            }
            if (lubMap.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            this.widenLub(otherLtl, lubMap);
            if (lubMap.isEmpty()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            return new LessThanLengthOf(lubMap);
        }

        private void widenLub(LessThanLengthOf other, Map<String, Set<OffsetEquation>> lubMap) {
            if (!LessThanLengthOf.containsSame(this.map.keySet(), lubMap.keySet()) || !LessThanLengthOf.containsSame(other.map.keySet(), lubMap.keySet())) {
                return;
            }
            ArrayList<Pair<String, OffsetEquation>> remove = new ArrayList<Pair<String, OffsetEquation>>();
            for (Map.Entry<String, Set<OffsetEquation>> entry : lubMap.entrySet()) {
                String array = entry.getKey();
                Set<OffsetEquation> lubOffsets = entry.getValue();
                Set<OffsetEquation> thisOffsets = this.map.get(array);
                Set<OffsetEquation> otherOffsets = other.map.get(array);
                if (lubOffsets.size() != thisOffsets.size() || lubOffsets.size() != otherOffsets.size()) {
                    return;
                }
                for (OffsetEquation lubEq : lubOffsets) {
                    if (lubEq.isInt()) {
                        int value;
                        int otherInt;
                        int thisInt = OffsetEquation.getIntOffsetEquation(thisOffsets).getInt();
                        if (thisInt == (otherInt = OffsetEquation.getIntOffsetEquation(otherOffsets).getInt()) || (value = lubEq.getInt()) >= -10) continue;
                        remove.add(Pair.of(array, lubEq));
                        continue;
                    }
                    if (thisOffsets.contains(lubEq) && otherOffsets.contains(lubEq)) continue;
                    return;
                }
            }
            for (Pair pair : remove) {
                Set<OffsetEquation> offsets = lubMap.get(pair.first);
                offsets.remove(pair.second);
                if (!offsets.isEmpty()) continue;
                lubMap.remove(pair.first);
            }
        }

        @Override
        public UBQualifier glb(UBQualifier other) {
            if (other.isUnknown()) {
                return this;
            }
            if (other.isBottom()) {
                return other;
            }
            LessThanLengthOf otherLtl = (LessThanLengthOf)other;
            HashSet<String> arrays = new HashSet<String>(this.map.keySet());
            arrays.addAll(otherLtl.map.keySet());
            HashMap<String, Set<OffsetEquation>> glbMap = new HashMap<String, Set<OffsetEquation>>();
            for (String array : arrays) {
                Set<OffsetEquation> glb = this.map.get(array);
                Set<OffsetEquation> otherglb = otherLtl.map.get(array);
                if (glb == null) {
                    glb = otherglb;
                } else if (otherglb != null) {
                    glb.addAll(otherglb);
                }
                glbMap.put(array, this.simplifyOffsets(glb));
            }
            return new LessThanLengthOf(glbMap);
        }

        private Set<OffsetEquation> simplifyOffsets(Set<OffsetEquation> offsets) {
            HashSet<OffsetEquation> newOff = new HashSet<OffsetEquation>();
            OffsetEquation literal = null;
            for (OffsetEquation eq : offsets) {
                if (eq.isInt()) {
                    if (literal == null) {
                        literal = eq;
                        continue;
                    }
                    literal = literal.lessThanOrEqual(eq) ? eq : literal;
                    continue;
                }
                newOff.add(eq);
            }
            if (literal != null) {
                newOff.add(literal);
            }
            return newOff;
        }

        @Override
        public UBQualifier plusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
            OffsetEquation newOffset = OffsetEquation.createOffsetFromNode(node, factory, '+');
            if (newOffset.hasError()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            return this.addOffset(newOffset);
        }

        @Override
        public UBQualifier plusOffset(int value) {
            OffsetEquation newOffset = OffsetEquation.createOffsetForInt(value);
            return this.addOffset(newOffset);
        }

        @Override
        public UBQualifier minusOffset(Node node, UpperBoundAnnotatedTypeFactory factory) {
            OffsetEquation newOffset = OffsetEquation.createOffsetFromNode(node, factory, '-');
            if (newOffset.hasError()) {
                return UpperBoundUnknownQualifier.UNKNOWN;
            }
            return this.addOffset(newOffset);
        }

        @Override
        public UBQualifier minusOffset(int value) {
            OffsetEquation newOffset = OffsetEquation.createOffsetForInt(-value);
            return this.addOffset(newOffset);
        }

        private UBQualifier addOffset(OffsetEquation newOffset) {
            HashMap<String, Set<OffsetEquation>> plusMap = new HashMap<String, Set<OffsetEquation>>(this.map.size());
            for (Map.Entry<String, Set<OffsetEquation>> entry : this.map.entrySet()) {
                HashSet<OffsetEquation> plus = new HashSet<OffsetEquation>(entry.getValue().size());
                for (OffsetEquation eq : entry.getValue()) {
                    plus.add(eq.copyAdd('+', newOffset));
                }
                plusMap.put(entry.getKey(), plus);
            }
            return new LessThanLengthOf(plusMap);
        }

        public UBQualifier divide(int divisor) {
            if (divisor == 1) {
                return this;
            }
            if (divisor > 1) {
                HashMap<String, Set<OffsetEquation>> divideMap = new HashMap<String, Set<OffsetEquation>>(this.map.size());
                for (Map.Entry<String, Set<OffsetEquation>> entry : this.map.entrySet()) {
                    HashSet<OffsetEquation> divide = new HashSet<OffsetEquation>(entry.getValue().size());
                    for (OffsetEquation eq : entry.getValue()) {
                        if (!eq.isNegativeOrZero()) continue;
                        divide.add(eq);
                    }
                    if (divide.isEmpty()) continue;
                    divideMap.put(entry.getKey(), divide);
                }
                if (divideMap.isEmpty()) {
                    return UpperBoundUnknownQualifier.UNKNOWN;
                }
                return new LessThanLengthOf(divideMap);
            }
            return UpperBoundUnknownQualifier.UNKNOWN;
        }

        public boolean isValuePlusOffsetLessThanMinLen(String array, int value, int minlen) {
            Set<OffsetEquation> offsets = this.map.get(array);
            if (offsets == null) {
                return false;
            }
            for (OffsetEquation offset : offsets) {
                if (!offset.isInt()) continue;
                return minlen > value + offset.getInt();
            }
            return false;
        }

        public String toString() {
            return "LessThanLengthOf{map=" + this.map + '}';
        }

        public Iterable<? extends String> getArrays() {
            return this.map.keySet();
        }
    }
}

