/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexMethodIdentifier;
import org.checkerframework.checker.index.lowerbound.LowerBoundAnnotatedTypeFactory;
import org.checkerframework.checker.index.lowerbound.LowerBoundChecker;
import org.checkerframework.checker.index.minlen.MinLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.minlen.MinLenChecker;
import org.checkerframework.checker.index.qual.IndexFor;
import org.checkerframework.checker.index.qual.IndexOrHigh;
import org.checkerframework.checker.index.qual.IndexOrLow;
import org.checkerframework.checker.index.qual.LTEqLengthOf;
import org.checkerframework.checker.index.qual.LTLengthOf;
import org.checkerframework.checker.index.qual.LTOMLengthOf;
import org.checkerframework.checker.index.qual.MinLen;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.index.samelen.SameLenAnnotatedTypeFactory;
import org.checkerframework.checker.index.samelen.SameLenChecker;
import org.checkerframework.checker.index.upperbound.OffsetEquation;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.framework.util.AnnotationBuilder;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.framework.util.dependenttypes.DependentTypesError;
import org.checkerframework.framework.util.dependenttypes.DependentTypesHelper;
import org.checkerframework.framework.util.dependenttypes.DependentTypesTreeAnnotator;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class UpperBoundAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    public final AnnotationMirror BOTTOM;
    private final IndexMethodIdentifier imf;

    public UpperBoundAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationUtils.fromClass(this.elements, UpperBoundUnknown.class);
        this.BOTTOM = AnnotationUtils.fromClass(this.elements, UpperBoundBottom.class);
        this.addAliasedAnnotation(IndexFor.class, this.createLTLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(IndexOrLow.class, this.createLTLengthOfAnnotation(new String[0]));
        this.addAliasedAnnotation(IndexOrHigh.class, this.createLTEqLengthOfAnnotation(new String[0]));
        this.imf = new IndexMethodIdentifier(this.processingEnv);
        this.postInit();
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(UpperBoundUnknown.class, LTEqLengthOf.class, LTLengthOf.class, LTOMLengthOf.class, UpperBoundBottom.class));
    }

    public static String[] getValue(AnnotationMirror anno) {
        if (!AnnotationUtils.hasElementValue(anno, "value")) {
            return null;
        }
        return AnnotationUtils.getElementValueArray(anno, "value", String.class, true).toArray(new String[0]);
    }

    ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    MinLenAnnotatedTypeFactory getMinLenAnnotatedTypeFactory() {
        return (MinLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(MinLenChecker.class);
    }

    private SameLenAnnotatedTypeFactory getSameLenAnnotatedTypeFactory() {
        return (SameLenAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(SameLenChecker.class);
    }

    private LowerBoundAnnotatedTypeFactory getLowerBoundAnnotatedTypeFactory() {
        return (LowerBoundAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(LowerBoundChecker.class);
    }

    @Override
    protected DependentTypesHelper createDependentTypesHelper() {
        return new DependentTypesHelper(this){

            @Override
            protected String standardizeString(String expression, FlowExpressionParseUtil.FlowExpressionContext context, TreePath localScope, boolean useLocalScope) {
                if (DependentTypesError.isExpressionError(expression)) {
                    return expression;
                }
                if (this.indexOf(expression, '-', '+', 0) == -1) {
                    return super.standardizeString(expression, context, localScope, useLocalScope);
                }
                OffsetEquation equation = OffsetEquation.createOffsetFromJavaExpression(expression);
                if (equation.hasError()) {
                    return equation.getError();
                }
                try {
                    equation.standardizeAndViewpointAdaptExpressions(context, localScope, useLocalScope);
                }
                catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                    return new DependentTypesError(expression, e).toString();
                }
                return equation.toString();
            }

            private int indexOf(String expression, char a, char b, int index) {
                int aIndex = expression.indexOf(a, index);
                int bIndex = expression.indexOf(b, index);
                if (aIndex == -1) {
                    return bIndex;
                }
                if (bIndex == -1) {
                    return aIndex;
                }
                return Math.min(aIndex, bIndex);
            }

            @Override
            public TreeAnnotator createDependentTypesTreeAnnotator(AnnotatedTypeFactory factory) {
                return new DependentTypesTreeAnnotator(factory, this){

                    @Override
                    public Void visitMemberSelect(MemberSelectTree tree, AnnotatedTypeMirror type) {
                        if (TreeUtils.isArrayLengthAccess(tree)) {
                            return null;
                        }
                        return super.visitMemberSelect(tree, type);
                    }
                };
            }
        };
    }

    @Override
    public AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        if (AnnotationUtils.areSameByClass(a, IndexFor.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        if (AnnotationUtils.areSameByClass(a, IndexOrLow.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        if (AnnotationUtils.areSameByClass(a, IndexOrHigh.class)) {
            List<String> stringList = AnnotationUtils.getElementValueArray(a, "value", String.class, true);
            return this.createLTEqLengthOfAnnotation(stringList.toArray(new String[0]));
        }
        return super.aliasedAnnotation(a);
    }

    public int minLenFromExpressionTree(ExpressionTree tree) {
        AnnotatedTypeMirror minLenType = this.getMinLenAnnotatedTypeFactory().getAnnotatedType(tree);
        AnnotationMirror anm = minLenType.getAnnotation(MinLen.class);
        if (anm == null) {
            return -1;
        }
        int minLen = AnnotationUtils.getElementValue(anm, "value", Integer.class, true);
        return minLen;
    }

    public AnnotationMirror sameLenAnnotationFromExpressionTree(ExpressionTree tree) {
        AnnotatedTypeMirror sameLenType = this.getSameLenAnnotatedTypeFactory().getAnnotatedType(tree);
        return sameLenType.getAnnotation(SameLen.class);
    }

    private List<Long> possibleValuesFromValueType(AnnotatedTypeMirror valueType) {
        AnnotationMirror anm = valueType.getAnnotation(IntVal.class);
        if (anm == null) {
            return null;
        }
        return ValueAnnotatedTypeFactory.getIntValues(anm);
    }

    private Integer maybeValFromValueType(AnnotatedTypeMirror valueType) {
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues != null && possibleValues.size() == 1) {
            return possibleValues.get(0).intValue();
        }
        return null;
    }

    public Integer valMaxFromExpressionTree(ExpressionTree tree) {
        AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues == null || possibleValues.size() == 0) {
            return null;
        }
        long valMax = Collections.max(possibleValues);
        return new Integer((int)valMax);
    }

    public Integer valMinFromExpressionTree(ExpressionTree tree) {
        AnnotatedTypeMirror valueType = this.getValueAnnotatedTypeFactory().getAnnotatedType(tree);
        List<Long> possibleValues = this.possibleValuesFromValueType(valueType);
        if (possibleValues == null || possibleValues.size() == 0) {
            return null;
        }
        long valMax = Collections.min(possibleValues);
        return (int)valMax;
    }

    public boolean isMathMin(Tree methodTree) {
        return this.imf.isMathMin(methodTree, this.processingEnv);
    }

    public boolean isRandomNextInt(Tree methodTree) {
        return this.imf.isRandomNextInt(methodTree, this.processingEnv);
    }

    AnnotationMirror createLTLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    AnnotationMirror createLTEqLengthOfAnnotation(String ... names) {
        AnnotationBuilder builder = new AnnotationBuilder(this.getProcessingEnv(), LTEqLengthOf.class);
        if (names == null) {
            names = new String[]{};
        }
        builder.setValue((CharSequence)"value", names);
        return builder.build();
    }

    public boolean hasLowerBoundTypeByClass(Node node, Class<? extends Annotation> classOfType) {
        return AnnotationUtils.areSameByClass(this.getLowerBoundAnnotatedTypeFactory().getAnnotatedType(node.getTree()).getAnnotationInHierarchy(this.getLowerBoundAnnotatedTypeFactory().UNKNOWN), classOfType);
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new UpperBoundQualifierHierarchy(factory);
    }

    @Override
    public TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new UpperBoundTreeAnnotator(this), super.createTreeAnnotator());
    }

    public AnnotationMirror convertUBQualifierToAnnotation(UBQualifier qualifier) {
        if (qualifier.isUnknown()) {
            return this.UNKNOWN;
        }
        if (qualifier.isBottom()) {
            return this.BOTTOM;
        }
        UBQualifier.LessThanLengthOf ltlQualifier = (UBQualifier.LessThanLengthOf)qualifier;
        return ltlQualifier.convertToAnnotationMirror(this.processingEnv);
    }

    protected class UpperBoundTreeAnnotator
    extends TreeAnnotator {
        public UpperBoundTreeAnnotator(UpperBoundAnnotatedTypeFactory factory) {
            super(factory);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, AnnotatedTypeMirror type) {
            if (UpperBoundAnnotatedTypeFactory.this.isMathMin(tree)) {
                AnnotatedTypeMirror leftType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotatedTypeMirror rightType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(1));
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.qualHierarchy.greatestLowerBound(leftType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN), rightType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN)));
            }
            if (UpperBoundAnnotatedTypeFactory.this.isRandomNextInt(tree)) {
                AnnotatedTypeMirror argType = UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(tree.getArguments().get(0));
                AnnotationMirror anno = argType.getAnnotationInHierarchy(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                UBQualifier qualifier = UBQualifier.createUBQualifier(anno);
                qualifier = qualifier.plusOffset(1);
                type.replaceAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(qualifier));
            }
            return (Void)super.visitMethodInvocation(tree, type);
        }

        @Override
        public Void visitUnary(UnaryTree node, AnnotatedTypeMirror type) {
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            return (Void)super.visitUnary(node, type);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, AnnotatedTypeMirror type) {
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            return (Void)super.visitCompoundAssignment(node, type);
        }

        @Override
        public Void visitBinary(BinaryTree tree, AnnotatedTypeMirror type) {
            if (TreeUtils.isStringConcatenation(tree)) {
                type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return super.visitBinary(tree, type);
            }
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            switch (tree.getKind()) {
                case PLUS: 
                case MINUS: {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                    break;
                }
                case MULTIPLY: {
                    this.addAnnotationForMultiply(left, right, type);
                    break;
                }
                case DIVIDE: {
                    this.addAnnotationForDivide(left, right, type);
                    break;
                }
            }
            return super.visitBinary(tree, type);
        }

        private void addAnnotationForDivide(ExpressionTree numeratorTree, ExpressionTree divisorTree, AnnotatedTypeMirror resultType) {
            AnnotatedTypeMirror divisorType = UpperBoundAnnotatedTypeFactory.this.getValueAnnotatedTypeFactory().getAnnotatedType(divisorTree);
            Integer divisor = UpperBoundAnnotatedTypeFactory.this.maybeValFromValueType(divisorType);
            if (divisor == null) {
                resultType.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
                return;
            }
            UBQualifier result = UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
            UBQualifier numerator = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(numeratorTree), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            if (!numerator.isUnknownOrBottom()) {
                result = ((UBQualifier.LessThanLengthOf)numerator).divide(divisor);
            }
            result = result.glb(this.plusTreeDivideByVal(divisor, numeratorTree));
            resultType.addAnnotation(UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(result));
        }

        private UBQualifier plusTreeDivideByVal(int divisor, ExpressionTree numeratorTree) {
            numeratorTree = TreeUtils.skipParens(numeratorTree);
            if (divisor < 2 || numeratorTree.getKind() != Tree.Kind.PLUS) {
                return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
            }
            BinaryTree plusTree = (BinaryTree)numeratorTree;
            UBQualifier left = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(plusTree.getLeftOperand()), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            UBQualifier right = UBQualifier.createUBQualifier(UpperBoundAnnotatedTypeFactory.this.getAnnotatedType(plusTree.getRightOperand()), UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
            if (!left.isUnknownOrBottom() && !right.isUnknownOrBottom()) {
                UBQualifier.LessThanLengthOf leftLTL = (UBQualifier.LessThanLengthOf)left;
                UBQualifier.LessThanLengthOf rightLTL = (UBQualifier.LessThanLengthOf)right;
                ArrayList<String> arrays = new ArrayList<String>();
                for (String string : leftLTL.getArrays()) {
                    if (!rightLTL.isLessThanLengthOf(string) || !leftLTL.isLessThanLengthOf(string)) continue;
                    arrays.add(string);
                }
                if (!arrays.isEmpty()) {
                    return UBQualifier.createUBQualifier(arrays, Collections.emptyList());
                }
            }
            return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
        }

        private boolean checkForMathRandomSpecialCase(ExpressionTree randTree, ExpressionTree arrLenTree, AnnotatedTypeMirror type) {
            if (randTree.getKind() == Tree.Kind.METHOD_INVOCATION && TreeUtils.isArrayLengthAccess(arrLenTree)) {
                MemberSelectTree mstree = (MemberSelectTree)arrLenTree;
                MethodInvocationTree mitree = (MethodInvocationTree)randTree;
                if (UpperBoundAnnotatedTypeFactory.this.imf.isMathRandom(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(mstree.getExpression().toString()));
                    return true;
                }
                if (UpperBoundAnnotatedTypeFactory.this.imf.isRandomNextDouble(mitree, UpperBoundAnnotatedTypeFactory.this.processingEnv)) {
                    type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.createLTLengthOfAnnotation(mstree.getExpression().toString()));
                    return true;
                }
            }
            return false;
        }

        private void addAnnotationForMultiply(ExpressionTree leftExpr, ExpressionTree rightExpr, AnnotatedTypeMirror type) {
            if (this.checkForMathRandomSpecialCase(rightExpr, leftExpr, type) || this.checkForMathRandomSpecialCase(leftExpr, rightExpr, type)) {
                return;
            }
            type.addAnnotation(UpperBoundAnnotatedTypeFactory.this.UNKNOWN);
        }
    }

    protected final class UpperBoundQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public UpperBoundQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(a1);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(a2);
            UBQualifier glb = a1Obj.glb(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(glb);
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            UBQualifier a1Obj = UBQualifier.createUBQualifier(a1);
            UBQualifier a2Obj = UBQualifier.createUBQualifier(a2);
            UBQualifier lub = a1Obj.lub(a2Obj);
            return UpperBoundAnnotatedTypeFactory.this.convertUBQualifierToAnnotation(lub);
        }

        @Override
        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            UBQualifier subtype = UBQualifier.createUBQualifier(rhs);
            UBQualifier supertype = UBQualifier.createUBQualifier(lhs);
            return subtype.isSubtype(supertype);
        }
    }
}

