/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.ExpressionTree;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.IndexRefinementInfo;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NumericalAdditionNode;
import org.checkerframework.dataflow.cfg.node.NumericalMultiplicationNode;
import org.checkerframework.dataflow.cfg.node.NumericalSubtractionNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.javacutil.AnnotationProvider;

public class UpperBoundTransfer
extends IndexAbstractTransfer {
    private UpperBoundAnnotatedTypeFactory atypeFactory;

    public UpperBoundTransfer(CFAnalysis analysis) {
        super(analysis);
        this.atypeFactory = (UpperBoundAnnotatedTypeFactory)analysis.getTypeFactory();
    }

    @Override
    public TransferResult<CFValue, CFStore> visitAssignment(AssignmentNode node, TransferInput<CFValue, CFStore> in) {
        ArrayCreationNode acNode;
        TransferResult<CFValue, CFStore> result = super.visitAssignment(node, in);
        Node expNode = node.getExpression();
        Node expNodeSansCast = expNode instanceof TypeCastNode ? ((TypeCastNode)expNode).getOperand() : expNode;
        ArrayCreationNode arrayCreationNode = acNode = expNodeSansCast instanceof ArrayCreationNode ? (acNode = (ArrayCreationNode)expNodeSansCast) : null;
        if (acNode != null) {
            List<Node> nodeList = acNode.getDimensions();
            if (nodeList.size() < 1) {
                return result;
            }
            Node dim = acNode.getDimension(0);
            UBQualifier previousQualifier = this.getUBQualifier(dim, in);
            FlowExpressions.Receiver arrayRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node.getTarget());
            String arrayString = arrayRec.toString();
            UBQualifier newInfo = UBQualifier.createUBQualifier(arrayString, "-1");
            UBQualifier combined = previousQualifier.glb(newInfo);
            AnnotationMirror newAnno = this.atypeFactory.convertUBQualifierToAnnotation(combined);
            FlowExpressions.Receiver dimRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), dim);
            result.getRegularStore().insertValue(dimRec, newAnno);
            this.knownToBeLessThanLengthOf(arrayString, dim, result.getRegularStore(), in);
        }
        return result;
    }

    private void knownToBeLessThanLengthOf(String array, Node node, CFStore store, TransferInput<CFValue, CFStore> in) {
        if (node instanceof NumericalAdditionNode) {
            this.knownToBeArrayLength((NumericalAdditionNode)node, array, in, store);
        } else if (node instanceof NumericalSubtractionNode) {
            this.knownToBeArrayLength((NumericalSubtractionNode)node, array, in, store);
        } else if (node instanceof NumericalMultiplicationNode) {
            Node right = ((NumericalMultiplicationNode)node).getRightOperand();
            Node left = ((NumericalMultiplicationNode)node).getLeftOperand();
            this.knownToBeArrayLengthMultiplication(left, right, array, in, store);
            this.knownToBeArrayLengthMultiplication(right, left, array, in, store);
        }
    }

    private void knownToBeArrayLengthMultiplication(Node node, Node other, String arrayExp, TransferInput<CFValue, CFStore> in, CFStore store) {
        if (this.atypeFactory.hasLowerBoundTypeByClass(other, Positive.class)) {
            Integer x = this.atypeFactory.valMinFromExpressionTree((ExpressionTree)other.getTree());
            UBQualifier lessThan = x != null && x > 1 ? UBQualifier.createUBQualifier(arrayExp, "0") : UBQualifier.createUBQualifier(arrayExp, "-1");
            UBQualifier qual = this.getUBQualifier(node, in);
            UBQualifier newQual = qual.glb(lessThan);
            FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node);
            store.insertValue(rec, this.atypeFactory.convertUBQualifierToAnnotation(newQual));
        }
    }

    private void knownToBeArrayLength(NumericalSubtractionNode node, String arrayExp, TransferInput<CFValue, CFStore> in, CFStore store) {
        UBQualifier newInfo = UBQualifier.createUBQualifier(arrayExp, "-1");
        UBQualifier left = this.getUBQualifier(node.getLeftOperand(), in);
        UBQualifier newLeft = left.glb(newInfo.minusOffset(node.getRightOperand(), this.atypeFactory));
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node.getLeftOperand());
        store.insertValue(leftRec, this.atypeFactory.convertUBQualifierToAnnotation(newLeft));
    }

    private void knownToBeArrayLength(NumericalAdditionNode node, String arrayExp, TransferInput<CFValue, CFStore> in, CFStore store) {
        UBQualifier left = this.getUBQualifier(node.getLeftOperand(), in);
        UBQualifier right = this.getUBQualifier(node.getRightOperand(), in);
        UBQualifier newInfo = UBQualifier.createUBQualifier(arrayExp, "-1");
        UBQualifier newLeft = left.glb(newInfo.plusOffset(node.getRightOperand(), this.atypeFactory));
        newLeft = this.accountForLowerBoundAnnos(node.getRightOperand(), newLeft, arrayExp);
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node.getLeftOperand());
        store.insertValue(leftRec, this.atypeFactory.convertUBQualifierToAnnotation(newLeft));
        UBQualifier newRight = right.glb(newInfo.plusOffset(node.getLeftOperand(), this.atypeFactory));
        newRight = this.accountForLowerBoundAnnos(node.getLeftOperand(), newRight, arrayExp);
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, node.getRightOperand());
        store.insertValue(rightRec, this.atypeFactory.convertUBQualifierToAnnotation(newRight));
    }

    private UBQualifier accountForLowerBoundAnnos(Node node, UBQualifier qual, String arrayExp) {
        if (this.atypeFactory.hasLowerBoundTypeByClass(node, Positive.class)) {
            qual = qual.glb(UBQualifier.createUBQualifier(arrayExp, "0"));
        } else if (this.atypeFactory.hasLowerBoundTypeByClass(node, NonNegative.class)) {
            qual = qual.glb(UBQualifier.createUBQualifier(arrayExp, "-1"));
        }
        return qual;
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        UBQualifier leftQualifier = UBQualifier.createUBQualifier(leftAnno);
        leftQualifier = leftQualifier.plusOffset(1);
        UBQualifier rightQualifier = UBQualifier.createUBQualifier(rightAnno);
        UBQualifier refinedRight = rightQualifier.glb(leftQualifier);
        if (this.isArrayLengthFieldAccess(left)) {
            String array = ((FieldAccessNode)left).getReceiver().toString();
            this.knownToBeLessThanLengthOf(array, right, store, in);
        }
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
        store.insertValue(rightRec, this.atypeFactory.convertUBQualifierToAnnotation(refinedRight));
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        UBQualifier leftQualifier = UBQualifier.createUBQualifier(leftAnno);
        UBQualifier rightQualifier = UBQualifier.createUBQualifier(rightAnno);
        UBQualifier refinedRight = rightQualifier.glb(leftQualifier);
        if (this.isArrayLengthFieldAccess(left)) {
            String array = ((FieldAccessNode)left).getReceiver().toString();
            this.knownToBeLessThanLengthOf(array, right, store, in);
        }
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
        store.insertValue(rightRec, this.atypeFactory.convertUBQualifierToAnnotation(refinedRight));
    }

    @Override
    protected TransferResult<CFValue, CFStore> strengthenAnnotationOfEqualTo(TransferResult<CFValue, CFStore> res, Node firstNode, Node secondNode, CFValue firstValue, CFValue secondValue, boolean notEqualTo) {
        TransferResult<CFValue, CFStore> result = super.strengthenAnnotationOfEqualTo(res, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        IndexRefinementInfo rfi = new IndexRefinementInfo(result, this.analysis, firstNode, secondNode);
        if (rfi.leftAnno == null || rfi.rightAnno == null) {
            return result;
        }
        CFStore equalsStore = notEqualTo ? rfi.elseStore : rfi.thenStore;
        CFStore notEqualStore = notEqualTo ? rfi.thenStore : rfi.elseStore;
        this.refineEq(rfi.left, rfi.leftAnno, rfi.right, rfi.rightAnno, equalsStore);
        this.refineNeqArrayLength(rfi.left, rfi.right, rfi.rightAnno, notEqualStore);
        this.refineNeqArrayLength(rfi.right, rfi.left, rfi.leftAnno, notEqualStore);
        return rfi.newResult;
    }

    private void refineEq(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store) {
        UBQualifier leftQualifier = UBQualifier.createUBQualifier(leftAnno);
        UBQualifier rightQualifier = UBQualifier.createUBQualifier(rightAnno);
        UBQualifier glb = rightQualifier.glb(leftQualifier);
        AnnotationMirror glbAnno = this.atypeFactory.convertUBQualifierToAnnotation(glb);
        FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
        store.insertValue(rightRec, glbAnno);
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), left);
        store.insertValue(leftRec, glbAnno);
    }

    private void refineNeqArrayLength(Node arrayLengthAccess, Node otherNode, AnnotationMirror otherNodeAnno, CFStore store) {
        if (this.isArrayLengthFieldAccess(arrayLengthAccess)) {
            String array;
            UBQualifier otherQualifier = UBQualifier.createUBQualifier(otherNodeAnno);
            FlowExpressions.FieldAccess fa = FlowExpressions.internalReprOfFieldAccess(this.atypeFactory, (FieldAccessNode)arrayLengthAccess);
            if (!fa.getReceiver().containsUnknown() && otherQualifier.isLessThanOrEqualTo(array = fa.getReceiver().toString())) {
                otherQualifier = otherQualifier.glb(UBQualifier.createUBQualifier(array, "0"));
                FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), otherNode);
                store.insertValue(leftRec, this.atypeFactory.convertUBQualifierToAnnotation(otherQualifier));
            }
        }
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalAddition(NumericalAdditionNode n, TransferInput<CFValue, CFStore> in) {
        UBQualifier left = this.getUBQualifier(n.getLeftOperand(), in);
        UBQualifier T = left.minusOffset(n.getRightOperand(), this.atypeFactory);
        UBQualifier right = this.getUBQualifier(n.getRightOperand(), in);
        UBQualifier S = right.minusOffset(n.getLeftOperand(), this.atypeFactory);
        UBQualifier glb = T.glb(S);
        return this.createTransferResult(n, in, glb);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitNumericalSubtraction(NumericalSubtractionNode n, TransferInput<CFValue, CFStore> in) {
        UBQualifier left = this.getUBQualifier(n.getLeftOperand(), in);
        UBQualifier leftWithOffset = left.plusOffset(n.getRightOperand(), this.atypeFactory);
        if ((this.atypeFactory.hasLowerBoundTypeByClass(n.getRightOperand(), NonNegative.class) || this.atypeFactory.hasLowerBoundTypeByClass(n.getRightOperand(), Positive.class)) && !left.isUnknownOrBottom()) {
            leftWithOffset = left.glb(leftWithOffset);
        }
        return this.createTransferResult(n, in, leftWithOffset);
    }

    @Override
    public TransferResult<CFValue, CFStore> visitFieldAccess(FieldAccessNode n, TransferInput<CFValue, CFStore> in) {
        FlowExpressions.FieldAccess arrayLength;
        FlowExpressions.Receiver arrayRec;
        if (this.isArrayLengthFieldAccess(n) && CFAbstractStore.canInsertReceiver(arrayRec = (arrayLength = FlowExpressions.internalReprOfFieldAccess(this.atypeFactory, n)).getReceiver())) {
            UBQualifier qualifier = UBQualifier.createUBQualifier(arrayRec.toString(), "-1");
            UBQualifier previous = this.getUBQualifier(n, in);
            return this.createTransferResult(n, in, qualifier.glb(previous));
        }
        return super.visitFieldAccess(n, in);
    }

    private UBQualifier getUBQualifier(Node n, TransferInput<CFValue, CFStore> in) {
        UBQualifier qualifier;
        QualifierHierarchy hierarchy = this.analysis.getTypeFactory().getQualifierHierarchy();
        FlowExpressions.Receiver rec = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, n);
        CFValue value = null;
        if (CFAbstractStore.canInsertReceiver(rec)) {
            value = (CFValue)in.getRegularStore().getValue(rec);
        }
        if (value == null) {
            value = (CFValue)this.analysis.getValue(n);
        }
        if ((qualifier = this.getUBQualifier(hierarchy, value)).isUnknown()) {
            CFValue valueFromFactory = (CFValue)this.getValueFromFactory(n.getTree(), n);
            return this.getUBQualifier(hierarchy, valueFromFactory);
        }
        return qualifier;
    }

    private UBQualifier getUBQualifier(QualifierHierarchy hierarchy, CFValue value) {
        if (value == null) {
            return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
        }
        Set<AnnotationMirror> set = value.getAnnotations();
        AnnotationMirror anno = hierarchy.findAnnotationInHierarchy(set, this.atypeFactory.UNKNOWN);
        if (anno == null) {
            return UBQualifier.UpperBoundUnknownQualifier.UNKNOWN;
        }
        return UBQualifier.createUBQualifier(anno);
    }

    private TransferResult<CFValue, CFStore> createTransferResult(Node n, TransferInput<CFValue, CFStore> in, UBQualifier qualifier) {
        AnnotationMirror newAnno = this.atypeFactory.convertUBQualifierToAnnotation(qualifier);
        CFValue value = (CFValue)this.analysis.createSingleAnnotationValue(newAnno, n.getType());
        if (in.containsTwoStores()) {
            CFStore thenStore = in.getThenStore();
            CFStore elseStore = in.getElseStore();
            return new ConditionalTransferResult<CFValue, CFStore>(this.finishValue(value, thenStore, elseStore), thenStore, elseStore);
        }
        CFStore info = in.getRegularStore();
        return new RegularTransferResult<CFValue, CFStore>(this.finishValue(value, info), info);
    }
}

