/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.upperbound;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ExpressionTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.index.qual.SameLen;
import org.checkerframework.checker.index.upperbound.UBQualifier;
import org.checkerframework.checker.index.upperbound.UpperBoundAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;

public class UpperBoundVisitor
extends BaseTypeVisitor<UpperBoundAnnotatedTypeFactory> {
    private static final String UPPER_BOUND = "array.access.unsafe.high";

    public UpperBoundVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree tree, Void type) {
        ExpressionTree indexTree = tree.getIndex();
        ExpressionTree arrTree = tree.getExpression();
        this.visitAccess(indexTree, arrTree);
        return super.visitArrayAccess(tree, type);
    }

    private void visitAccess(ExpressionTree indexTree, ExpressionTree arrTree) {
        List<String> slNames;
        AnnotatedTypeMirror indexType = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(indexTree);
        String arrName = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, arrTree).toString();
        UBQualifier qualifier = UBQualifier.createUBQualifier(indexType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        if (qualifier.isLessThanLengthOf(arrName)) {
            return;
        }
        AnnotationMirror sameLenAnno = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).sameLenAnnotationFromExpressionTree(arrTree);
        if (sameLenAnno != null && AnnotationUtils.areSameByClass(sameLenAnno, SameLen.class) && AnnotationUtils.hasElementValue(sameLenAnno, "value") && qualifier.isLessThanLengthOfAny(slNames = AnnotationUtils.getElementValueArray(sameLenAnno, "value", String.class, true))) {
            return;
        }
        Integer valMax = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).valMaxFromExpressionTree(indexTree);
        int minLen = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).minLenFromExpressionTree(arrTree);
        if (valMax != null && minLen != -1 && valMax < minLen) {
            return;
        }
        this.checker.report(Result.failure(UPPER_BOUND, indexType.toString(), arrName, arrName), indexTree);
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, ExpressionTree valueExp, @CompilerMessageKey String errorKey) {
        Integer rhsValue = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).valMaxFromExpressionTree(valueExp);
        if (rhsValue == null) {
            super.commonAssignmentCheck(varType, valueExp, errorKey);
            return;
        }
        UBQualifier qualifier = UBQualifier.createUBQualifier(varType, ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).UNKNOWN);
        if (qualifier.isUnknownOrBottom()) {
            super.commonAssignmentCheck(varType, valueExp, errorKey);
            return;
        }
        UBQualifier.LessThanLengthOf ltl = (UBQualifier.LessThanLengthOf)qualifier;
        for (String string : ltl.getArrays()) {
            int minLen = ((UpperBoundAnnotatedTypeFactory)this.atypeFactory).getMinLenAnnotatedTypeFactory().getMinLenFromString(string, valueExp, this.getCurrentPath());
            boolean minLenOk = ltl.isValuePlusOffsetLessThanMinLen(string, rhsValue, minLen);
            if (minLenOk) continue;
            super.commonAssignmentCheck(varType, valueExp, errorKey);
            return;
        }
    }
}

