/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.checker.signedness.SignednessAnnotatedTypeFactory;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.TreeUtils;

public class SignednessVisitor
extends BaseTypeVisitor<SignednessAnnotatedTypeFactory> {
    public SignednessVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    private boolean isMask(Tree node) {
        Tree.Kind kind = node.getKind();
        return kind == Tree.Kind.AND || kind == Tree.Kind.OR;
    }

    private boolean isLiteral(ExpressionTree expr) {
        return expr instanceof LiteralTree;
    }

    private long getLong(Object obj) {
        if (obj instanceof Integer) {
            Integer intObj = (Integer)obj;
            return intObj.longValue();
        }
        return (Long)obj;
    }

    private boolean maskIgnoresMSB(Tree.Kind maskKind, LiteralTree numBitsLit, LiteralTree maskLit) {
        long numBits = this.getLong(numBitsLit.getValue());
        long mask = this.getLong(maskLit.getValue());
        if (maskLit.getKind() != Tree.Kind.LONG_LITERAL) {
            mask <<= 32;
        }
        mask >>>= (int)(64L - numBits);
        if (maskKind == Tree.Kind.AND) {
            return mask == 0L;
        }
        if (maskKind == Tree.Kind.OR) {
            return mask == (long)((1 << (int)numBits) - 1);
        }
        throw new RuntimeException("Invalid Masking Operation");
    }

    private boolean isMaskedShift(BinaryTree shiftExpr) {
        Tree enclosing;
        TreePath parentPath = this.visitorState.getPath().getParentPath();
        Tree enclosingChild = enclosing = parentPath.getLeaf();
        while (enclosing.getKind() == Tree.Kind.PARENTHESIZED) {
            parentPath = parentPath.getParentPath();
            enclosingChild = enclosing;
            enclosing = parentPath.getLeaf();
        }
        if (!this.isMask(enclosing)) {
            return false;
        }
        BinaryTree maskExpr = (BinaryTree)enclosing;
        ExpressionTree shift = shiftExpr.getRightOperand();
        ExpressionTree mask = maskExpr.getRightOperand() == enclosingChild ? maskExpr.getLeftOperand() : maskExpr.getRightOperand();
        mask = TreeUtils.skipParens(mask);
        if (!this.isLiteral(shift) || !this.isLiteral(mask)) {
            return false;
        }
        LiteralTree shiftLit = (LiteralTree)shift;
        LiteralTree maskLit = (LiteralTree)mask;
        return this.maskIgnoresMSB(maskExpr.getKind(), shiftLit, maskLit);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        AnnotatedTypeMirror leftOpType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(leftOp);
        AnnotatedTypeMirror rightOpType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(rightOp);
        Tree.Kind kind = node.getKind();
        switch (kind) {
            case DIVIDE: 
            case REMAINDER: {
                if (leftOpType.hasAnnotation(Unsigned.class)) {
                    this.checker.report(Result.failure("operation.unsignedlhs", new Object[]{kind}), leftOp);
                    break;
                }
                if (!rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("operation.unsignedrhs", new Object[]{kind}), rightOp);
                break;
            }
            case RIGHT_SHIFT: {
                if (!leftOpType.hasAnnotation(Unsigned.class) || this.isMaskedShift(node)) break;
                this.checker.report(Result.failure("shift.signed", new Object[]{kind}), leftOp);
                break;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                if (!leftOpType.hasAnnotation(Signed.class) || this.isMaskedShift(node)) break;
                this.checker.report(Result.failure("shift.unsigned", new Object[]{kind}), leftOp);
                break;
            }
            case LEFT_SHIFT: {
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: {
                if (leftOpType.hasAnnotation(Unsigned.class)) {
                    this.checker.report(Result.failure("comparison.unsignedlhs", new Object[0]), leftOp);
                    break;
                }
                if (!rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("comparison.unsignedrhs", new Object[0]), rightOp);
                break;
            }
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                if (leftOpType.hasAnnotation(Unsigned.class) && rightOpType.hasAnnotation(Signed.class)) {
                    this.checker.report(Result.failure("comparison.mixed.unsignedlhs", new Object[0]), node);
                    break;
                }
                if (!leftOpType.hasAnnotation(Signed.class) || !rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("comparison.mixed.unsignedrhs", new Object[0]), node);
                break;
            }
            default: {
                if (leftOpType.hasAnnotation(Unsigned.class) && rightOpType.hasAnnotation(Signed.class)) {
                    this.checker.report(Result.failure("operation.mixed.unsignedlhs", new Object[]{kind}), node);
                    break;
                }
                if (!leftOpType.hasAnnotation(Signed.class) || !rightOpType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("operation.mixed.unsignedrhs", new Object[]{kind}), node);
            }
        }
        return (Void)super.visitBinary(node, p);
    }

    private String kindWithOutAssignment(Tree.Kind kind) {
        String result = kind.toString();
        if (result.endsWith("_ASSIGNMENT")) {
            return result.substring(0, result.length() - "_ASSIGNMENT".length());
        }
        return result;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        ExpressionTree var = node.getVariable();
        ExpressionTree expr = node.getExpression();
        AnnotatedTypeMirror varType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(var);
        AnnotatedTypeMirror exprType = ((SignednessAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(expr);
        Tree.Kind kind = node.getKind();
        switch (kind) {
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER_ASSIGNMENT: {
                if (varType.hasAnnotation(Unsigned.class)) {
                    this.checker.report(Result.failure("compound.assignment.unsigned.variable", this.kindWithOutAssignment(kind)), var);
                    break;
                }
                if (!exprType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("compound.assignment.unsigned.expression", this.kindWithOutAssignment(kind)), expr);
                break;
            }
            case RIGHT_SHIFT_ASSIGNMENT: {
                if (!varType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("compound.assignment.shift.signed", this.kindWithOutAssignment(kind), "unsigned"), var);
                break;
            }
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                if (!varType.hasAnnotation(Signed.class)) break;
                this.checker.report(Result.failure("compound.assignment.shift.unsigned", this.kindWithOutAssignment(kind), "signed"), var);
                break;
            }
            case LEFT_SHIFT_ASSIGNMENT: {
                break;
            }
            default: {
                if (varType.hasAnnotation(Unsigned.class) && exprType.hasAnnotation(Signed.class)) {
                    this.checker.report(Result.failure("compound.assignment.mixed.unsigned.variable", this.kindWithOutAssignment(kind)), expr);
                    break;
                }
                if (!varType.hasAnnotation(Signed.class) || !exprType.hasAnnotation(Unsigned.class)) break;
                this.checker.report(Result.failure("compound.assignment.mixed.unsigned.expression", this.kindWithOutAssignment(kind)), expr);
            }
        }
        return super.visitCompoundAssignment(node, p);
    }
}

